TITLE  'Wait Vertical Sync EGA - VIDEO SYSTEMS p.27'
NAME   WAITVS
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      wait for vertical sync                                 |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call WAITVS(cnt)                                       |
;    stack:      +06 = count (>0 wait for full VS start (0 same as +1)  |
;                             <0 wait for full VS end                   |
;  returns:      none                                                   |
;-----------------------------------------------------------------------|

PARMS           = 1
ARGcnt          EQU [bp+06]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

WaitVS_TEXT     SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:WaitVS_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  WaitVS
WaitVS          PROC    FAR

                push    bp
                mov     bp,sp
                mov     bx,ARGcnt
                mov     cx,[bx]

                mov     ax,040h
                mov     es,ax
                mov     dx,es:[063h]
                add     dl,6

                or      cx,cx
                js      End0
                jnz     Start1
                inc     cx      ;must be at least 1

                ;wait for a full VS to start (cx times)
Start1:         in      al,dx
                test    al,8
                jnz     Start1  ;if already in a VS wait
Start2:         in      al,dx
                test    al,8
                jz      Start2  ;if not in VS wait
                loop    Start1  ;for cx times
                pop     bp
                RET     PARMS * 2

                ;wait for full VS to end (cx times)
End0:           neg     cx
End1:           in      al,dx
                test    al,8
                jz      End1    ;if not in a VS wait
End2:           in      al,dx
                test    al,8
                jnz     End2    ;if in VS wait
                loop    End1
                pop     bp
                RET     PARMS*2

WaitVS          ENDP
WaitVS_TEXT     ENDS
                END

