'Ŀ
'                                                                        
'                             R E F . B A S                              
'                                                                        
'                   (C) Copyright 1989 by Tony Martin                    
'                                                                        
'Ĵ
'                                                                        
'  Author: Tony Martin                                                   
'  Completion Date: September 1, 1989                                    
'  Language: Microsoft QuickBASIC version 4.5                            
'                                                                        
'Ĵ
'                                                                        
'  The purpose of this program is to provide a computer-based reference  
'  to the portions of the QBSCR Screen Routines that require frequent    
'  lookups.  These section includes window types, frame types, explode   
'  types, and clear screen modes.                                        
'                                                                        
'Ĵ
'                                                                        
'  Compile instructions:                                                 
'                                                                        
'  Load the file REF.BAS into QuickBASIC normally.  Then load in add-    
'  ition the file QBSCR.BAS.  You can then save the whole deal so that   
'  QuickBASIC will create an .MAK file for the program.  At this         
'  point the program will run; either use Shift+F5 or compile to an      
'  .EXE file.                                                            
'                                                                        
'

'Ŀ
'  Load the necessary DECLARE statements for the QBSCR routines.         
'

REM $INCLUDE: 'QBSCR.INC'

'Ŀ
'  All other DECLARE statements.                                         
'

DECLARE SUB BuildScreenModes ()
DECLARE SUB ClrScrModes ()
DECLARE SUB ExplodeTypes ()
DECLARE SUB FrameTypes ()
DECLARE SUB Main ()
DECLARE SUB Quit ()
DECLARE SUB WindowTypes ()

'Ŀ
'  Declare global variables and constants.                               
'

CONST FALSE = 0, TRUE = NOT FALSE
COMMON SHARED marker$
COMMON SHARED kolor

'Ŀ
'  DIMension all necessary arrays.                                       
'

DIM SHARED menuChoices$(6)

'Ŀ
'  Determine whether or not the host machine has color capability.       
'  This is accomplished via the QBSCR ColorChk function.  For more       
'  detail, see the QBSCR documentation or the included SAMPLE program.   
'

IF ColorChk THEN
    kolor = TRUE
ELSE
    kolor = FALSE
END IF

'Ŀ
'  Call the function "Main."  This routine drives the entire program.    
'

Main

'Ŀ
'  Quit the REF program.                                                 
'

Quit
END

SUB BuildScreenModes

'Ŀ
'  This sub-program runs through all the different modes that the        
'  BuildScreen subroutine supports.  The user may press ESCape during    
'  the pause to quit.                                                    
'
  
'Ŀ
'  Set colors to something with black background and clear the screen.   
'

COLOR 7, 0
CLS

'Ŀ
'  Define the variable esc$ as the ASCII code for the ESCape character.  
'
  
esc$ = CHR$(27)

'Ŀ
'  Set the colors based on the value of the Kolor variable.  If Kolor is 
'  false, use monochrome colors.  If Kolor is true, use something more   
'  interesting (in this case, Cyan on Black).  While we're here, we'll   
'  also define the disk file containing the screen to display.           
'
  
IF kolor THEN
    windowForeColor% = 0     ' Black
    windowBackColor% = 3     ' Cyan
    inputForeColor% = 15     ' Bright White
    inputBackColor% = 0      ' Black
    screenFore% = 11         ' Bright Cyan
    screenBack% = 0          ' Black
    fillFore% = 9            ' Bright Blue
    fillBack% = 0            ' Black
    buildScreenFile$ = "TESTSCR.CLR"
ELSE
    windowForeColor% = 0     ' Black
    windowBackColor% = 7     ' White
    inputForeColor% = 15     ' Bright White
    inputBackColor% = 0      ' Black
    screenFore% = 15         ' Bright White
    screenBack% = 0          ' Black
    fillFore% = 7            ' White
    fillBack% = 0            ' Black
    buildScreenFile$ = "TESTSCR.MON"
END IF

'Ŀ
'  Let user input the mode they wish to see.  If ESC, then quit.         
'

maxModes% = 15
done% = FALSE
DO

    'Ŀ
    '  Clear the screen.                                                 
    '

    COLOR 7, 0
    CLS

    'Ŀ
    '  Make a window in the middle in which instructions will be placed. 
    '

    MakeWindow 10, 30, 14, 50, windowForeColor%, windowBackColor%, 0, 0, -1, 0, ""
  
    'Ŀ
    '  Add some instructional text in the center window.                 
    '
 
    COLOR windowForeColor%, windowBackColor%
    LOCATE 11, 32, 0: PRINT "Enter BuildScreen"
    LOCATE 12, 33, 0: PRINT "Mode (0-"; LTRIM$(RTRIM$(STR$(maxModes%))); ")"
    Center "<To QUIT hit ESC>", 13

    'Ŀ
    '  Get input from user via GetString function. Loop until valid.     
    '

    validNums$ = "0123456789" + CHR$(27)
    DO
        numOK% = TRUE
        userChoice$ = ""
        COLOR inputForeColor%, inputBackColor%
        LOCATE 12, 46, 0: PRINT SPACE$(2)
        LOCATE 12, 46, 1
        userChoice$ = GetString$(46, 12, 2, inputForeColor%, inputBackColor%)
        FOR i% = 1 TO LEN(userChoice$)
            IF INSTR(validNums$, MID$(userChoice$, i%, 1)) = FALSE THEN
                numOK% = FALSE
            END IF
        NEXT i%
        IF VAL(userChoice$) < 0 OR VAL(userChoice$) > maxModes% THEN
            numOK% = FALSE
        END IF
    LOOP UNTIL numOK%
  
    'Ŀ
    '  If the user pressed ESCape, then exit the subroutine and return   
    '  to the main menu.  Otherwise, clear the screen with the mode      
    '  indicated by the user input number.                               
    '
  
    IF userChoice$ = esc$ THEN
        EXIT SUB
    ELSE
        BuildScreen buildScreenFile$, VAL(userChoice$)
    END IF

    'Ŀ
    '  After the screen has cleared, tell user to hit a key and wait for  
    '  them to hit one.                                                   
    '
  
    pause$ = INPUT$(1)

LOOP UNTIL done%

END SUB

SUB ClrScrModes

'Ŀ
'  This sub-program runs through all the different modes that the        
'  ClrScr subroutine supports.  The user may press ESCape during pauses  
'  to quit.                                                              
'
   
'Ŀ
'  Set colors to something with black background and clear the screen.   
'

COLOR 7, 0
CLS

'Ŀ
'  Define the variable Esc$ as the ASCII code for the ESCape character.  
'
   
esc$ = CHR$(27)

'Ŀ
'  Set the colors based on the value of the Kolor variable.  If Kolor is 
'  false, use monochrome colors.  If Kolor is true, use something more   
'  interesting (in this case, Cyan on Black).                            
'
   
IF kolor THEN
    fillForeColor% = 9       ' Bright Blue
    fillBackColor% = 0       ' Black
    windowForeColor% = 0     ' Black
    windowBackColor% = 3     ' Cyan
    inputForeColor% = 15     ' Bright White
    inputBackColor% = 0      ' Black
ELSE
    fillForeColor% = 7       ' White
    fillBackColor% = 0       ' Black
    windowForeColor% = 0     ' Black
    windowBackColor% = 7     ' White
    inputForeColor% = 15     ' Bright White
    inputBackColor% = 0      ' Black
END IF

'Ŀ
'  Use a FOR...NEXT loop and iterate ten times (from 0 to 9).  This way  
'  we can use the loop control variable as the Mode passed to ClrScr.    
'  Fill the screen with characters and then clear it ten ways.           
'

maxModes% = 15
done% = FALSE
DO

    'Ŀ
    '  Fill the screen with the '' (ASCII 176) character.               
    '
   
    COLOR fillForeColor%, fillBackColor%
    FOR y% = 1 TO 25
        LOCATE y%, 1, 0
        PRINT STRING$(80, 176);
    NEXT y%

    'Ŀ
    '  Make a window in the middle in which instructions will be placed. 
    '

    MakeWindow 10, 30, 14, 50, windowForeColor%, windowBackColor%, 0, 0, 0, 0, ""
   
    'Ŀ
    '  Add some instructional text in the center window.                 
    '
  
    COLOR windowForeColor%, windowBackColor%
    LOCATE 11, 34, 0: PRINT "Enter ClrScr"
    LOCATE 12, 33, 0: PRINT "Mode (0-"; LTRIM$(RTRIM$(STR$(maxModes%))); ")"
    Center "<To QUIT hit ESC>", 13

    'Ŀ
    '  Get input from user via GetString function. Loop until valid.     
    '

    validNums$ = "0123456789" + CHR$(27)
    DO
        numOK% = TRUE
        userChoice$ = ""
        COLOR inputForeColor%, inputBackColor%
        LOCATE 12, 46, 0: PRINT SPACE$(2)
        LOCATE 12, 46, 1
        userChoice$ = GetString$(46, 12, 2, inputForeColor%, inputBackColor%)
        FOR i% = 1 TO LEN(userChoice$)
            IF INSTR(validNums$, MID$(userChoice$, i%, 1)) = FALSE THEN
                numOK% = FALSE
            END IF
        NEXT i%
        IF VAL(userChoice$) < 0 OR VAL(userChoice$) > maxModes% THEN
            numOK% = FALSE
        END IF
    LOOP UNTIL numOK%
   
    'Ŀ
    '  If the user pressed ESCape, then exit the subroutine and return   
    '  to the main menu.  Otherwise, clear the screen with the mode      
    '  indicated by the user input number.                               
    '
   
    IF userChoice$ = esc$ THEN
        EXIT SUB
    ELSE
        ClrScr VAL(userChoice$), " "
    END IF

    'Ŀ
    '  After the screen has cleared, tell user to hit a key and wait for  
    '  them to hit one.                                                   
    '
   
    LOCATE 25, 1, 0
    PRINT "Hit any key to continue...";
    pause$ = INPUT$(1)

LOOP UNTIL done%

END SUB

SUB ExplodeTypes

'Ŀ
'  This routine shows demonstrates the three possible explode types      
'  available in the MakeWindow subroutine.  For more information, see    
'  the SAMPLE program or the QBSCR documentation.                        
'

'Ŀ
'  Set the screen colors s they have a black background and then clear   
'  the screen.                                                           
'

COLOR 15, 0
CLS

'Ŀ
'  Set the colors based on the value of the Kolor variable.  If Kolor is 
'  false, use monochrome colors.  If Kolor is true, use something more   
'  interesting (in this case, bright White on Green).                    
'

IF kolor THEN
    foreColor% = 15   '== Bright white
    backColor% = 2    '== Green
ELSE
    foreColor% = 0    '== Black
    backColor% = 7    '== White
END IF

'Ŀ
'  Display an informational header at the top of the screen.             
'

Center "Demonstrating the QBSCR MakeWindow", 1
Center "E X P L O D E   T Y P E S", 3

'Ŀ
'  Run the demo for Mode 1 - Automatic adjust mode.                      
'

'Ŀ
'  Place a pause message at the bottom of the screen and wait for the    
'  user to hit a key before demonstrating explode type 1.                
'

Center "Hit any key for Explode Type 1", 23
pause$ = INPUT$(1)

'Ŀ
'  Blank out the pause message at the bottom of the screen.              
'

Center SPACE$(60), 23

'Ŀ
'  Make a window using explode type 1.                                   
'

MakeWindow 7, 16, 17, 65, foreColor%, backColor%, 1, 4, -1, 1, ""

'Ŀ
'  Add a bit of explanatory text + pause message to window.              
'

Center "Explode Type was 1", 8
Center "This explode type provides a smooth window", 11
Center "expansion so all corners are reached", 12
Center "at the same time", 13
Center "Hit any key to continue", 16

'Ŀ
'  Wait for user to hit a key before proceeding.                         
'

pause$ = INPUT$(1)

'Ŀ
'  Run the demo for Mode 2 - Horizontal Bias Mode.                       
'

'Ŀ
'  Change colors to black background.                                    
'

COLOR 15, 0

'Ŀ
'  Use the Wipe subroutine to clear a selected part of the screen, in    
'  this case to erase the first window.  For more information on Wipe    
'  see the SAMPLE program or the QBSCR documentation.                    
'

Wipe 6, 18, 1, 80, 0

'Ŀ
'  Place a pause message at the bottom of the screen and wait for the    
'  user to hit a key before demonstrating explode type 2.                
'

Center "Hit any key for Explode Type 2", 23
pause$ = INPUT$(1)

'Ŀ
'  Blank out the pause message at the bottom of the screen.              
'

Center SPACE$(60), 23

'Ŀ
'  Make a window using explode type 2.                                   
'

MakeWindow 8, 11, 15, 70, foreColor%, backColor%, 1, 4, -1, 2, ""

'Ŀ
'  Add a bit of explanatory text + pause message to window.              
'

Center "Explode Type was 2", 9
Center "This mode provides almost a completely horizontal", 11
Center "expansion.  Use for wide, short windows.", 12
Center "Hit any key to continue", 14

'Ŀ
'  Wait for user to hit a key before proceeding.                         
'

pause$ = INPUT$(1)

'Ŀ
'  Run the demo for Mode 2 - Horizontal Bias Mode.                       
'

'Ŀ
'  Change colors to black background.                                    
'

COLOR 15, 0

'Ŀ
'  Use the Wipe subroutine to clear a selected part of the screen, in    
'  this case to erase the second window.  For more information on Wipe   
'  see the SAMPLE program or the QBSCR documentation.                    
'

Wipe 7, 16, 1, 80, 0

'Ŀ
'  Place a pause message at the bottom of the screen and wait for the    
'  user to hit a key before demonstrating explode type 3.                
'

Center "Hit any key for Explode Type 3", 23
pause$ = INPUT$(1)

'Ŀ
'  Blank out the pause message at the bottom of the screen.              
'

Center SPACE$(60), 23

'Ŀ
'  Make a window using explode type 3.                                   
'

MakeWindow 5, 31, 21, 50, foreColor%, backColor%, 1, 4, -1, 3, ""

'Ŀ
'  Add a bit of explanatory text + pause message to window.              
'

Center "Type was 3", 6
Center "This type of", 9
Center "expansion is", 10
Center "biased in the", 11
Center "vertical", 12
Center "direction.", 13
Center "Use for tall", 15
Center "thin windows", 16
Center "like this one.", 17
Center "Easy, no?", 20

'Ŀ
'  Set colors to Bright White on Black for pause message.                
'

COLOR 15, 0

'Ŀ
'  Wait for user to hit a key before proceeding.                         
'

Center "  Hit any key for the main menu  ", 23
pause$ = INPUT$(1)

END SUB

SUB FrameTypes

'Ŀ
'  The FrameTypes subroutine displays a reference screen depicting all   
'  6 possible freame types in the MakeWindow subroutine.                 
'

'Ŀ
'  Change colors to something with a black background.                   
'

COLOR 7, 0
CLS

'Ŀ
'  Set the colors based on the value of the Kolor variable.  If Kolor is 
'  false, use monochrome colors.  If Kolor is true, use something more   
'  interesting (in this case, bright White on Magenta).                  
'

IF kolor THEN
    foreColor% = 15   '== Bright white
    backColor% = 5    '== Magenta
ELSE
    foreColor% = 0    '== Black
    backColor% = 7    '== White
END IF

'Ŀ
'  Make six windows, one at a time.  After each window, fill inside it   
'  text that tells the user what frame type it is.                       
'

'== First row of 3

MakeWindow 1, 5, 7, 25, foreColor%, backColor%, 1, 0, -1, 0, ""
OffCenter "Type = 0", 4, 5, 25
MakeWindow 1, 30, 7, 50, foreColor%, backColor%, 1, 1, -1, 0, ""
OffCenter "Type = 1", 4, 30, 50
MakeWindow 1, 55, 7, 75, foreColor%, backColor%, 1, 2, -1, 0, ""
OffCenter "Type = 2", 4, 55, 75

'== Second row of 3

MakeWindow 9, 5, 15, 25, foreColor%, backColor%, 1, 3, -1, 0, ""
OffCenter "Type = 3", 12, 5, 25
MakeWindow 9, 30, 15, 50, foreColor%, backColor%, 1, 4, -1, 0, ""
OffCenter "Type = 4", 12, 30, 50
MakeWindow 9, 55, 15, 75, foreColor%, backColor%, 1, 5, -1, 0, ""
OffCenter "Type = 5", 12, 55, 75

'Ŀ
'  Change the colors so our text won't have a magenta background.        
'

COLOR 15, 0

'Ŀ
'  Add some explanatory and instructional text underneath the windows.   
'

Center "F R A M E    T Y P E S", 17
Center "Hit any key to return to the main menu", 19
Center "Note that if your printer supports extended characters, you can use", 22
Center "Shift+PrtSc to get a hard copy of this reference screen", 23

'Ŀ
'  Pause until the user hits a key.  We will then return to Main.        
'

pause$ = INPUT$(1)

END SUB

SUB Main

'Ŀ
'  This routine drives the functional part of the program.  It first     
'  sets up the display and creates a menu (using the QBSCR "MakeMenu"    
'  function) and allows the user to select which item to reference.      
'  It then executes the appropriate subroutine based on the user's       
'  selection.  Selecting "Quit" returns control to the main module.      
'

'Ŀ
'  First define a few variables, specifically the array that will hold   
'  the menu choices.  Throw in a few others for spice.                   
'

menuChoices$(1) = "^Window Types"
menuChoices$(2) = "^Frame Types"
menuChoices$(3) = "^Explode Types"
menuChoices$(4) = "^ClrScr Modes"
menuChoices$(5) = "^BuildScreen Modes"
menuChoices$(6) = "^Quit"
numberOfChoices% = 6
justification$ = "L"
marker$ = "^"

windowTop = 9         '   Ŀ  We'll use these variables as our screen
windowBottom = 16     '      coordinates.  This way, if we need to change
windowLeft = 29       '      them, we only have to change them right here
windowRight = 52      '     and not throughout the whole module.

'Ŀ
'  Sit in a WHILE loop.  If we get menu entry 5 (Quit) then set          
'  the variable "Done" to True, and exit.                                
'

done = FALSE
WHILE NOT done

    'Ŀ
    '  Set the colors of the menu based on the boolean value of the Kolor    
    '  variable.  If Kolor is False, we use monochrome colors.  If Kolor is  
    '  True, we'll use grey on blue.                                         
    '

    IF kolor THEN
        foreColor% = 7    ' Grey (pale white)
        backColor% = 1    ' Blue
        qfg% = 15         ' Bright white
        qbg% = 1          ' Blue
    ELSE
        foreColor% = 0    ' Black
        backColor% = 7    ' White
        qfg% = 15         ' Bright White
        qbg% = 0          ' Black
    END IF

    'Ŀ
    '  Clear the screen.  But first set the colors to something with a black 
    '  background.  This way, when the screen is cleared, it will be black   
    '  and not some other stray color.                                       
    '

    COLOR 7, 0   ' White on a black background
    CLS

    'Ŀ
    '  Add a pleasing background of '' (ASCII 176) to display our menu on.  
    '

    FOR x% = 1 TO 25
        LOCATE x%, 1, 0
        PRINT STRING$(80, 176);
    NEXT x%

    'Ŀ
    '  Let's add the screen header and footer now.  The header consists of   
    '  a title and copyright notice (you're not allowed to remove this -     
    '  legal penalties and all that), and the footer contains instructions   
    '  for the user on how to use the menu.                                  
    '

    COLOR foreColor%, backColor%  'Change to our selected colors

    LOCATE 1, 1, 0                ' These 3 lines are the header...
    PRINT SPACE$(80);
    Center "REF  A companion to the QBSCR screen routines  (C) 1989 by Tony Martin", 1

    LOCATE 25, 1, 0               ' ...and these 3 are the footer.
    PRINT SPACE$(80);
    Center "Use the  and  or PgUp and PgDn keys to move  ENTER to select", 25

    'Ŀ
    '  Make the window in which we will place our menu.  We are using the    
    '  QBSCR "MakeWindow" function to do this.  Note that we are going to    
    '  use literal values for a few of the parameters.  See the QBSCR        
    '  documentation or the SAMPLE program for more information.             
    '

    MakeWindow windowTop, windowLeft, windowBottom, windowRight, foreColor%, backColor%, 0, 1, 0, -1, ""

    'Ŀ
    '  Now we add a decorative line to the frame.                            
    '

    FOR x = windowTop + 1 TO windowBottom - 1
        LOCATE x, windowLeft + 2, 0
        PRINT ""
    NEXT x

    'Ŀ
    '  Make the menu and place user's response in Response%.             
    '
   
    response% = MakeMenu%(menuChoices$(), numberOfChoices%, justification$, windowLeft + 4, windowRight - 1, windowTop + 1, marker$, foreColor%, backColor%, 15, 0, qfg%, qbg%)

    'Ŀ
    '  Decide what to do based on the user's input.                      
    '

    SELECT CASE response%

        CASE 1        ' User chose WINDOW TYPES
            WindowTypes
        CASE 2        ' User chose FRAME TYPES
            FrameTypes
        CASE 3        ' User chose EXPLODE TYPES
            ExplodeTypes
        CASE 4        ' User chose CLRSCR MODES
            ClrScrModes
        CASE 5        ' User chose BUILDSCREEN MODES
            BuildScreenModes
        CASE 6        ' User chose QUIT
            done = TRUE
        CASE ELSE     ' User hit something else, like ESCape

    END SELECT

WEND

END SUB

SUB Quit

'Ŀ
'  This routine simply resets colors to mono and clears the screen.      
'

COLOR 7, 0
ClrScr 14, " "
LOCATE 1, 1, 1

END SUB

SUB WindowTypes

'Ŀ
'  The WindowTypes subroutine displays a the reference screen depicting  
'  all ten possible window types in the MakeWindow subroutine.           
'

'Ŀ
'  Set colors to neutral and clear the display.                          
'

COLOR 7, 0
CLS

'Ŀ
'  Set new colors for the window reference screen.  If the variable      
'  Kolor is True, then use the colors bright white on red.  If Kolor is  
'  false, then use mono colors (white on black).                         
'

IF kolor THEN
    foreColor% = 15   '== Bright white
    backColor% = 4    '== Red
ELSE
    foreColor% = 0    '== Black
    backColor% = 7    '== White
END IF

'Ŀ
'  Make ten windows, one at a time.  After each window, fill inside it   
'  text that tells the user what window type it is.                      
'

'== First row of 5 windows

MakeWindow 1, 1, 7, 15, foreColor%, backColor%, 0, 0, -1, 0, ""
OffCenter "Type = 0", 4, 1, 15
MakeWindow 1, 17, 7, 31, foreColor%, backColor%, 1, 0, -1, 0, ""
OffCenter "Type = 1", 4, 17, 31
MakeWindow 1, 33, 7, 47, foreColor%, backColor%, 2, 0, -1, 0, ""
OffCenter "Type = 2", 4, 33, 47
MakeWindow 1, 49, 7, 63, foreColor%, backColor%, 3, 0, -1, 0, ""
OffCenter "Type = 3", 4, 49, 63
MakeWindow 1, 65, 7, 79, foreColor%, backColor%, 4, 0, -1, 0, ""
OffCenter "Type = 4", 4, 65, 79

'== Second row of 5 windows

MakeWindow 9, 1, 15, 15, foreColor%, backColor%, 5, 0, -1, 0, ""
OffCenter "Type = 5", 11, 1, 15
MakeWindow 9, 17, 15, 31, foreColor%, backColor%, 6, 0, -1, 0, ""
OffCenter "Type = 6", 11, 17, 31
MakeWindow 9, 33, 15, 47, foreColor%, backColor%, 7, 0, -1, 0, ""
OffCenter "Type = 7", 10, 33, 47
MakeWindow 9, 49, 15, 63, foreColor%, backColor%, 8, 0, -1, 0, ""
OffCenter "Type = 8", 14, 49, 63
MakeWindow 9, 65, 15, 79, foreColor%, backColor%, 9, 0, -1, 0, ""
OffCenter "Type = 9", 14, 65, 79

'Ŀ
'  Change the colors so our text won't have a red background.            
'

IF kolor THEN
    COLOR 15, 0
ELSE
    COLOR 7, 0
END IF

'Ŀ
'  Add some explanatory and instructional text underneath the windows.   
'

Center "W I N D O W    T Y P E S", 17
Center "Hit any key to return to the main menu", 19
Center "Note that if your printer supports extended characters, you can use", 22
Center "Shift+PrtSc to get a hard copy of this reference screen", 23

'Ŀ
'  Pause until the user hits a key.  We will then return to Main.        
'

pause$ = INPUT$(1)

END SUB

