' $linesize:132
' $title: 'RBBS-SUB1.BAS 17.5, Copyright 1986-94 by D. Thomas Mack'
'  Copyright 1990 by D. Thomas Mack, all rights reserved.
'  Name ...............: RBBSSUB1.BAS
'  First Released .....: June 21, 1992
'  Subsequent Releases.:
'  Copyright ..........: 1986-1994
'  Purpose.............:
'     Subprograms that require error trapping are incorporated
'     within RBBSSUB1.BAS as separately callable subroutines
'     in order to free up as much code as possible within
'     the 64K code segment used by RBBS-PC.BAS.
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine      Line       Function of Subroutine
'   Name          Number
' ----------      ------     ----------------------
'  BinSearch      63520      Binary searches sorted file for a key value
'  ChangeDir      20101      Change subdirectory
'  ChkBanned      60000      Stops user from joining conference
'  CheckInt       58360      Check input is valid integer
'  CommPut        59725      Write string to communications port
'  CopyFile       1450       Copy a file from CD-ROM to holding directory
'  DisplayUser    10091      Display user/callers files
'  DropCarrier    63901      Change users security level with excessive carrier drops
'  ExpiredPswd    63801      Force change of password
'  FindFile       59790      Determine whether a file exists without opening it
'  FindFree       51098      Find amount of space on the upload disk drive
'  FindItX        20219      Find if a file exists on a device
'  FindUser       12598      Find a user in the USERS file
'  FlushCom       20308      Read all characters in the communications port
'  GetCom          1418      Read a character from the communications port
'  GetLogoff      63930      Gets logoff command from user
'  GetMenuNew     58370      Read "MNEWx.DEF" file for MENU0 Updates
'  GetPassword    58280      Read RBBS-PC's "PASSWORD" file
'  GetWork        58330      Read record from file number 2
'  GraphicsSet    43000      Allows user to set graphics default
'  KillCDWork      1465      Kill files copied to CD Work Dir
'  KillWork       58260      Delete a RBBS-PC "WORK" file
'  Library        21105      Support Library downloads ** (REMOVED 8/15/94) **
'  MessageExport  63955      Exports message to txt file
'  NetBIOS        20898      Lock/Unlock NetBIOS semaphore files
'  NumberCheck    44000      Check filename for number/letters
'  OpenCom          200      Open communications port (number 3)
'  OpenFMS        58190      Open the upload management system directory
'  OpenOutW       58220      Open RBBS-PC's "WORK" file (number 2) for output
'  OpenRSeq        1479      Open a sequential file (number 2) for random I/O
'  OpenUser        9398      Open the USER file (number 5)
'  OpenWork       57978      Open RBBS-PC's work file (number 2)
'  Printit        13673      Print line on the local PC printer
'  PrintWork      58320      Print string to file #2 w/o CR/LF
'  PutCom         59650      Write to the communications port
'  PutWork        59660      Write to work file randomly
'  RBBSPlay       59680      Plays a musical string
'  ReadAny        58310      Read file number 2 into ZOutTxt$
'  ReadDef          112      Read configuration file
'  ReadDir        58290      Read entire lines
'  ReadParmsX     58300      Read certain number of parameters from specified file
'  SetCall          108      Find where next callers record is
'  SysInfo        63910      Get DOS/DV/OS2 version
'  Talk           59700      RBBS-PC Voice synthesizer support for sight impaired
'  UpdateC        43048      Update the caller's file with elasped session time
'  UpdtCalr       13661      Update to the caller's file
'
'  $INCLUDE: 'RBBS-VAR.BAS'
'
108 ' $SUBTITLE: 'SetCall - subroutine to find last callers rec'
' $PAGE
'
'  NAME    -- SetCall
'
'  INPUTS  --     PARAMETER                    MEANING
'
'  OUTPUTS --  ZCallersFileIndex!
'
'  PURPOSE --  To find where to leave off on callers file
'
    SUB SetCall
    ON ERROR GOTO 65000
    IF ZPrevCaller$ = ZCallersFile$ OR ZCallersFilePrefix$ = "" THEN _
       EXIT SUB
    ZPrevCaller$ = ZCallersFile$
    ZCallersFileIndex! = 1
    CLOSE 2
    CLOSE 4
    IF ZShareIt THEN _
       OPEN ZCallersFile$ FOR RANDOM SHARED AS #4 LEN=64 _
    ELSE OPEN "R",4,ZCallersFile$,64
    FIELD 4,64 AS ZCallersRecord$
    IF LOF(4) > 0 THEN _
       ZCallersFileIndex! = LOF(4) / 64
    IF ZCallersFileIndex! < 1 THEN _
       ZCallersFileIndex! = 0
    ZUserIn$ = STRING$(13,0)
110 GET 4,ZCallersFileIndex!
    IF ZErrCode > 0 THEN _
       ZErrCode = 0 : _
       ZCallersFileIndex! = 0 : _
       EXIT SUB
    IF LEFT$(ZCallersRecord$,13) = ZUserIn$ THEN _
       ZCallersFileIndex! = ZCallersFileIndex! - 1 : _
       GOTO 110
    END SUB
112 ' $SUBTITLE: 'ReadDef - subroutine to read RBBS-PC.DEF file'
' $PAGE
'
'  NAME    -- ReadDef
'
'  INPUTS  --     PARAMETER                    MEANING
'                ZConfigFileName$            NAME OF RBBS-PC.DEF FILE
'                ZSubParm = -62              ONLY READ THE .DEF FILE
'
'  OUTPUTS --  ALL THE RBBS-PC.DEF PARAMETERS
'
'  PURPOSE --  TO READ THE PARAMETERS FROM THE RBBS-PC.DEF FILE
'
     SUB ReadDef (ConfigFile$)
     ON ERROR GOTO 65000
'
' **** OPEN AND READ RBBS-PC CONFIGURATION DEFINITIONS ***
'
117 IF ZSubParm <> -62 THEN _
       IF ZPrevRead$ = ConfigFile$ THEN _
          EXIT SUB _
       ELSE ZPrevRead$ = ConfigFile$
    CLOSE 2
    ZBulletinSave$ = ZBulletinMenu$
    CALL OpenWork (2,ConfigFile$,ZFalse)
    ZCurDef$ = ConfigFile$
    INPUT #2,ZCnfgVer$, _
             ZDnldDrives$, _
             ZSysopPswd1$, _
             ZSysopPswd2$, _
             ZSysopFirstName$, _
             ZSysopLastName$, _
             ZRequiredRings, _
             ZStartOfficeHours, _
             ZEndOfficeHours, _
             ZMinsPerSession, _
             ZWasDF, _
             ZWasDF, _
             ZUpldDir$, _
             ZExpertUserDef, _
             ZActiveBulletins, _
             ZPromptBellDef, _
             ZWasDF, _
             ZMenusCanPause, _
             ZMenu$(1), _
             ZMenu$(2), _
             ZMenu$(3), _
             ZMenu$(4), _
             ZMenu$(5), _
             ZMenu$(6), _
             ZConfMenu$, _
             ZTestANSITime, _
             ZWelcomeInterruptable, _
             ZRemindFileXfers, _
             ZPageLengthDef, _
             ZMaxMsgLinesDef, _
             ZDoorsAvail, _
             ZWasDF$, _
             ZMainMsgFile$, _
             ZMainMsgBackup$
    INPUT #2, WasX$, _
              ZCmntsFile$, _
              ZMainUserFile$, _
              ZWelcomeFile$, _
              ZNewUserFile$, _
              ZMainDirExtension$
    CALL BreakFileName (WasX$,ZWasY$,ZWasDF$,ZWasZ$,ZFalse)
    IF ZWasDF$ <> "" THEN _
       ZCallersFile$ = WasX$
    INPUT #2, ZWasDF$
    IF ZComPort$ <> "COM0" THEN _
       IF NOT ZConfMode THEN _
          ZComPort$ = ZWasDF$
    INPUT #2, ZBulletinsOptional, _
              ZModemInitCmd$, _
              ZRTS$, _
              ZCallersLst$, _
              ZFG, _
              ZBG, _
              ZBorder
    IF ZConfMode THEN _
       INPUT #2, ZWasDF$, _
                 ZWasDF$ _
    ELSE INPUT #2, ZRBBSBat$ , _
                   ZRCTTYBat$
    INPUT #2,ZOmitMainDir$, _
             ZFirstNamePrompt$, _
             ZHelp$(3), _
             ZHelp$(4), _
             ZHelp$(7), _
             ZHelp$(9), _
             ZBulletinMenu$, _
             ZBulletinPrefix$, _
             ZWasDF$, _
             ZMsgReminder, _
             ZRequireNonASCII, _
             ZAskExtendedDesc, _
             ZMaxNodes
    IF ZConfMode THEN _
       INPUT #2, ZwasDF, ZwasDF _
    ELSE INPUT #2, ZNetworkType, _
                   ZRecycleToDos
    INPUT #2,ZWasDF, _
             ZWasDF, _
             ZTrashcanFile$
    INPUT #2,ZMinLogonSec, _
             ZDefaultSecLevel, _
             ZSysopSecLevel, _
             ZFileSecFile$, _
             ZSysopMenuSecLevel, _
             ZConfMailList$, _
             ZMaxViolations, _
             ZOptSec(50), _   ' SECURITY FOR SYSOP COMMANDS 1
             ZOptSec(51), _
             ZOptSec(52), _
             ZOptSec(53), _
             ZOptSec(54), _
             ZOptSec(55), _
	     ZOptSec(56)      ' SYSOP 7
    INPUT #2,ZPswdFile$
    IF NOT ZSubBoard THEN _
       ZMainPswdFile$ = ZPswdFile$
    IF ZPswdFile$ = "NONE" THEN _
       ZPswdFile$ = ZMainPswdFile$
    INPUT #2,ZMaxPswdChanges, _
             ZMinSecForTempPswd, _
             ZOverWriteSecLevel, _
             ZDoorsTermType, _
             ZMaxPerDay
    INPUT #2,ZOptSec(1), _   ' SECURITY FOR MAIN MENU COMMANDS 1
             ZOptSec(2), _
             ZOptSec(3), _
             ZOptSec(4), _
             ZOptSec(5), _
             ZOptSec(6), _
             ZOptSec(7), _
             ZOptSec(8), _
             ZOptSec(9), _
             ZOptSec(10), _
             ZOptSec(11), _
             ZOptSec(12), _
             ZOptSec(13), _
             ZOptSec(14), _
             ZOptSec(15), _
             ZOptSec(16), _
             ZOptSec(17), _
             ZOptSec(18), _   ' MAIN COMMAND 18
             ZMinNewCallerBaud, _
             ZWaitBeforeDisconnect
    INPUT #2,ZOptSec(19), _      ' SECURITY FOR FILE COMMANDS 1
             ZOptSec(20), _
             ZOptSec(21), _
             ZOptSec(22), _
             ZOptSec(23), _
             ZOptSec(24), _
             ZOptSec(25), _
             ZOptSec(26), _      ' FILE COMMAND 8
             ZOptSec(27), _      ' SECURITY FOR UTILITY COMMANDS 1
             ZOptSec(28), _
             ZOptSec(29), _
             ZOptSec(30), _
             ZOptSec(31), _
             ZOptSec(32), _
             ZOptSec(33), _
             ZOptSec(34), _
             ZOptSec(35), _
             ZOptSec(36), _
             ZOptSec(37), _
             ZOptSec(38), _   ' UTIL COMMAND 12
             ZOptSec(46), _   ' SECURITY FOR GLOBAL COMMANDS 1
             ZOptSec(47), _
             ZOptSec(48), _
             ZOptSec(49), _
             ZUpldTimeFactor!, _
             ZComputerType, _
             ZRemindProfile, _
             ZRBBSName$, _
             ZCmdsBetweenRings, _
             ZCopyrightSecs, _
             ZPagingPtrSupport$
    IF ZConfMode THEN _
         INPUT #2, ZwasDF _
    ELSE INPUT #2, ZModemInitBaud$
             IF ZErrCode > 0 THEN _
                EXIT SUB
118 INPUT #2, ZTurnPrinterOff,_    ' Turn printer off each recycle
              ZDirPath$, _         ' Where dir files are stored
              ZMinSecToView, _
              ZLimitSearchToFMS, _
              ZDefaultCatCode$, _
              ZDirCatFile$, _
              ZNewFilesCheck, _
              ZMaxDescLen, _
              ZShowSection, _
              ZCmndsInPrompt, _
              ZNewUserSetsDefaults, _
              ZHelpPath$, _
              ZHelpExtension$, _
              ZMainCmds$, _
              ZFileCmd$, _
              ZUtilCmds$, _
              ZGlobalCmnds$, _
              ZSysopCmds$
    INPUT #2, ZRecycleWait, _
              ZOptSec(39), _       ' SECURITY FOR LIBRARY COMMANDS 1
              ZOptSec(40), _
              ZOptSec(41), _
              ZOptSec(42), _
              ZOptSec(43), _
              ZOptSec(44), _
              ZOptSec(45), _       ' LIBRARY COMMANDS 7
              ZWasDF$, _
              ZLibDirPath$, _
              ZLibDirExtension$, _
              ZWasDF$, _
              ZWasDF, _
              ZWasDF, _
              ZWasDF, _
              ZWasDF$, _
              ZWasDF$, _
              ZWasDF$, _
              ZLibCmds$
'
' *****  ESTABLISH COMMUNICATION PORT REGISTERS AND COMMANDS   ***
' *****     GET DOS SUB-DIRECTORY RBBS-PC OPTIONS              ***
'
    INPUT #2, ZUpldPath$, _        ' Where upl dir goes
              ZMainFMSDir$, _      ' Shared dir in FMS
              ZAnsMenu$, _
              ZReqQues$,_
              ZRememberNewUsers,_
              ZSurviveNoUserRoom,_
              ZPromptHash$,_
              ZStartHash,_
              ZLenHash,_
              ZPromptIndiv$,_
              ZStartIndiv,_
              ZLenIndiv
    INPUT #2, ZBypassMsgs, _
              ZMusic, _
              ZRestrictByDate, _
              ZDaysToWarn, _
              ZDaysInRegPeriod, _
              ZVoiceType, _
              ZRestrictValidCmds, _
              ZMinSecPersUpld, _
              ZDistriHelp$, _
              ZDistriPath$, _
              ZFastFileList$, _
              ZFastFileLocator$, _
              ZMsgsCanGrow, _
              ZWrapCallersFile$, _
              ZRedirectIOMethod, _
              ZAutoUpgradeSec, _
              ZHaltOnError, _
              ZNewPublicMsgsSec, _
              ZNewPrivateMsgsSec, _
              SecNeededToChangeMsgs, _
              ZSLCategorizeUplds, _
              ZNoQuoting, _
              ZHourMinToDropToDos, _
              ZExpiredSec, _
              ZDTRDropDelay, _
              ZAskID, _
              ZMaxRegSec, _
              ZBufferSize, _
              ZMLCom, _
              ZNoDoorProtect, _
              ZDefaultExtension$, _
              ZEnableCC, _
              ZMaxBank, _
              ZNetMail$, _
              ZMasterDirName$, _
              ZWasDF$, _
              ZUpcatHelp$, _
              ZAllwaysStrewTo$, _
              ZLastNamePrompt$
    IF ZWasDF$ <> "" THEN _
       ZProtoDef$ = ZWasDF$
119 INPUT #2, ZPersonalDrvPath$, _
              ZPersonalDir$, _
              ZPersonalBegin, _
              ZPersonalLen, _
              ZPersonalProtocol$, _
              ZPersonalConcat , _
              ZPrivateReadSec, _
              ZPublicReadSec, _
              ZSecChangeMsg
    IF ZConfMode THEN _
         INPUT #2, ZwasDF _
    ELSE INPUT #2, ZKeepInitBaud
    INPUT #2, ZMainPUI$
    IF ZConfMode THEN _
       INPUT #2, ZWasDF$,ZWasDF$,ZWasDF$ _
    ELSE INPUT #2, ZDefaultEchoer$, _
                   ZHostEchoOn$, _
                   ZHostEchoOff$
    INPUT #2, ZSwitchBack, _
              ZDefaultLineACK$, _
              ZAltdirExtension$, _
              ZDirPrefix$
    IF ZConfMode THEN _
       INPUT #2, ZWasDF, _
                 ZWasDF, _
                 ZWasDF _
    ELSE INPUT #2, ZWasDF,_
                   ZModemInitWaitTime, _
                   ZModemCmdDelayTime
    INPUT #2, ZTurboRBBS, _
              ZSubDirCount, _
              ZWasDF, _
              ZUpldToSubdir, _
              ZWasDF, _
              ZUpldSubdir$, _
              ZMinOldCallerBaud, _
              ZMaxWorkVar, _
              ZDiskFullGoOffline, _
              ZExtendedLogging
     IF ZConfMode THEN _
        INPUT #2, ZWasDF$, _
                  ZWasDF$, _
                  ZWasDF$, _
                  ZWasDF$ _
     ELSE INPUT #2, ZModemResetCmd$, _
                    ZModemCountRingsCmd$, _
                    ZModemAnswerCmd$, _
                    ZModemGoOffHookCmd$
'     INPUT #2,ZDiskForDos$, _
'              ZDumbModem, _
     IF ZConfMode THEN _
        INPUT #2, ZWasDF$ _                                          ' 175-0115
     ELSE INPUT #2, ZDiskForDos$                                     ' 175-0115
     INPUT #2,ZDumbModem, _                                          ' 175-0115
              ZCmntsAsMsgs                                           ' 175-0115
     IF ZConfMode THEN _
        INPUT #2, ZWasDF, _
                  ZWasDF, _
                  ZWasDF, _
                  ZWasDF, _
                  ZWasDF, _
                  ZWasDF _
     ELSE INPUT #2, ZLSB,_
                    ZMSB,_
                    ZLineCntlReg,_
                    ZModemCntlReg,_
                    ZLineStatusReg,_
                    ZModemStatusReg
     INPUT #2,ZKeepTimeCredits, _
              ZXOnXOff, _
              ZAllowCallerTurbo, _
              ZUseDeviceDriver$, _
              ZPreLog$, _
              ZNewUserQuestionnaire$, _
              ZEpilog$, _
              ZRegProgram$, _
              ZQuesPath$, _
              ZUserLocation$, _
              ZWasDF$, _
              ZWasDF$, _
              ZWasDF$, _
              ZEnforceRatios, _
              ZSizeOfStack, _
              ZSecExemptFromEpilog, _
              ZUseBASICWrites, _
              ZDosANSI, _
              ZEscapeInsecure, _
              ZUseDirOrder, _
              ZAddDirSecurity, _
              ZMaxExtendedLines, _
              ZOrigCommands$
     INPUT #2,ZLogonMailLevel$, _
              ZMacroDrvPath$, _
              ZMacroExtension$, _
              ZEmphasizeOnDef$, _
              ZEmphasizeOffDef$, _
              ZFG1Def$, _
              ZFG2Def$, _
              ZFG3Def$, _
              ZFG4Def$, _
              ZSecVioHelp$
     IF ZConfMode THEN _
        INPUT #2,ZWasDF _
     ELSE INPUT #2,ZFossil
     INPUT #2,ZMaxCarrierWait, _
              ZWasDF, _
              ZSmartTextCode, _
              ZTimeLock, _
              ZWriteBufDef, _
              ZSecKillAny, _
              ZDoorsDef$, _
              ZScreenOutMsg$, _
              ZAutoPageDef$
     ZLibDriveSave$ = ZLibDrive$
     ZFastFileListSave$ = ZFastFileList$
     ZFastFileLocatorSave$ = ZFastFileLocator$
     ZDirCatFileSave$ = ZDirCatFile$
     ZLibSubdirPrefixSave$ = ZLibSubdirPrefix$
     ZLibDirExtensionSave$ = ZLibDirExtension$
     ZLibDirPathSave$ = ZLibDirPath$
     ZDirPrefixSave$ = ZDirPrefix$
     ZUpldSubDirTemp$ = ZUpldSubDir$
     ZOrigCDRomWorkDir$ = ZUpldSubDir$ + "NODE" + ZNodeFileID$ + "\"
     ZCDRom = ZFalse
     ZOrigSec41 = ZOptSec(41)
     ZOrigSec45 = ZOptSec(45)
     IF ZErrCode > 0 THEN _
        EXIT SUB
     ZConfigFileName$ = ConfigFile$
     IF ZCnfgVer$ < "17.5" THEN _
        ZErrCode = 1 : _
        EXIT SUB
     IF ZCnfgVer$ > "17.4A" THEN _
	  INPUT #2,ZMNewDef$, _
		 ZMNUExt$, _
		 ZMNUPath$, _
		 ZColorDef$, _
		 ZMaxNewFiles, _
		 ZFileScanRIP$, _
		 ZFidxCfg$, _
		 ZDescBeforeUpload, _
		 ZCtrlX, _
		 ZWhoUploaded, _
		 ZNodeTxt$, _
		 ZNeedSysMsg$, _
		 ZNoPeek, _
                 ZTwirlyType$, _
                 ZFG5Def$, _
                 ZCheckForRIP
     CALL EditDef
     ZLibDirSave$ = ZLibDir$
     ZCurDirPathSave$ = ZCurDirPath$
     IF NOT ZConfMode AND NOT ZSubBoard THEN _
	CALL ReadColorDef
     END SUB
200 ' $SUBTITLE: 'OpenCom - subroutine to open the communications port'
' $PAGE
'
'  NAME    -- OpenCom
'
'  INPUTS  --     PARAMETER                    MEANING
'                BaudRate$                  BAUD TO OPEN MODEM
'                Parity$                    PARITY TO OPEN MODEM
'
'  OUTPUTS -- BaudTest!                     BAUD RATE TO SET RS232 AT
'
'  PURPOSE -- To open the communications port.
'
    SUB OpenCom (BaudRate$,Parity$) 'STATIC
    ON ERROR GOTO 65000
    IF ZFossil THEN _
       IF ZRTS$ = "YES" THEN _
          ZFlowControl = ZTrue : _
          Flow = &H00F2 : _
          CALL FosFlowCtl(ZComPort,Flow)
    IF INSTR(Parity$,"N") THEN _
       Parity = 2 : _                                     ' No PARITY
       DataBits = 3 : _                                   ' 8 DATA BITS
       StopBits = 0 _                                     ' 1 STOP BIT
    ELSE Parity = 3 : _                                   ' EVEN PARITY
         DataBits = 2 : _                                 ' 7 DATA BITS
         StopBits = 0                                     ' 1 STOP BIT
    IF NOT ZFossil THEN _
       GOTO 202
    WasX& = VAL(Baudrate$)
    SELECT CASE WasX&
       CASE 12000
          ComSpeed = &H2EE0
       CASE 14400
          ComSpeed = &H3840
       CASE 16800
          ComSpeed = &H41A0
       CASE 19200
          ComSpeed = &H4B00
       CASE 21600
          ComSpeed = &H5460
       CASE 24000
          ComSpeed = &H5E88
       CASE 26400
          ComSpeed = &H6720
       CASE 28800
          ComSpeed = &H7080
       CASE 38400
          ComSpeed = &H9600
       CASE 57600
          ComSpeed = &H0E100
    END SELECT
    IF WasX& < 12000 THEN _
       ComSpeed = VAL(Baudrate$)
    CALL FosSpeed(ZComPort,ComSpeed,Parity,DataBits,StopBits)
    EXIT SUB
202 CLOSE 3
    IF ZRTS$ = "YES" THEN _
       ZFlowControl = ZTrue : _
       WasX$ = ",CS26600,CD,DS" _
    ELSE WasX$ = ",RS,CD,DS"
    WasX = (VAL(BaudRate$) > 19200)
    IF WasX THEN _
       ZWasY$ = "19200" _
    ELSE ZWasY$ = BaudRate$
    OPEN ZComPort$ + ":" + ZWasY$ + Parity$ + WasX$ AS #3
'
' ****************************************************************************
' *  RAISE THE RTS SIGNAL IF THE MODEM USES RTS FOR MODEM FLOW CONTROL (ONCE
' *  IT IS RAISED, IT WILL STAY UP UNTIL THE REGISTER IS CLEARED OUT).
' ****************************************************************************
'
    END SUB
'
1418 ' $SUBTITLE: 'GetCom -- subroutine reads a char. from  comm. port'
' $PAGE
'
'  NAME    -- GetCom
'
'  INPUTS  --   PARAMETER     MEANING
'                 Strng$       STRING TO READ A CHARACTER INTO FROM
'                              THE COMMUNICATIONS PORT (FILE #3)
'
'  OUTPUTS --   Strng$
'
'  PURPOSE -- Reads a character from the communications port.
'
     SUB GetCom (Strng$) STATIC
     ON ERROR GOTO 65000
1420 IF ZFOSSIL THEN _
        CALL FOSRXChar(ZComPort,Char) : _
        Strng$ = CHR$(Char) _
     ELSE Strng$ = INPUT$(1,3)
1421 IF ZErrCode = 57 THEN _
        LineStatus = INP(ZLineStatusReg) : _
        ZErrCode = 0 : _
        GOTO 1420
     END SUB
1450 ' $SUBTITLE: 'CopyFile  - Copy a file from CD-ROM to holding directory'
' $PAGE
'
'  NAME    -- CopyFile
'
'  INPUTS  -- PARAMETER             MEANING
'             FilName$      Name of file to copy
'             Whereto$      Where to copy file to
'             Type          1 = CD-ROM
'                           0 = Other
'
'  OUTPUTS --
'
'
'  PURPOSE -- To copy a file from CD-ROM to a download holding directory.
'             Can be used to copy a file from one directory to another
'             Including across drives.
'
     SUB CopyFile (FilName$,Whereto$,FType)
     ON ERROR GOTO 65000
     IF FType = 1 AND NOT ZCDWorkDriveFull THEN ' Create semaphore file to lock out
        FilNum1 = 2               ' out nodes in multinode environ
        CALL OpenWork (FilNum1,"CDWORK" + ZLibDrive$ + ".WRK",ZTrue)
        CALL PrintWork (FilNum1,ZNodeId$,ZFalse)
        CLOSE FilNum1
     END IF
     ZWasZ$ = MID$(Whereto$,1,2)
     CALL FindFree
     FilNum1 = 2
     CALL OpenWork (FilNum1,FilName$,ZFalse)
     Temp& = LOF(FilNum1)
     CLOSE FilNum1
     IF VAL(ZFreeSpace$) < Temp& + 4096 THEN _
        ZCDWorkDriveFull = ZTrue : _
        CALL LPrnt (ZEmphasizeOn$ + "CD ROM work drive insufficient space to copy!" + _
                     ZEmphasizeOff$,1) : _
        EXIT SUB
     FileLen# = 0
     LenLastRec# = 0
     NumRecs# = 0
     RecLen# = 1024
     FilNum1 = 11
     IF FType = 1 OR ZShareIt THEN
        OPEN FilName$ FOR BINARY ACCESS READ SHARED AS #FilNum1 LEN = RecLen#
     ELSE
        OPEN FilName$ FOR BINARY ACCESS READ AS #FilNum1 LEN = RecLen#
     END IF
     FileLen# = LOF(FilNum1)
     IF FileLen# >= 1024 THEN
        NumRecs# = FileLen# \ RecLen#
        LenLastRec# = FileLen# - (NumRecs# * RecLen#)
     END IF
     IF FileLen# < 1024 THEN
        NumRecs# = 1
        RecLen# = FileLen#
        CLOSE FilNum1
        IF FType = 1 OR ZShareIt THEN
           OPEN FilName$ FOR BINARY ACCESS READ SHARED AS #FilNum1 LEN = RecLen#
        ELSE
           OPEN FilName$ FOR BINARY ACCESS READ AS #FilNum1 LEN = RecLen#
        END IF
     END IF
     CALL BreakFileName (FilName$,DR$,Pre$,Ext$,ZTrue)
     OutFile$ = WhereTo$ + Pre$ + Ext$
     FilNum2 = 12
     IF FType = 1 OR ZShareIt THEN
        OPEN OutFile$ FOR BINARY ACCESS WRITE SHARED AS #FilNum2 LEN = RecLen#
     ELSE
        OPEN OutFile$ FOR BINARY ACCESS WRITE AS #FilNum2 LEN = RecLen#
     END IF
     IF ZErrCode > 74 AND ZErrCode < 77 THEN
        ZErrCode = 0
        CALL LPrnt ("CD-ROM work directory missing...creating directory",1)
        CLOSE FilNum2
        MKDIR MID$(WhereTo$,1,LEN(WhereTo$) - 1)
        IF FType = 1 OR ZShareIt THEN
           OPEN OutFile$ FOR BINARY ACCESS WRITE SHARED AS #FilNum2 LEN = RecLen#
        ELSE
           OPEN OutFile$ FOR BINARY ACCESS WRITE AS #FilNum2 LEN = RecLen#
        END IF
     END IF
     CopyFrom$ = STRING$(RecLen#," ")
     CopyTo$ = STRING$(RecLen#," ")
     FOR X# = 1 TO NumRecs#
        GET #FilNum1,,CopyFrom$
        LSET CopyTo$ = CopyFrom$
        PUT #FilNum2,,CopyTo$
     NEXT
     IF LenLastRec# > 0 THEN
        CopyFrom$ = STRING$(LenLastRec#," ")
        CopyTo$ = STRING$(LenLastRec#," ")
        GET #FilNum1,,CopyFrom$
        LSET CopyTo$ = CopyFrom$
        PUT #FilNum2,,CopyTo$
     END IF
     CLOSE FilNum1,FilNum2
     CopyTo$ = ""
     CopyFrom$ = ""
     FilName$ = OutFile$
     IF FType = 1 THEN _
        CALL KillWork ("CDWORK" + ZLibDrive$ + ".WRK") ' Delete semaphore file
1460 END SUB
'
1465 ' $SUBTITLE: 'KillCDWork - Kill files copied to CD Work Dir'
' $PAGE
'
'  NAME    -- KillCDWork
'
'  INPUTS  -- PARAMETER             MEANING
'
'
'
'  OUTPUTS --
'
'
'  PURPOSE -- Delete files copied to hard disk for downloading from
'             CD-ROM drive.
'
     SUB KillCDWork
     ON ERROR GOTO 65000
     OK = ZFalse
     IF ZUseCDWorkDrive THEN
        CALL FindFile (ZDownloadWorkFile$,OK)
        IF OK THEN
           FilNum = 2
           CALL OpenWork (FilNum,ZDownloadWorkFile$,ZFalse)
           WHILE NOT EOF(FilNum)
              LINE INPUT #FilNum,FilName$
              KILL FilName$
           WEND
           CLOSE FilNum
        ELSE
           EXIT SUB
        END IF
     END IF
     CALL KillWork (ZDownloadWorkFile$)
     END SUB
'
1479 ' $SUBTITLE: 'OpenRSeq  - open sequential file randomly'
' $PAGE
'
'  NAME    -- OpenRSeq
'
'  INPUTS  -- PARAMETER             MEANING
'             FilName$      NAME OF SEQUENTIAL FILE TO OPEN AS #2
'             RecLen        LENGTH OF A RECORD
'             FilNum        FILE NUMBER TO OPEN
'
'  OUTPUTS -- NumRecs&     NUMBER OF RECORDS IN THE FILE BASED ON RecLen
'             LenLastRec   NUMBER OF BYTES IN THE LAST RECORD
'                          MAY BE LESS THAN OR EQUAL TO RecLen).
'
'  PURPOSE -- Open a sequential file as file #2 and read it randomly
'
     SUB OpenRSeq (FilName$,NumRecs&,LenLastRec,RecLen,FilNum) STATIC
     ON ERROR GOTO 65000
     CALL OpenRand2 (FilName$,RecLen,FilNum)
     IF ZErrCode > 0 THEN _
        EXIT SUB
     FIELD FilNum, RecLen AS ZDnldRecord$
     WasI# = LOF(FilNum)
     NumRecs& = FIX(WasI#/RecLen)
     LenLastRec = WasI# - CDBL(NumRecs&) * RecLen
     IF LenLastRec > 0 THEN _
        NumRecs& = NumRecs& + 1 _
     ELSE LenLastRec = RecLen
     END SUB
1486 SUB OpenRand2 (FileToOpen$,FileLen,FilNum)
     ON ERROR GOTO 65000
     CLOSE FilNum
1487 ZErrCode = 0
     IF ZShareIt THEN _
        OPEN FileToOpen$ FOR RANDOM SHARED AS FilNum LEN=FileLen _
     ELSE OPEN "R",FilNum,FileToOpen$,FileLen
     END SUB
'
9398 ' $SUBTITLE: 'OpenUser - subroutine to open users file as #5'
' $PAGE
'
'  NAME    -- OpenUser
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZShareIt
'
'  OUTPUTS -- ZActiveUserFile$
'             ZCityState$
'             ZElapsedTime$
'             ZLastDateTimeOn$
'             LastRec                # OF LAST RECORD IN USERS FILE
'             ZListNewDate$
'             ZPswd$
'             ZSecLevel$
'             ZUserDnlds$
'             ZUserName$
'             ZUserOption$
'             ZUserRecord$
'             ZUserUplds$
'
'  PURPOSE -- Open the user file as file #5
'
      SUB OpenUser (LastRec)
      ON ERROR GOTO 65000
'
' ****  OPEN AND DEFINE USER FILE RECORD VARIABLES  ****
'
9400 CLOSE 5
     IF ZShareIt THEN _
        OPEN ZActiveUserFile$ FOR RANDOM SHARED AS #5 LEN=128 _
     ELSE OPEN "R",5,ZActiveUserFile$,128
     WasI# = LOF(5)
     LastRec = FIX(WasI#/128)
     FIELD 5,31 AS ZUserName$, _
             15 AS ZPswd$, _
              2 AS ZSecLevel$, _
             14 AS ZUserOption$,  _
             24 AS ZCityState$, _
              1 AS MachineType$, _
              1 AS ZDropTimes$, _
              1 AS ZBankTime$,_
              4 AS ZTodayDl$, _
              4 AS ZTodayBytes$, _
              4 AS ZDlBytes$, _
              4 AS ZULBytes$, _
             14 AS ZLastDateTimeOn$, _
              3 AS ZListNewDate$, _
              2 AS ZUserDnlds$, _
              2 AS ZUserUplds$, _
              2 AS ZElapsedTime$
     FIELD 5,128 AS ZUserRecord$
     END SUB
'
10091 '$SUBTITLE: 'DisplayUser -- subroutine to display users file'
' $PAGE
'
' NAME: DisplayUser
'
' PURPOSE: To display users file with "U" from Utility Menu or
'          2 from SysOp Menu.  Formerly in RBBS-PC.BAS
'
' INPUTS:
'
' OUTPUTS:
'
'
      SUB DisplayUser STATIC
10092 CALL Muzak (6)
      ZOutTxt$ = "List - U)sers, R)ecent callers"
      ZMacroMin = 2
      CALL SkipLine (1)
      GOSUB 10100
      IF ZWasQ = 0 THEN _
         EXIT SUB
      CALL AraAllCaps (ZUserIn$(),ZAnsIndex)
      ON INSTR("UR",ZUserIn$(ZAnsIndex)) + 1 GOTO 10092,10096,10093
10093 CALL DispCall
      EXIT SUB
10096 UserRecordHold$ = ZUserRecord$
      IF ZConfMode THEN _
         ZOutTxt$ = "Users of " + _
              ZConfName$ + _
              ":" : _
         GOSUB 10101
      CALL OpenUser (ZHighestUserRecord)
      FIELD 5,128 AS ZUserRecord$
      ZStopInterrupts = ZFalse
      WasI = 1
      ZWasZ$ = ZSecretName$
10097 IF WasI > ZHighestUserRecord OR ZRet THEN _
         GOTO 10099
      GET 5,WasI
      WasX$ = MID$(ZUserRecord$,ZStartHash,ZLenHash)
      IF ASC(WasX$)=0 OR LEFT$(WasX$,3)="   " THEN _
         GOTO 10098
      IF INSTR(WasX$,ZWasZ$) > 0 OR ZSysopSecLevel <= CVI(MID$(ZUserRecord$,47,2)) THEN _
         IF NOT ZSysop THEN _
            GOTO 10098
      CALL AskMore ("",ZTrue,ZTrue,WasXX,ZFalse)
      IF ZNo OR ZSubParm = -1 THEN _
         GOTO 10099
      ZOutTxt$ = LEFT$(WasX$,36) + ZCityState$ + ZLastDateTimeOn$
      GOSUB 10101
10098 WasI = WasI + 1
      GOTO 10097
10099 ZOutTxt$ = ""
      LSET ZUserRecord$ = UserRecordHold$
      ZStopInterrupts = ZTrue
      IF NOT ZExpertUser THEN _
         CALL AskMore ("",ZTrue,ZFalse,WasXX,ZTrue)
      EXIT SUB
10100 ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm < 0 THEN _
         EXIT SUB
      RETURN
10101 ZSubParm = 5
      CALL TPut
      IF ZSubParm < 0 THEN _
         EXIT SUB
      IF ZSubParm = 8 THEN _
         ZSubParm = 1 : _
         CALL TGet : _
         IF ZSubParm < 0 THEN _
            EXIT SUB
      RETURN
      END SUB
12598 ' $SUBTITLE: 'FindUser - subroutine to search users file for a name'
' $PAGE
'
'  NAME    -- FindUser
'
'  INPUTS  --     PARAMETER                    MEANING
'             HashToLookFor$        STRING TO SEARCH FOR IN USERS
'             IndivToLookFor$       STRING TO USE TO INDIVIDUATE
'                                   USERS WITH SAME HASH
'             StartHashPos          WHERE HASH FIELD STARTS IN THE
'                                   "USERS" FILE
'             LenHashField          LENGTH OF THE HASH FIELD
'             StartIndivPos         WHERE THE FIELD TO DISTINGUISH
'                                   AMONG USERS (I.E. WITH THE SAME
'                                   NAME) STARTS IN THE "USERS" FILE
'                                   (SET TO 0 IF NONE TO BE USED)
'             LenIndivField         LENGTH OF FIELD TO DISTINGUISH
'                                   AMONG USERS
'             MaxPosition           HIGHEST RECORD TO SEARCH OR USE
'
'  NOTE: THIS SUBROUTINE ASSUMES THE "USERS" FILE IS OPEN AS FILE 2.
'
'  OUTPUTS -- WhetherFound          SET TO "TRUE" IF USER WAS FOUND
'                                   OTHERWISE IT IS "FALSE"
'             PosToUse              NUMBER OF THE "USERS" RECORD THAT
'                                   BELONGS TO THE USER (IF FOUND) OR
'                                   TO USE FOR THE USER (IF THE USER
'                                   WASN'T FOUND)
'             PosToReclaim          SET TO 0 IF THE RECORD NUMBER
'                                   SELECTED FOR THIS USER HAS NEVER
'                                   BEEN USED.
'
'  PURPOSE -- To search the "USERS" file and determine the record
'             number to use for the caller in the "USERS" file.
'
      SUB FindUser (HashToLookFor$,IndivToLookFor$,StartHashPos,_
                    LenHashField,StartIndivPos,LenIndivField,_
                    MaxPosition,WhetherFound,_
                    PosToUse,PosToReclaim) STATIC
      ON ERROR GOTO 65000
      ZErrCode = 0
      WhetherFound = 0
      IF HashToLookFor$ = SPACE$(LEN(HashToLookFor$)) THEN _
         EXIT SUB
      EmptyRec$ = SPACE$(LenHashField)
      EmptyIndiv$ = SPACE$(LenIndivField)
      NewUser$ = LEFT$("NEWUSER  ",LenHashField + 2)
      FIELD 5, 128 AS Filler$
      WasX$ = HashToLookFor$ + SPACE$(LenHashField - LEN(HashToLookFor$))
      CALL HashRBBS (HashToLookFor$,MaxPosition,PosToUse,ZWasDF)
12600 ZWasY$ = IndivToLookFor$ + SPACE$(LenIndivField - LEN(IndivToLookFor$))
      PosToReclaim = 0
      ZErrCode = 0
12610 GET 5,PosToUse
      IF ZErrCode > 0 THEN _
         IF ZErrCode = 63 THEN _
            ZErrCode = 0 : _
            GOTO 12621 _
         ELSE ZErrCode = 0 : _
              GOTO 12620
      HashValue$ = MID$(Filler$,StartHashPos,LenHashField)
      IF WasX$ = HashValue$ THEN _
         IF StartIndivPos < 1 OR LenIndivField < 1 THEN _
            WhetherFound = ZTrue : _
            GOTO 12622 _
         ELSE IndivValue$ = MID$(Filler$,StartIndivPos,LenIndivField) : _
              IF ZWasY$ = IndivValue$ OR IndivValue$ = EmptyIndiv$ THEN _
                 WhetherFound = ZTrue : _
                 GOTO 12622
      IF HashValue$ = EmptyRec$ THEN _
         PosToUse = PosToReclaim - (PosToReclaim = 0) * PosToUse : _
         WhetherFound = ZFalse : _
         GOTO 12622
      IF ASC(HashValue$) = 0 OR INSTR(HashValue$,NewUser$) = 1 THEN _
         IF PosToReclaim = 0 THEN _
            PosToReclaim = PosToUse
12620 PosToUse = PosToUse + ZWasDF
      IF PosToUse > MaxPosition - 1 THEN _
         PosToUse = PosToUse - MaxPosition
      GOTO 12610
12621 IF PosToReclaim = 0 THEN _
         PosToReclaim = PosToUse
      GOTO 12620
12622 END SUB
13661 ' $SUBTITLE: 'UpdtCalr - subroutine to write to CALLERS file'
' $PAGE
'
'  NAME    -- UpdtCalr
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ErrMsg$                   MESSAGE TO GO IN CALLER LOG
'                 EXTLog               = 1  CHECK FOR EXTENDED LOGGING
'                                           BEFORE UPDATING.
'                                      = 2  UPDATE CALLER LOG WITH ZWasZ$
'                                      = 3  TIME STAMP BEFORE LOGGING
'
'  OUTPUTS -- ZCurDate$                CURRENT DATE (MM-DD-YY)
'             ZTime$                   CURRENT TIME (I.E. 1:13 PM)
'             TIME.LOGGEND.ON$         TIME USER LOGGED ON (HH:MM:SS)
'
'  PURPOSE -- To update the caller's file and/or print on the
'             local printer if it is enabled
'
      SUB UpdtCalr (ErrMsg$,EXTLog)
      ON ERROR GOTO 65000
      IF ZCallersFilePrefix$ = "" OR (ZLocalUser AND ZSysop) THEN _
         EXIT SUB
      WasX$ = "     " + ErrMsg$
13663 ZErrCode = 0
      FIELD 4, 64 AS ZCallersRecord$
      IF ZErrCode > 0 THEN _
         CALL QuickTPut1 ("Caller's file:  error"+STR$(ZErrCode)) : _
         ZErrCode = 0 : _
         EXIT SUB
      ON EXTLog GOTO 13665,13670,13667
'
' ****  EXTENDED LOGGING ENTRY  ***
'
13665 IF NOT ZExtendedLogging THEN _
         EXIT SUB
13667 CALL AMorPM
      WasX$ = WasX$ + " at " + ZTime$
'
' ****  UPDATE CALLERS FILE WITH USER ACTIVITY  ****
'
13670 LSET ZCallersRecord$ = WasX$
      CALL Printit (ZCallersRecord$)
      ZCallersFileIndex! = ZCallersFileIndex! + 1
13672 PUT 4,ZCallersFileIndex!
      END SUB
13673 ' $SUBTITLE: 'Printit - subroutine to print on the local printer'
' $PAGE
'
'  NAME    -- Printit
'
'  INPUTS  --     PARAMETER                    MEANING
'                 Strng$              STRING TO WRITE TO THE PRINTER
'
'  OUTPUTS -- NONE
'
'  PURPOSE -- To write to the printer attached to the pc running
'             RBBS-PC and toggle the printer switch off whenever
'             the printer is/becomes unavailable
'
      SUB Printit (Strng$)
      ON ERROR GOTO 65000
13674 IF ZPrinter THEN _
         LPRINT Strng$
      END SUB
20101 ' $SUBTITLE: 'ChangeDir - subroutine to change subdirectories'
' $PAGE
'
'  NAME    -- ChangeDir
'
'  INPUTS  -- PARAMETER                    MEANING
'             NewDir$                      NAME OF SUBDIRECTORY
'
'  OUTPUTS -- ZOK                           TRUE IF CHDIR SUCCESSFUL
'             ZErrCode                      ERROR CODE
'
'  PURPOSE -- Change subdirectory
'
      SUB ChangeDir (NewDir$)
      ON ERROR GOTO 65000
      ZErrCode = 0
      ZOK = ZTrue
20103 CHDIR NewDir$
      END SUB
20219 ' $SUBTITLE: 'FINDITX - subroutine to find if a file exists'
' $PAGE
'
'  NAME    -- FINDITX
'
'  INPUTS  -- PARAMETER                    MEANING
'             FilName$                 NAME OF FILE TO FIND
'             FileNum                  # TO OPEN FILE AS
'
'  OUTPUTS -- ZOK                      TRUE IF FILE EXISTS
'             ZErrCode                 ERROR CODE
'
'  PURPOSE -- Determine whether a file exists
'
      SUB FindItX (FilName$,FileNum)
      ON ERROR GOTO 65000
      ZErrCode = 0
      ZOK = ZFalse
      IF LEN(FilName$) < 1 THEN _
         EXIT SUB
      IF ZTurboRBBS THEN _
         CALL FindFile (FilName$,ZOK) : _
         IF ZOK THEN _
            GOTO 20222 _
         ELSE EXIT SUB
20221 CALL BadFileChar (FilName$,ZOK)
      IF NOT ZOK THEN _
         EXIT SUB
      ZOK = ZFalse
      NAME FilName$ AS FilName$
      IF ZErrCode = 53 THEN _
         ZErrCode = 0 : _
         EXIT SUB
20222 CLOSE FileNum
20223 CALL OpenWork (FileNum,FilName$,ZFalse)
      IF ZErrCode = 64 OR ZErrCode = 76 THEN _
         ZOK = ZFalse : _
         EXIT SUB
      ZOK = ZTrue
      END SUB
20308 ' $SUBTITLE: 'FlushCom -- subroutine reads all char. from  comm. port'
' $PAGE
'
'  NAME -- FlushCom
'
'  INPUTS --   PARAMETER     MEANING
'              STrng$       STRING TO READ CHARACTERS INTO FROM
'                           THE COMMUNICATIONS PORT (FILE #3)
'
'  OUTPUTS --   Strng$
'
'  PURPOSE -- Reads all characters from the communications port.
'
      SUB FlushCom (Strng$)
      ON ERROR GOTO 65000
      IF ZLocalUser THEN _
         EXIT SUB
      Strng$ = ""
      IF NOT ZFossil THEN _
         GOTO 20311
20310 CALL FosReadAhead(ZComPort,Char)
      IF Char <> -1 THEN _
         CALL FOSRXChar(ZComPort,Char) : _
         Strng$ = Strng$ + CHR$(Char) : _
         GOTO 20310
      EXIT SUB
20311 Strng$ = INPUT$(LOC(3),3)                     ' FLUSH THE COMM BUFFER
20312 IF ZErrCode = 57 THEN _
         LineStatus = INP(ZLineStatusReg) : _
         ZErrCode = 0 : _
         GOTO 20311
      END SUB
20898 ' $SUBTITLE: 'NetBIOS - subroutine to lock/unlock using NetBIOS'
' $PAGE
'
'  NAME    -- NetBIOS   (WRITTEN BY DOUG AZZARITO)
'
'  INPUTS  -- IBMLockCmd       = 1-LOCK, 0-UNLOCK
'             IBMFileLock      = 5 USERS FILE
'                              = 6 SEMAPHORE FILE
'             IBMRecLock       = RECORD NUMBER TO LOCK
'
'  OUTPUTS -- NONE
'
'  PURPOSE -- Lock and unlock files using NetBIOS commands.
'             If lock fails, this routine tries forever.
'
      SUB NetBIOS (IBMLockCmd,IBMFileLock,IBMRecLock) STATIC
      STATIC IBMCount
      ON ERROR GOTO 65000
20900 ON IBMLockCmd + 1 GOTO 20920, 20910
      EXIT SUB
'
' *****  LOCK LOOP   ****
'
20910 ZErrCode = 0
      IF IBMFileLock = 6 AND IBMRecLock = 3 THEN _
         IBMCount = IBMCount + 1 : _
         IF IBMCount > 1 THEN _
            EXIT SUB
      LOCK IBMFileLock, IBMRecLock TO IBMRecLock
      IF ZErrCode <> 0 THEN _
         GOTO 20910
      EXIT SUB
20920 ZErrCode = 0
      IF IBMFileLock = 6 AND IBMRecLock = 3 THEN _
         IBMCount = IBMCount - 1 : _
         IF IBMCount > 0 THEN _
            EXIT SUB _
         ELSE IBMCount = 0
      UNLOCK IBMFileLock, IBMRecLock TO IBMRecLock
      IF ZErrCode = 70 THEN _
         EXIT SUB
      IF ZErrCode <> 0 THEN _
         GOTO 20920
      END SUB
'
'21105 ' $SUBTITLE: 'Library - sub to support Library downloads'
' $PAGE
'
'  NAME    -- Library
'
'  INPUTS  --     PARAMETER                    MEANING
'              ZSubParm                 1 = DISPLAY ACTIVE AREA
'                                       2 = CHANGE ACTIVE AREA
'                                       3 = DISPLAY PC-SIG
'                                           DISCLAIMER
'                                       4 = ARCHIVE LIBRARY DISK
'                                       5 = DOWNLOAD COMPLETED
'              ZLibType                 0 = NO LIBRARY ACTIVE
'                                       1 = LIBRARY FROM PC-SIG
'              ZLibDrive$                   LIBRARY DRIVE ID
'
'  OUTPUTS -- NONE
'
'  PURPOSE -- To provide access support for library drives
'
'      SUB Library STATIC
'      STATIC LibSubdirName$(1)
'      STATIC DiskTitle$
'      ZErrCode = 0
'      IF ZLibType = 0 THEN _
'         EXIT SUB
'      IF ZLibDiskChar$ = "" THEN _
'         ZLibDiskChar$ = "0000"
'      ON ZSubParm GOTO 21110, 21115, 21130, 21140, 21159
'21110 IF ZLibDiskChar$ = "0000" THEN _
'         ZOutTxt$ = "No Library disk currently selected" _
'      ELSE ZOutTxt$ = "Library disk " + _
'                ZLibDiskChar$ + _
'                " selected - " + _
'                DiskTitle$
'      CALL QuickTPut1 (ZOutTxt$)
'      IF LibDiskArc$ = "" THEN _
'         EXIT SUB
'      IF INSTR(ZLibArcProgram$,"ARC") THEN _
'         Extension$ = "ARC" _
'      ELSE IF INSTR(ZLibArcProgram$,"ZIP") THEN _
'         Extension$ = "ZIP" _
'      ELSE IF INSTR(ZLibArcProgram$,"LHA") THEN _
'         Extension$ = "LZH" _
'      ELSE IF INSTR(ZLibArcProgram$,"ARJ") THEN _
'         Extension$ = "ARJ" _
'      ELSE Extension$ = ZDefaultExtension$
'      FOR LibDisplayCount = 0 TO LibLoopCount - 1
'         IF LibSubdirName$(LibDisplayCount) <> "" THEN _
'            CALL QuickTPut1 (LibSubdirName$(LibDisplayCount) + _
'                       "." + Extension$ + " ready for transmission!")
'      NEXT
'      EXIT SUB
'21115 IF ZWasQ = 1 THEN _
'         ZOutTxt$ = "Change Library disk from " + _
'              ZLibDiskChar$ + _
'              " to (1 -" + _
'              STR$(ZLibMaxDisk) + _
'              ")" : _
'         ZSubParm = 1 : _
'         CALL TGet : _
'         IF ZSubParm = -1 THEN _
'            EXIT SUB _
'         ELSE IF ZWasQ = 0 THEN _
'                 ZLibDiskChar$ = "0000" : _
'                 ChdirLib$ = ZLibDrive$ + _
'                                  "\" : _
'                 GOTO 21126
'21117 IF VAL(ZUserIn$(ZWasQ)) < 1 OR VAL(ZUserIn$(ZWasQ)) > ZLibMaxDisk THEN _
'         ZWasQ = 1 : _
'         GOTO 21115
'21120 ZLibDiskChar$ = ZUserIn$(ZWasQ)
'      CLOSE 2
'      ZLibDiskChar$ = RIGHT$("0000" + ZLibDiskChar$,4)
'21121 CALL FindIt("RBBS-CDR.DEF")
'      IF NOT ZOK THEN _
'         EXIT SUB
'21122 IF EOF(2) THEN _
'         ZLibDiskChar$ = "" : _
'         EXIT SUB
'      INPUT #2,WorkSubdir$,ChdirLib$
'      LINE INPUT #2,DiskTitle$
'      IF ZLibDiskChar$ = WorkSubdir$ THEN _
'         ChdirLib$ = ZLibDrive$ + _
'                          ChdirLib$ : _
'         GOTO 21126
'      GOTO 21122
'21126 ZErrCode = 0
'      CALL ChangeDir (ChdirLib$)
'      IF ZErrCode <> 0 THEN _
'         ZLibDiskChar$ = "0000" : _
'         ChdirLib$ = ZLibDrive$ + _
'                          "\" : _
'         GOTO 21126
'      EXIT SUB
'21130 IF ZLibType <> 1 THEN _
'         EXIT SUB
'      CALL SkipLine(1)
'      ZOutTxt$ = "The PC-SIG Library file that you are about to"
'      CALL QuickTPut1 (ZOutTxt$)
'      ZOutTxt$ = "download can also be ordered as DISK " + _
'           ZLibDiskChar$
'      CALL QuickTPut1 (ZOutTxt$)
'      ZOutTxt$ = "from PC-SIG, 1030D East Duane Ave. Sunnyvale, Ca. 94086"
'      CALL QuickTPut (ZOutTxt$,2)
'      EXIT SUB
'21140 IF ZLibDiskChar$ = "0000" THEN _
'         CALL QuickTPut1 ("First select a Library disk!") : _
'         EXIT SUB
'      ZOutTxt$ = "Archive files in Library disk - " + _
'           ZLibDiskChar$ + _
'           " for download (Y,[N])"
'      ZSubParm = 1
'      CALL TGet
'      IF NOT ZLocalUser THEN _
'         IF ZSubParm = -1 THEN _
'            EXIT SUB
'      IF NOT ZYes THEN _
'         EXIT SUB
'21145 CALL KillWork (ZLibWorkDiskPath$ + _
'                    ZLibNodeID$ + _
'                    "DK*." + Extension$)
'21150 CALL QuickTPut1 ("Work/RAM disk purged")
'      CALL QuickTPut1 ("Archiving with " + _
'                  ZLibArcProgram$ + _
'                  " Please be patient!")
'      REDIM LibSubdirName$(10)
'      LibSubdirChar$ = ""
'      LibLoopCount = 0
'      GOSUB 21157
'      ZOutTxt$ = "Contents of Library disk - " + _
'           ZLibDiskChar$ + _
'           " now archived for download"
'      CALL QuickTPut1 (ZOutTxt$)
'      ZOutTxt$ = "Searching for Sub-directories"
'      CALL QuickTPut1 (ZOutTxt$)
'      GOSUB 21158
'      LibDiskArc$ = ZLibDiskChar$
''
'' SEARCH AND ARCHIVE ANY SUBDIRECTORIES
''
'      Treedir$ = ZLibWorkDiskPath$ + _
'                 ZLibNodeID$ + _
'                 "DKDIR.LST"
'      DirCmd$ = "DIR " + _
'                ZLibDrive$ + _
'                " | FIND " +  _
'                CHR$(34) + _
'                " <DIR> " + _
'                CHR$(34) + _
'                "  > " + _
'                Treedir$
'21151 SHELL DirCmd$
'      CALL SkipLine (2)
'      LOCATE 24,1
'      ZErrCode = 0
'21152 CLOSE 2
'21153 CALL OpenWork (2,Treedir$,ZFalse)
'      LibSubdirCount = 0
'      WHILE NOT EOF(2)
'         LINE INPUT #2, Dirrec$
'         IF LEFT$(Dirrec$,1) <> "." THEN _
'            LibSubdirCount = LibSubdirCount + 1 : _
'            LibSubdirName$(LibSubdirCount) = _
'            LEFT$(Dirrec$,8)
'      WEND
'      CLOSE 2
'      LibLoopCount = 1
'      IF LibSubdirCount = 0 THEN _
'         GOTO 21156
'      ZOutTxt$ = STR$(LibSubdirCount) + _
'           " Subdirectories on Library disk - " + _
'           ZLibDiskChar$
'      CALL QuickTPut1 (ZOutTxt$)
'      FOR LibLoopCount = 1 TO LibSubdirCount
'         IF NOT ZLocalUser THEN _
'            CALL Carrier : _
'            IF ZSubParm THEN _
'               GOTO 21155
'         LibSubdirChar$ = MID$("ABCDEFGHI",LibLoopCount,1)
'         ZOutTxt$ = "Creating " + _
'              ZLibNodeID$ + _
'              "DK" + _
'              ZLibDiskChar$ + _
'              LibSubdirChar$ + "." + Extension$ + _
'              " using " + ZLibArcProgram$
'         CALL QuickTPut1 (ZOutTxt$)
'         CHDIR ChdirLib$ + _
'               "\" + _
'               LibSubdirName$(LibLoopCount)
'         GOSUB 21157
'         ZOutTxt$ = "Disk - " + _
'              ZLibDiskChar$ + _
'              "; Subdirectory" + _
'              " -" + _
'              STR$(LibLoopCount) + _
'              " archived for download"
'         CALL QuickTPut1 (ZOutTxt$)
'         GOSUB 21158
'21155 NEXT LibLoopCount
'21156 CALL Carrier
'      ZOutTxt$ = ""
'      EXIT SUB
'21157 LibArc$ = ZLibArcPath$ + _
'                       ZLibArcProgram$ + _
'                       " " + _
'                       ZLibWorkDiskPath$ + _
'                       ZLibNodeID$ + _
'                       "DK" + _
'                       ZLibDiskChar$ + _
'                       LibSubdirChar$ + _
'                       " " + _
'                       ZLibDrive$ + _
'                       "*.*"
'      IF ZUseDeviceDriver$ <> "" AND ZFossil AND NOT ZLocalUser THEN _
'         LibArc$ = ZDiskForDos$ + _
'                            "COMMAND /C " + _
'                            LibArc$ + _
'                            " > " + _
'                            ZUseDeviceDriver$
'      SHELL LibArc$
'      CALL SkipLine (2)
'      LOCATE 24,1
'      RETURN
'21158 LibSubdirName$(LibLoopCount) = ZLibNodeID$ + _
'                                             "DK" + _
'                                             ZLibDiskChar$ + _
'                                             LibSubdirChar$
'      RETURN
'21159 FOR LibDisplayCount = 0 TO LibLoopCount - 1
'         IF LibSubdirName$(LibDisplayCount) = ZOutTxt$ THEN _
'            LibSubdirName$(LibDisplayCount) = ""
'      NEXT
'      END SUB
'
43000 '$SUBTITLE: 'GraphicsSet -- subroutine to allow user to set graphics pref'
' $PAGE
'
' NAME: GraphicsSet
'
' PURPOSE: To allow user to set their graphics preference
'          Formerly in RBBS-PC.BAS
'
' INPUTS:
'
' OUTPUTS:
'
'
      SUB GraphicsSet STATIC
43002 IF ZRIPTest AND NOT ZNewUser THEN
         WasRIP = ZFalse
         ZOutTxt$ = "Disable RIP Support (Y, [N])"
         CALL TGet
         CALL AllCaps (ZUserIn$)
         IF ZUserIn$ = "Y" THEN
            WasRIP = ZTrue
            ZRIPTest = ZFalse
            CALL QuickTPut1 (ZRIPReset$)
            ZUserGraphicDefault$ = "C"
         END IF
         GOTO 43003
      END IF
      IF WasRIP THEN
         ZOutTxt$ = "Re-enable RIP Support (Y, [N])"
         CALL TGet
         CALL AllCaps (ZUserIn$)
         IF ZUserIn$ = "Y" THEN
            WasRIP = ZFalse
            ZRIPTest = ZTrue
            ZUserGraphicDefault$ = "R"
         END IF
         GOTO 43003
      END IF
      GOTO 43005
43003 ZOutTxt$ = "Change GRAPHICS Defaults (Y, [N])"
      CALL TGet
      CALL AllCaps (ZUserIn$)
      IF ZUserIn$ <> "Y" THEN
         EXIT SUB
      END IF
43005 GOSUB 43007
      GOTO 43022
43007 CALL AskGraphics
      IF ZSubParm = -1 THEN _
         EXIT SUB
      IF ZWasQ = 0 THEN _
         RETURN
43020 ZOutTxt$ = "Text Graphics: " + _
           MID$("None AsciiColor",ZWasGR * 5 + 1,5)
      ZSubParm = 5
      CALL TPut
      IF ZSubParm < 0 THEN _
         EXIT SUB
      IF ZSubParm = 8 THEN _
         CALL TGet : _
         IF ZSubParm < 0 THEN _
            EXIT SUB
      RETURN
43022 ZPrevPUI$ = ""
      IF ZEmphasizeOnDef$ = "" THEN _
         EXIT SUB
      ZOutTxt$ = "Do you want colorized prompts ([Y],N)"
      ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm < 0 THEN _
         EXIT SUB
      ZHiLiteOff = NOT ZNo
      CALL Toggle(5)
      END SUB
43048 ' $SUBTITLE: 'UpdateC - update of callers log on exiting'
' $PAGE
'
'  NAME    -- UpdateC
'
'  INPUTS  --     PARAMETER                    MEANING
'             ZCallersFileIndex!
'             ZFirstName$
'             ZWasHHH
'             ZLastName$
'             ZWasMMM
'             ZWasNG$
'             ZWasSSS
'             ZSysopFirstName$
'             ZSysopLastName$
'
'  OUTPUTS -- ZCallersRecord$
'             ZCallersFileIndex!
'             ZSysop
'
'  PURPOSE -- Update the callers file at logoff so that the number
'             of hours, minutes, and seconds for the session are
'             recorded as the last 9 characters of the 64-character
'             callers file record
'
      SUB UpdateC STATIC
      ON ERROR GOTO 65000
      IF ZCallersFilePrefix$ = "" THEN _
         EXIT SUB
'
' ****  UPDATE CALLERS FILE AT LOGOFF  ***
'
43050 FIELD 4,55 AS ZCallersRecord$,3 AS Hours$,3 AS Minutes$,3 AS Seconds$
      LSET ZCallersRecord$ = MID$(ZWasNG$,65,55)
      LSET Hours$ = STR$(ZSessionHour)
      LSET Minutes$ = STR$(ZSessionMin)
      LSET Seconds$ = STR$(ZSessionSec)
      ZCallersFileIndex! = ZCallersFileIndex! + 1
      PUT 4,ZCallersFileIndex!
      FIELD 4,64 AS ZCallersRecord$
      LSET ZCallersRecord$ = LEFT$(ZWasNG$,64)
      ZCallersFileIndex! = ZCallersFileIndex! + 1
      PUT 4,ZCallersFileIndex!
43060 LSET ZCallersRecord$ = STRING$(64,CHR$(0))
      ZCallersFileIndex! = ZCallersFileIndex! + 1
      PUT 4,ZCallersFileIndex!
      ZCallersFileIndex! = ZCallersFileIndex! + 1
      PUT 4,ZCallersFileIndex!
      IF ZOrigCallers$ <> ZCallersFile$ THEN _
         ZCallersFile$ = ZOrigCallers$ : _
         CALL SetCall : _
         GOTO 43050
      END SUB
'
44000' $SUBTITLE: 'NumberCheck - subroutine to check filename for number'
' $PAGE
'
'  NAME    --     NameCheck
'
'                 PARAMETER                    MEANING
'  INPUTS  --     PassedName$                  FILENAME TO CHECK FOR NUMBERS
'
'  OUTPUTS --     HasLetter                    ZTRUE  = FILENAME CONTAINS
'                                                       A LETTER IN IT
'                                              ZFALSE = FILENAME DOES NOT
'                                                       CONTAIN ANY LETTERS
'
'  PURPOSE --     TO CHECK USER INPUT FOR A FILENUMBER OR A FILENAME
'
      SUB NumberCheck(PassedName$,FileHasLetter)
      FileHasLetter = ZFalse
      WasJ = 1
      WasXX = LEN(PassedName$)
44005 IF WasJ > WasXX THEN _
         EXIT SUB
      WasX$ = MID$(PassedName$, WasJ, 1)
      IF INSTR("ABCDEFGHIJKLMNOPQRSTUVWXYZ", WasX$) > 0 THEN _
          FileHasLetter = ZTrue : _
          EXIT SUB
      WasJ = WasJ + 1
      GOTO 44005
      END SUB
'
51098 ' $SUBTITLE: 'FindFree - subroutine to find space on a device'
' $PAGE
'
'  NAME    -- FindFree
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZWasZ$                       NAME OF FILE TO FIND
'
'  OUTPUTS -- ZFreeSpace$                      NUMBER OF BYTES FREE
'
'  PURPOSE -- To determine amount of free space on a device
'
      SUB FindFree STATIC
      ON ERROR GOTO 65000
      ZErrCode = 0
52000 IF ZTurboRBBS THEN _
         GOTO 52003
      ZFreeSpace$ = ""
      CLS
      ZErrCode = 0
52001 FILES ZWasZ$
      IF ZErrCode = 53 AND (ZWasZ$ = ZCmntsFile$ OR ZWasZ$ = ZUpldDriveFile$ ) THEN _
         CALL OpenOutW (ZWasZ$) : _
         GOTO 52000
      IF ZErrCode = 53 AND ZWasZ$ = ZUpldDir$ THEN _
         ZOutTxt$ = "Upload directory missing.  Tell SysOp" : _
         ZSubParm = 6 : _
         CALL TPut : _
         GOTO 52002
      FOR WasX = 1 TO 25
         ZFreeSpace$ = ZFreeSpace$ + CHR$(SCREEN (3,WasX))
      NEXT
52002 ZSubParm = 1
      CALL Line25
      EXIT SUB
52003 WasAX = 0
      WasBX = 0
      WasCX = 0
      WasDX = 0
      IF MID$(ZWasZ$,2,1) = ":" THEN _
         WasAX = ASC(ZWasZ$) - ASC("A") + 1
      CALL RBBSFree (WasAX,WasBX,WasCX,WasDX)
      WasI# = CDBL(WasAX) * (WasBX + 65536! * (-(WasBX < 0)))
      WasI# = WasI# * WasCX
      ZFreeSpace$ = STR$(WasI#) + " bytes free"
      END SUB
57978 ' $SUBTITLE: 'OpenWork - subroutine to open RBBS-PC's work file (2)'
' $PAGE
'
'  NAME   -- OpenWork
'
'  INPUTS --     PARAMETER                    MEANING
'                FileNum                    # OF FILE TO OPEN AS
'                FilName$                   NAME OF FILE TO FIND
'                ZShareIt                   USE DOS' "SHARE" FACILITIES
'                FileMode                   0=INPUT, -1=APPEND
'
'  OUTPUTS -- ZErrCode                        ERROR CODE
'
'  PURPOSE -- To open RBBS-PC's "work" file (number 2)
'
      SUB OpenWork (FileNum,FilName$,FileMode)
      ON ERROR GOTO 65000
58000 CLOSE FileNum
58010 ZErrCode = 0
      IF FileMode THEN
         IF ZShareIt THEN _
            OPEN FilName$ FOR APPEND SHARED AS #FileNum _
         ELSE OPEN "A",FileNum,FilName$
      ELSE
         IF ZShareIt THEN _
            OPEN FilName$ FOR INPUT SHARED AS #FileNum _
         ELSE OPEN "I",FileNum,FilName$
     END IF
     IF ZErrCode = 52 THEN _
        GOTO 58010
58030 END SUB
'
58190 ' $SUBTITLE: 'OpenFMS - subroutine to open the FMS directory'
' $PAGE
'
'  NAME    -- OpenFMS
'
'  INPUTS  -- PARAMETER                      MEANING
'             ZShareIt                DOS SHARING FLAG
'             ZFMSDirectory$          NAME OF FMS DIRECTORY
'
'  OUTPUTS -- LastRec                NUMBER OF THE Last
'                                    RECORD IN THE FILE
'             CatLen                 LENGTH OF THE CATEGORY CODE
'
'  PURPOSE -- To open the upload directory as a random file and find
'             the number of the last record in the file.
'
      SUB OpenFMS (LastRec,CatLen) STATIC
      ON ERROR GOTO 65000
      CLOSE 2
      IF ZActiveFMSDir$ = "" THEN _
         IF ZMenuIndex = 6 THEN _
            ZActiveFMSDir$ = ZLibDir$ _
         ELSE ZActiveFMSDir$ = ZFMSDirectory$
      OldFile = (ZActiveFMSDir$ = PrevFMS$)
      IF OldFile THEN _
         GOTO 58192
      CALL OpenWork (2,ZActiveFMSDir$,ZFalse)
      CALL ReadDir (2,1)
      IF ZErrCode > 0 OR LEN(ZOutTxt$) < 37 THEN _
         IF ZActiveFMSDir$ = ZPersonalDir$ THEN _
            ZFMSFileLength = 36 + ZMaxDescLen + ZPersonalLen _
         ELSE ZFMSFileLength = 38 + ZMaxDescLen _
      ELSE ZFMSFileLength = LEN(ZOutTxt$) + 2
      IF ZFMSFileLength < 86 THEN _
         CalcCatLen = 3 : _
         ZMaxDescLen = ZFMSFileLength - 38 _
      ELSE CalcCatLen = ZPersonalLen : _
           ZMaxDescLen = ZFMSFileLength - 36 - ZPersonalLen
      CLOSE 2
58192 ZErrCode = 0
      IF ZShareIt THEN _
         OPEN ZActiveFMSDir$ FOR RANDOM SHARED AS #2 LEN=ZFMSFileLength _
      ELSE OPEN "R",2,ZActiveFMSDir$,ZFMSFileLength
      IF ZErrCode > 0 THEN _
         CALL QuickTPut1 ("Drive/path does not exist or bad name for FMS dir " + _
                     ZActiveFMSDir$) : _
         END
      LastRec = LOF(2)/ZFMSFileLength
      CatLen = CalcCatLen
      IF OldFile THEN _
         EXIT SUB
      PrevFMS$ = ZActiveFMSDir$
      FIELD 2, ZFMSFileLength AS FMSRec$
      GET #2,1
      ZWasA = (LEFT$(FMSRec$,4) <> "\FMS")
      ZUpInc = 2*(INSTR(FMSRec$," TOP ") = 0 OR ZWasA) + 1
      ZDateOrderedFMS = ZWasA OR (INSTR(FMSRec$," NOSORT") = 0)
      ZWasDF = INSTR(FMSRec$,"CH(")
      ZChainedDir$ = ""
      ZPersonalDnld = ((ZActiveFMSDir$ = ZPersonalDir$) OR _
                       (INSTR(FMSRec$," PERS") > 0 AND NOT ZWasA))
      ZFreeDnld = ZPersonalDnld
      ZListOnly = ZPersonalDnld
      ZExtraDnldTime = -60 * ZPersonalDnld
      IF ZActiveFMSDir$ = ZPersonalDir$ THEN _
         ZFileWaiting = ZFalse
      IF ZWasDF > 0 AND (NOT ZWasA) THEN _
         WasX = INSTR(ZWasDF,FMSRec$,")") : _
         IF WasX > 0 THEN _
            ZChainedDir$ = MID$(FMSRec$,ZWasDF+3,WasX-ZWasDF-3) : _
            CALL FindFile (ZChainedDir$,ZOK) : _
            IF NOT ZOK THEN _
               ZChainedDir$ = ""
      IF NOT ZWasA THEN _
         IF INSTR(FMSRec$," NOFREE") > 0 THEN _
            ZFreeDnld = ZFalse _
         ELSE IF INSTR(FMSRec$," FREE") > 0 THEN _
            ZFreeDnld = ZTrue
      IF NOT ZWasA THEN _
         IF INSTR(FMSRec$," LISTONLY ") > 0 THEN _
            ZListOnly = ZTrue
      IF NOT ZWasA THEN _
         WasX = INSTR(FMSRec$," TIMEEXTRA ")
      IF WasX > 0 THEN _
         CALL CheckInt (MID$(FMSRec$,WasX+10)) : _
         ZExtraDnldTime = ZTestedIntValue
      END SUB
58220 ' $SUBTITLE: 'OpenOutW - sub to open output work file (2)'
' $PAGE
'
'  NAME    -- OpenOutW
'
'  INPUTS  --     PARAMETER                 MEANING
'                 ZFileName$            NAME OF FILE TO FIND
'                 ZShareIt              USE DOS' "SHARE" FACILITIES
'
'  OUTPUTS -- ZErrCode                        ERROR CODE
'
'  PURPOSE -- To open RBBS-PC's "work" file (number 2) for output
'
      SUB OpenOutW (FilName$)
      ON ERROR GOTO 65000
      CLOSE 2
58225 ZErrCode = 0
58230 IF ZShareIt THEN _
         OPEN FilName$ FOR OUTPUT SHARED AS #2 _
      ELSE OPEN "O",2,FilName$
58235 END SUB
58260 ' $SUBTITLE: 'KillWork - subroutine to delete a "work" file'
' $PAGE
'
'  NAME    -- KillWork
'
'  INPUTS  --     PARAMETER                    MEANING
'                 FilName$                  NAME OF FILE TO DELETE
'
'  OUTPUTS -- ZErrCode                        ERROR CODE
'
'  SUBROUTINE PURPOSE -- To delete a RBBS-PC "work" file
'
      SUB KillWork (FilName$)
      ON ERROR GOTO 65000
      CLOSE 2
      ZErrCode = 0
      CALL FindFile (FilName$,Found)
      IF NOT Found THEN _
         EXIT SUB
58270 KILL FilName$
58275 END SUB
58280 ' $SUBTITLE: 'GetPassword - sub to read the "passwords" file'
' $PAGE
'
'  NAME    -- GetPassword
'
'                          PARAMETER             MEANING
'  INPUTS  -- FILE # 2 OPENED
'             NumFinds                 # OF PARAMS IN PASSWORDS FILE
'
'  OUTPUTS -- ZTempPassword$
'             ZTempSecLevel
'             ZTempTimeAllowed
'             ZTempRegPeriod
'             ZTempMaxPerDay
'
'  PURPOSE -- To read the RBBS-PC "PASSWORDS" file
'
      SUB GetPassword (NumFinds)
      ON ERROR GOTO 65000
      ZErrCode = 0
      ZPswdChngReqTime = 0
      ZDropCarSecChng = 0
      ZDropIncrement = 0
      ZDoMailCheck = 0
      ZTimeBankInActive = ZFalse
      ZAutoLogoffSecTime! = 20
      ZAllowInternodeChat = ZFalse
      INPUT #2,ZTempPassword$,    ZTempSecLevel, _
               ZTempTimeAllowed,  ZTempMaxPerDay, _
               ZTempRegPeriod,    ZTempExpiredSec, _
               ZStartTime,        ZEndTime, _
               ZByteMethod,       ZRatioRestrict#, _
               ZInitialCredit#,   ZTempTimeLock, _
               ZTempMaxBank
      IF NumFinds > 13 THEN _
         INPUT #2,ZPswdChngReqTime
      IF NumFinds > 14 THEN _
         INPUT #2,ZDropCarSecChng
      IF NumFinds > 15 THEN _
         INPUT #2,ZDropIncrement
      IF NumFinds > 16 THEN _
         INPUT #2,ZDoMailCheck
      IF NumFinds > 17 THEN _
         INPUT #2,ZTimeBankInActive
      IF NumFinds > 18 THEN _
         INPUT #2,ZAutoLogoffSecTime!
      IF NumFinds > 19 THEN _
         INPUT #2,ZAllowInternodeChat
      IF NumFinds > 20 THEN _
         INPUT #2,ZOnlyOneTimeLockPerDay
      IF ZTempMaxBank > 255 THEN _
         ZTempMaxBank = 255
      IF ZDropCarSecChng > 255 THEN _
         ZDropCarSecChng = 255
      IF ZAutoLogoffSecTime! > 99 THEN _
         ZAutoLogoffSecTime! = 99
      IF ZAutoLogoffSecTime! < 1 THEN _
         ZAutoLogoffSecTime! = 1
      IF ZAllowInternodeChat <> 0 THEN _
         ZAllowInternodeChat = ZTrue
      IF ZTimeBankInActive <> 0 THEN _
         ZTimeBankInActive = ZTrue
      IF ZOnlyOneTimeLockPerDay <> 0 THEN _
         ZOnlyOneTimeLockPerDay = ZTrue
58285 END SUB
58290 ' $SUBTITLE: 'ReadDir - subroutine to read the "DIR" files'
' $PAGE
'
'  NAME    -- ReadDir
'
'             PARAMETER                MEANING
'  INPUTS  -- FileNum                  WHICH # FILE TO READ
'             WhichLine                HOW MANY LINES TO ADVANCE
'
'  OUTPUTS -- ZOutTxt$
'
'  PURPOSE -- To read possible "DIR" files
'
      SUB ReadDir (FileNum,WhichLine)
      ON ERROR GOTO 65000
      ZErrCode = 0
      FOR WasI = 1 TO WhichLine
         LINE INPUT #FileNum,ZOutTxt$
         Temp = INSTR(ZOutTxt$,"~")                                  ' 175-0128
         IF Temp > 0 THEN _
            IF Temp = 1 THEN _
               WasI = WasI - 1 _
            ELSE _
               ZOutTxt$ = MID$(ZOutTxt$,1,Temp - 1) : _
               CALL Trim (ZOutTxt$)
      NEXT
58295 END SUB
58300 ' $SUBTITLE: 'ReadParmsX - subroutine to read parameter values'
' $PAGE
'
'  NAME    -- ReadParmsX
'
'               PARAMETER             MEANING
'  INPUTS  -- FILE # 2 OPENED
'             NumParms               # PARAMETERS TO READ
'             WhichLine              WHICH SET OF PARMS TO RETURN
'  OUTPUTS -- AraToUse$()            ARRAY OF STRING VARIABLES
'             File.Security
'             FilePswd$
'
'  PURPOSE -- To read different values, where values are
'             separated by a comma or carriage-return-line-feed.
'
      SUB ReadParmsX (FilNum,AraToUse$(1),NumParms,WhichLine)
      ON ERROR GOTO 65000
      ZErrCode = 0
      FOR WasJ = 1 TO WhichLine
         FOR WasI = 1 TO NumParms
            INPUT #FilNum,AraToUse$(WasI)
         NEXT
      NEXT
58305 END SUB
58310 ' $SUBTITLE: 'ReadAny - subroutine to read file 2 into ZOutTxt$'
' $PAGE
'
'  NAME    -- ReadAny
'
'               PARAMETER             MEANING
'  INPUTS  -- FILE # 2 OPENED
'
'  OUTPUTS -- ZOutTxt$
'
'  PURPOSE -- To read file #2 into ZOutTxt$
'
      SUB ReadAny
      ON ERROR GOTO 65000
      ZErrCode = 0
      INPUT #2,ZOutTxt$
58315 END SUB
58320 ' $SUBTITLE: 'PrintWork - subroutine to print to file 2'
' $PAGE
'
'  NAME    -- PrintWork
'
'               PARAMETER             MEANING
'  INPUTS  --   STRNG$                STRING TO WRITE OUT
'               FILNUM                FILE NUMBER TO USE
'               FILEMODE              HOW TO PRINT THE INFORMATION
'                                     -1 = PRINT STRING W/O CR/LF
'                                      0 = PRINT STRING WITH CR/LF
'                                      0 = PRINT STRING APPEND MODE WITH CR/LF
'
'  OUTPUTS --   STRNG$                STRING TO WRITE OUT
'
'  PURPOSE --   To print a string to file FILNUM
'
      SUB PrintWork (FilNum,Strng$,FileMode)
      ON ERROR GOTO 65000
      ZErrCode = 0
      IF FileMode THEN
         PRINT #FilNum, Strng$;           ' printwork
      ELSE
         PRINT #FilNum, Strng$            ' printworkb  printworka
      END IF
58325 END SUB
'
58330 ' $SUBTITLE: 'GetWork - subroutine to read file 2'
' $PAGE
'
'  NAME    -- GetWork
'
'               PARAMETER             MEANING
'  INPUTS  -- RecLen            LENGTH OF RECORD
'
'  OUTPUTS -- NONE
'
'  PURPOSE -- To read a record from file #2
'
      SUB GetWork (RecLen)
      ON ERROR GOTO 65000
      ZErrCode = 0
      FIELD 2, RecLen AS ZDnldRecord$
      GET 2,(LOC(2)+1)
58335 END SUB
'
58360 ' $SUBTITLE: 'CheckInt - subroutine to check input is an integer'
' $PAGE
'
'  NAME    -- CheckInt
'
'             PARAMETER             MEANING
'  INPUTS  -- Strng$              STRING TO VERIFY CAN BE AN INTEGER
'
'  OUTPUTS -- ZErrCode             = 0 MEANS IT IS AN INTEGER VALUE
'                                 <> 0 MEANS IT IS NOT AN INTEGER VALUE
'             ZTestedIntValue     INTEGER VALUE OF EXPRESSION
'
'  PURPOSE -- To validate that a string represents an integer
'
      SUB CheckInt (Strng$)
      ON ERROR GOTO 65000
      ZErrCode = 0
      WasX$ = Strng$
      CALL Trim (WasX$)
      ZTestedIntValue = VAL(LEFT$(WasX$,INSTR(WasX$+" "," ")-1))
58365 END SUB
'
58370 ' $SUBTITLE: 'GetMenuNew - sub to read the "MENUNEW.DEF" File'
' $PAGE
'
'  NAME    -- GetMenuNew
'
'                          PARAMETER             MEANING
'  INPUTS  -- FILE # 2 OPENED
'
'  OUTPUTS -- ZMenuNewDate$         DATE SYSOP LAST ONLINE
'             ZMenuNewTime$         TIME SYSOP LAST ONLINE
'             ZMenuNewUpld          NEW UPLOADS SINCE SYSOP ON
'             ZMenuNewUsers         NEW USERS SINCE SYSOP ON
'             ZMenuNewSysop         NEW SYSOP MAIL WAITING
'             ZMenuNewCalls         CALLS RECEIVED SINCE LAST ON
'
'  PURPOSE -- To read the RBBS-PC "MENUx.DEF" file
'
'     Written by: Scott Thompson
'
      SUB GetMenuNew
      Found = ZFalse
      CALL FindFile (ZMNewDef$,Found)
      IF Found THEN
         CALL OpenWork (2,ZMNewDef$,ZFalse)
         WHILE NOT EOF(2)
            LINE INPUT #2,ZMenuNewDate$
            LINE INPUT #2,ZMenuNewTime$
            LINE INPUT #2,Temp$
            ZMenuNewUpld = VAL(Temp$)
            LINE INPUT #2,Temp$
            ZMenuNewUsers = VAL(Temp$)
            LINE INPUT #2,Temp$
            ZMenuNewCalls = VAL(Temp$)
            LINE INPUT #2,Temp$
            ZMenuNewSysop = VAL(Temp$)
         WEND
         CLOSE 2
      END IF
58375 END SUB
59650 ' $SUBTITLE: 'PutCom -- subroutine to write to communications port'
' $PAGE
'
'  NAME    --  PutCom
'
'  INPUTS  --   PARAMETER     MEANING
'                STRNG$      STRING TO PRINT TO COMM PORT
'              ZFlowControl  WHETHER USING CLEAR TO SEND FOR FLOW
'                            CONTROL BETWEEN THE PC AND THE MODEM
'
'  OUTPUTS --
'
'  PURPOSE -- Checks for carrier drop and flow control (xon/xoff)
'             before writing to the communications port.
'
      SUB PutCom (Strng$) STATIC
      ON ERROR GOTO 65000
      IF ZLocalUser THEN _
         EXIT SUB
      CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         EXIT SUB
      IF NOT ZXOffEd THEN _
         GOTO 59652
      ZSubParm = 1
      CALL Line25
      ZWasY$ = ZXOff$
      XOffTimeout! = TIMER + 30
      WHILE ZWasY$ = ZXOff$ AND ZSubParm <> -1
         Char = -1
         WHILE Char = -1 AND ZSubParm <> -1
            GOSUB 59654
         WEND
         IF Char <> -1 THEN _
            CALL GetCom(ZWasY$) : _
            IF ZXOnXOff AND ZWasY$ <> ZXOn$ THEN _
               ZWasY$ = ZXOff$
      WEND
      ZXOffEd = ZFalse
      ZSubParm = 1
      CALL Line25
59652 ZNotCTS = ZFalse
      IF NOT ZFossil THEN _
         PRINT #3,Strng$; : _
         EXIT SUB
      IF Strng$ = "" THEN _
         EXIT SUB
      FOR WasN = 1 TO LEN(Strng$)
          Char = ASC(MID$(Strng$,WasN,1))
59653     CALL FosTXCharNW(ZComPort,Char,Result)
          IF Result = 0 THEN _
             CALL GoIdle : _
             GOTO 59653
      NEXT
      EXIT SUB
59654 CALL EofComm (Char)
      CALL GoIdle
      CALL CheckCarrier
      IF ZSubParm <> -1 THEN _
         CALL CheckTime(XOffTimeout!, TempElapsed!,1) : _
         IF ZSubParm = 2 THEN _
            ZSubParm = -1
      RETURN
      END SUB
59660 ' $SUBTITLE: 'PutWork -- subroutine to write to upload files'
' $PAGE
'
'  NAME    -- PutWork
'
'  INPUTS  --   PARAMETER     MEANING
'                STNG$       STRING TO WRITE TO FILE
'                RecNum      RECORD NUMBER TO WRITE
'                RecLen      LENGTH OF RECORD TO WRITE
'
'  OUTPUTS --
'
'  PURPOSE -- Writes uploaded file records to work file
'
      SUB PutWork (Strng$,RecNum,RecLen) STATIC
      ON ERROR GOTO 65000
      FIELD #2,RecLen AS ZUpldRec$
      LSET ZUpldRec$ = Strng$
      RecNum = RecNum + 1
      PUT #2,RecNum
      END SUB
59680 ' $SUBTITLE: 'RBBSPlay -- subroutine to play music'
' $PAGE
'
'  NAME    -- RBBSPlay
'
'  INPUTS  --   PARAMETER     MEANING
'               Strng$      STRING TO PLAY
'
'  OUTPUTS --
'
'  PURPOSE -- Play music.  Skip if get an error.
'
      SUB RBBSPlay (StringToPlay$)
      PLAY StringToPlay$
      ZErrCode = 0
      END SUB
59700 ' $SUBTITLE: 'Talk -- subroutine for voice response'
' $PAGE
'
'  NAME    -- Talk
'
'  INPUTS  --   PARAMETER     MEANING
'               ZVoiceType    TYPE OF VOICE SYNTHESIZER
'               VoiceRecord   RECORD NUMBER TO RETRIEVE
'
'  OUTPUTS --
'
'  PURPOSE -- Retrieve voice record and send to voice synthesizer
'
      SUB Talk (VoiceRecord,StringWork$) STATIC
      IF ZVoiceType = 0 THEN _
         EXIT SUB
      IF VoiceRecord > 0 THEN _
         GOTO 59720
      CLOSE 9,8
      IF ZVoiceType = 1 THEN _
         OPEN "COM2:2400,E,7,1,CS65535" AS #9 : _
         LPRINT "OPENED COM PORT"
      IF ZShareIt THEN _
         OPEN "RBBSTALK.DEF" FOR RANDOM SHARED AS #8 LEN=32 _
      ELSE OPEN "R",8,"RBBSTALK.DEF",32
      FIELD 8,30 AS TalkRecord$,2 AS Dummy$
      EXIT SUB
59720 IF NOT ZSnoop THEN _
         EXIT SUB
      IF VoiceRecord < 65 THEN _
         GET 8,VoiceRecord : _
         StringWork$ = TalkRecord$ : _
         CALL Trim (StringWork$)
59721 IF ZSmartTextCode THEN _
         CALL SmartText (StringWork$, CRFound,ZFalse)
59722 IF ZVoiceType = 1 THEN _
         PRINT #9,StringWork$
59723 IF ZVoiceType = 2 THEN _
         CALL RBBSHS (CHR$(LEN(StringWork$)+1)+StringWork$+CHR$(13))
      END SUB
59725 ' $SUBTITLE: 'CommPut -- Writes to communications port'
' $PAGE
'
'  NAME    -- CommPut
'
'  INPUTS  --   PARAMETER     MEANING
'               Strng$        STRING TO WRITE
'               ZFossil       WHETHER USING FOSSIL DRIVER
'
'  OUTPUTS --
'
'  PURPOSE -- Send string to comm port.  Recovers from errors.
'
      SUB CommPut (Strng$) STATIC
      ON ERROR GOTO 65000
      IF ZFossil THEN _
         Bytes = LEN(Strng$) : _
         CALL FosWrite(ZComPort,Bytes,Strng$) _
      ELSE PRINT #3,Strng$;
      END SUB
59790 ' $SUBTITLE: 'FindFile -- subroutine to find a file'
' $PAGE
'
'  NAME    --  FindFile
'
'  INPUTS  --  PARAMETER         MENANING
'               FilName$         NAME OF FILE TO LOOK FOR
'               FExists          WHETHER FILE EXISTS
'
'  OUTPUTS --  Returned.Value    VALUE RETURNED
'                                TRUE = FILE EXISTS
'                                NOT TRUE = FILE DOES NOT EXIST
'
'  PURPOSE --  Determine whether passed file FilName$ exists
'              Unlike, FindIt, this routine does not open any
'              file and, hence, does not create one in determining
'              whether a file exists.
'
      SUB FindFile (FilName$,FExists)
      CALL BadFileChar (FilName$,FExists)
59791 IF FExists THEN _
         IOErrorCount = 0 : _
         CALL RBBSFind (FilName$,WasZ,WasY,WasM,WasD) : _
         FExists = (WasZ = 0)
      END SUB
'
60000 '$SUBTITLE: 'ChkBanned 'stopes user from joining conference
' $PAGE
'
' NAME:    -- ChkBanned
'
' INPUT:   -- Drive$           PATH AND NAME OF USERS FILE OF CONFERENCE
'                              THE USER IS TRYING TO JOIN
'
' OUTPUT:  -- ZBlocked         1 = BAN USER FROM ENTERING CONFERENCE
'                              0 = ALLOW USER TO JOIN CONFERENCE
'
' PURPOSE: -- Lock specific user from joining any user base that has a
'             Confname.BAN file with users logon name.
'
      SUB ChkBanned(Drive$,ZBlocked)
      DIM User AS STRING * 30
      X$ = MID$(Drive$,1,LEN(Drive$)-1)
      X$ = X$ + ".BAN"
      CALL FindIt (X$)
      IF NOT ZOK THEN _
          EXIT SUB
      Banned = 11
      ZError = 0
      IF ZShareit THEN _
          OPEN X$ FOR INPUT SHARED AS #Banned _
      ELSE OPEN X$ FOR INPUT AS #Banned
      WHILE NOT EOF(Banned) AND ZError = 0
          INPUT #Banned, User
          IF LTRIM$(RTRIM$(UCASE$(User))) = LTRIM$(RTRIM$(ZActiveUserName$)) THEN
              IF NOT ZGlobalSysOp THEN
                 ZFileName$ = ZHelpPath$ + "BANMSG.HLP"
                 CALL Graphic (ZFileName$,ZTrue)
                 IF ZOK THEN _
                    ZNonStop = ZTrue : _
                    CALL BufFile (ZFileName$, ZWasX,ZTrue)
              END IF
              ZBlocked = 1
              CLOSE #Banned
              EXIT SUB
          END IF
      WEND
      ZBlocked = 0
      CLOSE #Banned
      END SUB
'
63520 ' $SUBTITLE: 'BinSearch - binary search a file'
' $PAGE
'
'  NAME    -- BinSearch
'                                  MEANING
'  INPUTS  -- PassedSearchFor$   VALUE YOU ARE LOOKING FOR
'             StartPos           STARTING POSITION OF SORT KEY
'             NumChars           # OF CHARACTERS IN SORT KEY
'             LenRec             LENGTH OF RECORD OF DATA FILE SEARCHING
'             High&              RECORD # OF LAST RECORD
'             ZFastTabs$         IN A BINARY INTEGER SUBFIELD (2 Bytes)
'                                  HOLDS 1st RECORD WHEN MIGHT FIND
'                                  A KEY BEGINNING WITH A PARTICULAR
'                                  CHARACTER (0-9,A-Z).   EMPTY IF
'                                  NO FAST TAB EXISTS FOR THE FILE.
'
'  OUTPUTS -- RecFoundAt&       RECORD # VALUE FOUND AT (0 IF NONE)
'             RecFound$         FULL DATA RECORD WHEN FOUND
'
'  PURPOSE -- Binary searches work file #2 for a key value in a
'             data file that is sorted on a key field
'
'    Large FIDX support by Yaeshar Behbehani
'
'
      SUB BinSearch (PassedSearchFor$,StartPos,NumChars,LenRec,High&,RecFoundAt&,RecFound$,FilNum,WCSearch) STATIC
      SearchFor$ = LEFT$(PassedSearchFor$,NumChars)
      SearchFor$ = SearchFor$ + SPACE$(NumChars-LEN(SearchFor$))
      FIELD FilNum, LenRec AS SearchRec$
      Low& = 0
      WasI& = High&
      IF LEN(ZFastTabs$) < 160 THEN _
         GOTO 63522
      WasX$ = LEFT$(SearchFor$,1)
      WasX = INSTR("!#$0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_",WasX$)
      IF WasX > 0 THEN _
         Low& = CVL(MID$(ZFastTabs$,1+4*(WasX-1),4)) - 1 : _
         IF WasX < 40 THEN _
            WasI& = CVL(MID$(ZFastTabs$,1+4*WasX,4))
      IF WasI& - 1 <> Low& THEN _
         High& = WasI&
      WasI& = 0
63522 RecFoundAt& = 0
      IF High& < 1 THEN _
         EXIT SUB
      WasX$ = SPACE$ (NumChars)
      Done = ZFalse
      CheckLow = ZFalse
      LowHold& = 0
      HighHold& = 0
      DoesMatch = ZFalse
63525 WHILE NOT Done
         WasI& = FIX(((High&/2) + (Low&/2)) + .5)
63527    GET FilNum, WasI&
         LSET WasX$ = MID$(SearchRec$,StartPos,NumChars)
         IF WCSearch THEN
            FileName$ = WasX$
            CALL Trim (FileName$)
            CALL Trim (SearchFor$)
            IF DoesMatch AND CheckLow THEN
               IF LEFT$(FileName$,INSTR(SearchFor$,"*")-1) <= LEFT$(SearchFor$,INSTR(SearchFor$,"*")-1) THEN
                  High& = HighHold&
                  Done = ZTrue
                  RecFoundAt& = Low&
                  GOTO 63525
               END IF
            END IF
            IF DoesMatch AND NOT CheckLow THEN
               IF LEFT$(FileName$,INSTR(SearchFor$,"*")-1) >= LEFT$(SearchFor$,INSTR(SearchFor$,"*")-1) THEN
                  Low& = LowHold&
                  CheckLow = ZTrue
               END IF
            END IF
            IF NOT DoesMatch THEN
               CALL WildFile (SearchFor$,FileName$,DoesMatch)
            END IF
            IF DoesMatch THEN
               IF NOT CheckLow THEN
                  LowHold& = Low&
                  IF (Low&+30 < High&) THEN
                     Low& = Low& + 30
                     WasI& = Low&
                  END IF
               ELSE
                  HighHold& = High&
                  IF (High&-30 > Low&) THEN
                     High& = High& - 30
                     WasI& = High&
                  END IF
               END IF
               GOTO 63527
            END IF
         END IF
         IF WasX$ = SearchFor$ THEN
            RecFound$ = SearchRec$
            RecFoundAt& = WasI&
            Done = ZTrue
         ELSE
            IF (High& - Low&) < 2 THEN
               Done = ZTrue
            ELSE
               IF WasX$ < SearchFor$ THEN
                  Low& = WasI&
               ELSE
                  IF WasX$ > SearchFor$ THEN
                     High& = WasI&
                  END IF
               END IF
            END IF
         END IF
      WEND
      IF WCSearch THEN _
         RecFoundAt& = Low&
      END SUB
'
63801 '$SUBTITLE: 'ExpiredPswd -- Subroutine to force change of password'
' $PAGE
'
' NAME:    -- ExpiredPswd
'
' PURPOSE: -- Force a user to change his/her password every X times
'             logged on to the system.
'
'
      SUB ExpiredPswd
      IF ZPswdChngReqTime = 0 THEN _
         EXIT SUB
      IF ZTimesLoggedOn MOD ZPswdChngReqTime <> 0 THEN _
         EXIT SUB
      CALL CmdStackPushPop (1)
      ZLastIndex = 0
63802 CALL SkipLine (1)
      CALL QuickTPut1 ("Your password has expired...you must change your password.")
      Prompt$ = "Enter a New Password"
      CALL NewPassword (Prompt$,ZTrue)
      IF ZSubParm < 0 THEN _
         EXIT SUB
      CALL AllCaps (ZOldPassword$)
      IF ZWasZ$ = ZOldPassword$ THEN _
         CALL SkipLine (1) : _
         CALL QuickTPut1 ("You CANNOT reuse your OLD PASSWORD!") : _
         CALL SkipLine (1) : _
         GOTO 63802
      ZOutTxt$ = "Re-enter your New Password"
      ZHidden = ZTrue
      ZSubParm = 1
      CALL TGet
      IF ZSubParm < 0 THEN _
         EXIT SUB
      CALL AllCaps (ZUserIn$)
      IF ZWasZ$ <> ZUserIn$ THEN _
         ZOutTxt$ = "Passwords do not match" : _
         ZSubParm = 1 : _
         CALL TPut : _
         GOTO 63802
      CALL UpdtCalr ("Expired Password! " + Time$,2)
      ZSubParm = 6
      CALL FileLock
      CALL OpenUser (HighestUserRecord)
      GET 5,ZUserFileIndex
      CALL AllCaps (ZUserIn$)
      LSET ZPswd$ = ZUserIn$
      IF ZUserFileIndex > 0 AND ZUserFileIndex < 32768 THEN _
         PUT 5,ZUserFileIndex
      ZSubParm = 8
      CALL FileLock
      ZOutTxt$ = "Password Changed."
      ZStopInterrupts = ZTrue
      ZSubParm = 1
      CALL TPut
      CALL SkipLine (1)
      CALL UpdtCalr ("New Password " + ZUserIn$(1),2)
      CALL DelayTime (2)
      CALL CmdStackPushPop (2)
      END SUB
'
63901 '$SUBTITLE: 'DropCarrier -- Subroutine to change users sec level'
' $PAGE
'
' NAME: DropCarrier
'
' PURPOSE: To change a users security level who is dropping carrier
'          excessively
'
' INPUTS:  ZDropCarSecChng
'
      SUB DropCarrier
63902 IF ZDropCarSecChng = 0 THEN
         IF ZDropChange = ZFalse THEN _
            ZDropTimes = ZDropTimes + 1 : _
            ZGlobalDropTimes = ZDropTimes
         IF ZGlobalDropTimes > 255 THEN _
            ZGlobalDropTimes = 0
         EXIT SUB
      END IF
      IF ZDropTimes > ZDropCarSecChng THEN _
         ZDropTimes = ZDropCarSecChng - 1
      IF ZDropChange = ZFalse THEN
         ZDropTimes = ZDropTimes + 1
         IF ZDropTimes MOD ZDropCarSecChng <> 0 THEN
            ZGlobalDropTimes = ZDropTimes
            ZDropChange = ZTrue
            EXIT SUB
         END IF
         ZUserSecLevel = ZUserSecLevel - ZDropIncrement
         ZSubParm = 6
         CALL FileLock
         CALL OpenUser (HighestUserRecord)
         GET 5,ZUserFileIndex
         LSET ZSecLevel$ = MKI$(ZUserSecLevel)
         IF ZUserFileIndex > 0 AND ZUserFileIndex < 32768 THEN _
            PUT 5,ZUserFileIndex
         ZSubParm = 8
         CALL FileLock
         ZDropChange = ZTrue
         CALL UpdtCalr ("Security reset for Dropped Carriers!",2)
         ZDropTimes = 0
         ZGlobalDropTimes = ZDropTimes
         ZSubParm = -1
      END IF
      END SUB
'
63910 '$SUBTITLE: 'SysInfo -- Subroutine to get DOS/DV version'
' $PAGE
'
' NAME: SysInfo
'
' PURPOSE: To get DOS or OS2 version RBBS is running under and store
'          it for display.  Also checks for DESQview and, if found,
'          gets version and stores it for display.
'
' INPUTS:
'
' OUTPUTS:  ZDOSversion$          - version of DOS
'           ZDVversion$           - version of DESQview
'           ZOS2version$          - version of OS2
'
      SUB SysInfo
      ZDOSversion$ = ""
      ZOS2version$ = ""
      ZDVversion$ = ""
      CALL RBBSDOS (Maj,Min)
      IF Maj > 9.99 THEN _
        Maj$ = STR$(Maj/10) _
      ELSE _
         Maj$ = STR$(Maj)
      Min$ = STR$(Min)
      CALL TRIM (Maj$)
      CALL TRIM (Min$)
      IF Maj > 9.99 THEN _
         ZOS2version$ = Maj$ + "." + Min$ : _
         ZNetworkType = 7 _
      ELSE _
         ZDOSversion$ = Maj$ + "." + Min$
      NetWorkTemp = ZNetWorkType
      CALL RBBSDESQ (Maj,Min)
      IF Maj > 0 THEN _
         Maj$ = STR$(Maj) : _
         Min$ = STR$(Min) : _
         CALL TRIM (Maj$) : _
         CALL TRIM (Min$) : _
         IF ZNetworkType <> 7 THEN _
            ZDVversion$ = Maj$ + "." + Min$ : _
            PRINT "DESQview detected!" : _
            IF ZNetworkType <> 6 THEN _                           ' 175-0110
                ZNetworkType = 4                                  ' 175-0110
      CALL CKSHARE(Min)
      IF Min > 0 THEN _
         PRINT "SHARE detected!" : _
         IF ZNetWorkType <> 3 AND ZNetWorkType <> 4 THEN _
            ZShareIt = ZTrue
      ZNetWorkType = NetWorkTemp
      END SUB
'
63930 '$SUBTITLE: 'GetLogoff -- Subroutine to get Logoff command'
' $PAGE
'
' NAME: GetLogoff
'
' PURPOSE: To get LogOff command options from user.
'
' INPUTS:
'
' OUTPUTS:  Wherego     - WHAT USER WANTS TO DO
'
'
      SUB GetLogoff (Wherego)
      ExpertOld = ZFalse
      InvalidOptSave$ = ZInvalidOpts$
      ZInvalidOpts$ = ""
      IF ZMaxBank < 1 OR ZTimeBankInActive THEN _
         ZInvalidOpts$ = ZInvalidOpts$ + "Bb"
      IF ZNetConference THEN _
         ZInvalidOpts$ = ZInvalidOpts$ + "Cc"
63935 ZFileName$ = ZMnuPath$ + "LOGOFF." + ZMnuExt$
      CALL Graphic (ZFileName$,ZTrue)
      IF ZOK AND NOT ZExpertUser THEN _
         ZDeleteInvalid = ZTrue : _
         CALL BufFile (ZFileName$,WasX,ZFalse) : _
         ZDeleteInvalid = ZFalse : _
         GOTO 63941
63940 IF NOT ZExpertUser THEN
         CALL SkipLine (1)
         IF ZMaxBank < 1 OR ZTimeBankInActive THEN _
            ZOutTxt$ = ZFGB$ + "  A" + ZFG4$ + ")bort Logoff " + ZCrLF$ _
         ELSE ZOutTxt$ = ZFGB$ + "  A" + ZFG4$ + ")bort Logoff " + ZCrLF$ + _
                         ZFGB$ + "  B" + ZFG4$ + ")ank Time " + ZCrLF$
         IF NOT ZNetConference THEN _
            ZOutTxt$ = ZOutTxt$ + ZFGB$ +  "  C" + ZFG4$ + ")omment to SysOp and Logoff " + _
                       ZCrLF$ + ZFGB$ + "  G" + ZFG4$ + ")o ahead, log me off now " + ZCrLF$ _
         ELSE ZOutTxt$ = ZOutTxt$ + ZFGB$ + "  G" + ZFG4$ + ")o ahead, log me off now " + ZCrLF$
         CALL QuickTPut1 (ZOutTxt$ + ZEmphasizeOff$)
         IF ExpertOld THEN _
            ZExpertUser = ZTrue
      END IF
63941 CALL SkipLine (1)
      IF ZMaxBank > 0 AND ZTimeBankInActive = 0 THEN _
         ZOutTxt$ = ZFG1$ + "  Enter Choice (" + ZFGB$ + "?,A,B," _
      ELSE ZOutTxt$ = ZFG1$ + "  Enter Choice (" + ZFGB$ + "?,A,"
      IF NOT ZNetConference THEN _
         ZOutTxt$ = ZOutTxt$ + ZFGB$ + "C,[G]" _
      ELSE ZOutTxt$ = ZOutTxt$ + ZFGB$ + "[G]"
      ZOutTxt$ = ZOutTxt$ + ZFG1$ + ")" + ZEmphasizeOff$
      ZSubParm = 1
      ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm < 0 THEN _
         EXIT SUB
      CALL AllCaps (ZUserIn$)
      WasX = INSTR("ABCGY?",ZUserIn$)
      IF ZUserIn$ = "" THEN _
         GOTO 63948
      IF WasX = 6 AND ZExpertUser THEN _
         ExpertOld = ZExpertUser : _
         ZExpertUser = ZFalse
      IF WasX = 0 THEN _
         GOTO 63948
      ON WasX GOTO 63942,63944,63946,63948,63948,63940
63942 Wherego = 1
      GOTO 63950
63944 IF ZMaxBank < 1 THEN _
         CALL SkipLine (1) : _
         CALL QuickTPut1 (ZFGE$ + "You do not have time bank privileges!" + _
                          ZEmphasizeOff$) : _
         GOTO 63940
      IF ZTimeBankInActive = 1 THEN _
         CALL SkipLine (1) : _
         CALL QuickTPut1 (ZFGE$ + "Time Bank NOT Available!" + ZEmphasizeOff$) : _
         GOTO 63940
      Wherego = 2
      GOTO 63950
63946 Wherego = 3
      GOTO 63950
63948 Wherego = 4
      GOTO 63950
63950 ZInvalidOpts$ = InvalidOptSave$
      END SUB
'
63955 '$SUBTITLE: 'MessageExport -- subroutine to export messages to file'
' $PAGE
'
' NAME: MessageExport
'
' PURPOSE: To allow SysOp to export messages to text file
'
' INPUTS:
'
' OUTPUTS:
'
      SUB MessageExport (EMsgRec$, ESent$, Year$, MsgSec, MsgTo$, MsgFrom$, Subject$)
      FilNum = 2
      CALL OpenWork (FilNum,ZNodeTxt$,ZTrue)
      Temp$ = "  Security:" + STR$(MsgSec)
      CALL PrintWork (FilNum,"   Msg #: " + EMsgRec$ + Temp$ + _
                      SPACE$(24 - LEN(Temp$)) + ZConfName$,ZFalse)
      CALL PrintWork (FilNum,"   From:  " + MsgFrom$ + "      Sent: " + ESent$,ZFalse)
      Temp$ = Year$
      IF LEFT$(Temp$,2) <> " R" THEN _
         Temp$ = " Rcvd: " + Year$
      CALL PrintWork (FilNum,"   To:    " + MsgTo$ + "     " + Temp$,ZFalse)
      CALL PrintWork (FilNum,"   Re:    " + Subject$,ZFalse)
      CALL PrintWork (FilNum," ",ZFalse)
      FOR I = 1 TO ZLinesInMsg
         CALL PrintWork (FilNum,ZOutTxt$(I),ZFalse)
      NEXT I
      CALL PrintWork (FilNum," ",ZFalse)
      CLOSE FilNum
      END SUB
'
'  $SUBTITLE: 'Error Handling for separately compiled subroutines'
'  $PAGE
'
'
' Error handling for the separately compiled subroutines of RBBS-PC
'
'
65000 IF ZDebug THEN _
         ZOutTxt$ = "RBBSSUB1 DEBUG Error Trap Entry ERL=" + _
              STR$(ERL) + _
              " ERR=" + _
              STR$(ERR) : _
         IF ZPrinter THEN _
            CALL Printit(ZOutTxt$) _
         ELSE CALL LPrnt(ZOutTxt$,1)
      ZErrCode = ERR
'
'     SetCall
'
      IF ERL = 108 THEN _
         CALL PScrn ("Unable to create callers log " + ZCallersFile$) : _
         SYSTEM
      IF ERL = 110 THEN _
          RESUME NEXT
'
'     OPEN CONFIG FILE
'
       IF ERL => 117 AND ERL <= 119 THEN _
          RESUME NEXT
'
'     OPEN COM PORT ERROR HANDLING
'
      IF ERL = 200 THEN _
         CLS : _
         CALL PScrn (ZComPort$ + " does not exist/not responding- Error" + STR$(ERR)) : _
         STOP
'
'     GETCOM ERROR HANDLING
'
       IF ERL = 1420 AND ERR = 57 THEN _
          RESUME NEXT
       IF ERL = 1420 AND ERR = 69 THEN _
          ZSubParm = -1 :_
          RESUME NEXT
'
'      OPENRESEQ ERROR HANDLING
'
       IF ERL = 1480 OR ERL = 1487 THEN _
           ZErrCode = ERR : _
           RESUME NEXT
'
'      COPYFILE ERROR HANDLING
'
       IF ERL = 1450 AND ERR > 74 AND ERR < 77 THEN _
          ZErrCode = ERR : _
          RESUME NEXT
'
'      KILLCDWORK ERROR HANDLING
'
       IF ERL = 1465 THEN _
          RESUME NEXT
'
'      OPENUSER ERROR HANDLING
'
       IF ERL = 9400 AND ERR = 75 AND ZShareIt THEN _
          CALL DelayTime (30) : _
          RESUME
'
'      FINDUSER ERROR HANDLING
'
       IF ERL = 12610 OR ERL = 12600 THEN _
          RESUME NEXT
'
'     UPDTCALR ERROR HANDLING
'
       IF ERL = 13663 THEN _
          RESUME NEXT
       IF ERL = 13672 AND ERR = 61 THEN _
          CALL QuickTPut1 ("Disk Full") : _
          IF ZDiskFullGoOffline THEN _
             GOTO 65010 _
          ELSE RESUME NEXT
       IF ERL = 13672 THEN _
          ZCallersFileIndex! = ZCallersFileIndex! - 1 : _
          RESUME NEXT
'
'     ZPRINTER ERROR HANDLING
'
       IF ERL = 13674 THEN _
          ZPrinter = ZFalse : _
          RESUME
'
'      CHANGEDIR ERROR HANDLING
'
       IF ERL = 20103 THEN _
          ZOK = ZFalse : _
          RESUME NEXT
'
'     FINDIT ERROR HANDLING
'
       IF ERL = 20221 THEN _
          RESUME NEXT
       IF ERL = 20223 AND ZErrCode = 58 THEN _
          ZErrCode = 64 : _
          ZOK = ZFalse : _
          RESUME NEXT
       IF ERL = 20223 AND ZErrCode = 76 THEN _
          CALL LPrnt("Bad path.  File name is " + FilName$,1) : _
          ZErrCode = 76 : _
          ZOK = ZFalse : _
          RESUME NEXT
       IF ERL => 20221 AND ERL <= 20223 AND ZErrCode = 70 _
          AND (ZNetworkType = 6 OR ZNetworkType = 7) THEN _
             ZErrCode = 0 : _
             RESUME NEXT
       IF ERL => 20221 AND ERL <= 20223 THEN _
          RESUME
'
'     FLUSHCOM ERROR HANDLING
'
       IF ERL = 20311 AND ERR = 57 THEN _
          RESUME NEXT
       IF ERL = 20311 AND ERR = 69 THEN _
          ZAbort = ZTrue : _
          ZSubParm = -1 : _
          RESUME NEXT
'
'     NetBIOS ERROR HANDLING
'
       IF ERL => 20900 AND ERL <= 20920 THEN _                       ' 175-1219
          RESUME NEXT
'
'     UPDATEC ERROR HANDLING
'
      IF ERL => 43050 AND ERL <= 43060 AND ERR = 61 THEN _
         ZOutTxt$ = "* Disk full - terminating *" : _
         ZSubParm =2 : _
         CALL TPut : _
         IF ZDiskFullGoOffline THEN _
           GOTO 65010 _
         ELSE SYSTEM
'
'     CHECKINT ERROR HANDLING
'
       IF (ERL = 59652 OR ERL = 59727) AND ERR = 24 THEN _
          ZNotCTS = ZTrue : _
          CALL Line25 : _
          ZErrCode = 0 : _
          RESUME
       IF ERL => 52000 AND ERL <= 59725 THEN _
          RESUME NEXT
'
'     FINDFILE ERROR HANDLING
'
       IF ERL = 59791 THEN _
          IF ERR <> 57 THEN _
             RESUME NEXT _
          ELSE IF ERR = 57 THEN _
             CALL DelayTime (1) : _
             CALL UpdtCalr ("SLOW I/O ERROR",1) : _
             IOErrorCount = IOErrorCount + 1 : _
             IF IOErrorCount < 11 THEN _
                RESUME
'
'     CATCH ALL OTHER ERRORS
'
       ZOutTxt$ = "RBBS-SUB1 Untrapped Error" + _
            STR$(ERR) + _
            " in line" + _
            STR$(ERL)
       CALL QuickTPut1 (ZOutTxt$)
       CALL UpdtCalr (ZOutTxt$,2)
       RESUME NEXT
'
'     SHARED ROUTINE FOR GOING OFF LINE WHEN DISK FULL
'
65010  CALL OpenCom(ZModemInitBaud$,",N,8,1")
       CALL TakeOffHook
       IF ZFossil THEN _
          CALL FOSExit(ZComPort)
       SYSTEM
