' $linesize:132
' $title: 'CNFGSUB2.BAS 17.5, Copyright 1987-94 by D. Thomas Mack'
'  Copyright 1994 by D. Thomas Mack, all rights reserved.
'  Name ...............: CNFGSUB2.BAS
'  First Released .....: May 1, 1994
'  Subsequent Releases.:
'  Copyright ..........: 1987-94
'  Purpose.............: The Remote Bulletin Board System for the IBM PC,
'                        RBBS-PC, configuration program -- CONFIG.BAS
'                        utilizes a lot of menus and string space.
'                        These are incorporated within CNFG-SUB.BAS as a
'                        seperately callable subroutines in order to free
'                        up as much code as possible within the 64K code
'                        segment used by CONFIG.BAS.
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine  Line      Function of Subroutine
'    Name    Number
' ALLCAPS    60510+     Captialize a string
' ANSIDECODE 61340+     Convert ANSI strings into english text expressions
' ASKRO      61100      Ask a question on a specific row
' ASKUPOS    61300      Ask for identifying field in USERS record
' BRKFNAME   61830      Break file name in drive/path, prefix, extension
' COLORCODE  61340+     Convert response into ANSI-meaningful strings
' EHELP      60500      Routine for displaying extensive help
' FINDFILE   61600      Determine whether a file exists
' FINDLAST   61850      Find last occurence of a character in a string
' NETTYPE    60382      Prompt for supported network types
' SELMODEM   62100      Select modem to set modem strings
' TRIMTRAIL  61840      Remove trailing characters from a string
' VOICETYPE  60482      Prompt for supported voice card types
'
'  $INCLUDE: 'CNFG-VAR.BAS'
'
'  $SUBTITLE: 'NETTYPE - subroutine to select supported networks'
'  $PAGE
'
'  SUBROUTINE NAME    --  NETTYPE
'
'  INPUT PARAMETERS   --  MLCOM
'                         NETWORK.TYPE
'                         NETWORK.TYPE$
'                         SUBROUTINE.PARAMETER
'
'  OUTPUT PARAMETERS  --  MLCOM
'                         NETWORK.TYPE
'                         NETWORK.TYPE$
'
'  SUBROUTINE PURPOSE --  TO SELECT THE RBBS-PC SUPPORTED NETWORKS
'
      SUB NETTYPE STATIC
      ON SUBROUTINE.PARAMETER GOTO 60382,60384
60382 CLS
      LOCATE 3,1
      PRINT "     RBBS-PC is supported in the following:"
      PRINT "                   Environment"
      CALL ANSI(FG1$ + "          0. " + FG2$ + _                    ' FIX052403
	 "Single RBBS-PC in an IBM DOS environment")                 ' FIX052403
      CALL ANSI(FG1$ + "          1. " + FG2$ + _                    ' FIX052403
	 "OS/2 v2.x DOS Box")                                        ' FIX062302
      CALL ANSI(FG1$ + "          2. " + FG2$ + _                    ' FIX052403
	 "Omninet (CORVUS)")                                         ' FIX052403
      CALL ANSI(FG1$ + "          3. " + FG2$ + _                    ' FIX052403
	 "PC-NET (Orchid)")                                          ' FIX052403
      CALL ANSI(FG1$ + "          4. " + FG2$ + _                    ' FIX052403
	 "DESQview (Quarterdeck)")                                   ' FIX052403
      CALL ANSI(FG1$ + "          5. " + FG2$ + _                    ' FIX052403
	 "10 NET (Fox Research)")                                    ' FIX052403
      CALL ANSI(FG1$ + "          6. " + FG2$ + _                    ' FIX052403
	 "NETBIOS (DOS Share)")                                      ' FIX052403
      CALL ANSI(FG1$ + "          7. " + FG2$ + _                    ' FIX052403
	 "DoubleDOS, but file sharing not supported.")               ' FIX052403
60383 XX$ = "Select environment (0 or 1-7, [ENTER] quits)"           ' FIX052001
      I! = FRE(C$)
      LOCATE 24,1
      PRINT STRING$(79,32);
      LOCATE 24,5
      PRINT XX$;
      LINE INPUT;X$
      IF X$ = "" THEN _
	 EXIT SUB
      NETWORK.TYPE = VAL(X$)
      IF NETWORK.TYPE < 0 OR NETWORK.TYPE > 7 THEN _                 ' FIX062301
	 GOTO 60383
60384 IF NETWORK.TYPE = 0 THEN _
	 NETWORK.TYPE$ = "IBM's DOS"
      IF NETWORK.TYPE = 1 THEN _
	 MLCOM = TRUE : _
	 NETWORK.TYPE$ = "OS/2 v2.x DOS Box"                         ' FIX062302
      IF NETWORK.TYPE = 2 THEN _
	 NETWORK.TYPE$ = "Omninet"
      IF NETWORK.TYPE = 3 THEN _
	 NETWORK.TYPE$ = "PC-NET"
      IF NETWORK.TYPE = 4 THEN _
	 NETWORK.TYPE$ = "DESQview"
      IF NETWORK.TYPE = 5 THEN _
	 NETWORK.TYPE$ = "10 NET"
      IF NETWORK.TYPE = 6 THEN _
	 NETWORK.TYPE$ = "NETBIOS"
      IF NETWORK.TYPE = 7 THEN _
	 NETWORK.TYPE$ = "No file sharing!"
      IF SUBROUTINE.PARAMETER = 2 THEN _
	 EXIT SUB
      END SUB
'  $SUBTITLE: 'VOICETYPE - subroutine to select voice'
'  $PAGE
'
'  SUBROUTINE NAME    --  VOICETYPE
'
'  INPUT PARAMETERS   --  VOICE.TYPE
'                         VOICE.TYPE$
'                         SUBROUTINE.PARAMETER
'
'  OUTPUT PARAMETERS  --  VOICE.TYPE
'                         VOICE.TYPE$
'
'  SUBROUTINE PURPOSE --  TO SELECT THE RBBS-PC SUPPORTED VOICE
'                         SYNTHESIZERS
'
      SUB VOICETYPE STATIC
      ON SUBROUTINE.PARAMETER GOTO 60482,60484
60482 CLS
      LOCATE 3,1
      PRINT "     RBBS-PC is supported in the following:"
      PRINT "            Voice Synthesizers"
      CALL ANSI(FG1$ + "          0. " + FG2$ + "None")              ' FIX052701
      CALL ANSI(FG1$ + "          1. " + FG2$ + "CompuTalker")       ' FIX052701
      CALL ANSI(FG2$ + "             B.G. MICRO")                    ' FIX052701
      CALL ANSI(FG2$ + "             P.O. Box 280298")               ' FIX052701
      CALL ANSI(FG2$ + "             Dallas, Texas 75228")           ' FIX052701
      CALL ANSI(FG1$ + "          2. " + FG2$ + "HearSay 1000")      ' FIX052701
      CALL ANSI(FG2$ + "             HEARSAY INC.")                  ' FIX052701
      CALL ANSI(FG2$ + "             1825 74th Street")              ' FIX052701
      CALL ANSI(FG2$ + "             Brooklyn, New York 11204")      ' FIX052701
60483 CALL ASKRO("Select environment (0 to 2, [ENTER] quits)",24,X$)
      IF X$ = "" THEN _
	 EXIT SUB
      VOICE.TYPE = VAL(X$)
      IF VOICE.TYPE < 0 OR VOICE.TYPE > 2 THEN _
	 GOTO 60483
60484 IF VOICE.TYPE = 0 THEN _
	 VOICE.TYPE$ = NONE.PICKED$
      IF VOICE.TYPE = 1 THEN _
	 VOICE.TYPE$ = "CompuTalker"
      IF VOICE.TYPE = 2 THEN _
	 VOICE.TYPE$ = "HearSay 1000"
      END SUB
'  $SUBTITLE: 'EHELP - give extensive help for each option'
'  $PAGE
'
'  SUBROUTINE NAME    --  EHELP
'
'  INPUT PARAMETERS   --  PARAMETER         MEANING
'                         X$             STRING CONTAINING THE OPTION NUMBER
'
'  SUBROUTINE PURPOSE --  TO GIVE EXTENSIVE HELP FOR EACH OPTION IN CONFIG
'
      SUB EHELP (X$) STATIC                                          ' FIX041802
60500 CALL FINDFILE (HELP.PATH$+"CONFIG." + HELP.EXTENSION$,FEXISTS) ' FIX041802
      IF FEXISTS THEN _                                              ' FIX052401
	 OPEN "I",#8,HELP.PATH$+"CONFIG." + HELP.EXTENSION$ : _      ' FIX052401
	 GOTO 60505                                                  ' FIX052401
      CALL FINDFILE ("CONFIG." + HELP.EXTENSION$,FEXISTS)            ' FIX052401
      IF FEXISTS THEN _                                              ' FIX052401
	 OPEN "I",#8,"CONFIG." + HELP.EXTENSION$ : _                 ' FIX052401
	 GOTO 60505                                                  ' FIX052401
      CALL ASKRO (HELP.PATH$+"CONFIG." + HELP.EXTENSION$ + " not found.  No help available.  (CR = CONTINUE)",24,HJ$) : _ ' FIX041802
      EXIT SUB                                                       ' FIX041802
60505 CLS                                                            ' FIX042501
      PRINT "Loading help data.  Please be patient."                 ' FIX042602
'     WHILE VAL(RIGHT$(X$,1)) = 0                                    ' FIX041802
'        X$=LEFT$(X$,LEN(X$)-1)                                      ' FIX042501
'     WEND                                                           ' FIX042501
      WHILE NOT EOF(8)                                               ' FIX042501
	 LINE INPUT #8,HLP$                                          ' FIX041802
	 IF LEFT$(HLP$,LEN(X$)+2) = "["+X$+"]" THEN _                ' FIX042501
	    HELP.FLAG = TRUE : _                                     ' FIX042501
	    CLS : _                                                  ' FIX042602
	    HLP$=FG1$ + MID$(HLP$,INSTR(HLP$,"]")+1,20) + FG3$ + _   ' FIX052403
	       MID$(HLP$,INSTR(HLP$,"]")+21) + FG2$                  ' FIX052403
	 IF HELP.FLAG AND LEFT$(HLP$,1) = "[" THEN _                 ' FIX042501
	    GOTO 60510                                               ' FIX042501
	 IF HELP.FLAG THEN _                                         ' FIX042501
	    CALL ANSI(HLP$)                                          ' FIX052303
      WEND                                                           ' FIX042501
      IF NOT HELP.FLAG THEN _                                        ' FIX042501
	 CLS : _                                                     ' FIX042602
	 PRINT "There is no help available for that option."         ' FIX042501
60510 CALL ASKRO ("Press ENTER to continue...",24,HJ$)               ' FIX042501
      HELP.FLAG = FALSE                                              ' FIX042501
      CLOSE #8                                                       ' FIX041802
      END SUB                                                        ' FIX041802
'  $SUBTITLE: 'ALLCAPS - convert a sting into all capital letters'
'  $PAGE
'
'  SUBROUTINE NAME    --  ALLCAPS
'
'  INPUT PARAMETERS   --  PARAMETER         MENANING
'                         STRNG$         STRING CONTAINING THE QUESTION
'
'  OUTPUT PARAMETERS  --  STRNG$         CAPITALIZED STRING
'
'  SUBROUTINE PURPOSE --  TO CAPITALIZE A STRING
'
      SUB ALLCAPS (STRNG$) STATIC
      FOR WasZ = 1 TO LEN(STRNG$)
	 WasX = ASC(MID$(STRNG$,WasZ,1))
	 IF WasX > 96 THEN IF WasX < 123 THEN _
	    MID$(STRNG$,WasZ,1) = CHR$(WasX AND 223)
      NEXT
      END SUB
'  $SUBTITLE: 'ASKRO - ask a question at a specific row'
'  $PAGE
'
'  SUBROUTINE NAME    --  ASKRO
'
'  INPUT PARAMETERS   --  PARAMETER         MEANING
'                         ANS$           STRING TO PUT THE ANSWER IN
'                         STRNG$         STRING CONTAINING THE QUESTION
'                         RO             ROW TO ASK THE QUESTION ON
'
'  OUTPUT PARAMETERS  --  ANS$           RESPONSE FROM THE KEYBOARD
'
'  SUBROUTINE PURPOSE --  TO ASK A QUESTION ON THE PC'S DISPLAY AT A
'                         SPECIFIC ROW
'
      SUB ASKRO (STRNG$,RO,ANS$) STATIC
61100 LOCATE RO,1
      PRINT SPACE$(79);
      LOCATE RO,5
      PRINT STRNG$;" ";
      LINE INPUT;ANS$
      END SUB
'  $SUBTITLE: 'ASKUPOS - find the unique user field for USERS'
'  $PAGE
'
'  SUBROUTINE NAME    --  ASKUPOS
'
'  INPUT PARAMETERS   --  PARAMETER         MENANING
'                         HDR$           HEADER
'                         BEGIN.COL      BEGINNING COLUMN OF FIELD
'                         FIELD.LEN      LENGTH OF FIELD IN USER'S RECORD
'                         PRMPT$         PROMPT TO GIVE FOR FIELD
'
'  OUTPUT PARAMETERS  --  ABOVE INPUTS UPDATED WITH USER'S RESPONSES
'
'  SUBROUTINE PURPOSE --  TO ASK THE SYSOP WHAT UNIQUE FIELD IN THE USERS
'                         RECORD IS TO BE ASKED FOR AT LOGON
'
      SUB ASKUPOS (HDR$,BEGIN.COL,FIELD.LEN,PRMPT$) STATIC
      CLS
      LOCATE 3,20
      PRINT HDR$;
61300 LOCATE 6,5
      CALL ANSI(FG1$ + "1.  " + FG2$ + "BEGINNING COLUMN in USERS file" + _ ' FIX052403
	 SPACE$(6) + FG3$ + STR$(BEGIN.COL) + "   ")                ' FIX052403
      LOCATE 8,5
      CALL ANSI(FG1$ + "2.  " + FG2$ + "Number of CHARACTERS to use" + _ ' FIX052403
	 SPACE$(9) + FG3$ + STR$(FIELD.LEN) + "   ")                ' FIX052403
      LOCATE 10,5
      CALL ANSI(FG1$ + "3.  " + FG2$ + "PROMPT to display to callers" + _ ' FIX052403
	 SPACE$(9) + FG3$ + PRMPT$ + SPACE$(34-LEN(PRMPT$)))        ' FIX052403
61310 CALL ASKRO ("Select option to change (1-3, ENTER to end)",24,X$)
      IF X$ = "" THEN _
	 EXIT SUB
      X = VAL(X$)
      IF X < 1 OR X > 3 THEN _
	 GOTO 61310
      ON X GOTO 61320,61330,61340
61320 CALL ASKRO ("New BEGINNING COLUMN",24,HJ$)
      IF HJ$ = "" THEN _
	 GOTO 61300                                                  ' FIX052001
      X = VAL(HJ$)
      IF X < 0 OR X > 128 THEN _
	 GOTO 61320
      BEGIN.COL = X
      GOTO 61300
61330 CALL ASKRO ("New # CHARACTERS to use",24,HJ$)
      IF HJ$ = "" THEN _
	 GOTO 61300                                                  ' FIX052001
      X = VAL(HJ$)
      IF X < 0 OR X > 31 THEN _
	 GOTO 61330
      FIELD.LEN = X
      GOTO 61300
61340 CALL ASKRO ("New PROMPT",24,HJ$)
      IF HJ$ = "" THEN _
	 GOTO 61300                                                  ' FIX052001
      IF LEN(HJ$) > 34 THEN _
	 GOTO 61340
      PRMPT$ = HJ$
      GOTO 61300
      END SUB
' $SUBTITLE: 'COLORCODE - SUBROUTINE TO GET COLOR CODES'
' $PAGE
'
'  SUBROUTINE NAME    -- COLORCODE
'
'  INPUT PARAMETERS   -- PARAMETER                      MEANING
'                        NAT.LANG.COLOR$  NATURAL LANGUAGE LETTER OF COLOR
'                                           N = NONE
'                                           B = BLUE
'                                           G = GREEN
'                                           C = CYAN
'                                           R = RED
'                                           P = PURPLE
'                                           Y = YELLOW
'                                           W = WHITE
'
'  OUTPUT PARAMETERS  -- ANSI.COLOR$      CORRECT CHARACTER SEQUENCE OF COLOR
'                        BASIC.FG         NUMBER FOR BASIC FORGROUND
'
'  SUBROUTINE PURPOSE -- TO CONVERT THE NATURAL LANGUAGE COLOR SELECTION INTO
'                        COLOR CODES THAT ARE MEANINGFUL.
'
      SUB COLORCODE (NAT.LANG.COLOR$,ANSI.COLOR$,BASIC.FG) STATIC
      BASIC.FG = 7
      IF NAT.LANG.COLOR$ = NONE.PICKED$ THEN _
	 ANSI.COLOR$ = "" : _
	 EXIT SUB
      X = INSTR(" BN",LEFT$(NAT.LANG.COLOR$,1))
      IF X < 2 THEN _
	 EXIT SUB
      X$ = MID$("10",X-1,1)
      X = INSTR(NAT.LANG.COLOR$," ")
      IF X < 1 OR X >= LEN(NAT.LANG.COLOR$) THEN _
	 EXIT SUB
      Z$ = MID$(NAT.LANG.COLOR$,X+1,1)
      X = INSTR("RGYBPCW",Z$)
      IF X < 1 THEN _
	 EXIT SUB
      BASIC.FG = INSTR("BGCRPYW",Z$) - 8 * (X$="1")
      Y$ = MID$(STR$(30+X),2)
      Z = INSTR("NRGYBPCW",MID$("NBGCRPYW",CALLER.BKGRD+1,1))
      Z$ = MID$(STR$(39+Z),2)
      ANSI.COLOR$ = CHR$(27) + "[" + X$ + ";" + Z$ + ";" + Y$ + "m"
      END SUB
' $SUBTITLE: 'ANSIDECODE - SUBROUTINE TO DECODE ANSI VALUES'
' $PAGE
'
'  SUBROUTINE NAME    -- ANSIDECODE
'
'  INPUT PARAMETERS   -- PARAMETER                      MEANING
'                        ANSI.EXPRESSION$ EXPRESSION WITH ANSI COLOR CODES IN
'
'  OUTPUT PARAMETERS  -- ANSI.EXPRESSION$ ENGLISH LANGUAGE DESCRIPTION OF COLOR
'
'  SUBROUTINE PURPOSE -- DECODES THE ANSI EXPRESSION INTO A MEANINGFUL
'                        ENGLISH TEXT DESCRIPTION.
'
      SUB ANSIDECODE (ANSI.EXPRESSION$) STATIC
      IF LEN (ANSI.EXPRESSION$) < 3 THEN _
	 EXIT SUB
      IF ASC(ANSI.EXPRESSION$) <> 27 THEN _
	 EXIT SUB
      X = INSTR(ANSI.EXPRESSION$,";")
      IF X < 1 THEN _
	 EXIT SUB
      IF MID$(ANSI.EXPRESSION$,X-1,1) = "1" THEN _
	 X$ = "Bright " _
      ELSE X$ = "Normal "
      X = INSTR(X,ANSI.EXPRESSION$,"m")
      IF X < 1 THEN _
	 EXIT SUB
      X = VAL(MID$(ANSI.EXPRESSION$,X-2,2)) - 30
      IF X < 1 OR X > 7 THEN _
	 EXIT SUB
      ANSI.EXPRESSION$ = X$ + MID$("Red   Green YellowBlue  PurpleCyan  White",X*6-5,6)
      END SUB
'  $SUBTITLE: 'FINDFILE - Determine whether a file exists'
'  $PAGE
'
'  SUBROUTINE NAME    --  FINDFILE
'
'  INPUT PARAMETERS   --  PARAMETER         MENANING
'                         FILNAME$         FILE TO LOOK FOR
'                         FEXISTS          WHETHER FILE EXISTS
'
'  OUTPUT PARAMETERS  --  RETURNED.VALUE   VALUE RETURNED
'
'  SUBROUTINE PURPOSE --  DETERMINE WHETHER PASSED FILE NAME EXISTS
'                         RETURN TRUE OR FALSE IN "FEXISTS"
'
      SUB FINDFILE (FILNAME$,FEXISTS) STATIC
61600 CALL RBBSFIND (FILNAME$,Z,Y,M,D)
      FEXISTS = (Z = 0)
      END SUB
' $SUBTITLE: 'BRKFNAME - subroutine to decompose a file name'
' $PAGE
'
'  SUBROUTINE NAME    -- BRKFNAME
'
'  INPUT PARAMETERS   -- PARAMETER                     MEANING
'                        FILENAME$       NAME OF THE FILE TO BE DECOMPOSED
'                        FOR.JOINING     INDICATOR IF OUTPUT IS TO BE COMPBINED
'
'  OUTPUT PARAMETERS  -- DRVPATH$        DRIVE AND PATH
'                        PREFIX$         8-CHARACTER FILE NAME PREFIX
'                        EXTENSION$      3-CHARACTER EXTENSION
'
'  SUBROUTINE PURPOSE -- BREAKS DOWN A FILE NAME INTO A DRIVE AND PATH,
'                        FILE PREFIX (8 CHARACTERS), AND FILE EXTENSION
'                        (3 CHARACTERS).  IF "FOR.JOINING" IS TRUE, THE
'                        DRIVE AND PATH HAVE A ":" AND A "\" IN IT AND
'                        THE EXTENSION BEGINS WITH A ".".
'
      SUB BRKFNAME (FILENAME$,DRVPATH$,PREFIX$,EXTENSION$,FOR.JOINING) STATIC
      FLNAME$ = FILENAME$
61830 CALL ALLCAPS (FLNAME$)
      DRVPATH$ = ""
      PREFIX$ = ""
      EXTENSION$ = ""
      L = LEN(FLNAME$)
      IF L < 1 THEN _
	 EXIT SUB
      CALL FINDLAST (FLNAME$,"\",X,Y)
      IF X < 1 THEN _
	 IF MID$(FLNAME$,2,1) = ":" THEN _
	    DRVPATH$ = LEFT$(FLNAME$, 2): _
	    S = 3 _
	 ELSE S = 1 _
      ELSE DRVPATH$ = LEFT$(FLNAME$,X) : _
	   S = X + 1
      X = INSTR(FLNAME$+".",".")
      IF X < L THEN _
	 EXTENSION$ = MID$(FILENAME$,X)
      IF S <= L THEN _
	 IF X >= S THEN _
	    PREFIX$ = MID$(FLNAME$,S,X - S)
      IF FOR.JOINING THEN _
	 EXIT SUB
      IF Y > 1 THEN _
	 DRVPATH$ = LEFT$(DRVPATH$, LEN(DRVPATH$) - 1)
      IF LEN(EXTENSION$) > 0 THEN _
	 EXTENSION$ = MID$(EXTENSION$, 2)
      END SUB
'
'  $SUBTITLE: 'TRIMTRAIL - subroutine to trim off trailing characters'
'  $PAGE
'
'  SUBROUTINE NAME    --  TRIMTRAIL
'
'  INPUT PARAMETERS   --  PARAMETER           MEANING
'                         TRIM.PARM$  TIME IN SECONDS AFTER MIDNIGHT TO WAIT
'                                     BEFORE DISPLAYING
'                         TRIM.THIS$  WHAT CHARACTER TO TRIM OFF END
'
'  OUTPUT PARAMETERS  --  NONE
'
'  SUBROUTINE PURPOSE --  TO DISPLAY RBBS-PC's SYSOP MENU ON THE LOCAL SCREEN
'
61840 SUB TRIMTRAIL (TRIM.PARM$,TRIM.THIS$) STATIC
      WHILE RIGHT$(TRIM.PARM$,1) = TRIM.THIS$
	 TRIM.PARM$ = LEFT$(TRIM.PARM$,LEN(TRIM.PARM$) - 1)
      WEND
      END SUB
'
' $SUBTITLE: 'FINDLAST - subroutine to find last occurence of a string'
' $PAGE
'
'  SUBROUTINE NAME    -- FINDLAST
'
'  INPUT PARAMETERS   -- PARAMETER             MEANING
'                        LOOK.IN$           STRING TO LOOK INTO
'                        LOOK.FOR$          STRING TO SEARCH FOR
'
'  OUTPUT PARAMETERS  -- WHERE.FOUND        POSITION IN LOOK.IN$ THAT
'                                            LOOK.FOR$ FOUND
'                        NUM.FINDS          HOW MANY OCCURENCES IN LOOK.IN$
'
'  SUBROUTINE PURPOSE -- FINDS THE LAST OCCURANCE OF "LOOK.FOR$" IN "LOOK.IN$"
'                        AND RETURNS COUNT OF NUMBER OF OCCURENCES.  IF NONE
'                        ARE FOUND, BOTH RETURNED PARAMETERS ARE ZERO.
'
      SUB FINDLAST (LOOK.IN$,LOOK.FOR$,WHERE.FOUND,NUM.FINDS) STATIC
61850 WHERE.FOUND = INSTR(LOOK.IN$,LOOK.FOR$)
      NUM.FINDS = -(WHERE.FOUND > 0)
      NEXT.FOUND = INSTR(WHERE.FOUND + 1,LOOK.IN$,LOOK.FOR$)
      WHILE NEXT.FOUND > 0
	 NUM.FINDS = NUM.FINDS + 1
	 WHERE.FOUND = NEXT.FOUND
	 NEXT.FOUND = INSTR(WHERE.FOUND + 1,LOOK.IN$,LOOK.FOR$)
      WEND
      END SUB
62100 SUB SELMODEM STATIC
      CALL FINDFILE ("MODEMS.SET",OK)
      IF OK THEN _
	 GOTO 62103
      CALL MODEMINITCMD
      EXIT SUB
62103 CLOSE 2
      IF NETWORK.TYPE = 6 THEN _
	 OPEN "MODEMS.SET" FOR INPUT SHARED AS #2 _
      ELSE OPEN "I",2,"MODEMS.SET"
      MODEM.MODEL = 0
      MODEM.PAGE = 0
62105 CLS
      PRINT "NUMBER";
      LOCATE 1,10
      PRINT "Modem Model";
      LOCATE 1,40
      PRINT "Switch Settings";
      LOCATE 2,1
      PRINT STRING$(78,"-");
      FOR DISPLAY.LINE = 3 TO 19
	 IF EOF(2) THEN _
	    MODEM.PAGE = 1 : _
	    GOTO 62108
	 MODEM.MODEL = MODEM.MODEL + 1
	 INPUT #2, MODEM.MODEL$, SWITCHES$
	 FOR I = 1 TO 14                    ' # MODEMS.SET parms - 2
	    INPUT #2,GARBAGE$
	 NEXT
	 LOCATE DISPLAY.LINE, 2
	 CALL ANSI(FG1$ + STR$(MODEM.MODEL))                         ' FIX052701
	 LOCATE DISPLAY.LINE, 10
	 CALL ANSI(FG2$ + MODEM.MODEL$)                              ' FIX052701
	 LOCATE DISPLAY.LINE, 40
	 CALL ANSI(FG3$ + SWITCHES$)                                 ' FIX052701
      NEXT
      LOCATE DISPLAY.LINE + 1, 2
      PRINT " 0"
      LOCATE DISPLAY.LINE + 1, 10
      PRINT "Next Page"
      GOTO 62110
62108 LOCATE DISPLAY.LINE + 1, 2
      PRINT " 0"
      LOCATE DISPLAY.LINE + 1, 10
      PRINT "Relist choices"
62110 LOCATE 24,10
      PRINT "Use Parameter 231 to initialize modem's firmware";
      CALL GETINIT("Select modem number, or [ENTER] to exit", _
		    22,0,MODEM.MODEL,MODEM.SELECTED, CR)
      IF CR THEN _
	 EXIT SUB
      IF MODEM.PAGE AND MODEM.SELECTED = 0 THEN _                    ' FIX050602
	 GOTO 62103                                                  ' FIX050602
      IF MODEM.SELECTED = 0 THEN _
	 GOTO 62105
      CLOSE 2
      IF NETWORK.TYPE = 6 THEN _
	 OPEN "MODEMS.SET" FOR INPUT SHARED AS #2 _
      ELSE OPEN "I",2,"MODEMS.SET"
      FOR I = 1 TO (MODEM.SELECTED - 1) * 16      ' # of parms * modem
	 INPUT #2,GARBAGE$
      NEXT
      INPUT #2, MODEM.MODEL$, _
		SWITCHES$, _
		USER.ANSWER.COMMAND$, _
		USER.COUNT.RINGS.COMMAND$, _
		USER.GO.OFFHOOK.COMMAND$, _
		USER.INIT.COMMAND$, _
		USER.RESET.COMMAND$, _
		USER.INITIALIZE.COMMAND$, _
		USER.FIRMWARE.CLEAR.CMND$, _
		USER.FIRMWARE.WRITE.CMND$, _
		RTS$, _
		MODEM.INIT.WAIT.TIME, _
		MODEM.COMMAND.DELAY.TIME, _
		COMMANDS.BETWEEN.RINGS, _
		MODEM.INIT.BAUD$, _
		KEEP.INIT.BAUD
      CLOSE 2
      END SUB
62120 SUB MODEMINITCMD STATIC
      RTS$ = "NO"
      MODEM.INIT.WAIT.TIME = 3
      COMMANDS.BETWEEN.RINGS = FALSE
      FIRMWARE.INITIALIZE.COMMAND$ = "AT&C1&D3B1E0V1M0S0=0"
      FIRMWARE.CLEAR.COMMAND$ = "AT&F"
      FIRMWARE.WRITE.COMMAND$ = "AT&W"
      KEEP.INIT.BAUD = FALSE
      MODEM.ANSWER.COMMAND$      = "ATQ0X1V1A"
      MODEM.COMMAND.DELAY.TIME   = 1
      MODEM.COUNT.RINGS.COMMAND$ = "ATS1?"
      MODEM.GO.OFFHOOK.COMMAND$  = "ATH1M0"
      'MODEM.GO.OFFHOOK.COMMAND$  = "ATQ1E1H1M0"
      MODEM.INIT.BAUD$           = "300"
      MODEM.INIT.COMMAND$        = "ATE0M0Q0V1X1S0=254S2=255S10=20"
      'MODEM.INIT.COMMAND$        = "ATM0Q1S2=255S10=30E0Q0X1S0=254  "
      MODEM.RESET.COMMAND$       = "ATZ"
      'USER.INITIALIZE.COMMAND$   = "AT&C1&D3B1E0V1M0S0=0&T5"
      'USER.FIRMWARE.WRITE.CMND$  = "&W"
      USER.ANSWER.COMMAND$ = MODEM.ANSWER.COMMAND$
      USER.COUNT.RINGS.COMMAND$ = MODEM.COUNT.RINGS.COMMAND$
      USER.GO.OFFHOOK.COMMAND$ = MODEM.GO.OFFHOOK.COMMAND$
      USER.INIT.COMMAND$ = MODEM.INIT.COMMAND$
      USER.RESET.COMMAND$ = MODEM.RESET.COMMAND$
      USER.INITIALIZE.COMMAND$ = FIRMWARE.INITIALIZE.COMMAND$
      USER.FIRMWARE.CLEAR.CMND$ = FIRMWARE.CLEAR.COMMAND$
      USER.FIRMWARE.WRITE.CMND$ = FIRMWARE.WRITE.COMMAND$
      END SUB
62130 SUB ANSI (HJ$) STATIC
      FOR XX = 1 TO LEN(HJ$)
	 IF MID$(HJ$,XX,1) = "`" THEN _
	    X = INSTR("0123456789ABCDEF",MID$(HJ$,XX+1,1)) : _
	    COLOR X : _
	    XX = XX + 2
	 IF LEN(HJ$) >= XX THEN _
	    PRINT MID$(HJ$,XX,1);
      NEXT
      COLOR FG
      PRINT
      END SUB
62140 SUB LCLCOLOR STATIC
      CALL COLORCODE (FG.1.DEF$,FG1$,X)
      FG1$ = "`" + MID$("0123456789ABCDEF",X,1)
      CALL COLORCODE (FG.2.DEF$,FG2$,X)
      FG2$ = "`" + MID$("0123456789ABCDEF",X,1)
      CALL COLORCODE (FG.3.DEF$,FG3$,X)
      FG3$ = "`" + MID$("0123456789ABCDEF",X,1)
      CALL COLORCODE (FG.4.DEF$,FG4$,X)
      FG4$ = "`" + MID$("0123456789ABCDEF",X,1)
      CALL COLORCODE (FG.5.DEF$,FG5$,X)                              ' FIX062303
      FG5$ = "`" + MID$("0123456789ABCDEF",X,1)                      ' FIX062303
      END SUB
