DEFINT A-Z
PassedArguments$ = COMMAND$ + " "
X = INSTR(" H h ? ", PassedArguments$)
IF X > 0 THEN
   CLS
   PRINT "MAKETABS version 1.0 Copyright (c) 1989 by Ken Goosens"
   PRINT "an RBBS utility to make an index tab for sorted file list"
   PRINT
   PRINT "Format:      MAKETABS <options>    where options are:"
   PRINT
   PRINT "/IN=<input file>                       Default:  FIDX.DEF"
   PRINT "/OUT=<output file>                     Default:  LIDX.DEF"
   PRINT "/B  (run batch)                        Default:  (no)"
   PRINT "/INDEXPOS=<column position to index>   Default:  1"
   PRINT                                                             ' RM070693
   IF X > 1 THEN END
END IF

' Initialize

InFile$ = "FIDX.DEF"
OutFile$ = "FIDXT.DEF"
IndexPos = 1
TRUE = -1
FALSE = 0
RunBatch = FALSE

' Process Command Line

PassedArguments$ = UCASE$(PassedArguments$)
X = INSTR(PassedArguments$, "/INDEXPOS=")
IF X > 0 THEN
   IndexPos = VAL(MID$(PassedArguments$, X + 10))
END IF
X = INSTR(PassedArguments$, "/IN=")
IF X > 0 THEN
   Y = INSTR(X, PassedArguments$, " ")
   InFile$ = MID$(PassedArguments$, X + 4, Y - X - 4)
END IF
X = INSTR(PassedArguments$, "/OUT=")
IF X > 0 THEN
   Y = INSTR(X, PassedArguments$, " ")
   OutFile$ = MID$(PassedArguments$, X + 5, Y - X - 5)
END IF
RunBatch = (INSTR(PassedArguments$, "/B ") > 0)

PRINT "MAKETABS version 1.0 Copyright (c) 1989 by Ken Goosens"       ' RM070693
PRINT                                                                ' RM070693
PRINT "Modified by R. Molinelli on 07/06/93 for Large Indices &"     ' RM070693
PRINT "additional characters in filenames for compatiblity with"     ' RM070693
PRINT "LRGE174 & TAB174 mods by Yaser Behbehani (STUNY)"             ' RM070693
PRINT
PRINT "File to Create Tabs for .. "; InFile$
PRINT "TAB file to make ......... "; OutFile$
PRINT "Position to index ........ "; IndexPos
PRINT
IF NOT RunBatch THEN
   INPUT "A to abort, anything else runs"; ANS$
   ANS$ = UCASE$(ANS$)
   IF ANS$ = "A" THEN END
END IF

DIM StartPos&(40)                                                    ' RM071793
CharsCounted$ = "!#$0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_"           ' RM070693
OPEN InFile$ FOR INPUT AS #1
FOR i = 1 TO 40                                                      ' RM070693
   StartPos&(i) = 0                                                  ' RM071793
NEXT
LinesRead& = 0                                                       ' RM071193
PRINT "Processing file "; InFile$; " ";
ColPos = POS(0)
WHILE NOT EOF(1)
   LINE INPUT #1, A$
   LinesRead& = LinesRead& + 1                                       ' RM071193
   LOCATE , ColPos
   PRINT LinesRead&;                                                 ' RM071193
   IndexChar$ = MID$(A$, IndexPos, 1)
   Position = INSTR(CharsCounted$, IndexChar$)
   IF Position > 0 THEN
      IF StartPos&(Position) = 0 THEN                                ' RM071793
         StartPos&(Position) = LinesRead&                            ' RM071193/071793
      END IF
   END IF
WEND
CLOSE 1

OPEN OutFile$ FOR RANDOM AS #1 LEN = 160                             ' RM070693
FIELD #1, 160 AS OutRec$                                             ' RM070693
PrevValue& = 0                                                       ' RM071793
' put 1 in for leading 0's
i = 1
WHILE i < 41 AND StartPos&(i) = 0                                    ' RM070693/071793
   StartPos&(i) = 1                                                  ' RM071793
   i = i + 1
WEND
' find last non-zero value
i = 40                                                               ' RM070693
WHILE i > 0 AND StartPos&(i) = 0                                     ' RM071793
   i = i - 1
WEND
StartPos&(40) = StartPos&(i)                                         ' RM070693/071793
' propagate high values to left over 0's
FOR i = 40 TO 1 STEP -1                                              ' RM070693
   IF StartPos&(i) = 0 THEN                                          ' RM071793
      CurrentValue& = 1                                              ' RM071793
      IF PrevValue& > CurrentValue& THEN                             ' RM071793
         CurrentValue& = PrevValue&                                  ' RM071793
      END IF
   ELSE
      CurrentValue& = StartPos&(i)                                   ' RM071793
   END IF
   StartPos&(i) = CurrentValue&                                      ' RM071793
   PrevValue& = CurrentValue&                                        ' RM071793
NEXT
FOR i = 1 TO 40                                                      ' RM070693
   MID$(OutRec$, 1 + 4 * (i - 1), 4) = MKL$(StartPos&(i))            ' RM070693/071793
NEXT
PUT 1, 1
CLOSE 1
PRINT
PRINT "Created TAB file "; OutFile$
'FOR i = 1 TO 36
'   PRINT MID$(CharsCounted$, i, 1); StartPos(i); ". ";
'NEXT
END

