' $segment
' $title: 'ANSIEMU ANSI Emulator Module for RBBS/CDOR'
'          By Dan Drinnon 1:109/331
'             The Cellar Door RBBS (703) 913-5621 V.Everything
'
'  Copyright (c) 1995,1996 by Daniel T. Drinnon
'  All Rights Reserved
'
' $SUBTITLE: 'ANSIPRINT - ANSI Emulator'
' $PAGE
'
' $INCLUDE: 'RBBS-VAR.BAS'
'
100 SUB ANSIPrint (Strng$) STATIC

    PlayMusicLocal = ZTrue

    FOR charcount = 1 TO LEN(Strng$)
       CurANSIChar$ = MID$(Strng$,charcount,1)
       GOSUB 110
    NEXT
    EXIT SUB


110 IF ANSIActive THEN
       IF LEFT$(ANSIStrng$,2) = "[M" THEN
          IF ASC(CurANSIChar$) = 14 THEN
             IF PlayMusicLocal THEN
                CALL RBBSPlay ("MB" + MID$(ANSIStrng$,4))
             END IF
             ANSIStrng$ = ""
             ANSIActive = ZFalse
          ELSE
             ANSIStrng$ = ANSIStrng$ + CurANSIChar$
          END IF
       ELSEIF INSTR("ABCDEFGHIJKLMNOPQRSTUVWXYZ",UCASE$(CurANSIChar$)) THEN
          SELECT CASE CurANSIChar$
             CASE "A":
                GOSUB 120
             CASE "B":
                GOSUB 130
             CASE "C":
                GOSUB 140
             CASE "D":
                GOSUB 150
             CASE "H", "f":
                GOSUB 160
             CASE "s":
                GOSUB 170
             CASE "u":
                GOSUB 180
             CASE "J":
                GOSUB 190
             CASE "K":
                GOSUB 200
             CASE "h", "l":
                ' Set Display Mode ignored
             CASE "m":
                GOSUB 210
             CASE ELSE
                PRINT ANSIStrng$;
                ANSIActive = ZFalse
                ANSIStrng$ = ""
          END SELECT
          ANSIStrng$ = ""
          ANSIActive = ZFalse
       ELSEIF ASC(CurANSIChar$) < 32 OR LEN(ANSIStrng$) > 80 THEN
          PRINT ANSIStrng$;
          ANSIActive = ZFalse
          ANSIStrng$ = ""
       ELSE
          ANSIStrng$ = ANSIStrng$ + CurANSIChar$
       END IF
    ELSEIF CurANSIChar$ = ZEscape$ THEN
       ANSIActive = ZTrue
       ANSIStrng$ = ""
    ELSEIF ASC(CurANSIChar$) < 32 THEN
       SELECT CASE ASC(CurANSIChar$)
          CASE 7 :
             SOUND 1650,1
          CASE 8 :
             IF POS(0) > 1 THEN
                LOCATE ,POS(0) - 1
                PRINT " ";
                LOCATE ,POS(0) - 1
             END IF
          CASE 9 :
             IF POS(0) < 76 THEN
                PRINT SPACE$(4);
                CurCol = CurCol + 4
             END IF
          CASE 10 :
             CurCol = POS(0)
             CurRow = CSRLIN
             CurRow = CurRow + 1
             IF CurRow > ZLocalPageLength-1 THEN
                CALL ScrollUp
                CurRow = ZLocalPageLength-1
             END IF
             LOCATE CurRow, CurCol
          CASE 11 :
             ' Vertical Tab
          CASE 12 :
             ' Form Feed - Uncomment to CLS
             ' GOSUB 190
          CASE 13 :
             CurRow = CSRLIN
             CurCol = 1
             LOCATE CurRow,CurCol
          CASE 0 TO 6, 14 TO 31
             CALL WriteChar (ASC(CurANSIChar$),ForeGround+(BackGround*16))
             ' NOTE: Some text editors may not display the following lines!
             '  0 - NUL
             '  1 - SOH 
             '  2 - STX 
             '  3 - ETX 
             '  4 - EOT 
             '  5 - ENQ 
             '  6 - ACK 
             ' 14 - SO  
             ' 15 - SI  
             ' 16 - DLE 
             ' 17 - DCI 
             ' 18 - DC2 
             ' 19 - DC3 
             ' 20 - DC4 
             ' 21 - NAK 
             ' 22 - SYN 
             ' 23 - ETB 
             ' 24 - CAN 
             ' 25 - EM  
             ' 26 - SUB (EOF)
             ' 27 - ESC 
             ' 28 - FS  
             ' 29 - GS  
             ' 30 - RS  
             ' 31 - US  
             CurRow = CSRLIN
             CurCol = POS(0)
             CurCol = CurCol + 1
             IF CurCol > 80 THEN
                CurCol = 80
             END IF
             LOCATE CurRow,CurCol
          CASE ELSE
             PRINT CurANSIChar$;
       END SELECT
       CurANSIChar$ = ""
    ELSE
       PRINT CurANSIChar$;
    END IF
    RETURN

120 ' Cursor Up
    WasX = VAL(MID$(ANSIStrng$,2))
    IF WasX < 1 THEN
       WasX = 1
    END IF
    CurRow = CSRLIN
    CurCol = POS(0)
    CurRow = CurRow - WasX
    IF CurRow < 1 THEN
       CurRow = 1
    END IF
    LOCATE CurRow,CurCol
    RETURN

130 ' Cursor Down
    WasX = VAL(MID$(ANSIStrng$,2))
    IF WasX < 1 THEN
       WasX = 1
    END IF
    CurRow = CSRLIN
    CurCol = POS(0)
    CurRow = CurRow + WasX
    IF CurRow > ZLocalPageLength-1 THEN
       CurRow = ZLocalPageLength-1
    END IF
    LOCATE CurRow,CurCol
    RETURN

140 ' Cursor Right
    WasX = VAL(MID$(ANSIStrng$,2))
    IF WasX < 1 THEN
       WasX = 1
    END IF
    CurRow = CSRLIN
    CurCol = POS(0)
    CurCol = CurCol + WasX
    IF CurCol > 80 THEN
       CurCol = 80
    END IF
    LOCATE CurRow,CurCol
    RETURN

150 ' Cursor Left
    WasX = VAL(MID$(ANSIStrng$,2))
    IF WasX < 1 THEN
       WasX = 1
    END IF
    CurRow = CSRLIN
    CurCol = POS(0)
    CurCol = CurCol - WasX
    IF CurCol < 1 THEN
       CurCol = 1
    END IF
    LOCATE CurRow,CurCol
    RETURN

160 ' Cursor Locate
    CurRow = VAL(MID$(ANSIStrng$,2))
    WasX = INSTR(ANSIStrng$,";")
    IF WasX THEN
       CurCol = VAL(MID$(ANSIStrng$,WasX + 1))
    ELSE
       CurCol = 1
    END IF
    IF CurRow < 1 THEN
       CurRow = 1
    ELSEIF CurRow > ZLocalPageLength-1 THEN
       CurRow = ZLocalPageLength-1
    END IF
    IF CurCol < 1 THEN
       CurCol = 1
    ELSEIF CurCol > 80 THEN
       CurCol = 80
    END IF
    LOCATE CurRow,CurCol
    RETURN

170 ' Save Cursor Position
    SaveCurRow = CSRLIN
    SaveCurCol = POS(0)
    RETURN

180 ' Restore Cursor Position
    IF SaveCurRow > 0 THEN
       LOCATE SaveCurRow,SaveCurCol
    END IF
    RETURN

190 'Erase Screen
    CALL ClearViewPort
    LOCATE 1,1
    CurRow = CSRLIN
    CurCol = POS(0)
    RETURN

200 'Erase Line
    CurRow = CSRLIN
    CurCol = POS(0)
    PRINT SPACE$(80 - CurCol);
    LOCATE CurRow, CurCol
    RETURN

210 'Set Colors
    ANSIStrng$ = MID$(ANSIStrng$,2)
    DO WHILE LEN(ANSIStrng$)
       WasX = VAL(ANSIStrng$)
       SELECT CASE WasX
          CASE 0 :                                          ' Reset Colors
             ForeGround = 7
             BackGround = 0
          CASE 1 :                                          ' High Intensity
             ForeGround = (ForeGround OR 8)
          CASE 2 :                                          ' Normal Intensity
             ForeGround = (ForeGround AND &H17)
          CASE 5 :                                          ' Blink
             ForeGround = (ForeGround OR 16)
          CASE 7 :                                          ' Reverse Video
             ForeGround = 0
             BackGround = 7
          CASE 8 :                                          ' Invisible
             ForeGround = 0
             BackGround = 0
          CASE 30 :                                         ' Black Foreground
             ForeGround = (ForeGround AND &H18)
          CASE 31 :                                         ' Red Foreground
             ForeGround = (ForeGround AND &H18) OR 4
          CASE 32 :                                         ' Green Foreground
             ForeGround = (ForeGround AND &H18) OR 2
          CASE 33 :                                         ' Yellow Foreground
             ForeGround = (ForeGround AND &H18) OR 6
          CASE 34 :                                         ' Blue Foreground
             ForeGround = (ForeGround AND &H18) OR 1
          CASE 35 :                                         ' Magenta Foreground
             ForeGround = (ForeGround AND &H18) OR 5
          CASE 36 :                                         ' Cyan Foreground
             ForeGround = (ForeGround AND &H18) OR 3
          CASE 37 :                                         ' White Foreground
             ForeGround = (ForeGround OR 7)
          CASE 40 :                                         ' Black Background
             BackGround = 0
          CASE 41 :                                         ' Red Background
             BackGround = 4
          CASE 42 :                                         ' Green Background
             BackGround = 2
          CASE 43 :                                         ' Yellow Background
             BackGround = 6
          CASE 44 :                                         ' Blue Background
             BackGround = 1
          CASE 45 :                                         ' Magenta Background
             BackGround = 5
          CASE 46 :                                         ' Cyan Background
             BackGround = 3
          CASE 47 :                                         ' White Background
             BackGround = 7
          CASE ELSE
       END SELECT

       WasX = INSTR(ANSIStrng$,";")
       IF WasX THEN
          ANSIStrng$ = MID$(ANSIStrng$,WasX + 1)
       ELSE
          ANSIStrng$ = ""
       END IF
    LOOP
    COLOR ForeGround, BackGround
    RETURN
    END SUB
