                   /* * * * * * * * * * * * * * * * * * * *
                    * CHKANSI.C  (c) 1994, Jim Groeneveld *
                    * * * * * * * * * * * * * * * * * * * *
                                Program CHKANSI
                                  Version 1.0
                               Date 30 April 1994

------------------------------------------------------------------------------
 Y. (Jim) Groeneveld, Schoolweg 14, 8071 BC Nunspeet, Nederland, 03412 60413.
Email (work): groeneveld@tno.nl, groeneveld@cmi.tno.nl, groeneveld@nipg.tno.nl
------------------------------------------------------------------------------

 * CHKANSI detects the presence of ANSI.SYS by using the function ChkAnsiCPR.
 *
 * Usage (from the DOS prompt): CHKANSI [>nul]
 * Example: see ANSIPRMT.BAT
 *
 * Exit codes:   0 = ANSI.SYS not detected
 *               1 = ANSI.SYS detected
 *             ( 2 = unknown, unable to open SCREEN for write )
 *             ( 3 = unknown, unable to open KEYBOARD for read )
 *             ( 4 = unknown, unable to read KEYBOARD )
 * Check these with ERRORLEVEL from DOS.
 *
 * Side effect: clearing of keyboard buffer (necessary, see comments in sources)

Disclaimer
----------
The author is not liable for any negative consequences of the use or misuse
of this program.

-----------------------------------------------------------------------
*/

/*-----------------------------------DEFINE-----------------------------------*/

/*----------------------------------INCLUDE-----------------------------------*/
#include <stdio.h>
#include "chk-ansi.h"

/*------------------------------------MAIN------------------------------------*/
main ()
{ char *CPRstr; int Line, Pos;

/* Program header */
  if (CPRstr=ChkAnsiCPR(0,&Line,&Pos)) printf ("%s\x1B[1;33;44m",CUL);
  printf (" CHKANSI, version 1.0, by Jim Groeneveld, 30 April 1994. ");

/* ANSI.SYS report */
  if (CPRstr)      /* CPRstr may be interpreted into current cursor position */
  {
    printf ("\x1B[1;37;42m ANSI.SYS detected. ");
#if KEYBOARD == 4     /* report input device (CON/stdin) using indicator '' */
    if (*CPRstr==27)     /* if first character is ESC: used getch from stdin */
      printf ("\x1B[1;31;40m ");
#endif /* KEYBOARD == 4 */
    printf ("\x1B[0m\n");
    exit (1);                           /* signal ANSI.SYS loaded */
  } else
  { printf ("ANSI.SYS not detected.\n");
    exit (0);                           /* signal ANSI.SYS not loaded */
  }

}

/*---------------------------- That's all folks! -----------------------------

   ---------------------------------History-----------------------------------
Vs. 1.0    Initial working release
30/04-94

   ----------------------------------Future-----------------------------------

   ---------------------------------Remarks-----------------------------------
*/
