/*
File: OPENREAD.C by Jim Groeneveld, Schoolweg 14, 8071 BC Nunspeet, Nederland.

Disclaimer
----------
The author is not liable for any negative consequences of the use or misuse
of these routines.
*/

/*-----------------------------------DEFINE-----------------------------------*/

/*----------------------------------INCLUDE-----------------------------------*/
#include <stdio.h>
#include "openread.h"

/*---------------------------------OpenFile-----------------------------------*/
FILE *OpenFile(char *FileName, char *Mode, int ExitCode)
/* if ExitCode = -1 don't exit at error, but return with return value NULL */
{ FILE *fp;
  if (!(fp=fopen(FileName,Mode)))
  { fprintf(stderr,"Unable to open %s for mode %s.\n",FileName,Mode);
  if (ExitCode!=-1) exit (ExitCode);
  }
  return fp;
} /* end of <OpenFile> */

/*---------------------------------ReadLine-----------------------------------*/
char *ReadLine (char *String, int StrLen, FILE *fp, int ExitCode)
/* if ExitCode = -1 don't exit at error, but return with return value NULL */
{ char *Result;
  if (!(Result=fgets(String,StrLen,fp)))
  { fprintf (stderr,"Unable to read line from input device.\n");
  if (ExitCode!=-1) exit (ExitCode);
  }
  return Result;
} /* end of <ReadLine> */
