/****************************************************************/
/* Doupdate() routine of the PCcurses package                   */
/*                                                              */
/****************************************************************/
/* This version of curses is based on ncurses, a curses version */
/* originally written by Pavel Curtis at Cornell University.    */
/* I have made substantial changes to make it run on IBM PC's,  */
/* and therefore consider myself free to make it public domain. */
/*              Bjorn Larsson (...mcvax!enea!infovax!bl)        */
/****************************************************************/
/* 1.0: Release:                                        870515  */
/* 1.2: Changed call sequence to cursesio.[c,asm], Thanks       */
/*      to S. Creps. Rcsid[] string for maintenance:    881002  */
/* 1.3: MSC -W3, Turbo'C' -w -w-pro checkes:            881005  */
/****************************************************************/

#include <curses.h>
#include <curspriv.h>

static void clrupdate(WINDOW*);         /* fwd declaration */
static bool transformline(int);
static void clearscreen(void);
static void gotoxy(int,int);
static void Putchar(int);

char _curses_update_rcsid[] = "@(#)update.c v1.3 - 881005";

static WINDOW   *twin;                  /* used by many routines */

/****************************************************************/
/* Doupdate() updates the physical screen to look like _curs-   */
/* var.tmpwin if curscr is not 'Clear-marked'. Otherwise it	*/
/* updates the screen to look like curscr.			*/
/****************************************************************/

void doupdate(void)
  {
  int	 i;

  twin   = _cursvar.tmpwin;
  if (curscr->_clear)
    clrupdate(curscr);
  else
    {
    if (twin->_clear)
      clrupdate(twin);
    else
      {
      for (i=0; i < LINES; i++)
	if (twin->_minchng[i] != _NO_CHANGE)
	  if (transformline(i))
	    break;
      } /* else */
    } /* else */
  curscr->_curx = twin->_curx;
  curscr->_cury = twin->_cury;
  gotoxy(curscr->_cury, curscr->_curx);
  } /* doupdate */

/****************************************************************/
/* Clrupdate(scr) updates the screen by clearing it and then	*/
/* redraw it in it's entirety. If _cursvar.refrbrk is TRUE, and	*/
/* there is pending input characters, the update will be pre-	*/
/* maturely terminated.						*/
/****************************************************************/

static void clrupdate(WINDOW *scr)
  {
  int		*src;
  int		*dst;
  int		 i;
  int		 j;
  WINDOW	*w;

  w = curscr;

  if (scr != w)				/* copy scr to curscr */
    {
    for (i=0; i < LINES; i++)
      {
      src = scr->_line[i];
      dst = w->_line[i];
      for (j=0; j < COLS; j++)
	*dst++ = *src++;
      } /* for */
    } /* if */
  clearscreen();			/* clear physical screen */
  scr->_clear = FALSE;
  for (i=0; i < LINES; i++)		/* update physical screen */
    {
    src = w->_line[i];
    for(j=0; j < COLS; j++)
      {
      if (*src != (' ' | ATR_NRM))
	{
	gotoxy(i,j);
	Putchar(*src);
	} /* if */
      src++;
      } /* for */
    if(_cursvar.refrbrk && _cursespendch())
      return;
    } /* for */
  } /* clrupdate */

/****************************************************************/
/* Transformline() updates the given physical line to look	*/
/* like the corresponding line in _cursvar.tmpwin. Transform-	*/
/* line returns 1 if premature refresh end is allowed, and	*/
/* there is an input character pending.				*/
/****************************************************************/

static bool transformline(int lineno)
  {
  int		*dstp;
  int		*srcp;
  int		 x;
  int		 endx;

  x    = twin->_minchng[lineno];
  endx = twin->_maxchng[lineno];
  dstp = curscr->_line[lineno] + x;
  srcp = twin->_line[lineno] + x;
  
  for( ; x <= endx; x++)
    {
    if(*dstp != *srcp)
      {
      gotoxy(lineno,x);
      Putchar(*srcp);
      } /* if */
    *dstp++ = *srcp++;
    } /* for */
  twin->_minchng[lineno] = _NO_CHANGE;
  twin->_maxchng[lineno] = _NO_CHANGE;
  return ((bool)(_cursvar.refrbrk && _cursespendch()));
  } /* transformline */

/****************************************************************/
/* Clearscreen() clears the physical screen and puts the cursor	*/
/* in the home position.					*/
/****************************************************************/

static void clearscreen(void)
  {
  _cursesscroll(0,0,LINES-1,COLS-1,0,0x07);
  _cursescursor(0,0);
  _cursvar.cursrow = 0;
  _cursvar.curscol = 0;
  } /* clearscreen */

/****************************************************************/
/* Gotoxy() moves the physical cursor to the desired address on	*/
/* the screen. We don't optimize here - on a PC, it takes more	*/
/* time to optimize than to do things directly.			*/
/****************************************************************/

static void gotoxy(int row, int col)
  {
  if((_cursvar.cursrow == row) && (_cursvar.curscol == col))
    return;
  _cursescursor(row,col);
  _cursvar.cursrow = row;
  _cursvar.curscol = col;
  } /* gotoxy */

/****************************************************************/
/* Putchar() writes a character, with attributes, to the physi-	*/
/* cal screen, but avoids writing to the lower right screen	*/
/* position.							*/
/****************************************************************/

static void Putchar(int ch)
  {
  if ((_cursvar.cursrow < _LINES) || (_cursvar.curscol < _COLS))
    _cursescattr(ch, (ch>>8) & 0xff);
  } /* Putchar */
