{$I-} {$S-} (* Check IO with IOResult; disable stack checking *)
PROGRAM DumpScreen; (* Even works on screens larger than 80x25! *)

PROCEDURE showhelp (CONST problem : BYTE);
(* If any *foreseen* errors arise, we are sent here to
   give a little help and exit (relatively) peacefully *)
CONST
  progdesc = 'DumpScreen - Free DOS utility: ' +
             'Quickly dump the entire screen to a text file.';
  author   = 'v1.10: April 14, 1995. ' +
             '(c) 1995 by David Daniel Anderson - Reign Ware.';
  usage    = 'Usage: DumpS <textfile>';
VAR
  message : STRING [50];
BEGIN
  WriteLn (progdesc);
  WriteLn (author);    WriteLn;
  WriteLn (usage);     WriteLn;
  IF problem > 0 THEN BEGIN
    CASE problem OF
      1 : message := 'Unexpected error opening or closing output file.';
      ELSE  message := 'Unanticipated error of unknown type.';
    END;
    WriteLn (#7, message);
  END;
  Halt (problem)
END;

FUNCTION GetVideoSegment : WORD;
(* From SWAG: By Lou Duchez *)
VAR
  MonoSystem: BOOLEAN;
  VideoMode: BYTE ABSOLUTE $0040:$0049;
BEGIN
  MonoSystem := (VideoMode = 7);
  IF MonoSystem THEN GetVideoSegment := $b000 ELSE GetVideoSegment := $b800;
END;

TYPE
  { "Reads" a character off the video screen. }
  VideoLocation = RECORD              { video memory locations }
                    VideoChar: CHAR;  { character displayed }
                    VideoAttr: BYTE;  { attributes }
                  END;

VAR
  scrncols : BYTE ABSOLUTE $0040:$004a; {from Lou Duchez, found in SWAG}
  scrnrows : BYTE ABSOLUTE $0040:$0084; {from Lou Duchez, found in SWAG}
  MaxX, MaxY : BYTE;
  X, Y : BYTE;

  VideoPtr : ^VideoLocation;
  VideoSegment : WORD;

  dumpfile : TEXT;

BEGIN
  IF ParamCount <> 1 THEN showhelp (0);
  Assign (dumpfile, ParamStr (1) );
  Rewrite (dumpfile); IF IOResult <> 0 THEN showhelp (1);

  MaxX := scrncols;
  MaxY := scrnrows + 1;
  VideoSegment := GetVideoSegment;

  FOR Y := 1 TO MaxY DO BEGIN
    FOR X := 1 TO MaxX DO BEGIN
      VideoPtr := Ptr (VideoSegment, 2 * (MaxX * (Y - 1) + (X - 1) ) );
      Write (dumpfile, VideoPtr^. VideoChar);
    END;
    WriteLn (dumpfile);
  END;
  Close (dumpfile); IF IOResult <> 0 THEN showhelp (1);
  WriteLn ('Screen contents successfully saved in "', ParamStr (1), '".');
END.
