; Unload this and QC2 with INT10MDA /U would be nice - see failed attempt
; Best if good enuf to leave installed
; Make part of BLDP600I renamed to this with /B for new beep ?
; not done: row longer than 80 chars

; Even with CLS at switch to Mode 7/87 - still no CLS at very start of ACAD

;---------------------------------
; Int 10h Monochrome functions for the crappy AMI BIOS on the 7ZX mbd.  11/00
; For AutoCAD R10 to run in dual-screen mode.
; Uninstall after exiting ACAD (reboot or use PMS)
; Releases its Environment to use less RAM; TSR listers won't show its name.
; Put MODE MONO it in your ACAD.BAT, then this, then QC2, then ACAD %1.

; Very tricky to debug, Turbo Debugger won't work -
;  copied this as INT10DGB.ASM and wrote calling funcs to color screen.

;functions included are AH=
;  0	Set Video Mode
;  2	Set Cursor Position (DH, DL = row, column)
;  3	Get Cursor Position
;  6	Scroll Up/Clear Window (full width only)
;  7	Scroll Down/Clear Window (only clear, and full width only)
;  8	Read Character and Attrib
;  9	Display char in AL and attribute in BL (attrib ignored)
; 0Ah	Display char in AL only
; 0Eh	Displ char in AL as TTY (CR, LF, BS, Bel acted on, moves cursor)
; 0Fh	Get Video Mode
; 12h	'Alt Functions' or 'Alt Select' gets EGA info
; 13h	Display String as TTY (ES:BP points to string, DX=cursor position)
; Note Int 21h Func 9 Display String$ uses Int 10h too
; Remember DS and ES can be anything when this runs!

CR		Equ	0Dh
LF		Equ	0Ah
Bel		Equ	7
Bksp		Equ	8

CSEG	segment	byte public
	assume	CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG

	ORG	100h

Start:	
;	Mov	AL,BYTE PTR DS:82h	;char after a space in command line
;	And	AL,0DFh			;strip bit 5, make upper case
;	Cmp	AL,'U'
;	JZ	Uninstall	
;	Mov	AL,BYTE PTR DS:83h	;char after a space and a / or -
;	And	AL,0DFh			;strip bit 5, make upper case
;	Cmp	AL,'U'
;	JZ	Uninstall
	JMP	Install

Uninstall:	;***cannot grab Int 10h, load QC2, then unload this ! ***
;	Mov	DX,INT10hOffset
;	Or	DX,DX			;check that we have been loaded
;	JZ	Exit
;	Mov	AX,Int10hSeg
;	Mov	DS,AX
;	Mov	AX,2510h		;set Int 10h as it was
;	Int	21h
;	Mov	DX,Offset UninstalledMsg
;	Mov	AH,9
;	Int	21h
;	Mov	AX,4C00h		;Exit w/Errorlevel=0
;	Int	21h

;Exit:	Mov	DX,Offset NotInstalledMsg
;	Mov	AH,9
;	Int	21h
;	Mov	AX,4CFEh		;Exit w/Errorlevel=FEh
;	Int	21h	

;NotInstalledMsg	DB	'Int10MDA not installed',cr,lf,'$'
;UninstalledMsg	DB	'Int10MDA uninstalled',cr,lf,'$'

INT10hOffset	DW	0
INT10hSeg	DW	0

Column		DW	0		;actually col X 2
Row		DW	0		;  both start at 0
ShowColumn	DW	0		;display location for funcs that
ShowRow		DW	0		;  do not move cursor
StringFunc	DB	0
MoveCursorFlag	DB	0
CmdCodeFlag	DB	0
ClearTopRow	DW	0
ClearBottomRow	DW	0

NewInt10h:
	Call	CheckMono
	JZ	Try0E		;if in Mono mode
	Jmp	ChkSetMode	;if not in Mono, only check for switch to Mono

Try0E:	CMP	AH,0Eh		;Display char in AL in TTY mode
	JNZ	TryOthers
	Cmp	AL,bel		;Let Bldp600I handle bel
	JNZ	ShowChar0E
	JMP	DWORD PTR CS:INT10hOffset

ShowChar0E:
	Push	DS
	Push	CS		;make sure refs to variables are in our segment
	Pop	DS
	Mov	MoveCursorFlag,1 ;move the Cursor
	Mov	CmdCodeFlag,1	 ;CR, LF, Bksp are commands, not chars
	Push	CX
	Push	DI
	Call	LocateDIatCursor
	Mov	CX,1		;be sure it only does 1 char
	Call	ShowEm
	Pop	DI
	Pop	CX
	Mov	CmdCodeFlag,0
	Mov	MoveCursorFlag,0
	Pop	DS
	IRET

TryOthers:
	Cmp	AH,9		;Display char and attribute
	JZ	Do09and0A

Try0A:	Cmp	AH,0Ah		;Display character only
	JNZ	Try13
Do09and0A:
	Push	DS
	Push	CS
	Pop	DS
	Push	DI
	Call	LocateDIatCursor
	Call	ShowEm
	Pop	DI
	Pop	DS
	IRET

Try13:	Cmp	AH,13h
	JNZ	TryMore
	Jmp	DisplayString

TryMore:Cmp	AH,12h		;'Alt Functions'
	JNZ	Try6
	Jmp	AltFuncs

Try6:	Cmp	AH,6		;Scroll Up or Blank
	JNZ	Try7
	Jmp	ScrollUp

Try7:	Cmp	AH,7		;Scroll Down or Blank (only blanks)
	JNZ	Try2
	Or	AL,AL
	JNZ	Try2
	Mov	CS:Column,0
	Jmp	ClearWindow

Try2:	Cmp	AH,2		;Set Cursor Position
	JNZ	Try3
	Jmp	SetCrsrPos

Try3:	Cmp	AH,3		;Get Cursor Position
	JNZ	Try8
	Jmp	GetCrsrPos

Try8:	Cmp	AH,8		;Read char and attrib at cursor
	JNZ	Try0F
	Jmp	ReadChar

Try0F:	Cmp	AH,0Fh		;get Video Mode - last Func checked for
	JNZ	OldInt
;if we're in Mono mode, say so
	Call	CheckMono
	JNZ	OldInt
	Xor	BX,BX		;page 0
	Mov	AL,7		;Mono mode
	IRET

OldInt:	JMP	DWORD PTR CS:INT10hOffset

CheckMono:
	Push	AX
	Push	ES
	Xor	AX,AX
	Mov	ES,AX
	Mov	AL,ES:[410h]
	And	AL,30h		;bits 4 & 5 indicate Mono
	Cmp	AL,30h
	Pop	ES
	Pop	AX
	Ret			;with Z set if in Mono

;If you don't intercept switch to Mono, damn AMI BIOS puts vertical blank lines
;on entire color screen. Guess ACAD switches to Mono with each text write.
ChkSetMode:
	Or	AH,AH		;set mode
	JNZ	OldInt
	Cmp	AL,87h		;to mode Mono without CLS ?
	JZ	Set400
	Cmp	AL,7		;to mode Mono ? (the AMI BIOS screws up Mono)
	JNZ	OldInt
;Clear the screen
	Push	ES
	Push	DI
	Push	CX
	CLD
	Mov	DI,0B000h	;Mono segment
	Mov	ES,DI
	Xor	DI,DI		;point DI at start of area to clear
	Mov	CX,25*80	;set CX for number of characters
	Mov	AX,0720h	;blank char
	Rep	StosW
	Pop	CX
	Pop	DI
	Pop	ES

;This lets PMS find which screen it should be running on
;reset lo RAM stuff to show Mono (using INT 10h clears the @#^*%!! screen)
Set400:	Push	AX
	Push	ES
	Push	DS
	Push	CX
	Push	SI
	Push	DI
	Xor	AX,AX
	Mov	ES,AX
	Mov	AL,ES:[410h]
	Or	AL,30h		;set bits 4 & 5 to indicate Mono
	Mov	ES:[410h],AL
	push	cs
	pop	ds
	mov	cx,30			;DECIMAL
	mov	si,offset At449
	mov	di,449h
	rep	movsb
	mov	di,484h
	mov	cx,7
	rep	movsb
	Pop	DI
	Pop	SI
	Pop	CX
	Pop	DS
	Pop	ES
	Pop	AX
	IRET

At449	DB	7,50h,0,0,10h,0,0
At450	DB	16 dup(0)		  ;16 DECIMAL
	DB	0Ah,0Fh,0,0B4h,3,29h,30h  ;last is 466h
At484	DB	18h,0Eh,0,68h,9,10h,0Ch


LocateDIatCursor:		;DS must be set to CS - uses memory locations!
	Push	AX
	Push	DX		;Mul uses DX
	Mov	AX,Row
	Mov	ShowRow,AX
	Mov	DI,160
	Mul	DI
	Add	AX,Column	;Column is position X 2
	Mov	DI,AX
	Mov	AX,Column
	Mov	ShowColumn,AX
	Pop	DX
	Pop	AX
	Ret

; Display character in AL CX times at DI as set by above routine except 13h
; Called by Func 13h (DisplayString), w/CX=1 & MoveCursorFlag as needed.
; Funcs 9 and 0Ah do not move cursor, 0Eh does and 13h may.
ShowEm:	Push	ES
	Push	DX
	Push	AX
	Push	CX
	Mov	DX,0B000h	;Mono segment
	Mov	ES,DX
	CLD
NextChar:	;** should check for running off end of screen
	Mov	AH,7		;normal white on black (0Fh is hi-intens)
	Cmp	CmdCodeFlag,1	;These are commands only for 0E and 13.
	JNZ	ShowText
	Cmp	AL,CR
	JZ	CarriageReturn
	Cmp	AL,LF
	JZ	LineFeed
	Cmp	AL,Bksp
	JZ	BackSpace
ShowText:
	StosW
	Add	ShowColumn,2
OneDone:
	Loop	NextChar

	Cmp	MoveCursorFlag,1  ;move cursor for Funcs 0Eh and 13h
	JNZ	ShowDone
	Mov	AX,ShowColumn
	Mov	Column,AX
	Mov	AX,ShowRow
	Mov	Row,AX
ShowDone:
	Pop	CX
	Pop	AX
	Pop	DX
	Pop	ES
	Ret

BackSpace:			;attrib in AH has been set
	Mov	AL,' '
	Dec	DI
	Dec	DI
	StosW
;check for Bksp at start of line
	Cmp	ShowColumn,2
	JNB	SubIt
	Mov	ShowColumn,160
	Dec	ShowRow		;needed for QC2
SubIt:	Sub	ShowColumn,2
	Jmp	Short OneDone

CarriageReturn:
	Mov	ShowColumn,0
	Jmp	Short OneDone

LineFeed:
	Cmp	ShowRow,24
	JB	NoScroll
	Call	Scroll
	Jmp	Short OneDone

NoScroll:
	Inc	ShowRow
	Jmp	Short OneDone

Scroll:	Push	DS
	Push	ES
	Push	DI
	Push	SI
	Push	CX
	Push	DX
	CLD
	Mov	DX,0B000h	;Mono segment
	Mov	ES,DX
	Mov	DS,DX
	Xor	DI,DI
	Mov	SI,160
	Mov	CX,80*24
	Rep	MovsW
	Mov	CX,80
	Mov	AX,0720h	;blank char
	Rep	StosW
	Pop	DX
	Pop	CX
	Pop	SI
	Pop	DI
	Pop	ES
	Pop	DS
	Ret

;Func 13h
; ES:BP points string, CX=count, DX=cursor posn, BH=page (not used)
; AL=0 => BL=attrib, no move
; AL=1 => BL=attrib, yes move cursor
; AL=2 => string is char-attrib, no move
; AL=3 => string is char-attrib, yes move cursor
; CR, LF, Bksp, bel are commands
DisplayString:
	Push	AX
	Push	BX
	Push	CX
	Push	DX
	Push	SI
	Push	DI
	Push	ES
	Push	DS
	Mov	StringFunc,AL	;save sub-function
	Push	AX		;use AX for calc's
	And	AL,00000001b	;get bit 0
	Mov	MoveCursorFlag,AL
	Mov	CmdCodeFlag,1
	Xor	AX,AX
	Mov	AL,DH		;AX=row
	Mov	Row,AX
	Mov	ShowRow,AX
	Mov	DI,160
	Mul	DI
	Xor	BX,BX
	Mov	BL,DL		;BX=column
	Add	BX,BX		;translate to our double columns
	Mov	Column,BX
	Mov	ShowColumn,BX
	Pop	AX
	Push	ES
	Pop	DS
	Mov	SI,BP		;now DS points string seg, so
	Cmp	CX,2000		; we must use CS: prefix on data locations
	JBE	StringLoop
	Mov	CX,2000
StringLoop:
	Lodsb
	Test	CS:StringFunc,00000010b	;char-attrib pairs ?
	JZ	SetForNext
	Inc	SI
SetForNext:
	Push	AX
	Mov	AX,CS:ShowRow
	Mov	DI,160
	Mul	DI
	Add	AX,CS:ShowColumn	;position X 2
	Mov	DI,AX
	Pop	AX
	Push	CX
	Mov	CX,1
	Call	ShowEm
	Pop	CX
	Loop	StringLoop

	Mov	CS:MoveCursorFlag,0
	Mov	CS:CmdCodeFlag,0
	Pop	DS
	Pop	ES
	Pop	DI
	Pop	SI
	Pop	DX
	Pop	CX
	Pop	BX
	Pop	AX
	IRET


AltFuncs:
	Call	CheckMono	;pass request on if not in Mono mode
	JZ	ShowAltInfo
	JMP	DWORD PTR CS:INT10hOffset

ShowAltInfo:
	Cmp	BL,10h		;get EGA info
	JNZ	NotDone
	Mov	BX,0110h	;return BL=10h for EGA not present
	Xor	CX,CX		;and BH=1 for mono
	IRET

NotDone:Xor	AL,AL		;signal not implimented
	IRET


SetCrsrPos:
	Push	DS
	Push	CS
	Pop	DS
	Push	AX
	Xor	AH,AH
	Mov	AL,DH
	Mov	Row,AX
	Mov	AL,DL
	Add	AX,AX
	Mov	Column,AX
	Pop	AX
	Pop	DS
	IRET


GetCrsrPos:
	Push	DS
	Push	CS
	Pop	DS
	Mov	DX,Row
	XCHG	DH,DL
	Mov	BX,Column
	Shr	BX,1
	Mov	DL,BL
	Pop	DS
	IRET


ReadChar:
	Push	DS
	Push	CS
	Pop	DS
	Push	DI
	Push	ES
	Mov	AX,0B000h
	Mov	ES,AX
	Mov	AX,Row
	Mov	DI,160
	Mul	DI
	Add	AX,Column	;Column is position X 2
	Mov	DI,AX
	Mov	AL,ES:[DI]
	Pop	ES
	Pop	DI
	Pop	DS
	IRET			;with char in AL


;Func 06, scroll up AL=lines to scroll or 0 to scroll & blank per CX & DX
;Abbreviated, it only scrolls full screen width
ScrollUp:
	Mov	CS:Column,0
	Or	AL,AL
	JZ	ClearWindow
	Push	CX
	Push	AX
	Xor	CX,CX
	Mov	CL,AL		;now CX=lines to scroll
ScrollLoop:
	Call	Scroll
	Loop	ScrollLoop

	Pop	AX
	Pop	CX
	IRET

;also used for Func 07, Scroll Down or Clear
ClearWindow:			;CH=upper DH=lower row
	Push	ES
	Push	DI
	Push	CX
	Push	DX
	Push	AX
	Mov	AL,CH
	Xor	AH,AH
	Mov	ClearTopRow,AX
	Mov	AL,DH
	Mov	ClearBottomRow,AX
	Mov	DX,0B000h	;Mono segment
	Mov	ES,DX
;point DI at start of area to clear
	Mov	AX,ClearTopRow
	Mov	CX,160		;160 bytes/line
	Mul	CX
	Mov	DI,AX		;point to 1st location to clear
;set CX for number of characters
	Mov	AX,ClearBottomRow
	Mov	CX,ClearTopRow
	Sub	AX,CX
	Inc	AX		;total lines is bottom - top + 1
	Mov	CX,80		;but only 80 chars/line
	Mul	CX		;lines X 80 chars
	Mov	CX,AX
	Mov	AX,0720h	;blank char
	CLD
	Rep	StosW
	Pop	AX
	Pop	DX
	Pop	CX
	Pop	DI
	Pop	ES
	IRET

;
Install:
	Mov	AH,93h
	Xor	AL,AL
	Int	2Fh		;INT 2Fh used to check if installed
	Cmp	AX,'QC'		;Crude fix: If QC2 installed, so are we
	JNZ	NotInstalledYet
	Mov	DX,OFFSET AlreadyInstalledMsg
	Mov	AH,9
	Int	21h
	Mov	AX,4CFFh	;exit w/Errorlevel=FFh
	Int	21h

AlreadyInstalledMsg DB	cr,lf,' INT10MDA is already resident.',cr,lf,'$'

NotInstalledYet:
	Push	ES
	Mov	AX,3510h		;get Int 10h vector
	Int	21h
	Mov	Int10hOffset,BX
	Mov	Int10hSeg,ES
	Mov	AX,2510h	
	Mov	DX,Offset NewInt10h
	Push	CS
	Pop	DS
	Int	21h
;De-allocate the Environment Block, we don't need it.
; This sometimes leaves a uselessly small unused Block
	Xor	ax,ax
	Xchg	ax,word ptr CS:2Ch	;Environment Block addr in the PSP
	Or	ax,ax
	JZ	GoRes			;skip it if there is no Env
	Mov	es,ax
	Mov	ah,49h			;free allocated RAM
	Int	21h
GoRes:	Mov	DX,OFFSET InstMsg	;show our banner (on the Mono screen)
	Mov	AH,9
	Int	21h
	Pop	ES
;go resident
	mov	dx,offset Install	;bytes to stay resident
	add	dx,15			;allow for fractional para
	mov	cl,4
	shr	dx,cl			;paras to stay resident
	mov	ax,3100h		;go TSR
	int	21h

InstMsg	DB	cr,lf,'Int 10h for MDA card installed$'

CSEG	ends
	END	Start
