_TEXT   SEGMENT WORD PUBLIC 'CODE'
_TEXT   ENDS

_DATA SEGMENT WORD PUBLIC 'DATA'

_DATA   ENDS

CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS

_BSS    SEGMENT WORD PUBLIC 'BSS'
;GLOBAL UNINITIATED DATA GOES HERE
_BSS    ENDS

DGROUP  GROUP CONST,_BSS,_DATA
;
	ASSUME DS:DGROUP,SS:DGROUP

;EXTRN EXTERNAL SUBROUTINE CALLS GO HERE
;
;
; _snddev FAR Procedure for C Written by John A. Ball  December 5, 1996
;
; Copyright (c) 1996 John A. Ball
;
; You may copy and modify for your own use only!
; Please notify me of any errors or suggested enhancements.
;
; Plays back sound on the Sound Blaster DSP
;
;     int error snddev(int message,void *data);
;
;     error=snddev(message,&sound_info);
;
;       message is command to sound driver
;       *data is pointer to information structure
;       error=0 ok
;       error 1=DMA in use
;       error 2=IRQ/DMA not Found
;       error 3=DSP not responding
;       error 4=No DSP version
;       error 5=DMA channel not correct
;       error 6=IRQ in environment not correct
;       error 7=IRQ not valid for Sound Blaster
;       error 8=Number of samples is zero
;       error 9=Unknown Command
;       error -1=Sound Halted
;
_TEXT   SEGMENT
	ASSUME CS:_TEXT
	PUBLIC _snddev,_sbdelay,_io_wait,_sb_info,_sound_info,_status_info

_snddev PROC FAR

PARMA           EQU [BP+6]      ;Command
PARMB           EQU [BP+8]      ;Pointer to data/information structure

	PUSH BP                 ;Save stack Frame
	MOV BP,SP
	PUSHF
	PUSH DS                 ;Save registers
	PUSH ES
	PUSH DI

	MOV AX,DGROUP           ;Set DS = our data segment
	MOV DS,AX

	JMP OVERDATA
CARD_INFO       LABEL   WORD
CARD_INFO_ADDR          DD 0    ;Pointer to external CARD_INFO structure
_sb_info      LABEL   WORD    ;EXTERN label for debugging
DRV_VER                 DW 100H ;Driver version number
SB_TYPE                 DW 20   ;Sound Blaster board type
SB_VER                  DW 0    ;Sound Blaster DSP Version
SB_IO_ADDR              DW 0    ;Sound Blaster I/O Address
SB_IRQ                  DW -1   ;Sound Blaster IRQ (default 5)
SB_DMA                  DW 1    ;Sound Blaster 8BIT DMA Channel (default 1)
MODE                    DW 0    ;Type of data format
IRQ16                   DW -1   ;IRQ for 16bit mode
DMA16                   DW 5    ;DMA channel for 16 bit mode (default 5)
DMA_BUF         LABEL   WORD
DMA_BUF_ADDR            DD 0    ;Pointer to DMA buffer
DMA_LEN                 DW 0    ;Length of DMA buffer
VALID_MARKER1           DW 055AAH
;
SOUND_INFO      LABEL   WORD
SOUND_INFO_ADDR         DD 0    ;Pointer to external SOUND structure
_sound_info     LABEL   WORD    ;EXTERN Label for debugging
BUFFER LABEL            WORD
BUFFER_ADDR             DD 0    ;Pointer to Sound Data
SAMPLES                 DW 0    ;Number of bytes to play
NUM_BYTES               DD 0    ;Length of sound block
NUMBER                  DD 0    ;Number of samples
FREQ            LABEL   WORD
FREQUENCY               DD 0    ;Frequency of playback
VOLUME                  DW 7    ;Play back volume
BITS                    DW 8    ;Bits per channel and sign
CHANNELS                DW 1    ;Number of channels
COMPRESSION             DW 0    ;Type of Hardware Compression
BYTE_FORMAT             DW 0    ;Intel/Motorola byte format
PCALLBACK       LABEL   WORD
PCALLBACK_ADDR          DD 0    ;Pointer to Call Back Routine
VALID_MARKER2           DW 055AAH
;
SND_STATUS      LABEL   WORD
SND_STATUS_ADDR         DD 0    ;Pointer to external SND_STATUS structure
_status_info    LABEL   WORD    ;EXTERN Label for debugging
DMA_FLAG        LABEL   WORD
DMA_FLAG_ADDR           DD 0    ;Pointer to DMA Flag
DMAFLAG                 DW 0    ;Flag to indicate DMA for DAC in use
DMA_COUNT               DW 0    ;Remaining count for DMA
FBUFFER         LABEL   WORD
FBUFFER_ADDR            DD 0    ;Pointer to next free buffer
BUFSIZE                 DW 0    ;Length of buffer
ERROR_STAT      LABEL   WORD
ERROR_STAT_ADDR         DD 0    ;Pointer to Error status
ERROR                   DW 0    ;Sound Blaster Hardware Error
VALID_MARKER3           DW 055AAH
;
PBUFFER LABEL           WORD
PBUFFER_ADDR            DD 0    ;Temporary Pointer
TIME_CONST              DW 0    ;DSP Time constant
TEMP                    DW 0    ;Temporary Storage
OLD_INTERRUPT   LABEL   WORD
OLD_INTERRUPT_ADDR      DD 0    ;Location of previous IRQ 5 System Interrupt
SAVEPIC                 DB 0    ;Contents of PIC 1
SAVEPIC2                DB 0    ;Contents of PIC 2
DMA_MODE                DB 014H ;DSP DMA mode
DSP_SPEED               DB 0    ;Indicates whether highspeed dma is required
SB_TEST                 DB 0    ;Indicates whether SB has been tested
IRQ                     DW 0    ;IRQ from environment
COMMAND                 DW 0    ;Sound driver command
IN_DV                   DW 0    ;In DESQview Flag
STEREO                  DW 0    ;8 Bit Stereo 
PRE_MODE                DW -1   ;Previous mono/stereo mode
OUT_FILTER              DW 0    ;Previous output filter status
REF_BYTE                DW 0    ;Flag to indicate reference byte sent
SB16_MODE               DW 0    ;Flag to indicate 16 bit mode
TESTBUFFER              DB 1 DUP(080H)
OLD_ISR2 LABEL          WORD
OLD_ISR2_ADDR           DD 0
OLD_ISR3 LABEL          WORD
OLD_ISR3_ADDR           DD 0
OLD_ISR5 LABEL          WORD
OLD_ISR5_ADDR           DD 0
OLD_ISR7 LABEL          WORD
OLD_ISR7_ADDR           DD 0
OLD_ISR10 LABEL         WORD
OLD_ISR10_ADDR          DD 0
DATA_INFO LABEL         WORD
DATA_INFO_ADDR          DD 0
DSP_DMA_MODE            DB 014H, 074H, 076H, 016H, 0C0H, 0C0H, 0B0H, 0B0H
DMA_PAGE                DB 087H, 083H, 081H, 082H, -1, 08BH, 089H, 08AH

OVERDATA:
	MOV AX,0                ;Reset error
	MOV CS:ERROR,AX
	MOV AX,PARMA            ;Get sound driver command and save it
	MOV CS:COMMAND,AX
	LES DI,PARMB            ;Get sound info pointer
	MOV CS:PBUFFER,DI       ;and save
	MOV AX,ES
	MOV CS:PBUFFER[2],AX

	MOV AX,CS:COMMAND       ;Get command and process it
	CMP AX,01H              ;Open?
	JNE CC0
	CALL OPEN
	JMP EXIT2
CC0:    CMP AX,02H              ;Play?
	JNE CC1
	CALL PLAY
	JMP EXIT2
CC1:    CMP AX,03H              ;Close?
	JNE CC2
	CALL CLOSE
	JMP EXIT2
CC2:    CMP AX,04H              ;Stop?
	JNE CC3
	CALL STOP_DMA
	JMP EXIT2
CC3:    CMP AX,05H              ;Pause?
	JNE CC4
	CALL PAUSE_DMA
	JMP EXIT2
CC4:    CMP AX,06H              ;Resume?
	JNE CC5
	CALL RESUME_DMA
	JMP EXIT2
CC5:    CMP AX,07H              ;Get status?
	JNE CC6
	CALL GET_STATUS
	JMP EXIT2
CC6:    CMP AX,08H              ;Get resource info
	JNE CC7
	CALL GET_RESOURCES
	JMP EXIT2
CC7:    CMP AX,09H              ;Play Continuous?
	JNE CC8
	CALL PLAYC
	JMP EXIT2
CC8:    CMP AX,0AH              ;Set volume
	JNE CC9
	CALL SET_VOLUME
	JMP EXIT2
CC9:
	MOV CS:ERROR,9          ;Unknown command error
	JMP EXIT2

EXIT2:  MOV AX,CS:ERROR         ;Get error if any
	POP DI                  ;Restore registers
	POP ES
	POP DS
	POPF
	POP BP                  ;RESTORE BP
	RET                     ;RETURN FAR

HANDLER:                        ;Interrupt for SB IRQ comes here!
	PUSHF
	PUSH AX
	PUSH BX
	PUSH CX
	PUSH DX
	PUSH DS
	PUSH ES
	sti                     ;enable interrupts or computer will crash
	mov ax,01234h
	CMP CS:SB16_MODE,0      ;Check for 8 or 16bit mode
	JE ACK8
	CALL ACK_16B
	JMP ACK
ACK8:   CALL sbdsprt
ACK:    CMP CS:SB_IRQ,10
	JE ACKIRQ10
	MOV AL,020H
	OUT 020H,AL
	JMP DONE_ACK
ACKIRQ10:
	MOV AL,020H
	OUT 020H,AL
	OUT 0A0H,AL
DONE_ACK:
	CMP CS:SAMPLES,0        ;Anymore samples?
	JE L13
	INC CS:BUFFER[2]        ;Increment to next page
	MOV CS:BUFFER,0000      ;and set offset to zero
	CALL START_DMA
	JMP EXIT1
L13:    DEC CS:DMAFLAG          ;Indicate it is

EXIT1:  POP ES
	POP DS
	POP DX
	POP CX
	POP BX
	POP AX
	POPF
	IRET

_snddev  ENDP

sbdspwt PROC NEAR

;Write to DSP with timeout

	PUSH CX
	MOV CX,200H
	MOV AH,AL
L1:     IN AL,DX
	JMP $+2
	OR AL,AL
	JNS L2
	LOOP L1
	STC
	JMP L3
L2:     MOV AL,AH
	OUT DX,AL
	CLC
L3:     POP CX
	RET

sbdspwt  ENDP


sbdspr PROC NEAR

;Read DSP

	PUSH DX
	MOV DX,CS:SB_IO_ADDR
	ADD DL,0EH
	SUB AL,AL
L7:     IN AL,DX
	JMP $+2
	OR AL,AL
	JNS L7
	SUB DL,04H
	IN AL,DX
	POP DX
	RET

sbdspr ENDP

sbdsprt PROC NEAR

;Read DSP with timeout

	PUSH CX
	PUSH DX
	MOV DX,CS:SB_IO_ADDR
	ADD DL,0EH
	MOV CX,0200H
L4:     IN AL,DX
	JMP $+2
	OR AL,AL
	JS L5
	LOOP L4
	STC
	JMP L6
L5:     SUB DL,04H
	IN AL,DX
	CLC
L6:     POP DX
	POP CX
	RET

sbdsprt ENDP

;Write to DSP

sbdspw PROC NEAR

	PUSH CX
	PUSH BX
	MOV AH,AL
	MOV BX,10
	MOV CX,0ffffH           ;After timeout send value anyway
	CLC
L8:     IN AL,DX
	JMP $+2
	JMP $+2
	OR AL,AL
	JNS L8E
	LOOP L8
	DEC BX
	OR BX,BX
	JNZ L8
	STC                     ;Set Carry to indicate timeout
L8E:    MOV AL,AH
	OUT DX,AL
	POP BX
	POP CX
	RET

sbdspw ENDP

;Convert FAR pointer to 64k pages and offset

PNT_TO_DMA PROC NEAR

	PUSH CX
	MOV CL,4
	ROL DX,CL
	MOV CX,DX
	AND DX,0FH
	AND CX,0FFF0H
	ADD AX,CX
	ADC DX,0
	POP CX
	RET

PNT_TO_DMA ENDP

INSTALL_ISR PROC NEAR

	pushf
	push ds
	push es
	CLI
	MOV AX,CS:SB_IRQ
	CMP AX,02
	JE INSTALL
	CMP AX,03
	JE INSTALL
	CMP AX,05
	JE INSTALL
	CMP AX,07
	JE INSTALL
	CMP AX,10
	JE INSTALL
	MOV CS:ERROR,7
	MOV AX,5                ;Use default if error
INSTALL:
	CALL IRQ_VECT
	MOV AH,035H             ;GET INTERRUPT for IRQ 5 AND SAVE IT
	INT 21H
	CLI
	MOV CS:OLD_INTERRUPT,BX
	MOV CS:OLD_INTERRUPT[2],ES
	MOV AX,CS
	MOV DS,AX
	MOV AX,CS:SB_IRQ
	CALL IRQ_VECT
	MOV AH,025H             ;AND SET NEW INTERRUPT IRQ 5
	LEA DX,HANDLER
	INT 21H
	pop es
	pop ds
	popf

	MOV AX,CS:SB_IRQ        ;IRQ 5
	AND AL,08H
	JZ L11
	IN AL,021H              ;ENABLE IRQ from PIC
	MOV CS:SAVEPIC,AL
	AND AL,0FBH
	OUT 021H,AL
	MOV DX,00A1H
	JMP L12
L11:    MOV DX,021H
L12:    MOV CX,CS:SB_IRQ        ;Sound Blaster IRQ
	AND CL,07H
	MOV AH,01
	SHL AH,CL
	NOT AH
	IN AL,DX
	MOV CS:SAVEPIC2,AL
	AND AL,AH
	OUT DX,AL
	RET

INSTALL_ISR ENDP

RESTORE_ISR PROC NEAR
;
;Restore IRQ and PICs before exiting
;
	PUSH AX
	MOV AX,0
	MOV CS:DMAFLAG,AX       ;Indicate DMA done
	LDS DX,CS:OLD_INTERRUPT_ADDR
	MOV AX,CS:SB_IRQ
	CALL IRQ_VECT
	CLI
	MOV AH,025H             ;Restore old IRQ 5
	INT 21h
	CLI
	MOV AX,CS:SB_IRQ        ;Restore PICs
	AND AL,08
	JZ L31
	MOV AL,CS:SAVEPIC
	OUT 021H,AL
	MOV DX,00A1H
	JMP L32
L31:    MOV DX,0021H
L32:    MOV AL,CS:SAVEPIC2
	OUT DX,AL
	POP AX
	RET

RESTORE_ISR ENDP

_io_wait PROC FAR
;
; Gives up time slice if time and stops dma if ESC key hit
;
IOWAIT1:
	MOV CX,0FFFFH
	CMP CS:DMAFLAG,0        ;Is DMAFLAG for DAC still in Use?
	JG SEEKEY
	JMP DMA_DONE            ;Wait until done
SEEKEY: MOV AH,01H              ;See if key pressed
	INT 16H
	JZ GET_DMA
KEY_PRESS:
	MOV AX,0
	INT 16H                 ;Get the pressed key
	CMP AL,1BH              ;See if ESC key hit?
	JNE GET_DMA
	CALL DSP_RESET
	MOV CS:DMAFLAG,0        ;Reset DMAFLAG to show done
	MOV AX,-1               ;and indicate sound halted
	JMP EXIT_IO
GET_DMA:
	MOV AL,CS:DMA_MODE      ;DSP DMA mode for 8-bit DAC
	CMP AL,0C0H             ;8 BIT DMA?
	JE I8DMA
	CMP AL,0B0H             ;16 BIT DMA?
	JE I16DMA
I8DMA:
	MOV AX,CS:SB_DMA        ;Determine DMA count register
	SHL AX,1
	ADD AX,1
	MOV DX,AX
	jmp getdmac
I16DMA:
	mov ax,cs:dma16
	sub ax,4
	shl ax,1
	shl ax,1
	add ax,0c2h
	mov dx,ax
getdmac:
	IN AL,DX                ;Get DMA countdown
	MOV AH,AL
	IN AL,DX
	XCHG AL,AH
	CMP AX,8000             ;If greater than 8000 bytes to go
	JG GIVE_CPU             ;then give up some cpu time
	CMP AX,-1               ;See if DMA is done
	JE I_D_ERR
	JMP WAIT_HERE
I_D_ERR:
	IN AL,DX                ;Get DMA countdown again
	MOV AH,AL
	IN AL,DX
	XCHG AL,AH
	CMP CS:DMAFLAG,0        ;Is DMAFLAG for DAC still in Use?
	JLE DMA_DONE            ;Exit if done
	CMP AX,-1               ;See if DMA is done
	JNE WAIT_HERE
	CALL DSP_RESET
	MOV CS:DMAFLAG,0        ;Reset DMAFLAG to show done
	MOV AX,-1               ;IRQ/DMA ERROR
	JMP EXIT_IO
WAIT_HERE:
	CMP CS:DMAFLAG,0        ;Is DMAFLAG for DAC still in Use?
	JE DMA_DONE             ;Wait until done
	DEC CX
	JZ GET_DMA
	JMP WAIT_HERE
GIVE_CPU:
	CMP CS:DMAFLAG,0        ;Is DMAFLAG for DAC still in Use?
	JE DMA_DONE             ;Wait until done
	CALL GIVE_SLICE
	JMP IOWAIT1
DMA_DONE:
	MOV AX,0                ;OK
EXIT_IO:
	RET

_io_wait ENDP

; Start DMA transfer

START_DMA PROC NEAR

	MOV AL,CS:DMA_MODE      ;DSP DMA mode for 8-bit DAC
	CMP AL,0C0H             ;8 BIT DMA?
	JE SB_8DMA
	CMP AL,0B0H             ;16 BIT DMA?
	JE SB_16DMA
SB_8DMA:
	JMP ST_8DMA            ;Setup 8 bit DMA Transfer
SB_16DMA:
	MOV AX,CS:DMA16         ;See if DMA channel is 16 or 8 bit?
	AND AX,07H              ;Limit DMA channels to (0-7)
	CMP AL,03
	JLE SB_8DMA
	CMP AL,04               ;DMA channel 4 is invalid
	JG SB_16DMA1
	JMP L20                 ;Exit
SB_16DMA1:
	JMP ST_16DMA           ;Set up 16 bit DMA transfer

PROG_DSP:
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0CH
	CMP CS:SB_VER,0400H     ;Check DSP version
	JL CK_SP
	JMP L21
CK_SP:  CMP CS:DSP_SPEED,01     ;Check for high speed mode
	JNZ L21
	MOV AL,048H
	CALL sbdspw
	JNC A11
	MOV CS:ERROR,3          ;DSP not responding
	JMP L20
A11:
	POP AX                  ;Get number of samples & send to DSP
	MOV BX,AX
	CALL sbdspw
	JNC A12
	MOV CS:ERROR,3          ;DSP not responding
	JMP L20
A12:
	MOV AL,BH
	CALL sbdspw
	JNC A13
	MOV CS:ERROR,3          ;DSP not responding
	JMP L20
A13:
	MOV AL,091H             ;High Speed DMA mode
	CALL SBDSPW
	JNC A14
	MOV CS:ERROR,3          ;DSP not responding
	JMP L20
A14:
	JMP L20
L21:
	MOV AL,CS:DMA_MODE      ;DSP DMA mode for 8-bit DAC
	CMP AL,0C0H             ;8 BIT sb16?
	JE SB16_8
	CMP AL,0B0H             ;16 BIT sb16?
	JE SB16_16
	JMP SBP
SB16_8: CALL sbdspw
	MOV CS:SB16_MODE,0      ;Indicate 8 bit mode
	MOV AL,00H
	CMP CS:STEREO,2
	JNE SB16_8T
	MOV AL,020H
SB16_8T:
	CMP CS:BITS,-8
	JG SBP
	OR AL,010H
	JMP SBP
SB16_16:
	CALL sbdspw
	MOV CS:SB16_MODE,1      ;Indicate 16 bit mode
	MOV AL,010H
	CMP CS:STEREO,2
	JNE SB16_16T
	MOV AL,030H
SB16_16T:
	CMP CS:BITS,-16
	JG SBP
	OR AL,010H
	JMP SBP
SBP:    CALL sbdspw
	JNC A15
	MOV CS:ERROR,3          ;DSP not responding
	JMP L20
A15:
	POP AX                  ;Get number of samples & send to DSP
	CMP CS:SB16_MODE,0      ;16 Bit mode?
	JZ A1511
	push dx
	INC AX                  ;Convert to # 16bit samples-1
	MOV BX,2
	MOV DX,0
	DIV BX
	DEC AX
	pop dx
A1511:  MOV BX,AX
	CALL sbdspw
	JNC A16
	MOV CS:ERROR,3          ;DSP not responding
	JMP L20
A16:
	MOV AL,BH
	CALL sbdspw
	JNC L20
	MOV CS:ERROR,3          ;DSP not responding
L20:
	RET

; Setup for 8 bit DMA transfer

ST_8DMA:
	MOV AX,CS:SB_DMA
	AND AX,03H              ;Limit DMA channels to (0-3) 8-BIT
	MOV CS:SB_DMA,AX
	MOV AX,CS:SB_DMA
	ADD AL,04
	OUT 0AH,AL              ;Set mask bit for DMA channel (default 1)
	JMP $+2
	MOV AL,0FFH
	OUT 0CH,AL              ;Clear byte pointer flip/flop
	JMP $+2
	MOV AL,048H             ;Write mode
	ADD AX,CS:SB_DMA        ;plus DMA channel
	OUT 0BH,AL              ;Single mode select read channel 1
	JMP $+2
	MOV BX,CS:SB_DMA        ;Get DMA Page Register
	MOV DX,0
	MOV DL,CS:DMA_PAGE[BX]
	MOV AX,CS:BUFFER[2]
	OUT DX,AL               ;Set DMA page register
	JMP $+2
	MOV BX,CS:BUFFER
	MOV DX,CS:SB_DMA        ;Determine memory address register
	SHL DX,1
	MOV AL,BL
	OUT DX,AL               ;Set base and current address
	JMP $+2
	MOV AL,BH
	OUT DX,AL
	JMP $+2
	XOR BX,-1               ;(65536-bx) = #bytes that can be transfered
	MOV AX,CS:SAMPLES       ;Get # of samples & subtract 1
	DEC AX                  ; # SAMPLES - 1
	CMP AX,BX               ;# SAMPLES > # that can be DMA?
	JBE L10
	MOV AX,BX               ;If yes, use # that can be DMA
L10:
	CLI
	PUSH AX
	INC DX
	OUT DX,AL               ;Base & current word count
	JMP $+2
	MOV AL,AH
	OUT DX,AL
	JMP $+2
	POP AX
	STI
	PUSH AX                 ;Save number of samples to play
	INC AX                  ;restore count
	SUB CS:SAMPLES,AX       ;Subtract # that can be DMA
	MOV AX,CS:SB_DMA
	OUT 0AH,AL              ;Clear channel 1 mask bit to start DMA
	JMP PROG_DSP            ;and then set up DSP

; Setup for 16 bit DMA transfer

ST_16DMA:
	MOV AX,CS:DMA16
	AND AX,07H
	OR AX,04H
	OUT 0D4H,AL             ;Set mask port for DMA channel
	JMP $+2
	MOV AL,0FFH
	OUT 0D8H,AL             ;Clear byte pointer flip/flop
	JMP $+2
	MOV AX,CS:DMA16         ;Get DMA channel
	AND AX,03H
	ADD AX,048H             ;Write mode
	OUT 0D6H,AL             ;Single mode select read channel 1
	JMP $+2
	MOV BX,CS:DMA16         ;Get DMA Page Register
	MOV DX,0
	MOV DL,CS:DMA_PAGE[BX]
	MOV AX,CS:BUFFER[2]
	PUSH CX
	MOV CX,AX
	TEST AX,01              ;See if page register is odd?
	JZ D16_OK
	DEC AX                  ;If is is then decrement page and
D16_OK:
	OUT DX,AL               ;Set DMA page register
	JMP $+2
	MOV BX,CS:BUFFER
	MOV DX,CS:DMA16         ;Determine memory address register
	AND DX,03H
	SHL DX,1
	SHL DX,1
	ADD DX,0C0H
	SHR BX,1                ;Divide pointer by 2 for 16 bit dma channel
	TEST CX,01              ;See if page register is odd?
	JZ D16_OK1
	ADD BX,08000H           ;If it is increase offset
d16_ok1:
	POP CX
	MOV AL,BL
	OUT DX,AL               ;Set base and current address
	JMP $+2
	MOV AL,BH
	OUT DX,AL
	JMP $+2
	XOR BX,-1               ;(65536-bx) = #bytes that can be transfered
	MOV AX,CS:SAMPLES       ;Get # of samples & subtract 1
	DEC AX                  ; # SAMPLES - 1
	CMP AX,BX               ;# SAMPLES > # that can be DMA?
	JBE AL10
	MOV AX,BX               ;If yes, use # that can be DMA
AL10:
	CLI
	PUSH AX
	INC DX
	INC DX
	inc ax
	shr ax,1
	dec ax
	OUT DX,AL               ;Base & current word count
	JMP $+2
	MOV AL,AH
	OUT DX,AL
	JMP $+2
	POP AX
	STI
	PUSH AX                 ;Save number of samples to play
	INC AX                  ;restore count
	SUB CS:SAMPLES,AX       ;Subtract # that can be DMA
	MOV AX,CS:DMA16
	AND AX,03H
	OUT 0D4H,AL             ;Clear channel 1 mask bit to start DMA
	JMP PROG_DSP            ;and then set up DSP
START_DMA ENDP

; Calculate interrupt vector for Sound Blaster IRQ (5)

IRQ_VECT PROC NEAR

	PUSH BX
	MOV BL,AL
	AND BL,08
	JZ L14
	AND AL,07
	ADD AL,070H
	JMP L15
L14:    ADD AL,08
L15:    CBW
	POP BX
	RET

IRQ_VECT ENDP

SBFINDIRQ PROC NEAR

; Install ISRs for possible Sound Blaster IRQs

	PUSHF
	PUSH DX
	PUSH CX

	MOV AX,CS
	MOV DS,AX
	MOV ES,AX

	MOV AL,02               ;IRQ 2
	CALL IRQ_VECT           ;Get IRQ ISR address
	PUSH AX
	MOV AH,035H             ;Get old ISR address and save
	INT 21H
	MOV CS:OLD_ISR2,BX
	MOV CS:OLD_ISR2[2],ES

	MOV AX,CS
	MOV DS,AX
	MOV ES,AX
	POP AX
	CLI
	MOV AH,025H             ;AND SET NEW INTERRUPT IRQ 2
	LEA DX,HANDLER2
	INT 21H

	MOV AL,03               ;IRQ 3
	CALL IRQ_VECT
	PUSH AX
	MOV AH,035H             ;Get old ISR address and save
	INT 21H
	MOV CS:OLD_ISR3,BX
	MOV CS:OLD_ISR3[2],ES

	MOV AX,CS
	MOV DS,AX
	MOV ES,AX
	POP AX
	CLI
	MOV AH,025H             ;AND SET NEW INTERRUPT IRQ 3
	LEA DX,HANDLER3
	INT 21H

	MOV AL,05               ;IRQ 5
	CALL IRQ_VECT
	PUSH AX
	MOV AH,035H             ;Get old ISR address and save
	INT 21H
	MOV CS:OLD_ISR5,BX
	MOV CS:OLD_ISR5[2],ES

	MOV AX,CS
	MOV DS,AX
	MOV ES,AX
	POP AX
	CLI
	MOV AH,025H             ;AND SET NEW INTERRUPT IRQ 5
	LEA DX,HANDLER5
	INT 21H

	MOV AL,07               ;IRQ 7
	CALL IRQ_VECT
	PUSH AX
	MOV AH,035H             ;Get old ISR address and save
	INT 21H
	MOV CS:OLD_ISR7,BX
	MOV CS:OLD_ISR7[2],ES

	MOV AX,CS
	MOV DS,AX
	MOV ES,AX
	POP AX
	CLI
	MOV AH,025H             ;AND SET NEW INTERRUPT IRQ 7
	LEA DX,HANDLER7
	INT 21H

	MOV AL,10               ;IRQ 10
	CALL IRQ_VECT
	PUSH AX
	MOV AH,035H             ;Get old ISR address and save
	INT 21H
	MOV CS:OLD_ISR10,BX
	MOV CS:OLD_ISR10[2],ES

	MOV AX,CS
	MOV DS,AX
	MOV ES,AX
	POP AX
	CLI
	MOV AH,025H             ;AND SET NEW INTERRUPT IRQ 10
	LEA DX,HANDLER10
	INT 21H
	IN AL,021H              ;ENABLE IRQS from PIC1
	MOV CS:SAVEPIC,AL
	AND AL,053H
	OUT 021H,AL
	IN AL,0A1H              ;ENABLE IRQS from PIC2
	MOV CS:SAVEPIC2,AL
	AND AL,0FBH
	OUT 0A1H,AL

	MOV CS:SB_IRQ,0         ;Set IRQ to 0 and see if it changes
	CALL TEST_DMA           ;Start short DMA and see if it works
	CMP CS:ERROR,0
	JNE FOUNDIRQ

	MOV CX,0ffffh
IRQWAIT:
	CALL GIVE_SLICE
	MOV AX,CS:SB_IRQ        ;Wait for interrupt to occur
	CMP AX,02               ;with Time-Out
	JE FOUNDIRQ
	CMP AX,03
	JE FOUNDIRQ
	CMP AX,05
	JE FOUNDIRQ
	CMP AX,07
	JE FOUNDIRQ
	CMP AX,10
	JE FOUNDIRQ
	LOOP IRQWAIT

	IN AL,08H               ;Read DMA status register
	JMP $+2
	IN AL,08H               ;and again
	CMP AL,0                ;Is status all clear?
	JE IRQERR               ;If 0 then IRQ error
	MOV CS:ERROR,5          ;DMA error
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0CH
	MOV AL,080H
	OUT DX,AL               ;Send 1 byte to fix DSP
	MOV CX,0ffffh           ;Wait for interrupt
IRQWAIT1:
	CALL GIVE_SLICE
	MOV AX,CS:SB_IRQ        ;Wait for interrupt to occur
	CMP AX,02               ;with Time-Out
	JE FOUNDIRQ
	CMP AX,03
	JE FOUNDIRQ
	CMP AX,05
	JE FOUNDIRQ
	CMP AX,07
	JE FOUNDIRQ
	CMP AX,10
	JE FOUNDIRQ
	LOOP IRQWAIT1

IRQERR: MOV CS:ERROR,2          ;IRQ error (IRQ did not occur)

FOUNDIRQ:
	CLI
	MOV AL,CS:SAVEPIC       ;Restore IRQs as found
	OUT 021H,AL
	MOV AL,CS:SAVEPIC2
	OUT 0A1H,AL

	MOV AL,02               ;IRQ 2
	CALL IRQ_VECT
	CLI
	MOV AH,025H
	LDS DX,CS:OLD_ISR2_ADDR
	INT 21H                 ;Restore OLD vector

	MOV AL,03               ;IRQ 3
	CALL IRQ_VECT
	CLI
	MOV AH,025H
	LDS DX,CS:OLD_ISR3_ADDR
	INT 21H                 ;Restore OLD vector

	MOV AL,05               ;IRQ 5
	CALL IRQ_VECT
	CLI
	MOV AH,025H
	LDS DX,CS:OLD_ISR5_ADDR
	INT 21H                 ;Restore OLD vector

	MOV AL,07               ;IRQ 7
	CALL IRQ_VECT
	CLI
	MOV AH,025H
	LDS DX,CS:OLD_ISR7_ADDR
	INT 21H                 ;Restore OLD vector

	MOV AL,10               ;IRQ 10
	CALL IRQ_VECT
	CLI
	MOV AH,025H
	LDS DX,CS:OLD_ISR10_ADDR
	INT 21H                 ;Restore OLD vector

	MOV AX,CS:SB_IRQ        ;return with SB irq

	POP CX
	POP DX
	POPF
	RET

HANDLER2:
	PUSH DX
	PUSH AX
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0EH
	IN AL,DX
	MOV CS:SB_IRQ,02
	MOV AL,020H
	OUT 20H,AL
	POP AX
	POP DX
	IRET

HANDLER3:
	PUSH DX
	PUSH AX
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0EH
	IN AL,DX
	MOV CS:SB_IRQ,03
	MOV AL,020H
	OUT 20H,AL
	POP AX
	POP DX
	IRET

HANDLER5:
	PUSH DX
	PUSH AX
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0EH
	IN AL,DX
	MOV CS:SB_IRQ,05
	MOV AL,020H
	OUT 20H,AL
	POP AX
	POP DX
	IRET

HANDLER7:
	PUSH DX
	PUSH AX
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0EH
	IN AL,DX
	MOV CS:SB_IRQ,07
	MOV AL,020H
	OUT 20H,AL
	POP AX
	POP DX
	IRET

HANDLER10:
	PUSH DX
	PUSH AX
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0EH
	IN AL,DX
	MOV CS:SB_IRQ,10
	MOV AL,020H
	OUT 020H,AL
	OUT 0A0H,AL
	POP AX
	POP DX
	IRET

SBFINDIRQ ENDP

;Get the Sound Blaster DSP version

GET_DSP_VER PROC NEAR

	PUSH CX
	MOV CX,10
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0CH
	MOV AL,0E1H
	CALL sbdspw
	JNC A21
	MOV CS:ERROR,3          ;DSP not responding
	JMP L23
A21:
G1:     CALL sbdsprt
	CMP AL,0AAH             ;Fix error in reading version
	JNZ G2
	LOOP G1
	MOV CS:ERROR,4          ;DSP error not responding or no version
	JMP L23
G2:     MOV AH,AL
	CALL sbdsprt
	MOV CS:SB_VER,AX
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0CH
	MOV AL,0E1H
	CALL sbdspw
	JNC A22
	MOV CS:ERROR,3          ;DSP not responding
	JMP L23
A22:
	CALL sbdsprt
	MOV AH,AL
	CALL sbdsprt
	CMP CS:SB_VER,AX
	JE L23
	MOV AX,00
	MOV CS:SB_VER,AX
L23:    POP CX
	RET

GET_DSP_VER ENDP

; Test Sound Blaster DMA transfer

TEST_DMA PROC NEAR

	MOV DX,CS
	LEA AX,TESTBUFFER
	CALL PNT_TO_DMA
	PUSH AX
	PUSH DX                 ;SAVE CONVERTED BUFFER ADDRESS
	MOV AL,0FFH
	OUT 00CH,AL             ;Clear byte pointer flip/flop
	JMP $+2
	MOV AX,CS:SB_DMA
	ADD AL,04
	OUT 0AH,AL              ;Set mask bit to channel
	JMP $+2
	MOV AL,048H
	ADD AX,CS:SB_DMA
	OUT 0BH,AL              ;Single mode select read channel
	JMP $+2
	MOV BX,CS:SB_DMA
	MOV DX,0
	MOV DL,CS:DMA_PAGE[BX]
	POP BX                  ;Restore converted buffer address
	MOV AL,BL
	OUT DX,AL               ;Set DMA page register
	JMP $+2
	POP AX
	MOV DX,CS:SB_DMA        ;Determine memory address register
	SHL DX,1
	OUT DX,AL               ;Set base and current address
	JMP $+2
	MOV AL,AH
	OUT DX,AL
	JMP $+2
	MOV BX,AX
	XOR BX,-1               ;(65536-BX) = # BYTES THAT CAN BE TRANSFERED
	MOV AX,0                ;# samples - 1
	CMP AX,BX
	JBE L100
	MOV AX,BX
L100:
	CLI
	INC DX
	OUT DX,AL             ;Base & current word count
	JMP $+2
	MOV AL,AH
	OUT DX,AL
	JMP $+2
	STI
	MOV AX,CS:SB_DMA
	OUT 0AH,AL            ;Clear channel 1 mask bit to start DMA
	JMP $+2
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0CH
	MOV AL,040H
	CALL sbdspw            ;Set DSP time constant
	JNC A31
	MOV CS:ERROR,3         ;DSP not responding
	JMP A35
A31:
	MOV AL,064H
	CALL sbdspw
	JNC A32
	MOV CS:ERROR,3         ;DSP not responding
	JMP A35
A32:
	MOV AL,014H
	CALL sbdspw            ;DMA mode 8-bit DAC
	JNC A33
	MOV CS:ERROR,3         ;DSP not responding
	JMP A35
A33:
	MOV AX,0000            ;Number of bytes to be sent to DSP is 1
	CALL sbdspw            ;#samples to be sent to DSP
	JNC A34
	MOV CS:ERROR,3         ;DSP not responding
	JMP A35
A34:
	MOV AL,AH
	CALL sbdspw
	JNC A35
	MOV CS:ERROR,3         ;DSP not responding
A35:
	RET

TEST_DMA ENDP

; Halt DMA transfer

; Open SND device for playback

OPEN PROC NEAR

	MOV AX,0
	MOV CS:REF_BYTE,AX      ;Zero adpcm reference byte flag
	MOV BX,CS:PBUFFER       ;Get pointer to CARD_INFO structure
	MOV CS:CARD_INFO,BX     ;and save it
	MOV AX,CS:PBUFFER[2]
	MOV CS:CARD_INFO[2],AX
	MOV DS,AX
GETIO:  MOV AX,[BX]+6           ;Get SB i/o address and save it
	CMP AX,0
	JLE GETIRQ
	MOV CS:SB_IO_ADDR,AX
GETIRQ: MOV AX,[BX]+8           ;Get SB IRQ and save
	CMP AX,0
	JLE GETDMA
	MOV CS:SB_IRQ,AX
GETDMA: MOV AX,[BX]+10          ;Get 8-BIT SB dma channel and save
	CMP AX,0
	JLE GET16DMA
	MOV CS:SB_DMA,AX
GET16DMA:
	MOV AX,[BX]+16          ;Get 16-Bit SB dma channel and save
	CMP AX,0
	JLE GETDMABUF
	MOV CS:DMA16,AX
GETDMABUF:
	LES DI,[BX]+18          ;Get pointer to dma buffer
	MOV CS:DMA_BUF,DI       ;and save
	MOV AX,ES
	MOV CS:DMA_BUF[2],AX

	CMP CS:SB_IRQ,-1        ;See if IRQ was available
	JNE TEST_SB
	CALL SBFINDIRQ          ;Find IRQ if none given
	CMP CS:ERROR,0          ;Check for errors
	JE TEST_SB
	JMP EXITO
TEST_SB:
	CMP CS:SB_TEST,0        ;Has SB been tested?
	JNE OK1
	CALL FIND_DV            ;See if in Desqview?
	MOV AX,CS:SB_IRQ        ;Get IRQ from environment
	MOV CS:IRQ,AX           ;and save it for later
	CALL SBFINDIRQ          ;Test IRQ/DMA operation
	CMP CS:ERROR,0          ;Check to see if IRQ was found OK
	JE IRQ_FOUND
	JMP EXITO
IRQ_FOUND:
	CMP CS:IRQ,0            ;See if IRQ was available
	JE SBOK
	MOV AX,CS:IRQ           ;if it was
	CMP AX,CS:SB_IRQ        ;see if it is the same as the IRQ found
	JE SBOK
	MOV CS:ERROR,6          ;indicate wrong IRQ found in environment
SBOK:   MOV CS:SB_TEST,1
	CMP CS:ERROR,0          ;Check to see if IRQ was found ok?
	JE OK1
	JMP EXITO
OK1:
	CALL INSTALL_ISR        ;Install IRQ for Sound Blaster
	MOV CS:DMAFLAG,0
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0CH
	MOV AL,0D1H             ;Turn on sound
	CALL SBDSPW
GETVER:
	MOV BX,CS:PBUFFER       ;Get pointer to CARD_INFO structure
	MOV AX,CS:PBUFFER[2]
	MOV DS,AX
	MOV AX,[BX]+4           ;Get SB DSP version
	CMP AX,0
	JNE EXITO
	PUSH BX
	CALL GET_DSP_VER
	POP BX
	MOV [BX]+4,AX           ;and save it
EXITO:
	MOV AX,CS:ERROR         ;Get any errors
	RET

OPEN ENDP

; Close SND device for playback

CLOSE PROC NEAR

	MOV BX,CS:PBUFFER       ;Get info from CARD_INFO structure
	MOV AX,CS:PBUFFER[2]
	MOV DS,AX
	MOV AX,[BX]+0           ;Get NOTHING
	MOV AX,CS:SB_IRQ        ;Get SB IRQ and save
	MOV [BX]+8,AX
	MOV AX,CS:SB_DMA        ;Get 8bit dma channel and save
	MOV [BX]+10,AX
	CALL IO_WAIT            ;Wait for DMA before closing
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0CH
	MOV AL,0D3H             ;Shut off sound
	CALL SBDSPW
	CALL DSP_RESET          ;Reset the DSP before exiting
	CALL RESTORE_ISR        ;Restore IRQ & PIC
	RET

CLOSE ENDP

; Play sound block via 1-shot dma mode

PLAY PROC NEAR
	CMP CS:DMAFLAG,0        ;Is DMAFLAG for DAC still in Use?
	JZ OK
	MOV CS:ERROR,1          ;DMA in use error
	JMP EXITP
OK:
	MOV BX,CS:PBUFFER       ;Get info from SOUND structure
	MOV CS:SOUND_INFO,BX    ;and save it
	MOV AX,CS:PBUFFER[2]
	MOV CS:SOUND_INFO[2],AX
	MOV DS,AX
	MOV AX,[BX]             ;Get sound buffer address and save
	MOV CS:BUFFER,AX
	MOV AX,[BX]+2
	MOV CS:BUFFER[2],AX
	MOV AX,[BX]+4           ;Get number of samples to play
	CMP AX,0                ;Check for zero samples
	JNE SAVE_S
	MOV CS:ERROR,8
SAVE_S: MOV CS:SAMPLES,AX       ;AND SAVE
	MOV AX,[BX]+20          ;Get number of bits and save
	MOV CS:BITS,AX
	MOV CX,[BX]+14          ;Get frequency & calculate time constant
	MOV CS:FREQ[2],CX       ;and save it
	MOV DX,000FH
	MOV AX,04240H
	DIV CX
	XOR AH,AH
	SUB AH,AL
	MOV AL,AH
	XOR AH,AH
	MOV CS:TIME_CONST,AX
	CMP AL,0EAH             ;Check playback speed
	JBE L18
	MOV AX,00EAH            ;Limit playback speed to 44,100 hz
	MOV CS:TIME_CONST,AX
L18:    MOV CS:DSP_SPEED,01
	CMP CS:SB_TYPE,-1       ;If SB is type -1
	JE L24                  ;don't check dsp version
	CMP CS:SB_VER,00
	JNZ L24
	CALL GET_DSP_VER        ;Check DSP version for maximum playback
L24:    CMP CS:SB_VER,0200H
	JAE L22
	CMP CS:TIME_CONST,0D4H  ;Is playback greater than 22,727 hz?
	JBE L22
	MOV AX,00D4H            ;Limit to 22,727 hz if DSP version < 2.00
	MOV CS:TIME_CONST,AX
L22:    CMP CS:TIME_CONST,0D4H  ;Is playback less than 22,727 hz?
	JA L19
	MOV CS:DSP_SPEED,00
L19:
	MOV AX,[BX]+24          ;DSP DMA mode
	AND AX,07FFEH
	CMP AX,0200H            ;Is it ADPCM4?
	JE ADPCM4
	CMP AX,0400H            ;Is it ADPCM26?
	JE ADPCM26
	CMP AX,0800H            ;Is it ADPCM2?
	JE ADPCM2
	CMP AX,01H
	JE MONO8
	CMP AX,02H              ;Is it 8 bit stereo?
	JE STER8
	CMP AX,04H              ;Is it 16 bit mono?
	JE MONO16
	CMP AX,08H              ;Is it 16 bit stereo?
	JE STER16
	JMP MONO8
MONO16: MOV AX,6
	JMP L30
MONO8:  MOV AX,0                ;Else normal
	CMP CS:SB_VER,0400H     ;sb16?
	JLE MONO8T
	MOV AX,4
MONO8T: JMP L30
ADPCM4: MOV AX,1
	JMP L30
ADPCM26:
	MOV AX,2
	JMP L30
ADPCM2: MOV AX,3
	JMP L30
STER16: MOV AX,7
	JMP STER8T
STER8:  MOV AX,0
	CMP CS:SB_VER,0400H     ;sb16?
	JLE STER8T
	MOV AX,5
STER8T: MOV BX,2                ;Two channel
	MOV CS:STEREO,BX
	MOV CS:CHANNELS,BX
	JMP L33
L30:
	MOV BX,1
	MOV CS:STEREO,BX
	MOV CS:CHANNELS,BX
L33:    
	AND AX,0007h            ;Limit to 8 modes
	MOV BX,AX
	MOV AL,DSP_DMA_MODE[BX]
	CMP BX,0
	JE L34
	CMP CS:REF_BYTE,0       ;See if reference byte has been sent
	JNE L34
	MOV CS:REF_BYTE,BX
L34:    MOV CS:DMA_MODE,AL

	CALL SET_MODE           ;Set mono or stereo for SB Pro

	MOV DX,CS:SB_IO_ADDR
	ADD DX,0CH
	MOV AL,040H             ;Set DSP time constant
	CMP CS:SB_VER,0400H     ;check dsp version for 16bit mode
	JL SET_TC
	MOV AL,041H             ;Set DSP transfer rate
	CALL sbdspw
	MOV AX,CS:FREQ[2]
	XCHG AL,AH
	CALL sbdspw
	MOV AX,CS:FREQ[2]
	CALL sbdspw
	JMP A2
SET_TC: CALL sbdspw
	JNC A1
	MOV CS:ERROR,3          ;DSP Error
	JMP EXITP
A1:     MOV AX,CS:TIME_CONST
	CALL sbdspw
	JNC A2
	MOV CS:ERROR,3          ;DSP Error
	JMP EXITP
A2:
	INC CS:DMAFLAG          ;SET DMAFLAG TO SHOW IN USE

	MOV DX,CS:BUFFER[2]     ;Convert Buffer Address to 64k Pages & Offset
	MOV AX,CS:BUFFER
	CALL PNT_TO_DMA
	MOV CS:BUFFER,AX        ;AND SAVE
	MOV CS:BUFFER[2],DX
	CALL START_DMA

; Return Imediately

EXITP:
	RET

PLAY ENDP

MOVE PROC NEAR

;
; Move sound data to DMA buffer for playback
;
	LDS DX,CS:DMA_BUF_ADDR
	LES BX,CS:BUFFER_ADDR
	MOV CX,CS:SAMPLES
	SHR CX,1
TRANSFER:
	MOV AX,ES:[BX]
	XCHG BX,DX
	MOV [BX],AX
	XCHG BX,DX
	ADD BX,2
	ADD DX,2
	DEC CX
	CMP CX,0
	JNE TRANSFER

	LDS DX,CS:DMA_BUF_ADDR          ;Point buffer to DMA buffer
	MOV CS:PBUFFER,DX
	MOV AX,DS
	MOV CS:PBUFFER[2],AX
	RET
MOVE ENDP

; Pause DMA transfer

PAUSE_DMA PROC NEAR

	RET

PAUSE_DMA ENDP

; Resume DMA transfer

RESUME_DMA PROC NEAR

	RET

RESUME_DMA ENDP

; Get Driver Status

GET_STATUS PROC NEAR

	MOV BX,CS:PBUFFER       ;Get info from SND_STATUS structure
	MOV CS:SND_STATUS,BX    ;and save pointer to it
	MOV AX,CS:PBUFFER[2]
	MOV CS:SND_STATUS[2],AX
	MOV DS,AX
	MOV AX,CS:DMAFLAG
	MOV [BX]+4,AX           ;Set dma flag in status structure
	MOV CS:DMA_FLAG,AX
	MOV AX,CS:SB_DMA        ;Determine DMA count register
	SHL AX,1
	ADD AX,1
	MOV DX,AX
	IN AL,DX                ;Get DMA countdown
	MOV AH,AL
	IN AL,DX
	XCHG AL,AH
	MOV [BX]+6,AX
	MOV CS:DMA_COUNT,AX
	RET

GET_STATUS ENDP

; Get Resource info

GET_RESOURCES PROC NEAR

	MOV DX,SEG _sb_info
	MOV AX,OFFSET _sb_info
	RET

GET_RESOURCES ENDP

; Play via continuous DMA

PLAYC PROC NEAR

	RET

PLAYC ENDP

DSP_RESET PROC NEAR

	MOV DX,CS:SB_IO_ADDR
	ADD DL,06
	MOV AL,01
	OUT DX,AL
	IN AL,DX
	IN AL,DX
	IN AL,DX
	IN AL,DX
	SUB AL,AL
	OUT DX,AL
	MOV BL,10H
D_GET:  CALL sbdsprt
	CMP AL,0AAH
	JZ D_END
	DEC BL
	JNZ D_GET
	MOV AX,0002             ;I/O read/write fail
	STC
	JMP D_END1
D_END:  SUB AX,AX
D_END1: OR AX,AX
	RET

DSP_RESET ENDP

STOP_DMA PROC NEAR

	PUSHF
	PUSH SI
	MOV AH,0D0H             ;HALT DMA IN PROGRESS
	MOV BX, OFFSET DMAFLAG
	SUB CX,CX
	MOV DX,CS:SB_IO_ADDR
	ADD DL,0CH
	MOV SI,0FFFFH
S1:     STI
	CMP CL,[BX]             ;Is dsp in use?
	JZ SE
	CLI
	IN AL,DX
	OR AL,AL
	JS S2
	DEC SI
	JNZ S1
S5:     MOV CS:ERROR,3          ;DSP error (not responding)
	JMP SE
S2:     MOV SI,0FFFFH           ;Timeout Period
S3:     DEC SI
	JZ S5
	IN AL,DX
	OR AL,AL
	JS S3
	MOV AL,AH
	OUT DX,AL
SE:     POP SI
	POPF
	RET

STOP_DMA ENDP

RESTORE PROC NEAR

	MOV AL,04               ;DMA channel mask register
	ADD AX,CS:SB_DMA
	OUT 0AH,AL
	MOV AX,0
	MOV CS:DMAFLAG,AX       ;Indicate it is
	LDS DX,CS:OLD_INTERRUPT_ADDR
	MOV AX,CS:SB_IRQ
	CALL IRQ_VECT
	CLI
	MOV AH,025H             ;Restore old IRQ 5
	INT 21h
	CLI
	MOV AX,CS:SB_IRQ        ;Restore PICs
	AND AL,08
	JZ R10
	MOV AL,CS:SAVEPIC
	OUT 021H,AL
	MOV DX,00A1H
	JMP R11
R10:    MOV DX,0021H
R11:    MOV AL,CS:SAVEPIC2
	OUT DX,AL
	MOV DX,CS:SB_IO_ADDR    ;Acknowledge DSP interrupt
	ADD DL,0EH
	IN AL,DX
	RET

RESTORE ENDP

IO_WAIT PROC NEAR
;
; gives up time slices if DMA has a sufficient count
; and waits for dma to complete
;
IOWAIT:
	CMP CS:DMAFLAG,0        ;Is DMAFLAG for DAC still in Use?
	JE EXITW                ;Wait until done
	CALL GIVE_SLICE
	CMP CS:DMAFLAG,0        ;Is DMAFLAG for DAC still in Use?
	JE EXITW                ;Wait until done
	JMP IOWAIT
EXITW:  RET

IO_WAIT  ENDP

_sbdelay PROC FAR
;
; _sbdelay FAR Procedure for C Written by John A. Ball   January 9, 1994
;
; Causes a time delay using the Sound Blaster DSP
;
;       int error sbdelay(char tc, int period);
;
PARMA1          EQU [BP+6]      ;Time Constant
PARMB1          EQU [BP+8]      ;Delay period

	PUSH BP                 ;Save stack Frame
	MOV BP,SP
	PUSHF
	PUSH DS                 ;Save registers
	PUSH ES
	PUSH DI

	MOV AX,DGROUP           ;Set DS = our data segment
	MOV DS,AX

	CMP CS:DMAFLAG,0        ;Is DMAFLAG for DAC still in Use?
	JZ DELAY
	MOV CS:ERROR,1          ;DMA in use error
	JMP EXIT3
DELAY:
	MOV CX,PARMA1           ;GET TIME CONSTANT
	MOV BX,PARMB1           ;Get delay period
	MOV DX,CS:SB_IO_ADDR
	ADD DX,0CH
	MOV AL,040H             ;Set Time Constant
	CALL sbdspw
	MOV AL,CL
	CALL sbdspw
	MOV AL,080H             ;Set Silence Length
	CALL sbdspw
	MOV AL,BL               ;and send Period
	CALL sbdspw
	MOV AL,BH
	CALL sbdspw

	INC CS:DMAFLAG          ;SET DMAFLAG TO SHOW IN USE

DELAYW:
	CALL GIVE_SLICE
	CMP CS:DMAFLAG,0        ;Is DMAFLAG for DAC still in Use?
	JE EXIT3                ;Wait until done
	JMP DELAYW

EXIT3:  MOV AX,CS:ERROR
	POP DI                  ;Restore registers
	POP ES
	POP DS
	POPF
	POP BP                  ;RESTORE BP
	RET
_sbdelay ENDP

GIVE_SLICE PROC NEAR
	CMP CS:IN_DV,0          ;See if in DESQview?
	JNE DV
	INT 28H                 ;MS-DOS idle handler
	MOV AX,1680H
	INT 2FH                 ;MS-DOS idle call
	JMP DV_EXIT
DV:
	MOV AX,1000H            ;Give up time slice to DESQview
	INT 15H
DV_EXIT:
	RET
GIVE_SLICE ENDP

FIND_DV PROC NEAR
	PUSH BX
	PUSH CX
	PUSH DX
	MOV CX,'DE'
	MOV DX,'SQ'
	MOV AX,2B01H
	INT 21H
	CMP AL,0FFH
	JE NO_DV
	MOV AX,BX
	MOV CS:IN_DV,1
	JMP E_F
NO_DV:
	MOV AX,0
E_F:
	POP DX
	POP CX
	POP BX
	RET
FIND_DV ENDP


SET_VOLUME PROC NEAR

	MOV AX,CS:SB_VER        ;Get DSP version and see if card has mixer
	CMP AX,0300H            ;Versions 3 and above have mixer chip
	JL EXIT_VOL
	MOV BX,CS:PBUFFER       ;Get info from SOUND structure
	MOV CS:SOUND_INFO,BX    ;and save it
	MOV AX,CS:PBUFFER[2]
	MOV CS:SOUND_INFO[2],AX
	MOV DS,AX
	MOV AX,[BX]+18          ;Get sound buffer address and save
	MOV CS:VOLUME,AX
	MOV AX,CS:VOLUME        ;Get volume and convert to mixer format
	MOV DX,0
	MOV BX,13
	DIV BX
	SHL AX,1
	MOV CX,4
	MOV BX,AX
	SHL AX,CL
	ADD BX,AX
	MOV DX,CS:SB_IO_ADDR
	ADD DX,04H
	MOV AX,04H              ;Voice Volume Register
	OUT DX,AL
	INC DX
	MOV AX,BX               ;Get volume and set
	OUT DX,AL
EXIT_VOL:
	RET

SET_VOLUME ENDP

SET_MODE PROC NEAR

	MOV AX,CS:STEREO        ;Get mono or stereo mode
	CMP AX,CS:PRE_MODE      ;Same mode as before?
	JE SM_EXIT
	CMP CS:SB_VER,0300H     ;Sound Blaster Pro
	JL SM_EXIT
	CMP CS:SB_VER,0400H     ;only
	JGE SM_EXIT
	MOV DX,CS:SB_IO_ADDR
	ADD DX,4
	MOV CS:PRE_MODE,AX      ;Save current mode
	CMP AX,2                ;Stereo or mono
	JE SET_STEREO
	MOV AL,00CH             ;Restore filter status
	OUT DX,AL
	INC DX
	MOV AX,CS:OUT_FILTER
	OUT DX,AL
	DEC DX
	MOV AL,00EH             ;Set hardware to mono mode
	OUT DX,AL
	INC DX
	IN AL,DX
	AND AL,0FDH
	OUT DX,AL
	JMP SM_EXIT
SET_STEREO:
	MOV AX,00EH             ;Set hardware to stereo mode
	OUT DX,AL
	INC DX
	IN AL,DX
	OR AL,002H
	OUT DX,AL
	DEC DX
	MOV AX,00EH
	OUT DX,AL
	INC DX
	IN AL,DX
	MOV CS:OUT_FILTER,AX
	OR AL,020H
	OUT DX,AL
SM_EXIT:
	RET

SET_MODE ENDP

ACK_16B PROC NEAR

;Read DSP with timeout

	PUSH CX
	PUSH DX
	MOV DX,CS:SB_IO_ADDR
	ADD DL,0FH
	MOV CX,0200H
ACK4:   IN AL,DX
	JMP $+2
	OR AL,AL
	JS ACK5
	LOOP ACK4
	STC
	JMP ACK6
ACK5:   SUB DL,04H
	IN AL,DX
	CLC
ACK6:   POP DX
	POP CX
	RET

ACK_16B ENDP

_TEXT   ENDS
	END

