#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <string.h>
#include <mem.h>
#include <math.h>
#define	TWO_PI	((double)2.0 * M_PI)

typedef unsigned char DacPalette256[256][3];
unsigned char far *VGAmem;
struct text_info tiGFX;
struct REGPACK regp;
union  REGS reg;
int Linecolor=1,WritePage=0,HighSpeed=0,Triggerbuffer=999;
int minX=0,minY=0,maxx=320,maxy=200;

DacPalette256 Hallo;

/* Globals */

int	samples, power;
double	real[2048], imag[2048], max, Pegel=10,FFTmax;
FILE	*fpi, *fpo;

/* Prototypes and forward declarations */

void	fft(void), max_amp(void);
int	permute(int);
double	magnitude(int);
void dspwrite ( unsigned char );
unsigned char dspread ( void );
unsigned Buffer[2048];
unsigned SBuffer[8900];
unsigned char far *data;
unsigned char far *aligned;
unsigned char far aligned_physical;

/* Getvgapalette256 gets the entire 256 color palette */
/* PalBuf contains RGB values for all 256 colors      */
/* R,G,B values range from 0 to 63	              */
/* Usage:					      */
/*  DacPalette256 dac256;			      */
/*						      */
/* getvgapalette256(&dac256);			      */
void getvgapalette256(DacPalette256 *PalBuf)
{
  regp.r_ax = 0x1017;
  regp.r_bx = 0;
  regp.r_cx = 256;
  regp.r_es = FP_SEG(PalBuf);
  regp.r_dx = FP_OFF(PalBuf);
  intr(0x10,&regp);
}

/* Setvgapalette256 sets the entire 256 color palette */
/* PalBuf contains RGB values for all 256 colors      */
/* R,G,B values range from 0 to 63	              */
/* Usage:					      */
/*  DacPalette256 dac256;			      */
/*						      */
/* setvgapalette256(&dac256);			      */
void setvgapalette256(DacPalette256 *PalBuf)
{
  regp.r_ax = 0x1012;
  regp.r_bx = 0;
  regp.r_cx = 256;
  regp.r_es = FP_SEG(PalBuf);
  regp.r_dx = FP_OFF(PalBuf);
  intr(0x10,&regp);
}



void Grafik(int GFXmode)  // 13,      14,     17mono,   18,      19vga,  -1,3
{                         //320x200, 640x200, 640x480, 640x480, 320x200, text
VGAmem=(char far *)MK_FP(0xa000,0);
if (GFXmode>=0)
  {
   gettextinfo(&tiGFX);
   regp.r_ax = GFXmode;
   intr(0x10,&regp);
  }
if (GFXmode<0)
  {
   regp.r_ax = tiGFX.currmode;
   intr(0x10,&regp);
  }
}



void Putpixel(int x, int y)
{
 reg.h.ah = 0x0c;
 reg.h.al = Linecolor;
 reg.h.bh = WritePage;
 reg.x.cx = x;
 reg.x.dx = y;
 int86(0x10,&reg,&reg);
}



void Putpixel2(int x, int y)
{
 reg.h.ah = 0x0c;
 reg.h.al = 0;
 reg.h.bh = WritePage;
 reg.x.cx = x;
 reg.x.dx = y;
 int86(0x10,&reg,&reg);
}



void Putpixel3(int x, int y)
{
 reg.h.ah = 0x0c;
 reg.h.al = 235-y;
 reg.h.bh = WritePage;
 reg.x.cx = x;
 reg.x.dx = y;
 int86(0x10,&reg,&reg);
}



int Getpixel(int x, int y)
{
 if(x<minX)return 0;
 if(y<minY)return 0;
 if(x>=maxx)return 0;
 if(y>=maxy)return 0;
 reg.h.ah = 0x0d;
 reg.h.bh = WritePage;
 reg.x.cx = x;
 reg.x.dx = y;
 int86(0x10,&reg,&reg);
 return reg.h.al;
}



void singlecolor256(int nr,int r,int g,int b)
{
 reg.h.ah = 0x10;
 reg.h.al = 0x10;
 reg.x.bx = nr;
 reg.h.ch = g;
 reg.h.cl = b;
 reg.h.dh = r;
 int86(0x10,&reg,&reg);
}



void singlecolor16(int nr,int r,int g,int b)
{
 reg.h.ah=0x10;
 reg.h.al=0x07;
 reg.h.bl=nr;
 int86(0x10,&reg,&reg);
 nr=reg.h.bh;
 reg.h.ah = 0x10;
 reg.h.al = 0x10;
 reg.x.bx = nr;
 reg.h.ch = g;
 reg.h.cl = b;
 reg.h.dh = r;
 int86(0x10,&reg,&reg);
}



void linie(double x1,double y1,double x2,double y2)
{
 double a,b,dx,dy,e;
 dx=x1-x2;
 dy=y1-y2;
 if(dx==0)
	  {
	   if(dy>=0) for(e=y2;e<=y1;e++)Putpixel(x1,e);
	   else      for(e=y1;e<=y2;e++)Putpixel(x1,e);
	   return;
	  }
 if(dy==0)
	  {
	   if(dx>=0) for(e=x2;e<=x1;e++)Putpixel(e,y1);
	   else      for(e=x1;e<=x2;e++)Putpixel(e,y1);
	   return;
	  }
 e=y1-(dy*x1)/dx;
if(abs(dx)>=abs(dy))
   {
    if(dx>=0)
	{
	 for(a=x2;a<=x1;a++){ b=e+(a*dy)/dx; Putpixel(a,b); }
	}
    else
	{
	 for(a=x1;a<=x2;a++){ b=e+(a*dy)/dx; Putpixel(a,b); }
	}
   }
if(abs(dx)<abs(dy))
   {
    if(dy>=0)
	{
	 for(a=y2;a<=y1;a++){ b=((a-e)*dx)/dy; Putpixel(b,a); }
	}
    else
	{
	 for(a=y1;a<=y2;a++){ b=((a-e)*dx)/dy; Putpixel(b,a); }
	}
   }
}





void MakePalette()
{
 int frag;
 for(frag=0;frag<256;frag++)
   {
    if(frag<32)
	       {
		Hallo[frag][0]=0;
		Hallo[frag][1]=0;
		Hallo[frag][2]=2*frag;
	       }
    if((frag>=32)&&(frag<96))
			     {
			      Hallo[frag][0]=0;
			      Hallo[frag][1]=(frag-32);
			      Hallo[frag][2]=(95-frag);
			     }
    if((frag>=96)&&(frag<128))
			      {
			       Hallo[frag][0]=2*(frag-96);
			       Hallo[frag][1]=63;
			       Hallo[frag][2]=0;
			      }
    if((frag>=128)&&(frag<192))
			       {
				Hallo[frag][0]=63;
				Hallo[frag][1]=(191-frag);
				Hallo[frag][2]=(frag-128);
			       }
    if(frag>=192)
   	         {
	          Hallo[frag][0]=63;
		  Hallo[frag][1]=0;
		  Hallo[frag][2]=0;
		  if(frag<223)Hallo[frag][2]=2*(222-frag);
	         }
   }
 setvgapalette256(&Hallo);
}


//------------------------------------------------------------------------------
void dspwrite ( unsigned char c )
{
    while(inportb(0x022C)&0x80);
    outportb(0x022C,c);
}
//------------------------------------------------------------------------------
void sbinit ( void )
{
    unsigned short x;
    inportb(0x022E);
    outportb(0x0226,0x01);
    inportb(0x0226);
    inportb(0x0226);
    inportb(0x0226);
    inportb(0x0226);
    outportb(0x0226,0x00);
    for(x=0;x<100;x++)
    {
        if(inportb(0x022E)&0x80)
        {
            if(inportb(0x022A)==0xAA) break;
        }
    }
    if(x==100)
    {
        printf("Sound Blaster not found at 0220h\n");
        exit(1);
    }
}
//------------------------------------------------------------------------------
void sbmalloc ( void )
{
    unsigned long physical;
    data=farmalloc(80000L);
    if(data==NULL)
    {
        printf("Memory Allocation Error\n");
        exit(1);
    }
    physical=((unsigned long)FP_OFF(data))+(((unsigned long)FP_SEG(data))<<4);
    physical+=0x0FFFFL;
    physical&=0xF0000L;
    aligned_physical=(physical>>16)&15;
    aligned=MK_FP(((unsigned short)aligned_physical<<12)&0xF000,0);
}
//------------------------------------------------------------------------------
void sbsettc ( unsigned char tc )
// tc = time constant = 256L - (1000000UL/samples per second)
{
    inportb(0x022E);
    dspwrite(0x40);
    dspwrite(tc);
}
//------------------------------------------------------------------------------
void sbrec ( unsigned short len )
// len = number of bytes to record to unsigned char *aligned (<=65000)
{
    len--;
    outportb(0x0A,0x05);
    outportb(0x0C,0x00);
    outportb(0x0B,0x45);
    outportb(0x02,0);
    outportb(0x02,0);
    outportb(0x83,aligned_physical);
    outportb(0x03,(unsigned char)(len&0xFF));
    outportb(0x03,(unsigned char)((len>>8)&0xFF));
    outportb(0x0A,0x01);
    dspwrite(0x24);
    dspwrite((unsigned char)(len&0xFF));
    dspwrite((unsigned char)((len>>8)&0xFF));
}
//------------------------------------------------------------------------------
void sbrec2 ( unsigned short len )
// len = number of bytes to record to unsigned char *aligned (<=65000)
{
    len--;
    outportb(0x0A,0x05);
    outportb(0x0C,0x00);
    outportb(0x0B,0x45);
    outportb(0x02,0);
    outportb(0x02,0);
    outportb(0x83,aligned_physical);
    outportb(0x03,(unsigned char)(len&0xFF));
    outportb(0x03,(unsigned char)((len>>8)&0xFF));
    outportb(0x0A,0x01);
    dspwrite(0x48);
    dspwrite((unsigned char)(len&0xFF));
    dspwrite((unsigned char)((len>>8)&0xFF));
    dspwrite(0x99);
}
//------------------------------------------------------------------------------
unsigned short dmacount ( void )
{
    unsigned short x;
    x=inportb(0x03);
    x|=inportb(0x03)<<8;
    if(x==0xFFFF) inportb(0x022E);
    return(x);
}
//------------------------------------------------------------------------------
void recording(int e,int f)
{
 int m,n=Triggerbuffer -e -30,o;
 int Smax=0,Spos=0;
 if(HighSpeed)sbrec2(Triggerbuffer); else sbrec(Triggerbuffer);
 while(dmacount()!=0xFFFF);
 for(m=0;m<n;m++)
    {
     o= *(aligned+m) + *(aligned+m+1) + *(aligned+m+2) + *(aligned+m+3);
     if(o>Smax)Smax=o,Spos=m+30;
    }
 if(f>0)for(m=0;m<e;m++)
           {
            o = *(aligned+Spos+m) - f;
            if(o<0)o=0;
            if(o>199)o=199;
            SBuffer[m]=o;
           }
 else for(m=0;m<e;m++)SBuffer[m] = *(aligned+Spos+m) - f;
}



void lineX00(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-1,v,w=abs(dy);
 if(w<2)
        {
         *(VGAmem+((x-1)>>3)+80*y1)&=255-(1<<(7-((x-1)&7)));
         *(VGAmem+(x>>3)+80*y2)&=255-(1<<(7-(x&7)));
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=v-y1;
              w /=dy;
              *(VGAmem+((m+w)>>3)+80*v)&=255-(1<<(7-((m+w)&7)));
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=v-y2;
          w /=dy;
          *(VGAmem+((x-w)>>3)+80*v)&=255-(1<<(7-((x-w)&7)));
         }
     }
}



void lineX01(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-1,v,w=abs(dy);
 if(w<2)
        {
         *(VGAmem+((x-1)>>3)+80*y1)|=1<<(7-((x-1)&7));
         *(VGAmem+(x>>3)+80*y2)|=1<<(7-(x&7));
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=v-y1;
              w /=dy;
              *(VGAmem+((m+w)>>3)+80*v)|=1<<(7-((m+w)&7));
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=v-y2;
          w /=dy;
          *(VGAmem+((x-w)>>3)+80*v)|=1<<(7-((x-w)&7));
         }
     }
}



int cool0()
{
unsigned t;
int i,m=Triggerbuffer;
Triggerbuffer=1500;
Grafik(18);
for(i=0;i<640;i++)Buffer[i]=0;
Linecolor=2;
for(i=0;i<640;i+=64)for(t=124;t<128;t+=2)Putpixel(i,t);
for(i=0;i<640;i+=8)for(t=128;t<385;t+=2)Putpixel(i,t);
for(i=128;i<385;i+=8)for(t=0;t<633;t+=2)Putpixel(t,i);
Linecolor=6;
for(i=128;i<385;i+=32)for(t=0;t<640;t+=2)Putpixel(t,i);
for(i=0;i<640;i+=32)for(t=128;t<385;t+=2)Putpixel(i,t);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,1);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,0);
singlecolor16(1,63,63,63);
nochmal:
    recording(640,(-128));
    lineX00(1,Buffer[0],Buffer[1]);
    for(i=1;i<640;i++)
                      {
                       lineX00(i+1,Buffer[i],Buffer[i+1]);
                       lineX01(i,SBuffer[i-1],SBuffer[i]);
                      }
    for(i=0;i<640;i++)Buffer[i]=SBuffer[i];
    if(!kbhit())goto nochmal;
i=getch();
if((i==13)||(i==32)) { getch(); goto nochmal; }
Triggerbuffer=m;
return i;
}






int cool1()
{
unsigned i,t,j;
Grafik(19);
MakePalette();
for(i=0;i<500;i++)Buffer[i]=0;
nochmal:
    recording(320,28);
    for(i=0;i<320;i++)
       {
        j=SBuffer[i];
        t=j*320;
        *(VGAmem+i+Buffer[i])=0;
        Buffer[i]=t;
        *(VGAmem+i+t)=235-j;
       }
    if(!kbhit())goto nochmal;
i=getch();
if(i=='-') { if(Triggerbuffer<8000)Triggerbuffer *= 1.1; goto nochmal; }
if(i=='+') { if(Triggerbuffer>400) Triggerbuffer /= 1.1; goto nochmal; }
return i;
}



int cool2()
{
unsigned t,h;
int i;
Grafik(19);
MakePalette();
nochmal:
    recording(320,28);
for(i=0;i<320;i++)
     {
      h=320*SBuffer[i];
      for(t=i;t<h;t+=320)*(VGAmem+t)=0;
      h=235-SBuffer[i];
      for(;t<64000;t+=320)*(VGAmem+t)=h, h--;
     }
    if(!kbhit())goto nochmal;
i=getch();
if(i=='-') { if(Triggerbuffer<8000)Triggerbuffer *= 1.1; goto nochmal; }
if(i=='+') { if(Triggerbuffer>400) Triggerbuffer /= 1.1; goto nochmal; }
return i;
}



void lineX30(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-1,v,w=abs(dy);
 if(w<2)
        {
         *(VGAmem+x-1+y1*320)=0;
         *(VGAmem+x+y2*320)=0;
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=v-y1;
              w /=dy;
              *(VGAmem+m+w+320*v)=0;
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=v-y2;
          w /=dy;
          *(VGAmem+x-w+320*v)=0;
         }
     }
}



void lineX31(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-1,v,w=abs(dy);
 if(w<2)
        {
         *(VGAmem+x-1+y1*320)=235-y1;
         *(VGAmem+x+y2*320)=235-y2;
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=v-y1;
              w /=dy;
              *(VGAmem+m+w+320*v)=235-v;
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=v-y2;
          w /=dy;
          *(VGAmem+x-w+320*v)=235-v;
         }
     }
}



int cool3()
{
int i;
Grafik(19);
MakePalette();
for(i=0;i<320;i++)Buffer[i]=0;
nochmal:
    recording(320,28);
    lineX30(1,Buffer[0],Buffer[1]);
    for(i=1;i<320;i++)
                      {
                       if(i<319)lineX30(i+1,Buffer[i],Buffer[i+1]);
                       lineX31(i,SBuffer[i-1],SBuffer[i]);
                      }
    for(i=0;i<320;i++)Buffer[i]=SBuffer[i];
    if(!kbhit())goto nochmal;
i=getch();
if(i=='-') { if(Triggerbuffer<8000)Triggerbuffer *= 1.1; goto nochmal; }
if(i=='+') { if(Triggerbuffer>400) Triggerbuffer /= 1.1; goto nochmal; }
return i;
}



void lineX41(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-2,v,w=abs(dy);
 if(w<3)
        {
         m=(y1+y2)/2;
         *(VGAmem+x-2+y1*320)=235-y1;
         *(VGAmem+x-1+m*320)=235-m;
         *(VGAmem+x+y2*320)=235-y2;
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=(v-y1)*2;
              w /=dy;
              *(VGAmem+m+w+320*v)=235-v;
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=(v-y2)*2;
          w /=dy;
          *(VGAmem+x-w+320*v)=235-v;
         }
     }
}



void lineX40(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-2,v,w=abs(dy);
 if(w<3)
        {
         m=(y1+y2)/2;
         *(VGAmem+x-2+y1*320)=0;
         *(VGAmem+x-1+m*320)=0;
         *(VGAmem+x+y2*320)=0;
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=(v-y1)*2;
              w /=dy;
              *(VGAmem+m+w+320*v)=0;
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=(v-y2)*2;
          w /=dy;
          *(VGAmem+x-w+320*v)=0;
         }
     }
}



int cool4()
{
int i,m;
Grafik(19);
MakePalette();
for(i=0;i<320;i++)Buffer[i]=128;
nochmal:
    recording(160,28);
    lineX40(2,Buffer[0],Buffer[1]);
    for(i=2;i<320;i+=2)
                      {
                       m=i/2;
                       if(m<159)lineX40(i+2,Buffer[m],Buffer[m+1]);
                       lineX41(i,SBuffer[m-1],SBuffer[m]);
                      }
    for(i=0;i<160;i++)Buffer[i]=SBuffer[i];
    if(!kbhit())goto nochmal;
i=getch();
if(i=='-') { if(Triggerbuffer<8000)Triggerbuffer *= 1.1; goto nochmal; }
if(i=='+') { if(Triggerbuffer>400) Triggerbuffer /= 1.1; goto nochmal; }
return i;
}
//----------------------------------------------------------------------------


/* The program */
//samples = How many Real/Imag Numbers...
//power =  log10((double)samples) / log10((double)2.0);


void fft()
{
	unsigned i1, i2, i3, i4, y;
	int	 loop, loop1, loop2;
	double	 a1, a2, b1, b2, z1, z2, v;

	/* Scale the data */

	for (loop = 0; loop < samples; loop++)  {
		real[loop] /= (double)samples;
		imag[loop] /= (double)samples;
	}

	i1 = samples >> 1;
	i2 = 1;
	v = TWO_PI * ((double)1.0 / (double)samples);

	for (loop = 0; loop < power; loop++)  {
		i3 = 0;
		i4 = i1;

		for (loop1 = 0; loop1 < i2; loop1++)  {
			y = permute(i3 / i1);
			z1 =  cos(v * y);
			z2 = -sin(v * y);

			for (loop2 = i3; loop2 < i4; loop2++)  {
				a1 = real[loop2];
				a2 = imag[loop2];

				b1 = z1*real[loop2+i1] - z2*imag[loop2+i1];
				b2 = z2*real[loop2+i1] + z1*imag[loop2+i1];

				real[loop2]      = a1 + b1;
				imag[loop2]      = a2 + b2;

				real[loop2 + i1] = a1 - b1;
				imag[loop2 + i1] = a2 - b2;
			}

			i3 += (i1 << 1);
			i4 += (i1 << 1);
		}

		i1 >>= 1;
		i2 <<= 1;
	}
}

/*
 *	Find maximum amplitude
 */

void max_amp()
{
	double	mag;
	int	loop;

	max = (double)0.0;
	for (loop = 0; loop < samples; loop++)  {
		if ((mag = magnitude(loop)) > max)
			max = mag;
	}
}

/*
 *	Calculate Power Magnitude
 */

double magnitude(n)
int	n;
{
	n = permute(n);
	return (sqrt(real[n] * real[n] + imag[n] * imag[n]));
}

/*
 *	Bit reverse the number
 *
 *	Change 11100000b to 00000111b or vice-versa
 */

int permute(index)
int	index;
{
	int	n1, result, loop;

	n1 = samples;
	result = 0;

	for (loop = 0; loop < power; loop++)  {
		n1 >>= 1;			/* n1 / 2.0 */
		if (index < n1)
			continue;

		result += (int) pow((double)2.0, (double)loop);
		index -= n1;
	}

	return result;
}
//---------------------------------------------------------------------------


void mode17line(int x,unsigned y0,int yy,double vol)
{
 unsigned e,f,g;
 char far *h = VGAmem + x/8;
 vol=vol*Pegel;
 if(vol<(-119.0))vol=-119.0;
 if(vol>yy) vol = yy;
 f=y0 - (int)vol;
 x=1<<(7-x&7);
 e=80*y0;
 f=80*f;
 if(e>f) g=e,e=f,f=g;
 for(g=e;g<=f;g+=80)*(h+g)|=x;
}



int coolM()
{
 unsigned u;
 int i,t,n2;
 double v;
 long m=0;
 samples=1024;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=0;i<8000;i++) m=m+ *(aligned+i);
 m=m/8000+1;    //Zero calibration!
 n2=samples/2;
 Grafik(17);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,15);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,1);

nochmal:
 if(HighSpeed) sbrec2(samples); else sbrec(samples);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+i) - (int)m; }
 fft();
 for(t=0;t<n2;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     real[samples+t]=v;
    }
 _fmemset(VGAmem,0,40000);
 for(t=0;t<n2;t++)mode17line(t+64,479,479,real[samples+t]);
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
if((i==13)||(i==32)) i='/';
return i;
}



int cool9()
{
 int i,t,n,n2;
 long m=0;
 samples=512;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=0;i<8000;i++) m=m+ *(aligned+i);
 m=m/8000+1;    //Zero calibration!
 n2=samples/2;
 Grafik(17);
 singlecolor16(15,0,16,63);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,15);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,1);

nochmal:
 if(HighSpeed) sbrec2(samples); else sbrec(samples);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+i) - (int)m; }
 fft();
 for(i=0;i<samples;i++)Buffer[i]=permute(i); //indizierter Zugriff
 _fmemset(VGAmem,0,40000);
 for(i=0;i<480;i+=2)*(VGAmem+80*i+40)=128;
 for(t=0;t<n2;t++)
    {
     n=Buffer[t];
     mode17line(t+n2+64,120,120,real[n]);
     mode17line(t+n2+64,360,120,imag[n]);
    }
 for(t=n2;t<samples;t++)
    {
     n=Buffer[t];
     mode17line(t-n2+64,120,120,real[n]);
     mode17line(t-n2+64,360,120,imag[n]);
    }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
if((i==13)||(i==32)) i='/';
return i;
}



void mode19bar8(int x,double vol)
{
 unsigned e,g;
 char far *h = VGAmem + x*3;
 vol=vol*Pegel;
 if(vol>199) vol = 199;
 g=199 - (int)vol;
 g=g*320;
 for(e=0;e<g;e+=320) *(h+e)=0, *(h+e+1)=0;
 e=235-g/320;
 for(;g<=64000;g+=320) *(h+g)=e, *(h+g+1)=e, e--;
}



int cool8()
{
 unsigned u;
 int i,t;
 double v;
 long m=0;
 samples=256;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=0;i<8000;i++) m=m+ *(aligned+i);
 m=m/8000+1;    //Zero calibration!
 Grafik(19);
 MakePalette();
nochmal:
 if(HighSpeed) sbrec2(samples); else sbrec(samples);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+i) - (int)m; }
 fft();
 for(t=0;t<107;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode19bar8(t,v);
    }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
if((i==13)||(i==32)) i='/';
return i;
}



void mode17bar(int x,double vol)
{
 unsigned e,g;
 char far *h = VGAmem + x;
 vol=vol*Pegel;
 if(vol>479) vol = 479;
 g=479 - (int)vol;
 g=g*80;
 for(e=0;e<g;e+=80)*(h+e)=0;
 for(;g<=38400;g+=80)*(h+g)=254;
}



int cool7()
{
 unsigned u;
 int i,t;
 double v;
 long m=0;
 samples=256;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=0;i<8000;i++) m=m+ *(aligned+i);
 m=m/8000+1;    //Zero calibration!
 Grafik(17);
 singlecolor16(15,0,63,0);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,15);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,1);
nochmal:
 if(HighSpeed) sbrec2(samples); else sbrec(samples);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+i) - (int)m; }
 fft();
 for(t=0;t<80;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode17bar(t,v);
    }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
if((i==13)||(i==32)) i='/';
return i;
}



void mode19bar(int x,double vol)
{
 unsigned e,g;
 char far *h = VGAmem + x*5;
 vol=vol*Pegel;
 if(vol>199) vol = 199;
 g=199 - (int)vol;
 g=g*320;
 for(e=0;e<g;e+=320) *(h+e)=0, *(h+e+1)=0, *(h+e+2)=0, *(h+e+3)=0;
 e=235-g/320;
 for(;g<=64000;g+=320) *(h+g)=e, *(h+g+1)=e, *(h+g+2)=e, *(h+g+3)=e, e--;
}



int cool6()
{
 unsigned u;
 int i,t;
 double v;
 long m=0;
 samples=128;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=0;i<8000;i++) m=m+ *(aligned+i);
 m=m/8000+1;    //Zero calibration!
 Grafik(19);
 MakePalette();
nochmal:
 if(HighSpeed) sbrec2(200); else sbrec(200);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+i+50) - (int)m; }
 fft();
 for(t=0;t<64;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode19bar(t,v);
    }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
if((i==13)||(i==32)) i='/';
return i;
}



void mode13bar(int x,double vol)
{
 unsigned e,g;
 char far *h = VGAmem + x + 4;
 vol=vol*Pegel;
 if(vol>199) vol = 199;
 g=199 - (int)vol;
 g=g*40;
 for(e=0;e<g;e+=40)*(h+e)=0;
 for(;g<=8000;g+=40)*(h+g)=254;
}



int cool5()
{
 unsigned u;
 int i,t;
 double v;
 long m=0;
 samples=64;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=0;i<8000;i++) m=m+ *(aligned+i);
 m=m/8000+1;    //Zero calibration!
 Grafik(13);
 singlecolor16(15,63,0,32);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,15);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,1);
nochmal:
 if(HighSpeed) sbrec2(200); else sbrec(200);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+i+100) - (int)m; }
 fft();
 for(t=0;t<32;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode13bar(t,v);
    }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
if((i==13)||(i==32)) i='/';
return i;
}



int coolP()
{
 unsigned u;
 int i,t;
 double v1,v2,v3,v4;
 long m=0;
 samples=32;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 Grafik(19);
 MakePalette();
 for(t=0;t<160;t++)
    {
     Linecolor=(t*0.401)+192;
     linie(160-t,100,160,100-t*0.628);
    }
 for(t=0;t<160;t++)
    {
     Linecolor=(t*0.401);
     if(Linecolor==0)Linecolor=1;
     linie(160+t,100,160,100+t*0.628);
    }
 for(t=0;t<160;t++)
    {
     Linecolor=(t*0.401)+64;
     linie(160-t,100,160,100+t*0.628);
    }
 for(t=0;t<160;t++)
    {
     Linecolor=(t*0.401)+128;
     linie(160+t,99,160,99-t*0.628);
    }
 while(dmacount()!=0xFFFF);
 for(i=0;i<8000;i++) m=m+ *(aligned+i);
 m=m/8000+1;    //Zero calibration!

nochmal:
 if(HighSpeed) sbrec2(100); else sbrec(100);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+i+50) - (int)m; }
 fft();
 v1=magnitude(0)+magnitude(1);
 v2=magnitude(2)+magnitude(3)+magnitude(4);
 v3=magnitude(5)+magnitude(6)+magnitude(7)+magnitude(4);
 v4=magnitude(8)+magnitude(9)+magnitude(10)+magnitude(11)+magnitude(12)+magnitude(13)+magnitude(14)+magnitude(15);
 v1*=Pegel, v2*=Pegel, v3*=Pegel, v4*=Pegel;
 if(v1>126)i=126; else i=v1;
 for(u=1;u<64;u++)
    {
     t=i-u;
     if(t<0)  t=0;
     if(t>63) t=63;
     Hallo[u][2]=t;
     Hallo[u][1]=0;
     Hallo[u][0]=0;
    }
 if(v2>126)i=126; else i=v2;
 for(u=0;u<64;u++)
    {
     t=i-u;
     if(t<0)  t=0;
     if(t>63) t=63;
     Hallo[u+64][2]=0;
     Hallo[u+64][1]=t;
     Hallo[u+64][0]=0;
    }
 if(v3>126)i=126; else i=v3;
 for(u=0;u<64;u++)
    {
     t=i-u;
     if(t<0)  t=0;
     if(t>63) t=63;
     Hallo[u+128][2]=t;
     Hallo[u+128][1]=0;
     Hallo[u+128][0]=t;
    }
 if(v4>126)i=126; else i=v4;
 for(u=0;u<64;u++)
    {
     t=i-u;
     if(t<0)  t=0;
     if(t>63) t=63;
     Hallo[u+192][2]=0;
     Hallo[u+192][1]=0;
     Hallo[u+192][0]=t;
    }
setvgapalette256(&Hallo);
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
if((i==13)||(i==32))
  {
   Grafik(19);
   MakePalette();
   for(u=0;u<192;u++)
      {
       Linecolor=u/3;
       if(u<3)Linecolor=1;
       linie(10,199-u,70,199-u);
       Linecolor=u/3+64;
       linie(90,199-u,150,199-u);
       Linecolor=u/3+128;
       linie(170,199-u,230,199-u);
       Linecolor=u/3+192;
       linie(250,199-u,310,199-u);
      }
   goto nochmal;
  }
return i;
}



void Menue(int o)
{
textcolor(14);
cprintf("---------------------------------------\n\r");
cprintf("Sound-Blaster 1.0 - 3.0 Visual Effects!\n\r");
cprintf("---------------------------------------\n\n\r");
textcolor(2);
cprintf("Freeware written 1994 by Lars Otte\n\n\r");
textcolor(8);
if(o)
 {
  cprintf("Samplerate=%5.0lf",FFTmax);
  if(HighSpeed)cprintf(",   HighSpeed");
  textcolor(1);
  cprintf("\n\n\r0. Oscilloscope    DIV = %1.3lfms\n\r",(8000.0/FFTmax));
  cprintf("1. Oscilloscope Effect - Points\n\r");
  cprintf("2. Oscilloscope Effect - Bars\n\r");
  cprintf("3. Oscilloscope Effect - Lines 1\n\r");
  cprintf("4. Oscilloscope Effect - Lines 2\n\n\r");
  textcolor(4);
  cprintf("5. FFT-Scope  fmax = %5.0lfHz\n\r",0.5*FFTmax);
  cprintf("6. FFT-Scope  fmax = %5.0lfHz\n\r",0.5*FFTmax);
  cprintf("7. FFT-Scope  fmax = %5.0lfHz\n\r",0.3125*FFTmax);
  cprintf("8. FFT-Scope  fmax = %5.0lfHz\n\r",0.417969*FFTmax);
  cprintf("9. FFT-Scope  fmax = %5.0lfHz\n\r",0.5*FFTmax);
  cprintf("*. FFT-Scope: Real. & Imag.\n\r");
  cprintf("/.  Visual Effect Nr. 1/2\n\n\r");
  printf("+. Increase the Samplerate (Add)\n");
  printf("-. Decrease the Samplerate (Sub)");
 }
else
    {
     printf("SoundBlaster Adress = 220h\n\n");
     printf("SoundBlaster IRQ is not used\n\n");
     printf("SoundBlaster DMA-channel = 1\n\n");
    }
}





void main()
{
 long ra,ca;
 int w=96;
directvideo=0;
clrscr();
Menue(0);
printf("Samplerate > 14999  use the Highspeed_Mode!\n\n");
printf("Samplerate: ");
scanf("%ld",&ra);
sbinit();
sbmalloc();
ca= 256L - ( 1000000L / ra);
if(ra>=15000) ca=(65536L - (256000000L / ra))>>8,HighSpeed=1;
if(HighSpeed) ra=256000000L/(65536L-(ca<<8));
else ra=1000000L/(259L-ca);
sbsettc(ca);
FFTmax=(double)ra;
Grafik(13);
Menue(1);

nochmal:
if(w==48)w=cool0();
if(w==49)w=cool1();
if(w==50)w=cool2();
if(w==51)w=cool3();
if(w==52)w=cool4();
if(w==53)w=cool5();
if(w==54)w=cool6();
if(w==55)w=cool7();
if(w==56)w=cool8();
if(w==57)w=coolM();
if(w=='*')w=cool9();
if(w=='/')w=coolP();
if(w=='+')
         {
          ca=ca&255;
          ca++;
          HighSpeed=0;
          if(ca>189)HighSpeed=1;
          if(HighSpeed) ra=256000000L/(65536L-(ca<<8));
          else ra=1000000L/(259L-ca);
          FFTmax=(double)ra;
          sbsettc(ca);
          if(ra>100000)ca--;
         }
if(w=='-')
         {
          ca=ca&255;
          if(ca>0)ca--;
          HighSpeed=0;
          if(ca>189)HighSpeed=1;
          if(HighSpeed) ra=256000000L/(65536L-(ca<<8));
          else ra=1000000L/(259L-ca);
          FFTmax=(double)ra;
          sbsettc(ca);
         }
Grafik(13);
Menue(1);
if(w==0){gotoxy(1,7); printf("<+> Increase Volume, <-> Decrease Volume"); delay(1000);}
if((w<'0')||(w>'9'))w=getch();
if(w!=27)goto nochmal;

Grafik(-1);
Menue(0);
printf("Screenwidth-Time:   0 = %lds,   1/2/3 = %lds,   4 = %lds\n\n",640000000L/ra,320000000L/ra,160000000L/ra);
printf("DIV = %lds,    bigDIV = %lds\n\n",8000000L/ra,32000000L/ra);
printf("Samplerate=%ld, Timerconst=%ld\n\n",ra,ca);
if(HighSpeed)printf("Highspeed_Mode = On\n"); else printf("Highspeed_Mode = Off\n");
}

