#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <string.h>
#include <mem.h>
#include <math.h>
#define	TWO_PI	((double)2.0 * M_PI)

typedef unsigned char DacPalette256[256][3];
unsigned char far *VGAmem;
struct text_info tiGFX;
struct REGPACK regp;
union  REGS reg;
int Linecolor=1,WritePage=0,HighSpeed=0,Triggerbuffer=999;
int minX=0,minY=0,maxx=320,maxy=200;

DacPalette256 Hallo;

/* Globals */

int	samples, power;
double	real[2048], imag[2048], max, min, Pegel=10,FFTmax;
FILE	*fpi, *fpo;
int Kanal=0,Kanalmax=15;
int KanalP[]={8,8};

/* Prototypes and forward declarations */

void	fft(void);
int	permute(int);
double	magnitude(int);
void dspwrite ( unsigned char );
unsigned char dspread ( void );
unsigned Buffer[2048];
unsigned SBuffer[8900];
unsigned char far *data;
unsigned char far *aligned;
unsigned char far aligned_physical;



/* Setvgapalette256 sets the entire 256 color palette */
/* PalBuf contains RGB values for all 256 colors      */
/* R,G,B values range from 0 to 63	              */
/* Usage:					      */
/*  DacPalette256 dac256;			      */
/*						      */
/* setvgapalette256(&dac256);			      */
void setvgapalette256(DacPalette256 *PalBuf)
{
  regp.r_ax = 0x1012;
  regp.r_bx = 0;
  regp.r_cx = 256;
  regp.r_es = FP_SEG(PalBuf);
  regp.r_dx = FP_OFF(PalBuf);
  intr(0x10,&regp);
}



void Grafik(int GFXmode)  // 13,      14,     17mono,   18,      19vga,  -1,3
{                         //320x200, 640x200, 640x480, 640x480, 320x200, text
VGAmem=(char far *)MK_FP(0xa000,0);
if (GFXmode>=0)
  {
   gettextinfo(&tiGFX);
   regp.r_ax = GFXmode;
   intr(0x10,&regp);
  }
if (GFXmode<0)
  {
   regp.r_ax = tiGFX.currmode;
   intr(0x10,&regp);
  }
}



void Putpixel(int x, int y)
{
 reg.h.ah = 0x0c;
 reg.h.al = Linecolor;
 reg.h.bh = WritePage;
 reg.x.cx = x;
 reg.x.dx = y;
 int86(0x10,&reg,&reg);
}



void singlecolor256(int nr,int r,int g,int b)
{
 reg.h.ah = 0x10;
 reg.h.al = 0x10;
 reg.x.bx = nr;
 reg.h.ch = g;
 reg.h.cl = b;
 reg.h.dh = r;
 int86(0x10,&reg,&reg);
}



void singlecolor16(int nr,int r,int g,int b)
{
 reg.h.ah=0x10;
 reg.h.al=0x07;
 reg.h.bl=nr;
 int86(0x10,&reg,&reg);
 nr=reg.h.bh;
 reg.h.ah = 0x10;
 reg.h.al = 0x10;
 reg.x.bx = nr;
 reg.h.ch = g;
 reg.h.cl = b;
 reg.h.dh = r;
 int86(0x10,&reg,&reg);
}




void MakePalette()
{
 int frag;
 for(frag=0;frag<256;frag++)
   {
    if(frag<32)
	       {
		Hallo[frag][0]=0;
		Hallo[frag][1]=0;
		Hallo[frag][2]=2*frag;
	       }
    if((frag>=32)&&(frag<96))
			     {
			      Hallo[frag][0]=0;
			      Hallo[frag][1]=(frag-32);
			      Hallo[frag][2]=(95-frag);
			     }
    if((frag>=96)&&(frag<128))
			      {
			       Hallo[frag][0]=2*(frag-96);
			       Hallo[frag][1]=63;
			       Hallo[frag][2]=0;
			      }
    if((frag>=128)&&(frag<192))
			       {
				Hallo[frag][0]=63;
				Hallo[frag][1]=(191-frag);
				Hallo[frag][2]=(frag-128);
			       }
    if(frag>=192)
   	         {
	          Hallo[frag][0]=63;
		  Hallo[frag][1]=0;
		  Hallo[frag][2]=0;
		  if(frag<223)Hallo[frag][2]=2*(222-frag);
	         }
   }
 setvgapalette256(&Hallo);
}


//------------------------------------------------------------------------------
void dspwrite ( unsigned char c )
{
    while(inportb(0x022C)&0x80);
    outportb(0x022C,c);
}
//------------------------------------------------------------------------------
void sbinit ( void )
{
    unsigned short x;
    inportb(0x022E);
    outportb(0x0226,0x01);
    inportb(0x0226);
    inportb(0x0226);
    inportb(0x0226);
    inportb(0x0226);
    outportb(0x0226,0x00);
    for(x=0;x<100;x++)
    {
        if(inportb(0x022E)&0x80)
        {
            if(inportb(0x022A)==0xAA) break;
        }
    }
    //if(x==100)
    //{
    //    printf("Sound Blaster not found at 0220h\n");
    //    exit(1);
    //}
}
//------------------------------------------------------------------------------
void sbmalloc ( void )
{
    unsigned long physical;
    data=farmalloc(80000L);
    if(data==NULL)
    {
        printf("Memory Allocation Error\n");
        exit(1);
    }
    physical=((unsigned long)FP_OFF(data))+(((unsigned long)FP_SEG(data))<<4);
    physical+=0x0FFFFL;
    physical&=0xF0000L;
    aligned_physical=(physical>>16)&15;
    aligned=MK_FP(((unsigned short)aligned_physical<<12)&0xF000,0);
}
//------------------------------------------------------------------------------
void sbsettc ( unsigned char tc )
// tc = time constant = 256L - (1000000UL/samples per second)
{
    inportb(0x022E);
    dspwrite(0x40);
    dspwrite(tc);
}
//------------------------------------------------------------------------------
void sbrec ( unsigned short len )
// len = number of bytes to record to unsigned char *aligned (<=65000)
{
    len--;
    outportb(0x0A,0x05);
    outportb(0x0C,0x00);
    outportb(0x0B,0x45);
    outportb(0x02,0);
    outportb(0x02,0);
    outportb(0x83,aligned_physical);
    outportb(0x03,(unsigned char)(len&0xFF));
    outportb(0x03,(unsigned char)((len>>8)&0xFF));
    outportb(0x0A,0x01);
    dspwrite(0x24);
    dspwrite((unsigned char)(len&0xFF));
    dspwrite((unsigned char)((len>>8)&0xFF));
}
//------------------------------------------------------------------------------
void sbrec2 ( unsigned short len )
// len = number of bytes to record to unsigned char *aligned (<=65000)
{
    len--;
    outportb(0x0A,0x05);
    outportb(0x0C,0x00);
    outportb(0x0B,0x45);
    outportb(0x02,0);
    outportb(0x02,0);
    outportb(0x83,aligned_physical);
    outportb(0x03,(unsigned char)(len&0xFF));
    outportb(0x03,(unsigned char)((len>>8)&0xFF));
    outportb(0x0A,0x01);
    dspwrite(0x48);
    dspwrite((unsigned char)(len&0xFF));
    dspwrite((unsigned char)((len>>8)&0xFF));
    dspwrite(0x99);
}
//------------------------------------------------------------------------------
unsigned short dmacount ( void )
{
    unsigned short x;
    x=inportb(0x03);
    x|=inportb(0x03)<<8;
    if(x==0xFFFF) inportb(0x022E);
    return(x);
}
//------------------------------------------------------------------------------
void recording(int e,int f)
{
 int m,n=Triggerbuffer -e,o;
 int Smax=0,Spos=0;
 if(HighSpeed)sbrec2(Triggerbuffer); else sbrec(Triggerbuffer);
 while(dmacount()!=0xFFFF);
 for(m=0;m<n;m++)
    {
     o= *(aligned+m);
     if(o>Smax)Smax=o,Spos=m;
    }
 if(f>0)for(m=0;m<e;m++)
           {
            o = *(aligned+Spos+m) - f;
            if(o<0)o=0;
            if(o>199)o=199;
            SBuffer[m]=o;
           }
 else for(m=0;m<e;m++)SBuffer[m] = *(aligned+Spos+m) - f;
}



void lineX00(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-1,v,w=abs(dy);
 if(w<2)
        {
         *(VGAmem+((x-1)>>3)+80*y1)&=255-(1<<(7-((x-1)&7)));
         *(VGAmem+(x>>3)+80*y2)&=255-(1<<(7-(x&7)));
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=v-y1;
              w /=dy;
              *(VGAmem+((m+w)>>3)+80*v)&=255-(1<<(7-((m+w)&7)));
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=v-y2;
          w /=dy;
          *(VGAmem+((x-w)>>3)+80*v)&=255-(1<<(7-((x-w)&7)));
         }
     }
}



void lineX01(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-1,v,w=abs(dy);
 if(w<2)
        {
         *(VGAmem+((x-1)>>3)+80*y1)|=1<<(7-((x-1)&7));
         *(VGAmem+(x>>3)+80*y2)|=1<<(7-(x&7));
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=v-y1;
              w /=dy;
              *(VGAmem+((m+w)>>3)+80*v)|=1<<(7-((m+w)&7));
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=v-y2;
          w /=dy;
          *(VGAmem+((x-w)>>3)+80*v)|=1<<(7-((x-w)&7));
         }
     }
}



int cool0()
{
unsigned t;
int i,m=Triggerbuffer;
Triggerbuffer=1500;
Grafik(18);
for(i=0;i<640;i++)Buffer[i]=0;
Linecolor=2;
for(i=0;i<640;i+=64)for(t=124;t<128;t+=2)Putpixel(i,t);
for(i=0;i<640;i+=8)for(t=128;t<385;t+=2)Putpixel(i,t);
for(i=128;i<385;i+=8)for(t=0;t<633;t+=2)Putpixel(t,i);
Linecolor=6;
for(i=128;i<385;i+=32)for(t=0;t<640;t+=2)Putpixel(t,i);
for(i=0;i<640;i+=32)for(t=128;t<385;t+=2)Putpixel(i,t);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,1);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,0);
singlecolor16(1,63,63,63);
nochmal:
    recording(640,(-128));
    lineX00(1,Buffer[0],Buffer[1]);
    for(i=1;i<640;i++)
                      {
                       lineX00(i+1,Buffer[i],Buffer[i+1]);
                       lineX01(i,SBuffer[i-1],SBuffer[i]);
                      }
    for(i=0;i<640;i++)Buffer[i]=SBuffer[i];
    if(!kbhit())goto nochmal;
i=getch();
if(i==13) { getch(); goto nochmal; }
Triggerbuffer=m;
return i;
}



void lineX11(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-2,v,w=abs(dy);
 if(w<3)
        {
         m=(y1+y2)/2;
         *(VGAmem+((x-2)>>3)+80*y1)|=1<<(7-((x-2)&7));
         *(VGAmem+((x-1)>>3)+80*m)|=1<<(7-((x-1)&7));
         *(VGAmem+((x)>>3)+80*y2)|=1<<(7-((x)&7));
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=(v-y1)*2;
              w /=dy;
              *(VGAmem+((m+w)>>3)+80*v)|=1<<(7-((m+w)&7));
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=(v-y2)*2;
          w /=dy;
          *(VGAmem+((x-w)>>3)+80*v)|=1<<(7-((x-w)&7));
         }
     }
}



void lineX10(int x,int y1,int y2)
{
 int dy=y1-y2;
 int m=x-2,v,w=abs(dy);
 if(w<3)
        {
         m=(y1+y2)/2;
         *(VGAmem+((x-2)>>3)+80*(y1))&=255-(1<<(7-((x-2)&7)));
         *(VGAmem+((x-1)>>3)+80*(m))&=255-(1<<(7-((x-1)&7)));
         *(VGAmem+((x)>>3)+80*(y2))&=255-(1<<(7-((x)&7)));
         return;
        }
 if(dy<0)
         {
          dy=w;
          for(v=y1;v<=y2;v++)
             {
              w=(v-y1)*2;
              w /=dy;
              *(VGAmem+((m+w)>>3)+80*v)&=255-(1<<(7-((m+w)&7)));
             }
         }
 else
     {
      for(v=y2;v<=y1;v++)
         {
          w=(v-y2)*2;
          w /=dy;
          *(VGAmem+((x-w)>>3)+80*v)&=255-(1<<(7-((x-w)&7)));
         }
     }
}




int cool1()
{
unsigned t;
int i,m=Triggerbuffer;
Triggerbuffer=1000;
Grafik(18);
for(i=0;i<640;i++)Buffer[i]=0;
Linecolor=2;
for(i=0;i<640;i+=64)for(t=124;t<128;t+=2)Putpixel(i,t);
for(i=0;i<640;i+=8)for(t=128;t<385;t+=2)Putpixel(i,t);
for(i=128;i<385;i+=8)for(t=0;t<633;t+=2)Putpixel(t,i);
Linecolor=6;
for(i=128;i<385;i+=32)for(t=0;t<640;t+=2)Putpixel(t,i);
for(i=0;i<640;i+=32)for(t=128;t<385;t+=2)Putpixel(i,t);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,1);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,0);
singlecolor16(1,63,63,63);
nochmal:
    recording(640,(-128));
    lineX10(2,Buffer[0],Buffer[1]);
    for(i=2;i<640;i+=2)
                      {
                       lineX10(i+2,Buffer[i/2],Buffer[i/2+1]);
                       lineX11(i,SBuffer[i/2-1],SBuffer[i/2]);
                      }
    for(i=0;i<640;i++)Buffer[i]=SBuffer[i];
    if(!kbhit())goto nochmal;
i=getch();
if(i==13) { getch(); goto nochmal; }
Triggerbuffer=m;
return i;
}




//----------------------------------------------------------------------------


/* The program */
//samples = How many Real/Imag Numbers...
//power =  log10((double)samples) / log10((double)2.0);


void fft()
{
	unsigned i1, i2, i3, i4, y;
	int	 loop, loop1, loop2;
	double	 a1, a2, b1, b2, z1, z2, v;

	/* Scale the data */

	for (loop = 0; loop < samples; loop++)  {
		real[loop] /= (double)samples;
		imag[loop] /= (double)samples;
	}

	i1 = samples >> 1;
	i2 = 1;
	v = TWO_PI * ((double)1.0 / (double)samples);

	for (loop = 0; loop < power; loop++)  {
		i3 = 0;
		i4 = i1;

		for (loop1 = 0; loop1 < i2; loop1++)  {
			y = permute(i3 / i1);
			z1 =  cos(v * y);
			z2 = -sin(v * y);

			for (loop2 = i3; loop2 < i4; loop2++)  {
				a1 = real[loop2];
				a2 = imag[loop2];

				b1 = z1*real[loop2+i1] - z2*imag[loop2+i1];
				b2 = z2*real[loop2+i1] + z1*imag[loop2+i1];

				real[loop2]      = a1 + b1;
				imag[loop2]      = a2 + b2;

				real[loop2 + i1] = a1 - b1;
				imag[loop2 + i1] = a2 - b2;
			}

			i3 += (i1 << 1);
			i4 += (i1 << 1);
		}

		i1 >>= 1;
		i2 <<= 1;
	}
}


/*
 *	Calculate Power Magnitude
 */

double magnitude(int n)
{
	n = permute(n);  //get position
	return (sqrt(real[n] * real[n] + imag[n] * imag[n]));
}

/*
 *	Bit reverse the number
 *
 *	Change 11100000b to 00000111b or vice-versa
 */

int permute(int index)   //give back the position of Freqency in real[],imag[]
{
	int  n1, result, loop;
	n1 = samples;
	result = 0;
	for (loop = 0; loop < power; loop++)
               {
		n1 >>= 1;			/* n1 / 2.0 */
		if (index < n1)continue;
		result += (int) pow((double)2.0, (double)loop);
		index -= n1;
	       }
	return result;
}



void windows()
{
 int t;
 double w = 2.0 * M_PI / samples;
 double p90 = M_PI / 2.0;
 for(t=0;t<samples;t++) real[t]*=(1.0+sin(w*t-p90));   //cos!
}
//---------------------------------------------------------------------------



void mode17line(int x,unsigned y0,int yy,double vol)
{
 unsigned e,f,g;
 char far *h = VGAmem + x/8;
 vol=vol*Pegel;
 if(vol<(-119.0))vol=-119.0;
 if(vol>yy) vol = yy;
 f=y0 - (int)vol;
 x=1<<(7-(x&7));
 e=80*y0;
 f=80*f;
 if(e>f) g=e,e=f,f=g;
 for(g=e;g<=f;g+=80)*(h+g)|=x;
}



int cool9()
{
 int i,t,n,n2;
 long m=0;
 samples=512;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=500;i<8000;i++) m=m+ *(aligned+i);
 m=m/7500+1;    //Zero calibration!
 n2=samples/2;
 Grafik(17);
 singlecolor16(15,0,16,63);
nochmal:
 if(HighSpeed) sbrec2(samples); else sbrec(samples);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+i) - (int)m; }
 windows();
 fft();
 for(i=0;i<samples;i++)Buffer[i]=permute(i); //indizierter Zugriff
 _fmemset(VGAmem,0,40000);
 for(i=0;i<480;i+=2)*(VGAmem+80*i+40)=128;
 for(t=0;t<n2;t++)
    {
     n=Buffer[t];
     mode17line(t+n2+64,120,120,real[n]);
     mode17line(t+n2+64,360,120,imag[n]);
    }
 for(t=n2;t<samples;t++)
    {
     n=Buffer[t];
     mode17line(t-n2+64,120,120,real[n]);
     mode17line(t-n2+64,360,120,imag[n]);
    }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
return i;
}



int cool5()
{
 int i,t,n,n2;
 long m=0;
 samples=1024;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=500;i<8000;i++) m=m+ *(aligned+i);
 m=m/7500+1;    //Zero calibration!
 n2=samples/2;
 Grafik(17);
 singlecolor16(15,63,63,0);
nochmal:
 if(HighSpeed) sbrec2(samples); else sbrec(samples);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+i) - (int)m; }
 windows();
 fft();
 for(i=0;i<n2;i++)Buffer[i]=permute(i); //indizierter Zugriff
 for(i=0;i<n2;i++)
    {
     t=permute(i);
     real[1200+i]=sqrt(real[t] * real[t] + imag[t] * imag[t]);
     if(imag[t]==0.0)imag[t]=1e-99;
     if(real[t]==0.0)real[t]=1e-99;
     imag[1200+i]=18.0*atan2(imag[t],real[t])/Pegel;
    }
 _fmemset(VGAmem,0,40000);
 for(t=0;t<n2;t++)
    {
     mode17line(t+64,350,350,real[1200+t]);
     mode17line(t+64,420,60,imag[1200+t]);
    }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
return i;
}



int cool8()
{
 unsigned u;
 int i,t;
 double v,REal,IMag,w,Zeit;
 long m=0;
 samples=1024;
 Pegel=10;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 Grafik(18);
textcolor(4);
gotoxy(1,1); cprintf("10Hz");
gotoxy(23,1); cprintf("100Hz");
gotoxy(45,1); cprintf("1kHz");
gotoxy(67,1); cprintf("10kHz");
for(i=0;i<640;i++)Buffer[i]=0;
Linecolor=2;
for(i=0;i<4;i++)
   {
    for(t=0;t<480;t+=4)Putpixel(i*176+53,t);
    if(i<3)for(t=0;t<480;t+=4)Putpixel(i*176+123,t);
   }
for(i=0;i<480;i+=20)for(t=0;t<640;t+=4)Putpixel(t,i);
Linecolor=6;
for(i=0;i<640;i+=176)for(t=0;t<480;t+=2)Putpixel(i,t);
i=outp(0x3c4,2);
i^=255;
i=outp(0x3c5,1);
i^=255;
i=outp(0x3ce,4);
i^=255;
i=outp(0x3cf,0);
singlecolor16(1,63,63,63);
while(dmacount()!=0xFFFF);
for(i=500;i<8000;i++) m=m+ *(aligned+i);
m=m/7500+1;    //Zero calibration!
u=(unsigned)(176.0*(log10(FFTmax/2.0)-1.0));
nochmal:

 if(HighSpeed) sbrec2(samples); else sbrec(samples);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) real[i] = (*(aligned+i) - (int)m);
 windows();
 for(t=0;t<=u;t++)
    {
     v = 1.0 + (((double)t) / 176.0);
     w = 2 * M_PI * pow(10.0,v) /FFTmax;
     REal = 0.0;
     IMag = 0.0;
     for(i=0;i<samples;i++)
        {
         Zeit = w * (double)i;
         REal += real[i] * cos(Zeit);
         IMag -= real[i] * sin(Zeit);
        }
     imag[t] = sqrt(REal*REal + IMag*IMag);
    }
max=1e-10;
min=1e+10;
for(t=0;t<=u;t++)
   {
    if(imag[t]>max)max=imag[t];
    if(imag[t]<min)min=imag[t];
   }
v=48.0/max;
_fmemset(VGAmem,0,40000);
for(t=0;t<=u;t++)
   {
    mode17line(t,479,479,v*imag[t]);
   }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
return i;
}



void mode17bar(int x,double vol)
{
 unsigned e,g;
 char far *h = VGAmem + x;
 vol=vol*Pegel;
 if(vol>479) vol = 479;
 g=479 - (int)vol;
 g=g*80;
 for(e=0;e<g;e+=80)*(h+e)=0;
 for(;g<=38400;g+=80)*(h+g)=254;
}



int cool7()
{
 unsigned u;
 int i,t;
 double v;
 long m=0;
 samples=256;
 power =  log10((double)samples) / log10((double)2.0);
 if(HighSpeed) sbrec2(8000);    else sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=500;i<8000;i++) m=m+ *(aligned+i);
 m=m/7500+1;    //Zero calibration!
 Grafik(17);
 singlecolor16(15,0,63,0);
nochmal:
 if(HighSpeed) sbrec2(samples); else sbrec(samples);
 while(dmacount()!=0xFFFF);
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+i) - (int)m; }
 windows();
 fft();
 for(t=0;t<80;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     mode17bar(t,v);
    }
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
return i;
}



void Menue(int o)
{
printf("--------------------------------------\n");
printf("Sound-Blaster 1.0 - 3.0  SMALL - FFT !\n");
printf("--------------------------------------\n\n");
printf("Freeware written 1994 by Lars Otte\n\n\n\n");
if(o)
 {
  printf("3. Trigger-Oszilloscope !!!\n\n");
  printf("4. Trigger-Oszilloscope Zoom=2\n\n");
  printf("5. Betrag und Phasen Spektrum\n\n");
  printf("7.FFT-Analysator fmax=0.3125*Samplerate\n\n");
  printf("8. Fourier-Transformation: Spectrum\n\n");
  printf("9. FFT-Analysator: Real. & Imag.");
 }
else
    {
     printf("SoundBlaster Adress = 220h\n\n");
     printf("SoundBlaster IRQ is not used\n\n");
     printf("SoundBlaster DMA-channel = 1\n\n");
    }
}



void main()
{
 long ra,ca;
 int w=32;
directvideo=0;
clrscr();
Menue(0);
printf("Samplerate > 14999  use the Highspeed_Mode!\n\n");
printf("Samplerate: ");
scanf("%ld",&ra);
sbinit();
sbmalloc();
ca= 256L - ( 1000000L / ra);
if(ra>=15000) ca=(65536L - (256000000L / ra))>>8,HighSpeed=1;
if(HighSpeed) ra=256000000L/(65536L-(ca<<8));
else ra=1000000L/(259L-ca);
FFTmax=ra;
sbsettc(ca);
Grafik(13);
Menue(1);

nochmal:
if(w==51)w=cool0();
if(w==52)w=cool1();
if(w==53)w=cool5();
if(w==54)w=getch();
if(w==55)w=cool7();
if(w==56)w=cool8();
if(w==57)w=cool9();
Grafik(13);
Menue(1);
if((w<'3')||(w>'9'))w=getch();
if(w!=27)goto nochmal;

Grafik(-1);
Menue(0);
printf("Screenwidth-Time:   0 = %lds,   1/2/3 = %lds,   4 = %lds\n\n",640000000L/ra,320000000L/ra,160000000L/ra);
printf("DIV = %lds,    big_DIV = %lds\n\n",8000000L/ra,32000000L/ra);
printf("Samplerate=%ld, Timerconst=%ld\n\n",ra,ca);
if(HighSpeed)printf("Highspeed_Mode = On\n"); else printf("Highspeed_Mode = Off\n");
}

