/* BEGIN DAVID LAI COPYRIGHT ********************************************* */
/*
(C) Copyright David Lai 1993, 1994.  All rights reserved.

The source code is copyright by David Lai, however it is freely
distributable and released for unrestricted use.  Users may copy or modify 
this source code without charge, provided all copyright
notices remain intact in all the source code.  Portions of the source code
copyright by their respective copyright holders and are covered
under different agreements, however the source code used has
specifically been marked distributable royalty-free.

You can do whatever you want with it, even charge money for it, if
you find a sucker willing to pay for it.  This is not shareware, the program
is not crippled in any way, do not send money.  You can e-mail comments
to the electronic mail address below, or fax to the fax number below.

If you add a feature thats useful, or do a new port, you can send
the context diffs to the e-mail address below.  I may include it in
subsequent releases.  Your code must specifically be marked
freely distributable, I will not include code marked otherwise.

THE SOURCE CODE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.

The source code is provided with no support and without any obligation on
the part of David Lai to assist in its use, correction,
modification or enhancement.

DAVID LAI SHALL HAVE NO LIABILITY WITH RESPECT TO THE
INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS SOFTWARE
OR ANY PART THEREOF.

In no event will David Lai be liable for any lost revenue
or profits or other special, indirect and consequential damages, even if
David Lai has been advised of the possibility of such damages.

David Lai
1370 McKendrie St
San Jose, CA 95126
fax: 408-241-4615

lai%fastfood@daver.bungi.com

*/
/* END   DAVID LAI COPYRIGHT ********************************************* */

/* wave file I/O */

#include "misc.h"
#include "modcomp.h"
#include "wav.h"

#ifdef __STDC__
FILE * wav_write( signed char *sample_data, struct sample *sample_info,
		uint32 sample_rate, int info_flag)
#else
FILE * wav_write( sample_data, sample_info, sample_rate, info_flag)
 signed char *sample_data; struct sample *sample_info; uint32 sample_rate;
 int info_flag;
#endif
 {
 /* write the sample as a .wav file */
 /* In Microsoft syntax: 
	RIFF ( 'WAVE'
		   fmt(1, 1, sample_rate, sample_rate, 1, 8)
		   data (sample_data) 
		   INFO( INAM(sample_name) ISFT("Wave Compiler v. nn.n"Z)
			 ICMT("Volume: vv Finetune: ff RepeatOffset: ooo RepeatLength: lll"Z))
		)
		
		The INFO chunk is optional

	Note: The default sample rate is 16574Hz, the sample rate of a C-3
	      period, which is the
	      de-facto standard sampling rate for mod samples.  However
	      some systems may have problems playing at this rate.  In
	      these situations you may want to convert to a more
	      standard rate, like 11025, you can specify a command line
	      option, or use sox, or some other conversion package.

	      sample_data will be written in 8-bit unsigned format.
 */
 FILE *fw;
 uint32 wave_size, isiz, dsiz, fsiz, chunk_header_siz;
 uint32 inam_siz, isft_siz, icmt_siz, list_header_siz, riff_header_siz, info_size;
 char comment[100];
 PCMWAVEFORMAT fmt;
 if (sample_info->sample_filename ==NULL)
	err_exit("No filename specified for .wav write", NULL);
 if ((fw = fopen(sample_info->sample_filename, WRITEBINARY))==NULL)
	err_exit("Cant create %s", sample_info->sample_filename);
 /* calculate the sizes of the various chunks */
 /* common chunk header size */
 chunk_header_siz = 8;
 list_header_siz = chunk_header_siz + 4; /* standard header + list type */
 riff_header_siz = chunk_header_siz + 4; /* standard header + form type */

 /* data, fmt, and riff chunks are always required - info optional */
 /* wave data */
 dsiz = (unsigned long)sample_info->length * 2 - 2;
 /* fmt */
 fsiz = sizeof(PCMWAVEFORMAT);
if (info_flag) 
 {
 /* info */
 inam_siz = (strlen(sample_info-> name)+1);
 isft_siz = (strlen(PRODUCT_ID)+1);
 sprintf(comment,"Volume: %d Finetune: %d RepeatOffset: %u RepeatLength: %u", sample_info->volume, sample_info-> finetune, sample_info->rpt_offset, sample_info->rpt_length);
 icmt_siz = (strlen(comment)+1);
 isiz = EVEN(inam_siz) + EVEN(isft_siz)  + EVEN(icmt_siz) + 3 * chunk_header_siz;
 info_size = isiz + list_header_siz;
 }
else
 {
 info_size = 0;
 }
 wave_size = info_size + EVEN(dsiz) + EVEN(fsiz) + 2 * chunk_header_siz + riff_header_siz;

 /* now write the file */
 wllong(fw, cc4_RIFF);	/* RIFF (WAVE */
 wllong(fw, wave_size-chunk_header_siz); /* size doesn't include standard header */
 wllong(fw,cc4_WAVE);
 fmt.wFormatTag = WAVE_FORMAT_PCM;
 fmt.nChannels = 1;
 fmt.nSamplesPerSec = sample_rate;
 fmt.wBitsPerSample = 8;
 fmt.nBlockAlign = fmt.nChannels * ((fmt.wBitsPerSample+7) / 8 );
 fmt.nAvgBytesPerSec = fmt.nChannels * ((fmt.wBitsPerSample+7) / 8) * sample_rate;
 wllong(fw, cc4_fmt);	/* fmt(1, 1, sample_rate, sample_rate, 1, 8) */
 wllong(fw,fsiz);
 wlshort(fw,fmt.wFormatTag);
 wlshort(fw,fmt.nChannels);
 wllong(fw,fmt.nSamplesPerSec);
 wllong(fw,fmt.nAvgBytesPerSec);
 wlshort(fw,fmt.nBlockAlign);
 wlshort(fw,fmt.wBitsPerSample);
 wllong(fw, cc4_data);	/* data (sample_data)) */
 wllong(fw, dsiz);

 /* the data is in memory or in the file at the indicated offset */
 /* we defer writes to the write_continue */
 return fw;
 }

#ifdef __STDC__
void wav_write_final( FILE *fw, struct sample *sample_info,
		uint32 sample_rate, int info_flag)
#else
void wav_write_final( fw, sample_info, sample_rate, info_flag)
 FILE * fw; struct sample *sample_info; uint32 sample_rate;
 int info_flag;
#endif
 {
 /* finish writing the sample as a .wav file */
 /* in our case we write the INFO list if requested */
 uint32 isiz, chunk_header_siz;
 uint32 inam_siz, isft_siz, icmt_siz, list_header_siz, info_size;
 char comment[100];
 chunk_header_siz = 8;
 list_header_siz = chunk_header_siz + 4; /* standard header + list type */
if (info_flag) 
  {
  /* info */
  inam_siz = (strlen(sample_info-> name)+1);
  isft_siz = (strlen(PRODUCT_ID)+1);
  sprintf(comment,"Volume: %d Finetune: %d RepeatOffset: %u RepeatLength: %u", sample_info->volume, sample_info-> finetune, sample_info->rpt_offset, sample_info->rpt_length);
  icmt_siz = (strlen(comment)+1);
  isiz = EVEN(inam_siz) + EVEN(isft_siz)  + EVEN(icmt_siz) + 3 * chunk_header_siz;
  info_size = isiz + list_header_siz;
  wllong(fw, cc4_LIST);	/* LIST INFO ( */
  wllong(fw, info_size - chunk_header_siz);
  wllong(fw, cc4_INFO);
  wllong(fw, cc4_INAM);	/* INAM(sample_name) */
  wllong(fw, inam_siz);
  wezstr(fw, sample_info-> name);
  wllong(fw, cc4_ISFT);	/* ISFT("Wave Compiler v. nn.n"Z) */
  wllong(fw, isft_siz);
  wezstr(fw, PRODUCT_ID);
  wllong(fw, cc4_ICMT);	/* ICMT("Volume: vv Finetune: ff RepeatOffset: ooo RepeatLength: lll"Z)) */
  wllong(fw, icmt_siz);
  wezstr(fw, comment);
  }
 }

static char rcs_id[]="$Id: wav.c,v 1.1 1994/03/19 09:21:31 dlai Exp $";

#if 0
$Log: wav.c,v $
 * Revision 1.1  1994/03/19  09:21:31  dlai
 * Initial revision
 *

#endif
