/* Warning! This C source contains extended characters! */

#define VERSION      "1.1" /* MUSIQUE version number */
#define TRUE             1
#define FALSE            0
#define DISKNAMELENGTH   2 /* from 1 to 99 should be enough */
#define SCORELENGTH      2 /* I guess -  + and NP (no play) would cover it */
#define DOSNAMELENGTH    8 /* don't put in the extension .MOD or .ZIP */
#define SONGNAMELENGTH  19 /* according to module specs without EOS */
#define LINELENGTH     128 /* maximum length of most strings */
#define MAXSONGS       350 /* maximum number of songs */
#define PATHLENGTH   25000 /* size of the pool of DOS paths */ 
#define BUFFERSIZE    8192 /* big enough since PATHLENGTH is more important */
#define PORT1        0x3BC /* parallel ports in the standard BIOS order */
#define PORT2        0x378
#define PORT3        0x278
#define HIGHINT        0x8 /* high intensity mask */
#define SCROLLDELAY      2 /* in 10msec */ 
#define SHUTUPDELAY      2 /* in msec */
#define NOTFOUNDDELAY  500 /* in msec */
#define SNDFREQ        300 /* in Herz */
#define SNDLENGTH       10 /* in msec */
#define LANGUAGENUMBER   3 /* how many languages supported in current version */
#define FRENCH           0
#define ENGLISH          1
#define GERMAN           2
#define XRATIO           8 /* motion/pixel mouse ratios */
#define YRATIO           8
#define ODDDRIVE        -1 /* indicates drive not set yet */
#define ODDPORTS      '\0' /* indicates ports not set yet */
#define ODDMODE        -24 /* indicates video mode not set yet */
#define ODDPATH        "." /* indicates no DOS path supplied */
#define COMMENTFLAG    '%'
#define FLAG1          '/' /* DOS style */
#define FLAG2          '-' /* UNIX style */
#define TEMPFLAG       'T' /* temporary drive letter follows */
#define PAUSEFLAG      'P' /* pause before shelling for debugging */
#define MODEFLAG       'I' /* for telling the video mode to be used */
#define ENGLISHFLAG    'E' /* english */
#define GERMANFLAG     'D' /* deutsch */
#define FRENCHFLAG     'F' /* french*/
#define COLORFLAG      'K' /* user defined color */
#define QUESTIONFLAG   '?' /* syntax please */
#define MOUSEFLAG      'M' /* use mouse as well */
#define BIOSFLAG       'O' /* use BIOS calls only */
#define NOPORTFLAG     '0' /* number of each parallel port present */
#define PORT1FLAG      '1'
#define PORT2FLAG      '2'
#define PORT3FLAG      '3'
#define HIGHFLAG       'H' /* high intensity for display */
#define VERBOSEFLAG    'V' /* display all fields in menu */
#define DOSFLAG        'N' /* display only DOS file name in menu */
#define SONGFLAG       'S' /* display only song name in menu */
#define SPEED1FLAG     'A' /* speed control for ModPlay */
#define SPEED2FLAG     'B'
#define SPEED3FLAG     'C'
#define DEFAULTSPEED  "/b" /* must use small letter */
#define KEYENTER    0x1C0D /* scan code & ASCII code */
#define KEYSPACE    0x3920
#define KEYESC      0x011B
#define KEYPGUP     0x4900
#define KEYPGDN     0x5100
#define KEYLEFT     0x4B00
#define KEYRIGHT    0x4D00
#define KEYUP       0x4800
#define KEYDOWN     0x5000
#define KEYHOME     0x4700
#define KEYEND      0x4F00
#define SKEYPGUP    0x4939
#define SKEYPGDN    0x5133
#define SKEYLEFT    0x4B34
#define SKEYRIGHT   0x4D36
#define SKEYUP      0x4838
#define SKEYDOWN    0x5032
#define SKEYHOME    0x4737
#define SKEYEND     0x4F31
#define SKEYCENTER  0x4C35
#define KEYATSLASH  0x0340
#define KEYSTAR1    0x092A
#define KEYSTAR2    0x372A
#define DEFAULTMENU "musique"
#define PGUP        " Pg Up "
#define PGDN        " Pg Dn "
#define MODPLAY0    "modplay"
#define MODPLAY1    "modplay.com"
#define MODPLAY2    "modplay.exe"
#define MODPLAY3    "modplay.bat"
#define PKUNZIP0    "pkunzip"
#define PKUNZIP1    "pkunzip.exe"
#define MPENDING    ".mod"
#define PKENDING    ".zip"
#define MENUENDING  ".men"
#define STEREO      "/xs" /* uses in stereo the first two ports found */
#define SINGLE      "/xm" /* uses in mono the first port found */
#define SPEAKER     "/0"  /* uses the PC speaker if no port found */
#define PORT1S      "3BC"
#define PORT2S      "378"
#define PORT3S      "278"
#define FTITLE      "Menu pour ModPlay"
#define ETITLE      "ModPlay Menu"
#define GTITLE      "Men fr ModPlay"
#define DEFAULTOUTLINE     4 /* red */
#define DEFAULTTITLE       3 /* cyan */
#define DEFAULTITEM        2 /* green */
#define DEFAULTPICKED      3 /* cyan */
#define DEFAULTCURRENT     1 /* blue */
#define DEFAULTCURSOR      4 /* red */
#define DEFAULTBORDER      0 /* black */

typedef struct {
  char diskname[DISKNAMELENGTH+1]; /* diskette name for A: and B: users */
  char score[SCORELENGTH+1];       /* score for the current module */
  char *DOSpath;                   /* DOS path name searched first */
  char DOSname[DOSNAMELENGTH+1];   /* DOS file name used */
  char songname[SONGNAMELENGTH+1]; /* Official consistent song name */
  int  picked;                     /* priority for playing (0=NP) */
} SONGTYPE;

typedef struct {
  int songnumber;  /* total number of songs */
  int songcorner;  /* song to appear in upper left corner of menu */
  int songcurrent; /* song currently selected */
  int songpriority; /* priority for next song selected for playing */
  SONGTYPE song[MAXSONGS+1]; /* song 0 is BLANK */
  char songpath[PATHLENGTH+1]; /* big array of consecutive strings for paths */
  int songpathoffset; /* next chunk free in path pool */
} SONGSTYPE;

typedef struct {
  int currentdrive; /* 0=A 1=B etc */
  int tempdrive;
  char speed[3]; /* "/a" or "/b" or "/c" */
  int mouse; /* indicates if mouse is used */
  int pause; /* must pause before system() calls */
  int rawvideo; /* bypass BIOS or not */
  int videosegment; /* video RAM segment (B000H or B800H) */
  int verbose; /* display all fields in menu */
  int DOS; /* display DOS file name only in menu */
  int modplaycopied; /* temporary copy indicator */
  int pkunzipcopied,pkunzipfound;
  char ports[10]; /* typical "/xs3BC378" or "/0" for ModPlay */
  int A,B,C; /* which parallel ports are used */
  int videomode; /* startup video mode */
  int itemlength; /* width of a menu item */
  int maxcolumn,maxline; /* screen size */
  int bigcolumn,bigline; /* number of menu items visible */
  int hugeline; /* number of menu items visible and invisible */
  int leftcolumn; /* columns left over used for nice item column spacing */
} PARAMETERTYPE;

typedef struct {
  int x,y; /* coordinates from 0 to MAXMOUSE */
  int left,right; /* button status */
  char c; /* character on which the mouse cursor sits */
  int color; /* original color of this character */
} MOUSETYPE;
