'RUCKMIDI.BI 1.0

DECLARE FUNCTION RUCKMIDI% (SEG packinfo AS ANY)

CONST SysInfoMidi = 0, InitMidi = 1, ExitMidi = 2, AtExitMidi = 3
CONST LoadMidi = 4, PlayMidi = 5
CONST EndMidi = 8, PauseMidi = 9
CONST DeallocMidi = 10, FastFwdMidi = 11, OutMsgMidi = 12

CONST SetAllMidi = 20, SetVolumeMidi = 21, SetToneMidi = 22
CONST SetPatchMidi = 23, SetChMaskMidi = 24

CONST SetAllFMSBP = 30

TYPE DeallocMidiPackTYPE        'DMP
 Func       AS INTEGER
 stat       AS INTEGER
 HandSeg    AS INTEGER          'RUCKUS allocates DOS segment (para)
 TypeFlag   AS INTEGER          '0=DOS para (must=0)
END TYPE '8

TYPE FastFwdMidiPackTYPE        'FFMP
 Func       AS INTEGER
 stat       AS INTEGER
 TickCount  AS LONG             'tick count to fast forward to
end type '8

TYPE GetMidiDataPackTYPE        'GDP
 Func       AS INTEGER
 stat       AS INTEGER
 BytePos    AS LONG             'current byte relative base ptr (27)
END TYPE '8

TYPE mInitMidiPackTYPE          'MIMP (can't use IMP with BASIC)
 Func       AS INTEGER
 stat       AS INTEGER
 DeviceID   AS INTEGER          '0=AdLib melodic, 1=AdLib percussive
 IOport     AS INTEGER
 PercCh     AS INTEGER
 ChMask     AS INTEGER
 Flags      AS INTEGER          '(see source)
 InfoPtrOff AS INTEGER          'ret:far ptr to Midi info
 InfoPtrSeg AS INTEGER
 MidiExitPtrOff AS INTEGER      'ret:far ptr to Midi's ExitXB routine
 MidiExitPtrSeg AS INTEGER
END TYPE '22

TYPE LoadMidiPackTYPE           'LMP
 Func       AS INTEGER
 stat       AS INTEGER
 FilenamePtrOff AS INTEGER      'far ptr to filenameZ to load
 FilenamePtrSeg AS INTEGER
 StartPos   AS LONG             'offset into file to start load at
 LoadSize   AS LONG             'number of bytes to load (or 0 for autosize)
 LoadPtrOff AS INTEGER          'ret:DOS seg:offset (offset always 0)
 LoadPtrSeg AS INTEGER
END TYPE '20

TYPE OutMsgMidiPackTYPE         'OMMP
 Func       AS INTEGER
 stat       AS INTEGER
 Mstatus    AS INTEGER          'status byte (8n, 9n...)
 Mdata      AS INTEGER          'data
END TYPE '8

TYPE PlaybackMidiPackTYPE       'PMBP
 Func       AS INTEGER
 stat       AS INTEGER
 Mode       AS INTEGER          'playback mode (0=interrupt FG,1=BG)
 LoadPtrOff AS INTEGER          'seg:off to start of data to play
 LoadPtrSeg AS INTEGER
END TYPE '10

TYPE PauseMidiPackTYPE          'PMP
 Func       AS INTEGER
 stat       AS INTEGER
 Pause      AS INTEGER          '0=unpause else pause
END TYPE '6

TYPE SetFMProPackTYPE           'SFMPP (FM mixer control for SB PRO-compatibles)
 Func       AS INTEGER
 stat       AS INTEGER
 IOport     AS INTEGER          'base I/O port (&H220, &H240)
 MasterVol  AS INTEGER          '0F0F (low=right ch, high=left,-1 no change)
 Steer      AS INTEGER          '0=none,1=left,2=right,3=mute,-1 no change)
 FMVol      AS INTEGER          '0F0F (low=right,high=left,cannot skip)
END TYPE '12

TYPE SetMidiPackTYPE            'SMP
 Func       AS INTEGER
 stat       AS INTEGER
 Channel    AS INTEGER          'channel to set (bit mask of channels 0-15)
 Volume     AS INTEGER          'volume adjust
 Tone       AS INTEGER          'tone adjust
 ChMask     AS INTEGER          'if bit=0 then that channel is ignored
 PatchMapID AS INTEGER          'patch map ID
 PatchMapPtrOff AS INTEGER      'far ptr to alternate patch map or
 PatchMapPtrSeg AS INTEGER      'address of patch map ID selected
END TYPE '18

TYPE SysInfoMidiPackTYPE        'SIMP
 Func       AS INTEGER          'this (or any) TYPE will be expanded as needed
 stat       AS INTEGER          'to accomodate additional MIDI devices
 Device0    AS INTEGER          '=1 AdLib melodic mode available
 D0port     AS INTEGER          '388h
 D0mask     AS INTEGER          '
 Device1    AS INTEGER          '=1 AdLib percussive mode available
 D1port     AS INTEGER          '388h
 D1mask     AS INTEGER
END TYPE '16

TYPE XitMidiPackTYPE            'XMP
 Func       AS INTEGER
 stat       AS INTEGER
END TYPE '4

'END RUCKMidi.BI -----------------------
