
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1995
//------------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <conio.h>

FILE *fp;
char filename[80];
unsigned short ra;
unsigned short rb;
unsigned long la;
unsigned short fmttag=0;
unsigned long samplerate;
unsigned short channels;
unsigned short bits;
unsigned long ckid;
unsigned long cksize;
unsigned long filesize;
unsigned long nextseek;
unsigned char *byteptr;
unsigned short iobase;
unsigned long physical;
unsigned char dma;
unsigned char dmareg;
unsigned char irq;
unsigned char *data;
volatile unsigned short swapcount;
unsigned short swapmon;
unsigned short bytesread;

//------------------------------------------------------------------------------
void dspwrite ( unsigned char c )
{
    while(inp(iobase+0xC)&0x80);
    outp(iobase+0xC,c);
}
//------------------------------------------------------------------------------
unsigned char dspread ( void )
{
    while(!(inp(iobase+0xE)&0x80)) continue;
    return(inp(iobase+0xA));
}
//-----------------------------------------------------------------------------
void interrupt sbisr()
{
    swapcount++;
    outp(iobase+0x4,0x82); if(inp(iobase+0x5)&1) inp(iobase+0xE);
    outp(iobase+0x4,0x82); if(inp(iobase+0x5)&2) inp(iobase+0xF);
    if(irq==10) outp(0xA0,0xA0);
    outp(0x20,0x20);
}
//------------------------------------------------------------------------------
void main ( int argc, char *argv[] )
{
    if(argc==1)
    {
        printf(".WAV file not specified\n");
        exit(1);
    }
    // Check out file first
    strcpy(filename,argv[1]);
    strcat(filename,".WAV");
    if((fp=fopen(filename,"rb"))==NULL)
    {
        strcpy(filename,argv[1]);
        if((fp=fopen(filename,"rb"))==NULL)
        {
            printf("Error opening .WAV file [%s]\n",filename);
            exit(1);
        }
    }
    fread(&la,1,4,fp);
    if(la!=0x46464952)
    {
        printf("Not a RIFF format file\n");
        exit(1);
    }
    fread(&filesize,1,4,fp);
    filesize+=ftell(fp);
    fread(&la,1,4,fp);
    if(la!=0x45564157)
    {
        printf("Not a WAVE file\n");
        exit(1);
    }
    //Look for Sound Blaster 16
    for(iobase=0x220;iobase<=0x280;iobase+=0x20)
    {
        if(inp(iobase)==0xFF) continue;
        outp(iobase+0x6,0x01);  // Reset Sound Blaster
        for(ra=0;ra<65000;ra++) continue; //At least 3ms delay
        outp(iobase+0x6,0x00);
        for(ra=0;ra<65000;ra++) if(dspread()==0xAA) break;
        if(ra<65000) break;
    }
    if(iobase>0x280)
    {
        printf("Sound Blaster not detected\n");
        exit(1);
    }
    dspwrite(0xE1);   // Get DSP Version Number
    ra=dspread();
    rb=dspread();
    printf("Sound Blaster Detected, DSP Version %u.%02u\n",ra,rb);
    if(ra!=4)
    {
        printf("Only Sound Blaster DSP Versions 4.xx (SB16) supported.\n");
        exit(1);
    }
    outp(iobase+0x4,0x80);
    switch(inp(iobase+0x5)&0xF)
    {
        case 0x00:
            printf("IRQ Line not set\n");
            exit(1);
        case 0x01: irq=2; break;
        case 0x02: irq=5; break;
        case 0x04: irq=7; break;
        case 0x08: irq=10; break;
    }
    printf("IRQ %u  ",irq);
    outp(iobase+0x4,0x81);
    switch(inp(iobase+0x5)&0x0B)
    {
        case 0x00:
            printf("DMA Channel not set\n");
            exit(1);
        case 0x01: dma=0; break;
        case 0x02: dma=1; break;
        case 0x08: dma=3; break;
    }

    dmareg=inp(iobase+0x5)&0xEB;
    outp(iobase+0x5,dmareg&0x0B);

    printf("DMA %u  ",dma);

    //Allocate and justify the memory
    data=malloc(16384);
    if(data==NULL)
    {
        printf("\nError Allocating Memory\n");
        outp(iobase+0x4,0x81);
        outp(iobase+0x5,dmareg);
        exit(1);
    }
    physical=((unsigned long)FP_SEG(data)<<4)+FP_OFF(data);
    if((physical&0xFF0000)!=((physical+16383)&0xFF0000))
    {
        printf("\nPage Boundary crossing!\n");
    }

    nextseek=ftell(fp);
    while(nextseek<filesize)
    {
        fseek(fp,nextseek,0);
        fread(&ckid,1,4,fp);
        fread(&cksize,1,4,fp);
        nextseek=cksize+ftell(fp);
        switch(ckid)
        {
            case 0x20746D66: //Format Chunk
                fread(&fmttag,1,2,fp);
                fread(&channels,1,2,fp);
                switch(channels)
                {
                    case 1: printf("Mono  "); break;
                    case 2: printf("Stereo  "); break;
                    default:
                        printf("\nInvalid number of channels:  %u\n",channels);
                        fmttag=0;
                        break;
                }
                if(!fmttag) break;
                fread(&samplerate,1,4,fp);
                printf("%lu Hz  ",samplerate);
                if((samplerate<5000)||(samplerate>45000))
                {
                    printf("\nInvalid Sample Rate\n");
                    fmttag=0;
                    break;
                }
                byteptr=(void *)&samplerate;
                dspwrite(0x41);
                dspwrite(byteptr[1]);
                dspwrite(byteptr[0]);
                fseek(fp,6,1);
                fread(&bits,1,2,fp);
                switch(bits)
                {
                    case 8: printf("8-Bit  "); break;
                    case 16: printf("16-Bit  "); break;
                    default:
                        printf("\nInvalid bits per sample:  %u\n",bits);
                        fmttag=0;
                        break;
                }
                break;
           case 0x61746164: //Data Chunk
                printf("\n");
                if(fmttag!=0x0001)
                {
                    printf("Invalid file format or WAVE format not supported\n");
                    break;
                }
                if(bits==8)
                {
                    switch(channels)
                    {
                        case 1: printf("%lu Samples\n",cksize); break;
                        case 2: printf("%lu Samples\n",cksize>>1); break;
                    }
                    switch(irq) // Disable Interrupt
                    {
                        case  2: outp(0x21,inp(0x21)|0x04); break;
                        case  5: outp(0x21,inp(0x21)|0x20); break;
                        case  7: outp(0x21,inp(0x21)|0x80); break;
                        case 10: outp(0xA1,inp(0xA1)|0x04); break;
                    }
                    switch(irq) // Set Interrupt Vector
                    {
                        case 2: case 5: case 7: setvect(0x08+irq,sbisr); break;
                        case 10:                setvect(0x68+irq,sbisr); break;
                    }
                    inp(iobase+0xE); // Clear Interrupt on Sound Blaster
                    switch(irq) // Enable Interrupt
                    {
                        case  2: outp(0x21,inp(0x21)&0xFB); break;
                        case  5: outp(0x21,inp(0x21)&0xDF); break;
                        case  7: outp(0x21,inp(0x21)&0x7F); break;
                        case 10: outp(0xA1,inp(0xA1)&0xFB); break;
                    }
                    if(cksize<8192)
                    {
                        bytesread=fread(data,1,cksize,fp);
                        cksize=0;
                    }
                    else
                    {
                        bytesread=fread(data,1,8192,fp);
                        cksize-=8192;
                    }
                    for(ra=bytesread;ra<8192;ra++) data[ra]=0x80;
                    switch(dma)
                    {
                        case 0:
                        case 1:
                        case 3:
                            outp(0x0A,0x04|dma);
                            outp(0x0C,0x00);
                            outp(0x0B,0x58|dma); //Read is play
                            byteptr=(void *)&physical;
                            outp(dma<<1,byteptr[0]);
                            outp(dma<<1,byteptr[1]);
                            switch(dma)
                            {
                                case 0:
                                    outp(0x487,byteptr[3]);
                                    outp(0x87,byteptr[2]);
                                    break;
                                case 1:
                                    outp(0x483,byteptr[3]);
                                    outp(0x83,byteptr[2]);
                                    break;
                                case 3:
                                    outp(0x482,byteptr[3]);
                                    outp(0x82,byteptr[2]);
                                    break;
                            }
                            outp((dma<<1)|1,0xFF); //low byte of length-1
                            outp((dma<<1)|1,0x3F); //high byte of length-1
                            outp(0x0A,dma);
                            break;
                    }
                    swapmon=0; swapcount=1;
                    switch(channels)
                    {
                        case 1:
                            dspwrite(0xC6);
                            dspwrite(0x00);
                            dspwrite(0xFF); //length-1 low byte
                            dspwrite(0x1F); //length-1 high byte
                            break;
                        case 2:
                            dspwrite(0xC6);
                            dspwrite(0x20);
                            dspwrite(0xFF); //length-1 low byte
                            dspwrite(0x1F); //length-1 high byte
                            break;
                    }
                    while(kbhit()) getch();
                    while(1)
                    {
                        if(kbhit()) if(getch()==0x1B)
                        {
                            printf("ESCape\n");
                            break;
                        }
                        if(swapmon!=swapcount)
                        {
                            swapmon=swapcount;
                            if(bytesread<8192) break;
                            switch(swapmon&1)
                            {
                                case 0:
                                    if(cksize<8192)
                                    {
                                        bytesread=fread(data,1,cksize,fp);
                                        cksize=0;
                                    }
                                    else
                                    {
                                        bytesread=fread(data,1,8192,fp);
                                        cksize-=8192;
                                    }
                                    for(ra=bytesread;ra<8192;ra++) data[ra]=0x80;
                                    break;
                                case 1:
                                    if(cksize<8192)
                                    {
                                        bytesread=fread(&data[8192],1,cksize,fp);
                                        cksize=0;
                                    }
                                    else
                                    {
                                        bytesread=fread(&data[8192],1,8192,fp);
                                        cksize-=8192;
                                    }
                                    for(ra=bytesread;ra<8192;ra++) data[ra+8192]=0x80;
                                    break;
                            }
                        }
                    }
                    dspwrite(0xDA); //stop after this block
                    while(swapmon==swapcount) continue; //wait for this block to finish
                    switch(dma) //Disable DMA
                    {
                        case 0:
                        case 1:
                        case 3:
                            outp(0x0A,0x04|dma);
                            break;
                    }
                    switch(irq) // Disable Interrupt
                    {
                        case  2: outp(0x21,inp(0x21)|0x04); break;
                        case  5: outp(0x21,inp(0x21)|0x20); break;
                        case  7: outp(0x21,inp(0x21)|0x80); break;
                        case 10: outp(0xA1,inp(0xA1)|0x04); break;
                    }
                }
                if(bits==16)
                {
                    switch(channels)
                    {
                        case 1: printf("%lu Samples\n",cksize>>1); break;
                        case 2: printf("%lu Samples\n",cksize>>2); break;
                    }
                    switch(irq) // Disable Interrupt
                    {
                        case  2: outp(0x21,inp(0x21)|0x04); break;
                        case  5: outp(0x21,inp(0x21)|0x20); break;
                        case  7: outp(0x21,inp(0x21)|0x80); break;
                        case 10: outp(0xA1,inp(0xA1)|0x04); break;
                    }
                    switch(irq) // Set Interrupt Vector
                    {
                        case 2: case 5: case 7: setvect(0x08+irq,sbisr); break;
                        case 10:                setvect(0x68+irq,sbisr); break;
                    }
                    inp(iobase+0xF); // Clear Interrupt on Sound Blaster
                    switch(irq) // Enable Interrupt
                    {
                        case  2: outp(0x21,inp(0x21)&0xFB); break;
                        case  5: outp(0x21,inp(0x21)&0xDF); break;
                        case  7: outp(0x21,inp(0x21)&0x7F); break;
                        case 10: outp(0xA1,inp(0xA1)&0xFB); break;
                    }
                    if(cksize<8192)
                    {
                        bytesread=fread(data,1,cksize,fp);
                        cksize=0;
                    }
                    else
                    {
                        bytesread=fread(data,1,8192,fp);
                        cksize-=8192;
                    }
                    for(ra=bytesread;ra<8192;ra++) data[ra]=0x00;
                    switch(dma)
                    {
                        case 0:
                        case 1:
                        case 3:
                            outp(0x0A,0x04|dma);
                            outp(0x0C,0x00);
                            outp(0x0B,0x58|dma); //Read is play
                            byteptr=(void *)&physical;
                            outp(dma<<1,byteptr[0]);
                            outp(dma<<1,byteptr[1]);
                            switch(dma)
                            {
                                case 0:
                                    outp(0x487,byteptr[3]);
                                    outp(0x87,byteptr[2]);
                                    break;
                                case 1:
                                    outp(0x483,byteptr[3]);
                                    outp(0x83,byteptr[2]);
                                    break;
                                case 3:
                                    outp(0x482,byteptr[3]);
                                    outp(0x82,byteptr[2]);
                                    break;
                            }
                            outp((dma<<1)|1,0xFF); //low byte of length-1
                            outp((dma<<1)|1,0x3F); //high byte of length-1
                            outp(0x0A,dma);
                            break;
                    }
                    swapmon=0; swapcount=1;
                    switch(channels)
                    {
                        case 1:
                            dspwrite(0xB6);
                            dspwrite(0x10);
                            dspwrite(0xFF); //length-1 low byte
                            dspwrite(0x0F); //length-1 high byte
                            break;
                        case 2:
                            dspwrite(0xB6);
                            dspwrite(0x30);
                            dspwrite(0xFF); //length-1 low byte
                            dspwrite(0x0F); //length-1 high byte
                            break;
                    }
                    while(kbhit()) getch();
                    while(1)
                    {
                        if(kbhit()) if(getch()==0x1B)
                        {
                            printf("ESCape\n");
                            break;
                        }
                        if(swapmon!=swapcount)
                        {
                            swapmon=swapcount;
                            if(bytesread<8192) break;
                            switch(swapmon&1)
                            {
                                case 0:
                                    if(cksize<8192)
                                    {
                                        bytesread=fread(data,1,cksize,fp);
                                        cksize=0;
                                    }
                                    else
                                    {
                                        bytesread=fread(data,1,8192,fp);
                                        cksize-=8192;
                                    }
                                    for(ra=bytesread;ra<8192;ra++) data[ra]=0x00;
                                    break;
                                case 1:
                                    if(cksize<8192)
                                    {
                                        bytesread=fread(&data[8192],1,cksize,fp);
                                        cksize=0;
                                    }
                                    else
                                    {
                                        bytesread=fread(&data[8192],1,8192,fp);
                                        cksize-=8192;
                                    }
                                    for(ra=bytesread;ra<8192;ra++) data[ra+8192]=0x00;
                                    break;
                            }
                        }
                    }
                    dspwrite(0xD9); //stop after this block
                    while(swapmon==swapcount) continue; //wait for this block to finish
                    switch(dma) //Disable DMA
                    {
                        case 0:
                        case 1:
                        case 3:
                            outp(0x0A,0x04|dma);
                            break;
                    }
                    switch(irq) // Disable Interrupt
                    {
                        case  2: outp(0x21,inp(0x21)|0x04); break;
                        case  5: outp(0x21,inp(0x21)|0x20); break;
                        case  7: outp(0x21,inp(0x21)|0x80); break;
                        case 10: outp(0xA1,inp(0xA1)|0x04); break;
                    }
                }
                fmttag=0;
                break;
        }
    }
    outp(iobase+0x4,0x81);
    outp(iobase+0x5,dmareg);
}
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1995
//------------------------------------------------------------------------------

