// Monitor.cpp

// Displays a real-time bar graph of the Sound Blaster recording input
// This demonstrates the SoundDevice function monitor_input()

// Written by Christopher M. Box, modified from play_rec.cpp

// Usage: monitor [sample rate]

#define DMA_BUF_SIZE 32000U
#define ALLOCATE ((2*DMA_BUF_SIZE) + 65536L)

#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <dos.h>

#include "sndclass.h"

int main(int argc, char **argv) {
	unsigned sr=10000;         // Default sample rate

	if (argc > 1) sr = atoi(argv[1]);

	SoundDevice *sdev;
	sdev = new SbDevice;
	if (! sdev -> install_ok()) exit(1);

// Obtain an aligned 64K memory buffer for the DMA functions
	byte far *raw = (byte far *) farmalloc(ALLOCATE);
	if (! raw) {
		cprintf("Not enough memory available - an extra %uK needed.\r\n",
			((unsigned int)(ALLOCATE-farcoreleft()))/1024+1);
		exit(1);
	}
	long physical = ((long)FP_OFF(raw)) + (((long)FP_SEG(raw)) << 4);
	long aligned_physical = (physical+0x0FFFFL) & 0xF0000L;
	byte far *buf = (byte far *)
		MK_FP((unsigned )((aligned_physical >> 4) & 0xFFFF),0);

	sdev -> set_rate(sr,RECORD);
	sdev -> monitor_input(buf,1000);
	farfree(raw);
	return 0;
}