/*
 *  Routines to draw the spectrum display for the spectrogram progam
 *
 *  Copyright (C) 1995  Philip VanBaren
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>

#include "specgram.h"
#include "display.h"
#include "extern.h"
#include "fft.h"

int df=0;
int tf=0;
int repcount=1;

void DisplayData(short *data,short *olddata,int x,int y)
{
   int i;
   int ey=y-fftlen*repcount/2;
   int *bri=BitReversed;
   int lastval=0;

   if(logamp)
   {
      while(y>ey)
      {
         register long real=data[*bri];
         register long imag=data[*bri+1];
         register long asq=(real*real+imag*imag);
         register int val;
         if(asq<=0)
            asq=1;
         val=(int)(log_scale*log(asq))-log_base;
         if(diff_mode)
         {
            /* Get difference with offset */
            register int val2=*olddata-val+(_draw_colors/2);
            *olddata=lastval;
            olddata++;
            lastval=val;
            val=val2;
         }
         if(val>=_draw_colors) val=_draw_colors-1;
         if(val<MIN_COLOR) val=MIN_COLOR;
         for(i=0;i<repcount;i++)
            draw_putpixel(x,y--,val);
         bri++;
      }
   }
   else
   {
      while(y>ey)
      {
         register long real=data[*bri];
         register long imag=data[*bri+1];
	 register long asq=(real*real+imag*imag);
	 int val;
	 if(asq<0) asq=0;
         val=(int)(amp_scale*sqrt(asq));
         if(diff_mode)
         {
            /* Get difference with offset */
            register int val2=*olddata-val+(_draw_colors/2);
            *olddata=lastval;
            olddata++;
            lastval=val;
            val=val2;
         }
         if(val>=_draw_colors) val=_draw_colors-1;
         if(val<MIN_COLOR) val=MIN_COLOR;
         for(i=0;i<repcount;i++)
            draw_putpixel(x,y--,val);
         bri++;
      }
   }
}

void DrawBar(int x,int y)
{
   int ey=y-fftlen*repcount/2;
   int fc=df;

   for(;y>ey;y--)
   {
      /* Use pre-computed values to determine where the tick marks lie */
      if((fc+=df)>=tf)
      {
         fc-=tf;
         draw_putpixel(x,y,TICK_COLOR);
      }
      else
         draw_putpixel(x,y,BAR_COLOR);
   }
   /* Fill the top in with three black pixels to erase time ticks */
   for(;y>ey-3;y--)
      draw_putpixel(x,y,0);
}

