/*
 *  Graphics function remaps for VESA SVGA BIOS extensions
 */
#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>

#include "specgram.h"
#include "display.h"
#include "extern.h"

int _font_color;
int _font_width;
int _font_height;
int _draw_colors;

extern volatile int done;

int ctrlcfunc(void)
{
   /* Function called whenever Ctrl-C is pressed (Borland C only) */
   done=1;
   return 1;
}

void draw_init(void)
{
   ctrlbrk(ctrlcfunc);
   if(initSuperVGA()!=0)
   {
      puts("Vesa video drivers are not installed.");
      exit(1);
   }
   SaveState();      /* Save the current video state */
}

void draw_setup_graphics(void)
{
   int i;
   _font_height=14;
   _font_width=8;
   _draw_colors=256;
   _font_color=1;
   if((i=setSuperVGAMode(0x103))!=0)
   {
      cleanup_soundcard();
      RestoreState();
      printf("Error %d setting VESA mode.",i);
      exit(1);
   }
}

int draw_getpixel(int x,int y)
{
   return getPixel(x,y);
}

void draw_text_vertical(int x,int y,char *string)
{
   char out[2];
   out[1]=0;
   while(*string)
   {
      out[0]=*string;
      writeText(x,y,_font_color,out);
      y+=_font_height+2;
      string++;
   }
}

void draw_fontcolor(int c)
{
   _font_color=c;
}

void draw_rectangle(int x1,int y1,int x2,int y2,int c)
{
   line(x1,y1,x2,y1,c);
   line(x1,y2,x2,y2,c);
   line(x1,y1,x1,y2,c);
   line(x2,y1,x2,y2,c);
}

void draw_setallpalette(unsigned char *p)
{
   int i;
   /* Can only get 64 color levels with this driver */
   for(i=0;i<(256*3);i++)
      p[i]>>=2;

   setvgapalette256(p);
}

int draw_getch()
{
   register int c=getch();
   if(c>0)
      return(c);
   else
      return(0x100+getch());
}

int draw_getkey()
{
   if(kbhit())
   {
      register int c=getch();
      if(c>0)
	 return(c);
      else
	 return(0x100+getch());
   }
   else
      return(0);
}
