#define VERSION "v.2"
#define COPYRIGHT "1996"

#ifdef DEBUG_OUTPUT
 #define DOUT(string) puts(string)
#else
 #define DOUT(string) {}
#endif

/*
 *  Define the DMA buffering scheme.  Note that in the current setup for
 *  running the buffers, having more than two buffers may improve the
 *  continuity of the DMA, but will cause more lag in the display.
 *  Also, the number of buffers must be 2 or greater.
 */
typedef unsigned char uchar;

#define BUFFERS 4
#define MAX_LEN 1024

#define STARTX 25
#define MAXX 799
#define MAXY 599
#define MODE 0x103

enum {HSV,THRESH,COOL,HOT,BW,BONE,COPPER,PALETTES};
enum {BGND_COLOR,TICK_COLOR,BAR_COLOR,MIN_COLOR};

#define SRX 290
#define SRY 20
#define FLX 290
#define FLY 35
#define FRX 260
#define FRY 50

#define WFX 20
#define WFY 20
#define PLX 20
#define PLY 35
#define AFX 20
#define AFY 50

#define DGX 580
#define DGY 20
#define AMX 580
#define AMY 35
#define MDX 580
#define MDY 50

#define LVX 580
#define LVY 5

#define GIX 260
#define GIY 65

#define UP_ARROW    0x148
#define DOWN_ARROW  0x150
#define LEFT_ARROW  0x14b
#define RIGHT_ARROW 0x14d
#define CTL_LEFT    0x173
#define CTL_RIGHT   0x174
#define HOME        0x147
#define END         0x14f
#define PGUP        0x149
#define PGDN        0x151

/*
 *  Defines for soundcard usage.  Non-implemented ones are commented out
 */
#ifdef DOS
 #define SC_SB8     0
 #define SC_PAS16   1
 #define SC_VESA    2
 #define SC_SB16    3
 /*#define SC_GUS16   3 */
#endif
#ifdef LINUX
 #define SC_MULAW 0
 #define SC_LINUX 1
#endif
#ifdef SUN
 #define SC_MULAW 0
#endif

/* Default soundcard */
#define SC_DEF  0

/* Text versions of the soundcard selections */
#define SC_SB8_NAME   "SB8"
#define SC_PAS16_NAME "PAS16"
#define SC_VESA_NAME  "VESA"
#define SC_SB16_NAME  "SB16"
/*#define SC_GUS16_NAME "GUS"*/
#define SC_LINUX_NAME "LINUX"
#define SC_MULAW_NAME "MULAW"

/* Mixer definitions */
#define MIXER_EXT 0
#define MIXER_INT 1
#define MIXER_MIC 2

/* Default soundblaster settings */
#define SB_IRQ 5
#define SB_DMA 1
#define SB_ADDR 0x220

/*
 *  Functions in SETUPSUB.C
 */
void parse_ini_file(void);
void parse_command(int,char *[],char *[]);
void setup_buffers(int);
void compute_window_function(void);
void setup_xscale(void);
void setup_linscales(void);
void setup_logscales(void);
void frequency_scale(void);
void amplitude_scale(void);
void draw_axis(void);
void show_help(void);
void update_header(void);
void set_palette(int);
void fillpalette(unsigned char *palette,int n);

/*
 *  Functions in PROCINP.C
 */
int process_input(int);

/*
 *  Functions in DISPDATA.ASM
 */
void DisplayData(short *data,short *olddata,int x,int y);
void DrawBar(int x,int y);

/*
 *  Functions in WINDDATA.C
 */
void window_data_normal(void);
void window_data_first_difference(void);
void window_data_second_difference(void);

/* Function in SC_PAS.C */
#ifdef SC_PAS16
  void init_pas16(void);
#endif

/* Function in SC_SB.C */
#ifdef SC_SB8
  void init_sb8(char *environ[]);
#endif

/* Function in SC_VESA.C */
#ifdef SC_VESA
  void init_vesa(void);
#endif

/* Function in SC_SB16.C */
#ifdef SC_SB16
  void init_sb16(char *environ[]);
#endif

/* Function in SC_LINUX.C */
#ifdef SC_LINUX
  void init_linux_sc(void);
#endif

/* Function in SC_MULAW.C */
#ifdef SC_MULAW
  void init_mulaw_sc(void);
#endif

