; DAC_INIT.ASM
;
; External assembler subroutine for Recwav.pas, initializes the DAC chip.
;

CODE		SEGMENT	BYTE PUBLIC
		ASSUME	CS:CODE,DS:CODE
		PUBLIC	DAC_INIT
DAC_INIT	PROC	NEAR
		JMP	START
		;
		; Local data.
		;
SOUNDHALTED	DB	0	; flag, 1 when Int 1Ah function complete
INT15OLD	DD	0	; default vector for Int 15h
		;
		; Temporary Int 15h handler.
		;
INT15NEW:	CMP	AX,91FBh
		JE	>L0
		JMP	DWORD PTR CS:INT15OLD
L0:		MOV	CS:SOUNDHALTED,1
		IRET
		;
		; Body of the procedure.  DS addresses code segment.
		;
START:		PUSH	DS
		MOV	AX,CS
		MOV	DS,AX
		;
		; Save the default Int 15h vector.
		;
		MOV	AX,3515h
		INT	21h
		MOV	WORD PTR INT15OLD,BX
		MOV	WORD PTR INT15OLD+2,ES
		;
		; Use the new Int 15h handler now.
		;
		MOV	DX,OFFSET INT15NEW
		MOV	AX,2515h
		INT	21h
		;
		; Prepare the sound chip.  (Mr. Terry's code.)
		;
		MOV	SOUNDHALTED,0
L1:		MOV	AH,84h
		INT	1Ah
L2:		MOV	AH,81h
		INT	1Ah
		JC	L2
		CMP	SOUNDHALTED,0
		JE	L1
		;
		; Restore the default Int 15h vector.
		;
		MOV	DX,WORD PTR INT15OLD
		MOV	DS,WORD PTR INT15OLD+2
		MOV	AX,2515h
		INT	21h
		;
		; Restore DS and exit.
		;
		POP	DS
		RET
DAC_INIT	ENDP
CODE		ENDS
		END
