/************************************************
 * DSFILE - File operations (ANSI)
 * File single pass descriptive stat
 * and array loading pass.
 *
 * Contains the following functions:
 *
 * IsNum    - Check if it looks like a number
 *
 * TrimLeft - Trim blank space on the left of a string
 *
 * ClearString -  Initialize a string with 0x00
 *
 * Upcase   - converts a string to uppercase.
 *
 * Openfile - open a file for text read-only and
 *            return file pointer or exit on error.
 * S101Fly  - on the fly stats. Opens file, reads
 *            elements, returns accumulated counters.
 *            Uses OpenFile.
 * S101Vect - same as previous, but loads a data
 *            vector in case you intend to compute
 *            the median. Uses OpenFile.
 * By its own nature this code belongs in
 * the public domain.
 */

/******* these were moved into the main fuction
#include <stdio.h>
#include <stdlib.h>
#include <float.h>
***/

#ifndef __FLOAT_H
#include <float.h>
#endif
#include "openfile.acf"

/* string utilities */

int IsNum(char C)
   {
   const char * S="+-.0123456789";

   while ((C != *S) && *S) S++;
   if ((C == * S) && *S) return 1;
   else return 0;
   }


char * TrimLeft(char * S)
   {
   while ((*S) && isspace(*S)) S++;
   return S;
   }


char * ClearString(char * S)
   {
   char *P = S;
   while (*P) *P=0x00, P++;
   return S;
   }




/****************************************************
 * S101Fly
 * File single pass
 * Open file, performs single pass, closes file.
 * Counters must have 5 elements.
 */

void S101Fly (long double * Counters, char * FileName)
   {
   int I, Unusable = 1;
   char InString[1024];
   float InItem;
   FILE * In;

   for (I=0; I <3; I++) Counters[I] = 0.0;
   Counters[3] = -1e+40;
   Counters[4] = +1e+40;

   In = OpenFile(FileName, "rt");

   do
     {
     InItem = 0.0; ClearString(InString);
     I = (int) fgets(InString, 1000, In);
     if (! I) break;
     strcpy(InString, TrimLeft(InString) );
     InItem = atof(InString);
     Unusable++;
     }
   while (! IsNum(*InString));
   Unusable--;

   while (! feof(In))
      {
	 Counters[0]++;
	 Counters[1] += (long double) InItem;
	 Counters[2] += (long double) InItem
		     * (long double) InItem;
	 if (InItem > Counters[3])
	    Counters[3] = InItem;
	 if (InItem < Counters[4])
	    Counters[4] = InItem;
	 do
	    {
	    InItem = 0.0; ClearString(InString);
	    I = (int) fgets(InString, 1000, In);
	    if (! I) break;
	    strcpy(InString, TrimLeft(InString) );
	    InItem = atof(InString);
	    Unusable++;
	    }
	 while (! IsNum(*InString));
	 Unusable--;
      }
   fclose(In);

   if (Counters[0] < 3)
      {
      printf("\nS102Fly: menos de"
	     " 3 elementos em %s.\n",
	      FileName);
      exit(2);
      }

   if (Unusable)
      printf("\nS101Fly: Aviso: %d elementos"
	     " inutilizveis em %s",
	     Unusable, FileName);
   } /* S101Fly ends. */




/****************************************************
 * S101Vect
 * File single pass with array loading.
 * Open file, clear array, perform single pass, loads
 * array, closes file.
 * Counters must have 5 elements.
 */

void S101Vect (long double * Counters,
	       char * FileName,
	       float * Data,
	       int MaxSize)
   {
   int I, Unusable=1;
   char InString[1024];
   float InItem;
   FILE * In;

   for (I=0; I<3; I++) Counters[I] = 0.0;
   Counters[3] = -1e+40;
   Counters[4] = +1e+40;

   for (I=0; I < MaxSize; I++) Data[I] = 0.0;

   In = OpenFile(FileName, "rt");
   do
     {
     InItem = 0.0; ClearString(InString);
     I = (int) fgets(InString, 1000, In);
     if (! I) break;
     strcpy(InString, TrimLeft(InString) );
     InItem = atof(InString);
     Unusable++;
     }
   while (!IsNum(*InString));
   Unusable--;

   while (! feof(In))
      {
	 if (Counters[0] > MaxSize)
	    {
	    printf
	    ("\nS101Vect: mais de %d"
	     " elementos em %s. Exiting.\n",
	     MaxSize, FileName);
	     fclose(In);
	     exit(1);
	     }

	 Data[Counters[0]] = InItem;
	 Counters[0]++;
	 Counters[1] += (long double) InItem;
	 Counters[2] += (long double) InItem
		     * (long double) InItem;
	 if (InItem > Counters[3])
	    Counters[3] = InItem;
	 if (InItem < Counters[4])
	    Counters[4] = InItem;
      do
	 {
	 InItem = 0.0; ClearString(InString);
	 I = (int) fgets(InString, 1000, In);
	 if (! I) break;
	 strcpy(InString, TrimLeft(InString) );
	 InItem = atof(InString);
	 Unusable++;
	 }
	 while (! IsNum(*InString));
	 Unusable--;
      }
   fclose(In);

   if (Counters[0] < 3)
      {
      printf("\nS102Vect: menos de 3"
	     " elementos em %s.\n",
	     FileName);
      exit(2);
      }
   if (Unusable)
      printf("\nS102Vect: Aviso: %d elementos"
	     " inutilizveis em in %s",
	     Unusable, FileName);

   }  /* S101Vect ends. */
