unit betain_u;
interface
  uses acrcy;

  function betain(x, p, q, lnbeta:double;var ifault:integer):double;

implementation

  function betain(x, p, q, lnbeta:double;var ifault:integer):double;
{
c        algorithm  as 63  appl stats (1973)  vol 22  no 3  pp 410-411
c
c        computes incomplete beta integral for arguments
c        x between zero and one, p and q positive.
c        complete beta function assumed known.
}
label
  label4,
  label5;
var
  index : boolean;
  psq,
  cx,rx,xx,
  pp,qq,
  term,ai,
  temp,
  result
   : double;
  ns
   : integer;
{
c        define accuracy and initialize.
}
begin
      result := x;
      betain := result;
{
c        test for admissibility of arguments.
}
      ifault := 1;
      if (p<=0.0) or (q<=0.0) then
        exit;
      ifault := 2;
      if(x<0.0) or (x>1.0) then
        exit;
      ifault := 0;
      if(x=0.0) then
        exit;
  {9} if(x=1.0) then
 {10}   exit;
{
c        change tail if necessary and determine s.
}
 {11} psq := p + q;
      cx := 1.0 - x;
      if (p<psq*x) then
      begin
        xx := cx;
        cx := x;
        pp := q;
        qq := p;
        index := true;
      end
      else
      begin
    {1} xx := x;
        pp := p;
        qq := q;
        index := false;
      end;
  {2} term := 1.0;
      ai := 1.0;
      result := 1.0;
      ns:= trunc(qq+ cx* psq);
      rx := xx / cx;
{
c        use soper's reduction formulae.
}
      repeat
    {3} temp := qq - ai;
        if (ns=0) then
          rx := xx;
      label4:
        term := term * temp * rx / (pp + ai);
        result := result + term;
        temp := abs(term);
        if (temp<=acu) and (temp<=acu*result) then
          goto label5;
        ai := ai + 1.0;
        ns := ns - 1;
      until (ns<0);
      temp := psq;
      psq := psq + 1.0;
      goto label4;
{
c        calculate result.
}
    label5:
      result := result*exp(pp*ln(xx)+(qq-1.0)*ln(cx)-lnbeta) / pp;
      if(index) then
        result := 1.0 - result;
      betain := result;
end;

end.

