function ARCCOS (X: real): real;
{ returns the arc-cosine of X in radians }
begin
  { Prevent errors on out-of-range }
  if (X >= 1.0) then
    Arccos := 0.0
  else if (X <= -1.0) then
    Arccos := 3.141592654
  else
    Arccos := -arctan(X / sqrt (-X * X + 1)) + 1.5708;
end;
