{ SETNORMAL and NORMALIZE were written by Joseph Mackey }
{ Variables shared between NORMALIZE and SETNORMAL: }
var Xfactor, Yfactor:   real;    { factors for XYadjust }

function SETNORMAL (Xfotran,Yfotran: real; var XYmax: real): boolean;

{ Set up for normalize procedure }

var
  i: word;                        {counter for traversing trans arrays}
  Xmin,Ymin,Xmax,Ymax: real;      {minimum and maximum x & y values}

begin
{$ifdef BIGMEM}
with ptrd^ do with ptre^ do
begin
{$endif}

  Setnormal := TRUE;
  Xmax:=-99999.0;
  Xmin:=99999.0;
  Ymax:=-9999.0;
  Ymin:=99999.0;
  XYmax:=-99999.0;

  if (XYadjust > 1.0) then begin
    Xfactor := 1.0;
    Yfactor := 1.0 / XYadjust;
  end else begin
    Xfactor := XYadjust;
    Yfactor := 1.0;
  end;

  for i:=1 to Nnodes do begin
    if Xtran[i]>Xmax then
      Xmax:=Xtran[i];
    if Xtran[i]<Xmin then
      Xmin:=Xtran[i];
    if Ytran[i]>Ymax then
      Ymax:=Ytran[i];
    if Ytran[i]<Ymin then
      Ymin:=Ytran[i];
  end;

  if (Xfotran>Xmax) or (Xfotran<Xmin) or (Xfotran>Ymax) or (Yfotran<Ymin) then
    Setnormal := FALSE;


  for i:=1 to Nnodes do begin
    if abs(Xtran[i]-Xfotran)>XYmax then
      XYmax:=abs(Xtran[i]-Xfotran);
    if abs(Ytran[i]-Yfotran)>XYmax then
      XYmax:=abs(Ytran[i]-Yfotran);
  end;
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { function Setnormal }

procedure NORMALIZE (var Xtr, Ytr: real; Xfotran, Yfotran, XYmax: real);

    {procedure takes 2-D nodes, scales and offsets them relative to the
     focal point now offset to the center of the screen}

begin
{   Note: 0.35333 is 0.5 * (6.625 / 9.375).
    9.375 is X dimension of screen in inches; 6.625 is Y dimension. }
    Xtr := (Gxmax+Gxmin) div 2 -
        round((Xfotran-Xtr)*0.35333*(Gxmax-Gxmin)*Magnify*Xfactor/XYmax);
    Ytr := (Gymax+Gymin) div 2 +
        round((Yfotran-Ytr)*0.5*(Gymax-Gymin)*Magnify*Yfactor/XYmax);
end; { procedure NORMALIZE }
