function ONSCREEN (Surf: word): boolean;

{ Returns true if any part of surface #Surf is within screen limits }

var Vert: integer;                    { vertex # }
    Node: word;                       { node # of vertex }
    On: boolean;                      { result to be returned }

begin
{$ifdef BIGMEM}
with ptrd^ do with ptre^ do with ptrh^ do
begin
{$endif}

  if (Magnify <= 1.0) then
    { If no magnification, then by definition all surfaces are on the
      screen }
    Onscreen := TRUE
  else begin
    Vert := 1;
    On := FALSE;
    while (Vert <= Nvert[Surf]) and (not On) do begin
      Node := konnec (Surf, Vert);
      if (Xtran[Node] >= Gxmin) then
        On := TRUE;
      Vert := Vert + 1;
    end;
    if (not On) then
      Onscreen := FALSE
    else begin
      Vert := 1;
      On := FALSE;
      while (Vert <= Nvert[Surf]) and (not On) do begin
        Node := konnec (Surf, Vert);
        if (Xtran[Node] <= Gxmax) then
          On := TRUE;
        Vert := Vert + 1;
      end;
      if (not On) then
        Onscreen := FALSE
      else begin
        Vert := 1;
        On := FALSE;
        while (Vert <= Nvert[Surf]) and (not On) do begin
          Node := konnec (Surf, Vert);
          if (Ytran[Node] >= Gymin) then
            On := TRUE;
          Vert := Vert + 1;
        end;
        if (not On) then
          Onscreen := FALSE
        else begin
          Vert := 1;
          On := FALSE;
          while (Vert <= Nvert[Surf]) and (not On) do begin
            Node := konnec (Surf, Vert);
            if (Ytran[Node] <= Gymax) then
              On := TRUE;
            Vert := Vert + 1;
          end;
          if (not On) then
            Onscreen := FALSE
          else
            Onscreen := TRUE;
        end; { Gymax }
      end; { Gymin }
    end; { Gxmax }
  end; { Gxmin }
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure ONSCREEN }
