procedure STORSHADES (X1, Y1, X2, Y2: integer; Shade1, Shade2: real;
    var Xpt, Ypt: points; var Shpt: realpts; var Npts: integer);

{ Store the line from (X1,Y1) to (X2,Y2) in an internal buffer with
  interpolated shading from Shade1 to Shade2 }

var X, Y: integer;                   { current point being stored }
    Xfact: real;                     { factor for (X,Y) interpolation }
    Shfact: real;                    { factor for shade interpolation }
    Ylow, Yhigh: integer;            { range of for loop }
    Firstx: boolean;                 { flag first dot of line }
    Firstsh: boolean;                { flag first shade of line }
    Shade: real;                     { shade at each pixel }

begin
  Firstx := TRUE;
  Firstsh := TRUE;
  if (Y2 = Y1) then
    Xfact := 0.0
  else
    Xfact := (X2-X1) / (Y2-Y1);
  if (Y1 > Y2) then begin
    Ylow := Y2;
    Yhigh := Y1;
  end else begin
    Ylow := Y1;
    Yhigh := Y2;
  end;
  if (Ylow < Gymin) then
    Ylow := Gymin;
  if (Yhigh > Gymax) then
    Yhigh := Gymax;
  if (Y1 = Y2) then
    Shfact := 0.0
  else
    Shfact := (Shade2 - Shade1) / (Y2 - Y1);

{ Store the line segment, making sure there is not more than one X
  value for any given Y (unless Y1 = Y2, in which case only the two
  endpoints should be saved).
}
{ Make sure the entire line isn't out of bounds }
  if (Ylow <= Gymax) and (Yhigh >= Gymin) then begin
    for Y := Ylow to Yhigh do begin
      if (Xfact = 0.0) then
        if (Firstx) then begin
          X := X1;
          Firstx := FALSE;
        end else
          X := X2
      else
        X := X1 + round((Y-Y1) * Xfact);
      if (Shfact = 0.0) then
        if (Firstsh) then begin
          Shade := Shade1;
          Firstsh := FALSE;
        end else
          Shade := Shade2
      else
        Shade := Shade1 + (Y - Y1) * Shfact;
      Npts := Npts + 1;
      if (Npts <= MAXPTS) then begin
        Xpt[Npts] := X;
        Ypt[Npts] := Y;
        Shpt[Npts] := Shade;
      end;
    end;  { for Y }
  end; { if Ylow... }

{ Flag error condition if array dimension exceeded }
  if (Npts > MAXPTS) then
    Npts := -1;
end;  { procedure STORSHADES }
