{ WRITECFG: Write a new-format configuration (INI) file }
procedure WRITECFG;
var Out: text;
    Mat: integer;
    Lite: integer;
    Notopen: boolean;        { flag file not open yet }
    Ans: string[5];

begin
  { Open the new file for processing }
  assign (Out, Inifile);
  Notopen := TRUE;
  while (Notopen) do begin
    {$I-}
    rewrite (Out);
    {$I+}
    if (ioresult = 0) then
      Notopen := FALSE
    else begin
      writeln ('Error writing file ', Inifile);
      write ('Try again (Y/N)? ');
      readln (Ans);
      if (Ans = 'N') or (Ans = 'n') then
        exit;
    end; { if ioresult }
  end; { while }

  writeln (Out, 'VERSION: 5');
  writeln (Out, 'EYE: ', Xeye, ' ', Yeye, ' ', Zeye);
  writeln (Out, 'FOCAL: ', Xfocal, ' ', Yfocal, ' ', Zfocal);
  writeln (Out, 'MAGNIFY: ', Magnify);
  write (Out, 'VIEWTYPE: ');
  case Viewtype of
    0:  writeln (Out, 'STD');
    1:  writeln (Out, 'XY');
    2:  writeln (Out, 'YZ');
    3:  writeln (Out, 'XZ');
  end;
  if (not Interpolate) then
    Epsilon := 0;
  writeln (Out, 'GOURAUD: ', Epsilon);
  write (Out, 'SHADOWING: ');
  if (Shadowing) then
    writeln (Out, 'ON')
  else
    writeln (Out, 'OFF');
  write (Out, 'AXISSHOW: ');
  if (Showaxes = 1) then
    writeln (Out, 'ON')
  else
    writeln (Out, 'OFF');
  writeln (Out, 'AXISLEN: ', Xaxislen, ' ', Yaxislen, ' ', Zaxislen);
  writeln (Out, 'AXISCOLOR: ', Axiscolor);
  { DITHER: No longer supported }
  if (not Dorandom) then
    Randshade := 0;
  writeln (Out, 'RANDOM: ', Randshade);
  write (Out, 'BORDERS: ');
  if (ShowAllBorders = 1) then
    writeln (Out, 'ON')
  else
    writeln (Out, 'OFF');
  write (Out, 'SHOWTITLE: ');
  if (ShowTitle) then
    writeln (Out, 'ON')
  else
    writeln (Out, 'OFF');

  { Write out material data }
  for Mat := 1 to Nmatl do begin
    writeln (Out, 'MATL: ', Mat);
    writeln (Out, 'MATCONST: ', R1[Mat], ' ', R2[Mat], ' ', R3[Mat]);
    writeln (Out, 'MATCOLOR: ', Color[Mat]);
    writeln (Out, 'MATAMBIENT: ', Ambient[Mat]);
    writeln (Out, 'MATRGB: ', Redmax[Mat], ' ', Grnmax[Mat], ' ', Blumax[Mat]);
  end;

  { Write out the light source data }
  for Lite := 1 to Nlite do begin
    writeln (Out, 'LIGHT: ', Lite);
    writeln (Out, 'LTCOORD: ', Xlite[Lite], ' ', Ylite[Lite], ' ', Zlite[Lite]);
    writeln (Out, 'LTINTENS: ', Intensity[Lite]);
  end;

  close (Out);

end; { WRITECFG }


