VAR
  GxZoomIndex : Integer;

  PROCEDURE ZoomPan;

  {Package to enable zoom and pan. Pan is achieved by pressing the ARROWED
   KEYS in the numeric key pad, Zoom by pressing + for out and - for in.
   To fix the new window to the currently displayed frame press key 5.
   To leave without changing the current window press key 7 (home).

   The old window coordinates are NOT saved.

   IMPORTANT:  the numeric keypad MUST be in NumLock mode, otherwise the
               bell is sounded.}


CONST
    BELL = ^G;
    Esc = ^[;
    control : SET OF Char = ['2', '4', '5', '6', '7', '8', '+', '-'];

  TYPE
    actions = (ZoomIn, ZoomOut, PanLeft, PanRight, PanUp, PanDown, Fix, Quit);

  VAR
    action : actions;
    Fxc, Fyc : Real; {centre of frame}
    Fw, Fh : Real; {frame width and height}
    SemiFw, SemiFh : Real;
    bx, By, Tx, Ty : Real; {frame coordinates: bottom left, top right}
    DeltaW, DeltaH : Real; {zoom-pan step increments}
    DeltaWmin, DeltaHmin : Real;
    CurrMode : Integer;
    CurrIndex : Integer;

    PROCEDURE DrawFrame;
    VAR
      LineX, LineY : Real;

    BEGIN
      SemiFw := Fw*0.5;
      SemiFh := Fh*0.5;
      bx := Fxc-SemiFw;
      By := Fyc-SemiFh;
      Tx := Fxc+SemiFw;
      Ty := Fyc+SemiFh;
      LineX := 0.05*Fw;
      IF LineX < DeltaWmin THEN
        BEGIN
          MoveTo(bx, By);
          DrawTo(Tx, By);
          DrawTo(Tx, Ty);
          DrawTo(bx, Ty);
          DrawTo(bx, By);
          PlotAt(bx, By);

         PlotAt(Tx, By);
          PlotAt(Tx, Ty);
          PlotAt(bx, Ty);
        END
      ELSE
        BEGIN
          LineY := 0.05*Fh;
          MoveTo(bx, By+LineY);
          RelDrawTo(0, -LineY);
          RelDrawTo(LineX, 0);
          MoveTo(Tx-LineX, By);
          RelDrawTo(LineX, 0);
          RelDrawTo(0, LineY);
          MoveTo(Tx, Ty-LineY);
          RelDrawTo(0, LineY);
          RelDrawTo(-LineX, 0);
          MoveTo(bx+LineX, Ty);
          RelDrawTo(-LineX, 0);

        RelDrawTo(0, -LineY);
        END;
    END {DrawFrame} ;

    FUNCTION GetAction : actions;
    VAR
      c : Char;
      numlock : Byte;

    BEGIN
      numlock := Mem[$40:$17] AND $20; {record Numlock status}
      Mem[$40:$17] := Mem[$40:$17] OR $20; {force NumLock on}
      REPEAT
        Read(Kbd, c);
        IF c = Esc THEN
          BEGIN
            Read(Kbd, c);
            IF c IN ['1'..'9'] THEN
              BEGIN
                DeltaW := ((Ord(c)-Ord('0')) SHL 2)*

                (GxWxt-GxWxb)/(GxVxt-GxVxb);
                DeltaH := DeltaW*(Fh/Fw);
                c := Esc;
              END
            ELSE
              Write(BELL);
          END;
      UNTIL c IN control;
      CASE c OF
        '2' : GetAction := PanDown;
        '4' : GetAction := PanLeft;
        '6' : GetAction := PanRight;
        '8' : GetAction := PanUp;
        '+' : GetAction := ZoomOut;
        '-' : GetAction := ZoomIn;
        '5' : GetAction := Fix;
        '7' :
GetAction := Quit;
      END;
      Mem[$40:$17] := Mem[$40:$17] AND NOT($20); {force NumLock off}
      Mem[$40:$17] := Mem[$40:$17] OR numlock; {restore Numlock status}
    END {GetAction} ;

  BEGIN {Zoom - Pan}
    IF NOT(GxZoomIndex IN [0..GxIndexRng]) THEN
      GxZoomIndex := GxPalette[15]; {white in default colour map}
    CurrMode := GxMode;
    CurrIndex := GxIndex;
    GxIndex := GxZoomIndex;
    Fxc := (GxWxt+GxWxb)*0.5;
    Fyc := (GxWyt+GxWyb)*0.5;
    Fw := (GxWxt-GxWxb)*0.5;

    Fh := (GxWyt-GxWyb)*0.5;
    DeltaW := 4.0*(GxWxt-GxWxb)/(GxVxt-GxVxb);
    DeltaH := DeltaW*(Fh/Fw);
    DeltaWmin := DeltaW;
    DeltaHmin := DeltaH;
    WriteModeXor;
    DrawFrame;
    REPEAT {... until action is either Fix or Quit}
      action := GetAction;
      DrawFrame; {to delete currently displayed frame}
      CASE action OF
        ZoomIn : BEGIN
                   Fw := Fw-DeltaW; Fh := Fh-DeltaH;
                   IF Fw < DeltaWmin THEN
                     BEGIN

                  Fw := DeltaWmin; Fh := DeltaHmin;
                     END;
                 END;
        ZoomOut : BEGIN
                    Fw := Fw+DeltaW; Fh := Fh+DeltaH;
                  END;
        PanLeft : Fxc := Fxc-DeltaW;
        PanRight : Fxc := Fxc+DeltaW;
        PanUp : Fyc := Fyc+DeltaH;
        PanDown : Fyc := Fyc-DeltaH;
        Fix, Quit : ;
      END;
      DrawFrame; {to display new frame}
    UNTIL action IN [Quit, Fix];

    DrawFrame; {to delete finally select
ed frame}
    IF action = Fix THEN
      Window(bx, By, Tx, Ty);
    GxMode := CurrMode;
    IF GxMode = GxXor THEN
      WriteModeSet;
    GxIndex := CurrIndex;
  END {ZoomPan} ;

  PROCEDURE ZoomColour(index : Integer);
  BEGIN
    GxZoomIndex := index AND $F;
  END {ZoomColour} ;

