procedure SETSYS;
{ Initialize system-dependent parameters, and check for hardware presence
  if possible.  (Ncolors is set to 0 if the hardware is known to not be
  present.
}

begin
  case System of
    STDCGA: begin
      Ngraphchar := 40;
      Gxmin := 5;
      Gxmax := 315;
      Gymin := 5;
      Gymax := 195;
      Ncolors := 3;
    end;
    EGA: begin
      Ngraphchar := 80;
      Gxmin := 5;
      Gxmax := 630;
      Gymin := 5;
      Gymax := 345;
      { Set the number of available colors on this EGA system (dependent on the
        amount of EGA memory on the board). }
      Inline(
      $B4/$12                {     MOV     AH,$12}
      /$B3/$10               {     MOV     BL,$10}
      /$B9/$FF/$FF           {     MOV     CX,$FFFF}
      /$CD/$10               {     INT     $10}
                             {     XOR     AX,AX}
      /$81/$F9/$FF/$FF       {     CMP     CX,-1}
      /$74/$00               {     JZ      X43}
      /$B8/$03/$00           {     MOV     AX,$3}
      /$08/$DB               {     OR      BL,BL}
      /$74/$03               {     JZ      X43}
      /$B8/$0F/$00           {     MOV     AX,$f}
      /$A3/>NCOLORS          {X43:  MOV     [>Ncolors],AX}
      );
      if Ncolors = 0 then begin
        writeln('You don''t have an EGA');
        halt;
      end;
    end;
    HERCULES: begin
      Ngraphchar := 0;
      Gxmin := 10;
      Gymin := 5;
      Gxmax := 709;
      Gymax := 344;
      Ncolors := 1;
    end;
    SANYO: begin
      Ngraphchar := 80;
      Gxmin := 10;
      Gxmax := 630;
      Gymin := 5;
      Gymax := 195;
      Ncolors := 7;
    end;
    Z100: begin
      Ngraphchar := 0;
      Gxmin := 5;
      Gxmax := 630;
      Gymin := 5;
      Gymax := 220;
      Ncolors := 7;
    end;
    TBCGA: begin
      { Initialize the graphics first }
      if (not TBinit) then begin
        initgraphic;
        exgraphic;
        TBinit := TRUE;
      end;
      Ngraphchar := 40;
      Gxmin := 10;
      Gymin := 5;
      Gxmax := Xscreenmaxglb - 10;
      Gymax := Ymaxglb - 5;
      Ncolors := 1;
    end;
    ATT: begin
      { Initialize the graphics first }
      if (not TBinit) then begin
        initgraphic;
        exgraphic;
        TBinit := TRUE;
      end;
      Ngraphchar := 0;
      Gxmin := 10;
      Gymin := 5;
      Gxmax := Xscreenmaxglb - 10;
      Gymax := Ymaxglb - 5;
      Ncolors := 15;
    end;
    IBM3270: begin
      { Initialize the graphics first }
      if (not TBinit) then begin
        initgraphic;
        exgraphic;
        TBinit := TRUE;
      end;
      Ngraphchar := 0;
      Gxmin := 10;
      Gymin := 5;
      Gxmax := Xscreenmaxglb - 10;
      Gymax := Ymaxglb - 5;
      Ncolors := 15;
    end;
    QUAD480: begin
      Ncolors := 15;
      Ngraphchar := 80;
      Gxmin := 5;
      Gxmax := 635;
      Gymin := 5;
      Gymax := 475;
    end;
    QUAD752: begin
      Ncolors := 15;
      Ngraphchar := 80;
      Gxmin := 5;
      Gxmax := 747;
      Gymin := 5;
      Gymax := 405;
    end;
  end; { case System }
end; { procedure SETSYS }
