procedure SURFFILE;
 { read an old SURFMODL data file }

var
   Firstnode, Lastnode:   integer;       { first, last node # in the solid }
   Num:                   integer;       { #inputted vals on line }
   Comment:               text80;        { comment at end of line }
   Realvar:               vartype;       { genl. input array }
   Scale:                 vector;        { scale factors }
   Shift:                 vector;        { shift distances }
   Rotate:                vector;        { rotation angles }
   Filename:              text80;        { name of SURFMODL data file }

begin
  Line_num := Line_num + 1;
  readln (Infile, Filename);
  if (In_version > 1) then begin
    Line_num := Line_num + 1;
    Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
    if (Num <> 6) then begin
      writeln ('Bad input for shifting or scaling (line ', Line_num, ')');
      writeln ('Expecting 6 numeric entries');
      close (Infile);
      halt;
    end;
    Scale[1] := Realvar[1];
    Scale[2] := Realvar[2];
    Scale[3] := Realvar[3];
    Shift[1] := Realvar[4];
    Shift[2] := Realvar[5];
    Shift[3] := Realvar[6];

    Line_num := Line_num + 1;
    Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
    if (Num <> 3) then begin
      writeln ('Bad input for rotations (line ', Line_num, ')');
      writeln ('Expecting 3 numeric entries');
      close (Infile);
      halt;
    end;
    Rotate[1] := Realvar[1];
    Rotate[2] := Realvar[2];
    Rotate[3] := Realvar[3];
  end;

  Firstnode := Nnodes + 1;
  readfile (Filename);
  Lastnode := Nnodes;

  if (In_version > 1) then begin
    rotatenodes (Firstnode, Lastnode, Rotate);
    shiftnodes (Firstnode, Lastnode, Shift);
    scalenodes (Firstnode, Lastnode, Scale);
  end;
end; { procedure SURFFILE }
