;Program		: YESNO.ASM
;Author			: Gary Conway
;Created		: 11.07.86
;Updated		: 02.02.89
;Notice			: Copyright 1986-1989 Infinity Design Concepts
;			  All Rights Reserved
;Environ		: COM


MajVer		Equ	1
MinVer		Equ	1


comment	\

	This program will execute a command line and then return an
	errorlevel that can be read by a batch file errorlevel function.
	Useful in batch files when the user needs to respond to some 
	question and would like access to the users response.
		The response returned is an ASCII char in decimal, i.e.

.... a portion of a batch file

	YESNO RESP "Do you want the money ? " ( YESNO gets users answer)
	IF ERRORLEVEL 59 ECHO I will give it to you then
	IF ERRORLEVEL 78 ECHO Ok, then don't take it

.. 59 and 78 above are the ASCII chars Y and N

	For more examples of how to use YESNO, see the FLOPPY.BAT file, also
	in this ARChive.
	
RETURN CODES:
		    0 - No response asked for
	     Non Zero - Errorlevel is the actual character
			entered by the user.  It  has been 
			converted to upper case and is  in
			decimal  --- (when accessed by the 
			ERRORLEVEL function in BATch files).


SYNTAX:	yesno resp "What is your answer ? "
	---- waits for reply from user 

	yesno 27 "[31m" "Does not wait here" 13 10
	---- simply prints message in ANSI color and then CR,LF

	yesno resp 13 10 "What is your reply ?"
	---- sends CR,LF and prompt and waits for reply

	yesno 13 "N" 13 | FORMAT A:
	---- formats the disk in A with no user intervention

NOTES:	any ALT-permissable value may be used on the command line

	\

CR		Equ	13
LF		Equ	10


CSEG	SEGMENT PARA PUBLIC 'CODE'
	ASSUME CS:CSEG,DS:CSEG,SS:CSEG,ES:CSEG

.xlist
.xcref

	ORG	100H			;SKIP TO END OF THE PSP

START	PROC	NEAR

		Jmp	GO

		DB	cr,lf
		DB	"YESNO.COM - batch file enhancer version "
		DB	MajVer+"0",".",MinVer+"0",cr,lf
		DB	"Copyright 1986-1989 Infinity Design Concepts ",cr,lf
		DB	"All Rights Reserved.",cr,lf
		DB	"1052 Parkway Drive ",cr,lf
		DB	"Louisville, Kentucky 40217 ",cr,lf
		DB	"(502) 636-1234",cr,lf
		DB	1Ah

GO:

		Mov	SI,81h		;check for response trigger
		Cld
SkipSpace:	Lodsb
		Call	Case
		Cmp	AL,' '
		Je	SkipSpace
		Cmp	AL,'R'
		Jne	NoResponse
		Lodsb
		Call	Case
		Cmp	AL,'E'
		Jne	NoResponse
		Lodsb
		Call	Case
		Cmp	AL,'S'
		Jne	NoResponse
		Lodsb
		Call	Case
		Cmp	AL,'P'
		Jne	NoResponse
;get here then user wishes an answer to a question
		Mov	RespFlag,1
		Je	YesResponse

NoResponse:	Mov	SI,81h
		Mov	RespFlag,0
YesResponse:	Mov	BX,0
		Mov	CH,0
Parse:		Lodsb			;get next char from command line
Parse1:		Cmp	AL,0Dh
		Jz	RealCR
		Cmp	AL,22h		;quote ?
		Jnz	NoQuote
		Cmp	CH,1		;have end " in AL, is this pass 1 ?
		Jnz	Pass0		;nope, it is pass 0
		Lodsb			;get next char
		Cmp	AL,22h		;is it quote ?
		Jz	YesQuote	;yup
		Xor	CH,1		;toggle CH back to 0
		Jmp	Parse1
Pass0:		Xor	CH,1		;toggle CH (make it 1 for inside " "'s)
		Jmp	Alpha
NoQuote:	Cmp	CH,1		;is CH = 1 ?
		Jnz	CheckNumeric	;nope
YesQuote:	Mov	DL,AL
		Mov	AH,2
		Int	21h		;print char
		Jmp	Parse
CheckNumeric:	Cmp	AL,'0'		;lower end of numerics ?
		Jl	Alpha		;jmp if below 30H
		Cmp	AL,'9'
		Jg	Alpha		;jmp if above 39H
		And	AL,0Fh		;zero high nibble
		Xchg	BX,AX		;give BL char to convert
		Mov	BH,10
		Mul	BH		;AX = AX * 10
		Xchg	BX,AX
		Add	BL,AL
		Mov	BH,1		;flag working on decimal conversion
		Jmp	Parse
Alpha:		Cmp	BH,0		;0 if " char is in AL
		Jz	Parse		;so go get next char
		Mov	DL,BL
		Mov	AH,2
		Int	21h		;print char
		Mov	BX,0
		Jmp	Parse
RealCR:		Cmp	BH,0
		Jz	Exit
		Mov	DL,BL
		Mov	AH,2
		Int	21h
Exit:		Mov	AL,0		;0 says errorlevel 0 (no reply)
		Cmp	RespFlag,1	;if 1 then ask for user reply
		Jne	ErrorLevelExit
		Mov	AH,1
		Int	21h		;wait for user response
		Call	Case
					;user char is the error level
ErrorLevelExit:	Mov	AH,4Ch
		Int	21h		;terminate, passing ERRORlevel in AL
		

Case:		Cmp	AL,'a'		;convert char to upper case
		Jl	GoBack
		Cmp	AL,'z'
		Jg	Goback
		Sub	AL,20h
Goback:		Ret


START	ENDP

RespFlag	DB	0


CSEG	ENDS
	END	start
