/*
Ŀ
 Title   : jaz.h							     
 Purpose : Define general purpose macros for use in my programs	     
									     
	Written by Jack Zucker - 75766,1336    301-794-5950  on 1/15/85      

*/

/* given a segment and offset, return a pointer which will point to the */
/* seg:off pair 							*/

#define LPOINTER(type,seg,ofs) (type far *) ((long) seg << 16 | ofs)


/*  define various memory peek macros.  */

/* this one returns a char */
#define MEMB(seg,ofs) (*LPOINTER(unsigned char,seg,ofs))

/* this one returns a word */
#define MEMW(seg,ofs) (*LPOINTER(unsigned int,seg,ofs))

#define MEML(seg,ofs) (*LPOINTER(long,seg,ofs))
/* this one returns a long */

/*  define a macro for avoiding snow.   */

/* this next macro will wait for the horizontal retrace status bit to */
/* avoid snow. Much more elegant than writing the routines in masm    */

#define WAITSCR while (inp(0x3da) & 1) ; while (! (inp(0x3da) & 1)) ;

struct tfat {
  long		free;
  long		total;
  long		used;
} ;
#define TFAT struct tfat


#if LINT_ARGS
/*global*/  unsigned char  *jzgetfat(int ,int  *,int  *,int  *);
#else
unsigned char *jzgetfat();
#endif

struct REGW {
  unsigned int ax,bx,cx,dx,si,di,ds,es,flags;
};

struct REGB {
  unsigned char al,ah,bl,bh,cl,ch,dl,dh;
};

union TREG {
  struct REGW x;
  struct REGB h;
};

struct tname {
  char *filename;
  struct tname *next;
};
#define TNAME struct tname

struct thead {
  int listlen;
  struct tname *first,*last;
};
#define THEAD struct thead

THEAD *rsplist();
THEAD *dirlist();

struct tregx {			/* define a register struct for bios calls */
  unsigned int ax,bx,cx,dx,si,di,ds,es,flags;
};

struct tregh {
  unsigned char al,ah,bl,bh,cl,ch,dl,dh;
};

union treg {
  struct tregx x;
  struct tregh h;
};
#define TREG union treg

struct tvector { unsigned int offset,segment; };
#define TVECTOR struct tvector

/*global*/  void intr(int , TREG *);
/*global*/  int rindex(char *,char);
/*global*/ char *tabtosp(char *,char *);
/*global*/ void jzdskfre(TFAT *,int);
/*global*/ char *jzpad(int , int);
/*global*/ void jzgetint(int,TVECTOR *);
/*global*/ int jzinstr(char*,int,int,int,int,long,char*);
/*global*/ char *jzrgtjst(char *,int);
/*global*/ void jzdelay(long);
/*global*/ char *jzstrpos(char *,char*);
#define msdos(_wreg) intr(0x21,_wreg)	/* define turbo like msdos call */
#define hibyte(x) (unsigned int) x & 0xff
#define lobyte(x) (unsigned int) x >> 8
#define max(x,y) (x > y ? x : y)
#define min(x,y) (x < y ? x : y)
