;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
; Beep.asm
;
; Function: Do a beep
;   Handle Decrement beep counter
;   Handle Interrupt driven (Via the 18.2 Hz Clock) control over audio output
;
	;MASM MODE
	.386p

include  segs.asi 
include  dispatch.ase 
include  iodelay.asi 

BEEP_WAITING EQU 2	; State for idle beeper
BEEP_ON	     EQU 1	; State for beeper on
BEEP_OFF     EQU 0	; State for beeper off; Must keep these in order
BEEP_ONCOUNT EQU 6	; Beeper on-time , 18.2ths of a second
BEEP_OFFCOUNT EQU 3	; Beeper off-time
TIMERPORT    EQU 61h	; Beeper control port
TIMERCTL     EQU 43h	; Timer controll port
TIMER2DATA   EQU 42h	; Timer 2 frequency port
TIMER2CMD    EQU 0b6h	; Timer 2 set command
BEEPERFREQ   EQU 1000	; Beeper frequency


	PUBLIC	beepcount, beepint, beep_disable

SEG386DATA	SEGMENT	
beepcount	dd	2		; Do two beeps on power up
beepstate	db	BEEP_WAITING	; Current state of beeper
beepwait	db	0		; Interrupts to wait
seg386data	ENDS	

seg386	SEGMENT	
;
; Turn off beeper at power-down
;
beep_disable	PROC	
	in	al,TIMERPORT		; Get control value
	and	al,0fch			; Clear beeper bits
	out	TIMERPORT,al		;
	ret
beep_disable	ENDP	
;
; Beeper interrupt
;
beepint	PROC	
	push	eax			; Save ax
	test	[beepwait],-1		; See if waiting
	jz	short chkwait		; No, check state
	dec	[beepwait]		; Else dec count
	jmp	done			; And get out
chkwait:
	cmp	[beepstate],BEEP_WAITING ; See if beeper idle
	jnz	short chkon		; No, see if on
	test	[beepcount],-1		; If idle and beeps left is none
	jz	short done		; Get out
	mov	[beepwait],BEEP_ONCOUNT ; Else set on timing
	dec	[beepstate]		; Set state to on
	mov	al,TIMER2CMD		; Set beeper freq
	out	TIMERCTL,al		;
	IODELAY
	mov	ax,BEEPERFREQ		;
	out	TIMER2DATA,al		;
	IODELAY
	mov	al,ah			;
	out	TIMER2DATA,al		;
	in	al,TIMERPORT		; Turn beeper on
	or	al,3			;
	out	TIMERPORT,al		;
	jmp	short done		; Exit
chkon:
	cmp	[beepstate],BEEP_ON	; If state is on
	jnz	short chkoff		;
	mov	[beepwait],BEEP_OFFCOUNT; Set the offcount
	dec	[beepstate]		; Set state to off
	in	al,TIMERPORT		; Turn beeper off
	and	al,0fch			;
	out	TIMERPORT,al		;
	jmp	short done		; Exit
chkoff:
	cmp	[beepstate],BEEP_OFF	; If state is off
	jnz	short done		;
	dec	[beepcount]		; Dec the beeps left count
	mov	[beepstate],BEEP_WAITING; Set state to idle
done:
	pop	eax			; Restore eax
	ret
beepint	ENDP	
seg386	ENDS	
END
