;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
;
; Dispatch.asm
;
; Function: OS Function dispatcher
;   Handles Call to Major function number
;   Handles generic call to function number
;   Handles keeping track of last known error
;
	;MASM MODE
	.386p
include  segs.asi 
include  os.asi 
include  page.asi 
include  tss.asi 
include  tss.ase 
include  errors.asi 
include  prints.ase 

	PUBLIC	_oshandler, TableDispatch, nofunction, LastError

	extrn _dosfilehandler: proc, _videohandler: proc, TaskHandler : PROC
	extrn _kbhandler: proc, _mischandler: proc, memoryhandler : PROC
	extrn serialhandler : PROC, floppyhandler : PROC
	extrn fs_dispatch : PROC, DirTest : PROC
	extrn FileHandler : PROC, Graphics_Handler : PROC
	extrn MouseHandler : PROC

seg386data	SEGMENT	
LastError	dd	0
seg386data	ENDS	

seg386	SEGMENT	
;
; Dispatch an OS function call to the appropriate handler
;
_oshandler	PROC	far
	assume	ds:nothing, es:nothing
	ENTER	0,0
	
	mov	eax,[ebp+12]		; Get key ( this is a FAR call )
	push	eax
	mov	al,ah			; High byte of key tells which routines		
	call	TableDispatch		; Dispatch to the subroutine
	dd	MAX_OSFUNC
	dd	_kbhandler
	dd	_videohandler
	dd	_dosFileHandler
	dd	TaskHandler
	dd	memoryhandler
	dd	_MiscHandler
	dd	serialhandler
	dd	floppyhandler
	dd	floppyhandler
	dd	fs_dispatch
	dd	FileHandler
	dd	Graphics_Handler
	dd	MouseHandler
	jnc	short oh_noerror		; Skip if no error
	sub	ah,ah			; Otherwise convert to long
	cwde				;
	assume ds:dgroup
	push	ds
	push	DS386
	pop	ds
	mov	[LastError],eax		; Save in LastError
	pop	ds
	assume ds:nothing
	stc				; Set Error flag again
oh_noerror:
       	LEAVE
	ret	04
_oshandler	ENDP	
;
; Core dispatch routine.  Calls the subfunction indicated in AL
; and then set the return address to after the dispatch table
; This expects a subfunction code to be on the stack
;
TableDispatch	PROC	
	ENTER	0,0
	xchg	ebx,[ebp+4]		; xchg ret address & ebx
	cmp	al,cs:[ebx]		; Limit check
	ja	short noaction		; Error if too big
	; Here we call the routine
	push	offset cgroup:finishup		; Return address
	sub	ah,ah			; Make key a dword
	cwde				;
	push	DWORD PTR cs:[ebx + 4 * eax + 4]	; Get code address to stack
	xchg	ebx,[ebp+4]		; put things as they were
	mov	eax,[ebp + 8]		; Get the subkey
	cld				; Assume move dir up
	ret				; Go to subroutine
	
noaction:
	xchg	ebx,[ebp+4]		; Put things as they were
	call	nofunction		; Register bad function error
finishup:
	; Now we have to find the return address
	xchg	ebx,[ebp+4]		; Get return address
	push	eax
	mov	eax,cs:[ebx]
	lea	ebx,[ebx + 4 * eax + 8]	; Get offset to return address
	pop	eax
	xchg	ebx,[ebp+4]		; Xchg with orig value of ebx
	LEAVE
	ret	4
TableDispatch	ENDP	
nofunction	PROC	
	mov	eax,ERR_ILLFUNC		; Ill function error
	stc				; Set carry flag
	ret
nofunction	ENDP	
seg386	ENDS	
END
	
	
	
	
	
	
