;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
;
; traps.asm
;
; Function : Dynamic changing of trap vectors
;
;
	;MASM MODE
	.386p

include  segs.asi 
include  descript.ase 
include  boot.ase 
include  gdt.asi 

	PUBLIC GetTrapVect, SetTrapVect
seg386	SEGMENT	
GetTrapVect	PROC	
	push	edi
	shl	edi,3
	add	edi,offset dgroup:tIDT
	call	GetDescriptorType
	or	al,al
	jns	novector
	and	al,0fh
	cmp	al,ST_TRAPGATE
	jnz	novector
	call	GetGateOffset	
	mov	ebx,eax
	call	GetGateSelector
	mov	edx,eax
	sub	eax,eax
	clc
	pop	edi
	ret
novector:
	stc
	pop	edi
	ret
GetTrapVect	ENDP	
SetTrapVect	PROC	
	push	edi
	shl	edi,3
	add	edi,offset dgroup:tIDT
	mov	[edi + GATEDESC.GTYPE],DT_PRESENT OR DT_DPL3 OR ST_TRAPGATE
	mov	[edi + GATEDESC.COUNT],0
	mov	eax,edx
	call	SetGateSelector
	mov	eax,ebx
	call	SetGateOffset
	sub	eax,eax
	pop	edi
	ret
SetTrapVect	ENDP	
seg386	ENDS	
END
