;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
;
; EXEC.ASM
;
; Function: Handle T,G,P commands
;
	;MASM MODE
	.386p


include  segs.asi 
include  os.asi 
include  gdt.asi 
include  prints.ase 
include  input.ase 
include  mtrap.ase 
include  breaks.ase 

TRAPFLAG = 100h			; 80386 trap enable flag

	PUBLIC go,trap, proceed

seg386	SEGMENT	
;
; Wade through spaces only
;
WadeSpaceOnly	PROC	
	lodsb			; Get a char
	cmp	al,' '		; Is space
	jz	WadeSpaceOnly	; Loop if so
	dec	esi		; Else point at char
	ret
WadeSpaceOnly	ENDP	
;
; Execute program
;
go	PROC	
	Call	WadeSpaceOnly	; Wade till address
	cmp	al,13		; CR means from this point on
	jz	short dogo	; Do it from this EIP if CR
	inc	esi		; See if is a comma
	cmp	al,','		;
	jz	short dobreak	; Only a breakpoint if so
	dec	esi		; Get the execution point
	call	ReadAddress	;
	jc	goerr		;
	mov	[dreip],ebx	; Fix CS:EIP for new routine
	or	dx,dx		;
	jz	short checkbreak;
	mov	[drcs],dx	;
checkbreak:
	call	WadeSpaceOnly	; Wade
	cmp	al,13		; execute if CR
	jz	short dogo	;
	cmp	al,','		; Check for comma
	jnz	goerr		; Error if not a comma
	inc	esi		; Wade to address
	call	WadeSpaceOnly
dobreak:
	call	ReadAddress	; Read break address
	jc	goerr		; Quit if errir
	sub	eax,eax		; Break 0
	call	SetBreak	; Set the break
dogo:
	call	EnableBreaks	; Enable breaks
	xor	eax,eax		; Not trapping
	jmp	short gotrap	; Run the code
go	ENDP	
;
; Limited procede, only traps through near and far direct calls
;
PROCEED	PROC	
	push	fs		; Get CS:EIP in FS:EBX
	mov	fs,[drcs]	;
	mov	ebx,[dreip]	;
	mov	ah,fs:[ebx]	; Load the first byte of the instruction
	pop	fs
	cmp	ah,0e8h		; Near Call?
	mov	al,5		; Yes, this is five bytes
	jz	short pgo	; And execute it
	cmp	ah,09ah		; Far call
	mov	al,7		; This one is 7 bytes
	jnz	short trap	; Not either of these, just trap
pgo:
	cbw			; EAX = bytes to skip past
	cwde			;
	add	ebx,eax		; Ebx = breakpoint
	mov	dx,[drcs]	; DX:EBX = position to break at
	sub	eax,eax		; Use the scratch breakpoint
	call	SetBreak	; Set a break
	call	EnableBreaks	; Enable breakpoints
	sub	eax,eax		; No trapping
	jmp	short gotrap	; Run the code
PROCEED	ENDP	
;
; Trap command
;
trap	PROC	
	mov	eax,TRAPFLAG	; Are trapping on instruction
gotrap:
	mov	esp,[rtoss]	; Load toss
	mov	ebx,cs		; See if changing priv levels
	movzx	ecx,[drcs]	;
	xor	ebx,ecx		;
	test	ebx,SEL_RPL	;
	jz	short nostack   ;
	movzx	ebx,[drss]       ; Yeah, have to put outer stack on inner stack
	push	ebx		;
	push	[dresp]		;
nostack:
	or	eax,[reflags]	; Fill stack frame with FLAGS , CS:EIP
	push	eax		;
	movzx	ebx,[drcs]	;
	push	ebx		;
	push	[dreip]		;
	movzx	ebx,[drds]	; Load DS last
	push	ebx		;
	movzx	eax,[dres]	; Load other segs
	mov	es,eax		;
	movzx	eax,[drfs]	;
	mov	fs,eax		;
	movzx	eax,[drgs]	;
	mov	gs,eax		;
	mov	eax,[dreax]	; Load regs
	mov	ebx,[drebx]	;
	mov	ecx,[drecx]	;
	mov	edx,[dredx]	;
	mov	esi,[dresi]	;
	mov	edi,[dredi]	;
	mov	ebp,[drebp]	;
	pop	ds		; Load DS
	iretd
goerr:
	stc
	ret
TRAP	ENDP	
seg386	ENDS	
end