;
; prints.asm
;
;  Function: Print utilities used for testing
;
	.386


include  os.asi 

	PUBLIC	printspace,printdword,printword,printbyte
	PUBLIC	printDecimalNumber

_text	SEGMENT	PUBLIC USE32 "CODE"
	assume cs:_text, ds:NOTHING
printspace:
	push	edx
	mov	dl,20h		; Get a space
	os	VF_CHAR		; Output it
	pop	edx
	ret
printdword:
	push	eax		; To print a dword
	shr	eax,16		; Print the high 16 bits
	call	printword
	pop	eax		; And the low 16 bits
printword:
	push	eax		; To print a word
	mov	al,ah		; Print the high byte
	call	printbyte
	pop	eax		; And the low byte
printbyte:
	push	eax		; To print a byte
	shr	eax,4		; Print the high nibble
	call	printnibble
	pop	eax		; And the low nibble
printnibble:
	and	al,0fh		; Get a nibble
	add	al,'0'		; Make it numeric
	cmp	al,'9'		; If supposed to be alphabetic
	jle	onib
	add	al,7		; Add 7
onib:
	push	edx		; Save DX through the call
	PUTCHAR	al		; Put a char
	pop	edx		;
	ret
NUMBERBUF	=	ebp - 20
PrintDecimalNumber	PROC	
	ENTER	20,0
	push	ebx
	push	ecx
	push	edx
	push	esi
	lea	esi,[NUMBERBUF]
	mov	ebx,10
	sub	ecx,ecx
pdn_divlp:
	sub	edx,edx
	div	ebx
	add	dl,'0'
	mov	ss:[esi],dl
	inc	esi
	inc	ecx
	or	eax,eax
	jnz	pdn_divlp
pdn_prlp:
	dec	esi
	mov	dl,ss:[esi]
	os	vf_char
	loop	pdn_prlp
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	leave
	ret
PrintDecimalNumber	ENDP	
_text	ENDS	
END