;************************************************************************
;*                                                                      *
;*      DATETIME command. (C) 1997 Ronald Nordberg.                     *
;*      Those MS-DOS DATE/TIME commands drives me nutz when they always *
;*      want me to give it a new date/time. So I did this one instead.  *
;*                                                                      *
;*      Comments, suggestions:                                          *
;*      christine.martinson@swipnet.se                                  *
;*      This is Completley PUBLIC DOMAIN.                               *
;*                                                                      *
;************************************************************************

msdos           equ     21h             ;MSDOS irq
getdate         equ     2ah             ;get current date
gettime         equ     2ch             ;get current time
fwrite          equ     40h             ;write to file with handle
exit            equ     4c00h           ;msdos exit

[SEGMENT .text]                         ;NASM stuff
[ORG 100h]

        jmp     start

tbuff   dw      0,0,0,0,0,0,0,0,0,0,0,0,0    ;data storage
year    dw      0
mth     db      0
day     db      0
days    db     'SunMonTueWedThuFriSat',0
month   db     'JanFebMarAprMayJunJulAugSepOctNovDec',0

start:                                  ;herewego
        mov     ax,cs
        mov     ds,ax

        mov     ah,getdate              ;get current date
        int     msdos                   ;MSDOS interrupt
        mov     [year],cx               ;save year
        mov     [mth],dh                ;save month
        mov     [day],dl                ;day
          
        mov     si,days                 ;source buffer
        mov     di,tbuff                ;dest buffer
        cbw                             ;dayname in AL, make word
        mov     cx,ax                   ;loop count
copy0:  add     si,3                    ;add offset to SI
        loop    copy0
        mov     cx,3                    ;copy 3 chars
copy1:  lodsb                           ;copy DS:SI->AL
        stosb                           ;copy AL->ES:DI
        loop    copy1                   ;three of them
        mov     al,' '                  ;a SPACE
        stosb                           ;copy it
        mov     al,[day]                ;get day
        cbw                             ;expand to word
        mov     dx,ax                   ;copy to work
        call    conv                    ;make ascii
        mov     al,' '                  ;a space
        stosb
        mov     si,month                ;month name buffer
        sub     si,3                    ;adjust back
        xor     cx,cx                   ;clar that one
        mov     cl,[mth]                ;get month
adjit:  add     si,3                    ;add 3 to offset for each month
        loop    adjit                   ;go on
        mov     cx,3                    ;copy 3 chars
copy2:  lodsb
        stosb
        loop    copy2
        mov     al,' '                  ;a space
        stosb                           ;copy it
        mov     dx,[year]               ;get year
        call    conv                    ;make ascii
        mov     al,' '                  ;a space
        stosb                           ;copy it
        mov     al,' '                  ;a space
        stosb                           ;copy it
                 
        mov     ah,gettime              ;get current time
        int     msdos                   ;MSDOS interrupt
        mov     bh,dh                   ;save second
        mov     bl,cl                   ;minute
        mov     al,ch                   ;get hour
        cbw                             ;expand to WORD
        mov     dx,ax                   ;copy to workreg
        call    conv                    ;convert to ASCII
        mov     al,':'                  ;copy those
        stosb
        mov     al,bl                   ;get minute
        cbw
        mov     dx,ax
        call    conv
        mov     al,':'
        stosb
        mov     al,bh                   ;get second
        cbw
        mov     dx,ax
        call    conv

        mov     al,13                   ;linefeed
        stosb
        mov     al,10                   ;carriage
        stosb
        mov     al,0
        stosb

        mov     dx,tbuff                ;get the output buffer
        mov     cx,25                   ;25 chars
        mov     bx,1                    ;filehandle 1=CON:
        mov     ah,fwrite               ;get function
        int     msdos                   ;write it out

        xor     eax,eax                 ;clean out eax
        mov     ax,exit                 ;MS-DOS successful exit
        int     msdos                   ;back to the operating system

conv:
        mov     ax,dx                  ;add in numerator
        mov     dx,0                   ;clear top half
        mov     cx,10                  ;enter decimal divisor
        div     cx                     ;perform division AX/CX
        xchg    ax,dx                  ;get quotient
        add     al,30h                 ;make digit ASCII
        mov     [di+1],al              ;store digit in proper place
        mov     ax,dx                  ;do it twice to get all zeroes
        mov     dx,0
        mov     cx,10
        div     cx
        xchg    ax,dx
        add     al,30h
        mov     [di],al
        add     di,2
        ret

        END
