;
; (And you thought this nonsense was limited to Pyramid computers!)
;
; UNIVERSE.ASM -- Set the "universe" (MS-DOS or XENIX) of a PC compatible
;
; UNIVERSE by itself prints "XENIX" or "MSDOS" depending on the setting of
; the SWITCHAR as reported by undocumented DOS function call 37H.  With an
; argument, the first character of the argument is scanned: M sets MS-DOS,
; X sets Xenix(tm) compatible, and any other prints a help message, along
; with the current setting.  (UNIVERSE ? acts as just UNIVERSE.)
;
; XENIX and MS-DOS are trademarks of Microsoft Inc.
;

CR              EQU     13
LF              EQU     10
SPACE           EQU     32
EOS             EQU     '$'

XENIX_SW        EQU     '-'
MSDOS_SW        EQU     '/'

ARGC            EQU     80H
ARGV            EQU     81H

TELL_CMD        EQU     '?'
XENIX_CMD       EQU     'X'
MSDOS_CMD       EQU     'M'

PRINT_STR       EQU     09H
SET_SWITCH      EQU     37H
EXIT            EQU     4CH

;
; Required nonsense for the 8086/8088.  The 68000 is easier!
;

STACK_SEG       SEGMENT STACK
                DB      256 DUP(?)
STACK_SEG       ENDS

;
; The data area.  Ditto the above comment.  THIS shtuff looks like PDP-11
; with split I and D spaces!
;

DATA_SEG        SEGMENT

XENIX_MSG       DB      "You are in the Xenix(tm) universe."
                DB      CR,LF,EOS

MSDOS_MSG       DB      "You are in the MS-DOS(tm) universe."
                DB      CR,LF,EOS

HELP_MSG        DB      "UNIVERSE -- Public Domain MS-DOS 2/3 Uni"
                DB      "(x)verse Modification Utility"
                DB      CR,LF
                DB      "Written 6/30/85 by Brandon Allbery for g"
                DB      "eneral net sharing and use."
                DB      CR,LF
                DB      CR,LF
                DB      "You are free to copy, distribute, etc. t"
                DB      "his program in source or object form."
                DB      CR,LF
                DB      CR,LF
                DB      "UNIVERSE without any arguments prints th"
                DB      "e current universe (XENIX or MS-DOS) of"
                DB      CR,LF
                DB      "the computer.  With an argument of X or "
                DB      "M, it sets the specified mode."
                DB      CR,LF
                DB      CR,LF
                DB      "Xenix and MS-DOS are trademarks of Micro"
                DB      "Soft, Inc."
                DB      CR,LF
                DB      CR,LF,EOS

XENIX_SET       DB      "You are now in the Xenix(tm) universe."
                DB      CR,LF,EOS

MSDOS_SET       DB      "You are now in the MS-DOS(tm) universe."
                DB      CR,LF,EOS

DATA_SEG        ENDS

TEXT_SEG        SEGMENT
                ASSUME  CS:TEXT_SEG,DS:DATA_SEG,SS:STACK_SEG

;
; The main program ascertains the function, placing it in AL, and calls
; the procedure that does all the work.  On return, it prints the help
; message, if applicable.
;

MAIN            PROC    FAR

                MOV     BX,DATA_SEG    ; SET UP THE DATA SEGMENT (UGH)
                MOV     DS,BX
                MOV     AL,ES:[ARGC]   ; CHECK FOR ARGUMENTS
                CMP     AL,0           ; NONE, THEN REPORT STATUS
                JZ      TELL_FUNC
                MOV     BX,ARGV        ; PREPARE TO SEARCH FOR ARGS
FIND_ARG:       MOV     AL,ES:[BX]     ; GET NEXT CHAR OF ARGUMENT STRING
                INC     BX             ; AND SKIP PAST IT
                CMP     AL,SPACE       ; IS IT A SPACE?
                JZ      FIND_ARG       ; YES, THEN SKIP IT
                CMP     AL,XENIX_CMD   ; XENIX_CMD, THEN SET XENIX PATHS
                JZ      DO_FUNC
                CMP     AL,MSDOS_CMD   ; MSDOS_CMD, THEN SET MS-DOS PATHS
                JZ      DO_FUNC
                MOV     DX,OFFSET HELP_MSG ; NONE OF THE ABOVE, PRINT HELP
                MOV     AH,PRINT_STR
                INT     21H
TELL_FUNC:      MOV     AL,TELL_CMD    ; SET DEFAULT COMMAND = TELL_CMD
DO_FUNC:        CALL    SWITCHAR       ; DO THE SPECIFIED COMMAND
                MOV     AL,0           ; AND RETURN A NO-ERROR CODE
                MOV     AH,EXIT
                INT     21H

MAIN            ENDP

;
; The SWITCHAR function takes a command in AL, converts it to a system
; command, and calls the system.
;

SWITCHAR        PROC    NEAR

                CMP     AL,TELL_CMD    ; DO WE REPORT STATUS ONLY?
                JNZ     IS_XENIX
                MOV     AL,0
                MOV     AH,SET_SWITCH
                INT     21H
                CMP     DL,MSDOS_SW    ; IS IT THE MS-DOS UNIVERSE?
                JNZ     OTHER_SW
                MOV     DX,OFFSET MSDOS_MSG ; PRINT MS-DOS UNIVERSE MSG
                MOV     AH,PRINT_STR
                INT     21H
                RET                    ; AND EXIT TO MAIN PROCEDURE

OTHER_SW:       MOV     DX,OFFSET XENIX_MSG ; PRINT XENIX UNIVERSE MSG
                MOV     AH,PRINT_STR
                INT     21H
                RET                    ; AND EXIT AS ABOVE

IS_XENIX:       CMP     AL,XENIX_CMD   ; ARE WE SETTING XENIX MODE?
                JNZ     IS_MSDOS
                MOV     DL,XENIX_SW    ; YES, TELL DOS WE ARE XENIX
                MOV     AL,1
                MOV     AH,SET_SWITCH
                INT     21H
                MOV     DX,OFFSET XENIX_SET ; AND TELL THE USER
                MOV     AH,PRINT_STR
                INT     21H
                RET                    ; AND RETURN TO THE MAIN PROCEDURE

IS_MSDOS:       MOV     DL,MSDOS_SW    ; NO, SET THE MS-DOS UNIVERSE
                MOV     AL,1
                MOV     AH,SET_SWITCH
                INT     21H
                MOV     DX,OFFSET MSDOS_SET ; TELL THE USER
                MOV     AH,PRINT_STR
                INT     21H
                RET                    ; AND RETURN AS ABOVE

SWITCHAR        ENDP

TEXT_SEG        ENDS

                END     MAIN
