/* TCAP.H: C/C++ TCAP API.  See API.TXT for more information.
   Copyright(c) 1998 Tim Kannel

   Use of this source code in a commercial or shareware program,
   with or without modification, requires permission from the author.
   Permission to use this source code in freeware programs, with or without
   modification, is granted.  Distribution of a modified version of this
   source code requires permission from the author, regardless of the
   program distribution type.

   An 'id' function parameter refers to TCAP's multiplex id, returned
   by tcapGetID(). All functions other than tcapGetID() assume that
   TCAP is loaded and that 'id' is valid. Some functions require
   pointers in order to return information to the caller - no information
   will be stored if the pointer is NULL.
*/
#ifndef _TCAP_H
#define _TCAP_H

/* Global Data */

extern char _tcapID;  /* TCAP's ID number, updated by tcapGetID() */

/* Function Prototypes */

#ifdef __cplusplus
extern "C" {
#endif

/* tcapGetID: returns TCAP's multiplex id, or zero if TCAP is not installed.
   The integer pointed to by 'API' will be nonzero if the full API is
   supported, zero if not. The global variable '_tcapID' is also updated. */
char tcapGetID(int* API);

/* tcapGetVersion: returns TCAP's version number in the two integers
   pointed to by 'major' and 'minor'. *reserved is set to the value
   returned in register BX (should be zero). */
void tcapGetVersion(char id, int* major, int* minor,int* reserved);

/* tcapGetCaptureFlag: returns the state of TCAP's capturing - a zero
   value indicates that capturing is disabled, any other value indicates
   that capturing is enabled. */
unsigned short tcapGetCaptureFlag(char id);

/* tcapSetCaptureFlag: sets the state of TCAP's capturing - a zero
   value disables capturing, any other value enables capturing. */
void tcapSetCaptureFlag(char id, unsigned short flag);

/* tcapGetBufferBytes: returns the number of bytes waiting to be flushed. */
unsigned tcapGetBufferBytes(char id);

/* tcapFlush: attempts to flush the capture buffer.
   Return value: returns the number of bytes waiting to be
   flushed (zero if the flush was successful). */
unsigned tcapFlush(char id);

/* tcapWaitForFlush: waits for TCAP to flush its buffer.
   Waits for at most 'seconds' seconds before returning, if 'seconds'
   is <= 0 then the routine attempts a buffer flush and returns immediately.
   Return value: zero if the buffer is empty, nonzero otherwise. */
int tcapWaitForFlush(char id, int seconds);

/* tcapGetOverflowStatus: retrieves the primary and last-command
   overflow status values. The primary overflow value is returned as
   the function result, the last-command overflow value is stored in
   the integer pointed to by the second paraemter. */
int tcapGetOverflowStatus(char id, int* last_cmd_ovr);

#ifdef __cplusplus
}
#endif

#endif  /* _TCAP_H */
