/*********************************************************************
 * ImErr.h -- imaging error definitions.  
 *
 * made this version on 88-10-31
 */
#define IM_BASE	0

#define	IM_BUG				(IM_BASE +  1)	/* supposedly impossible situation - almost certainly my problem */
#define	IM_MEM_FULL			(IM_BASE +  2)	/* can't allocate enough memory */
#define	IM_MEM_FAIL			(IM_BASE +  3)	/* can't lock allocated memory */
#define	IM_NO_WIDTH			(IM_BASE +  4)	/* no ImageWidth */
#define	IM_NO_LENGTH		(IM_BASE +  5)	/* no ImageLength */
#define	IM_NO_OFFSETS		(IM_BASE +  6)	/* no StripOffsets */
#define	IM_BAD_SPP			(IM_BASE +  7)	/* unsupported SamplesPerPixel */
#define	IM_BAD_COMPR		(IM_BASE +  8)	/* unsupported compression type */
#define	IM_BAD_PHOTO		(IM_BASE +  9)	/* unsupported photometricInterpretation */
#define	IM_BAD_PREDICT		(IM_BASE + 10)	/* unsupported Predictor */
#define	IM_BAD_PLANAR		(IM_BASE + 11)	/* unsupported PlanarConfiguration */
#define	IM_BAD_BPS			(IM_BASE + 12)	/* unsupported BitsPerSample */
#define	IM_BAD_NUM_OFF		(IM_BASE + 13)	/* wrong number of StripOffsets */
#define	IM_UNK_FORMAT		(IM_BASE + 14)	/* unknown format */
#define	IM_BAD_FILLORDER	(IM_BASE + 15)	/* unsupported FillOrder */
#define	IM_BAD_WIDTH		(IM_BASE + 16)	/* bad ImageWidth - like 0 */
#define	IM_BAD_LENGTH		(IM_BASE + 17)	/* bad ImageLength - like 0 */
#define	IM_PRED_MISMATCH	(IM_BASE + 18)	/* cannot use this predictor with this bit depth */

#define	IM_FADING_COMPR		(IM_BASE + 19)	/* this compression type is not recommended */
#define	IM_BAD_TTYPE		(IM_BASE + 20)	/* bad tiff type (not BYTE or ASCII or ...) */
#define	IM_BAD_NUM_BITS		(IM_BASE + 21)	/* wrong number of BitsPerSample values */
#define	IM_LARGE_STRIP		(IM_BASE + 22)	/* the strip is larger than the recommended 10K */
#define	IM_BAD_NUM_COUNTS	(IM_BASE + 23)	/* wrong number of StripByteCounts */
#define	IM_NO_BYTECOUNTS	(IM_BASE + 24)	/* no StripByteCounts */	/* fatal if LZW */
#define	IM_BAD_NEXT_IFD		(IM_BASE + 25)	/* the (2nd) next-ifd-pointer points past EOF */
#define	IM_PB_BITSNOTONE	(IM_BASE + 26)	/* PackBits: bit depth is greater than 1 */
#define	IM_NO_PHOTO			(IM_BASE + 27)	/* no PhotometricInterpretation field */
#define	IM_FADING_BITDEPTH	(IM_BASE + 28)	/* not-recommended bit depth (probably 6) */
#define	IM_BAD_ROWSPERSTRIP	(IM_BASE + 29)	/* bad RowsPerStrip (probably 0) */
#define	IM_NO_COMPR			(IM_BASE + 30)	/* uncompressed */
#define IM_COLOR_CLASH		(IM_BASE + 31)	/* PhotometricInterpretation does not match SamplesPerPixel */
#define	IM_NO_NEWSUBFILETYPE (IM_BASE + 32)	/* no NewSubfileType */
