/*****************************************************************************
 * winmacp.c -- macpaint subroutine(s?) -- in particular, unpackbits()
 *
 * Copyright (C) 1986 Aldus Corporation.  All rights reserved.
 *
 *      $Revision:   1.3  $
 *      $Author:   sec  $
 *      $Date:   12 Dec 1986 11:50:38  $
 *
 *      $Log:   I:/pm2/wgr/vcs/winmacp.cv  $
 * 
 *    Rev 1.3   12 Dec 1986 11:50:38   sec
 * don't quit at > 127-byte lines
 * 
 *    Rev 1.2   09 Dec 1986 13:11:48   sec
 * I think I just added some checks.
 * 
 *    Rev 1.1   12 Nov 1986  9:43:30   sec
 * made it safer, and changed the name to aUnpackBits
 * 
 *    Rev 1.0   10 Nov 1986 20:06:30   sec
 * Initial revision.
 */

#include "AldTypes.h"
#include "PageMake.h"		/* pagemaker types and global data */
#include "AldUtils.h"
#define IMPDEFS
#include "errdefs.h"

RC aUnpackBits ARGS((LPSTR *, LPSTR *, short));
RC aUnpackBits (plpSrc, plpDst, dstBytes)
LPSTR	*plpSrc;
LPSTR	*plpDst;
short	dstBytes;
{
		register LPSTR		lpSrc = *plpSrc;
		register LPSTR		lpDst = *plpDst;
		register char		cc;
		register short		count;
		register short		outsofar = 0;
		RC					err = SUCCESS;

#if 0
		/* DEBUGGING check only:
		 */
		if (dstBytes <= 0) {
			DBMSG(("UnpackBits: dstBytes=%d\n",dstBytes));
			err = IE_BUG;
			goto cu0;
		}
#endif

		while (outsofar < dstBytes) {

			cc = *(char FAR *)lpSrc++;

			/* if -127 <= BYTE <= -1, replicate the next byte -n+1 times
			 */
			if (cc & '\200') {
				count = -(short)cc + 1;	/* relies on sign-extension!!! */
				if (count <= 0 || count > 127) {
					DBMSG(("UnpackBits: bad replicate count\n"));
					DBMSG((" cc = %x  count=%d\n", (unsigned)(cc & 0xff),
					 count));
					err = IE_BUG;
					goto cu0;
				}
				outsofar += count;
				if (outsofar > dstBytes) {
					DBMSG(("UnpackBits: overflow\n"));
					err = IE_DATA_OVERRUN;
					goto cu0;
				}
				lmemset (lpDst, (BYTE)*lpSrc, (WORD)count);
				lpSrc++;
			}

			/* else if 0 <= BYTE <= 127, copy the next n+1 bytes literally
			 */
			else {
				count = (short)cc + 1;
				if (count <= 0 || count > 127) {
					DBMSG(("UnpackBits: bad literal count\n"));
					DBMSG((" cc = %x  count=%d\n", (unsigned)(cc & 0xff),
					 count));
					err = IE_BUG;
					goto cu0;
				}
				outsofar += count;
				if (outsofar > dstBytes) {
					DBMSG(("UnpackBits: overflow\n"));
					err = IE_DATA_OVERRUN;
					goto cu0;
				}
				lmemcpy (lpDst, lpSrc, (WORD)count);
				lpSrc += count;
			}
			lpDst += count;
		}
		*plpSrc = lpSrc;
		*plpDst = lpDst;
cu0:	return err;
}
