Title	MenuTSRs.ASM -- Load TSRs via Load2TSR.BAT from MENU
Subttl			     V3.1 --- 30-May-1989 - 03:10:00
_DATA Segment Para Memory 'DATA'
UsageMsg						DB  13,10,9
DB 'MenuTSRs 3.1 provides a MENU of TSRs for Load2TSR.BAT.',13,10,9
DB '======================================================',13,10,9
DB 'You can avoid input of the TSRdir and MrkDir variables',13,10,9
DB 'by using the SET command to SET the environment BEFORE',13,10,9
DB 'calling MenuTSRs, but; there are more requirements:',13,10,10,9
DB 'WATCH 3.1 MUST HAVE a File-Mark and be the ONLY memory',13,10,9
DB 'resident program when MenuTSRs is INITIALLY activated!',13,10,10,9
DB 'MenuTSRs will provide a list of TSRs in the TSRdir and',13,10,9
DB 'display either "DISK" if NOT YET installed or the PSPA',13,10,9
DB 'in HEX if they are currently installed and [F]Marked.',13,10,10,9
DB 9,'File-Marks will be placed ahead of each TSR',13,10,9
DB 9,'that is installed.  UnMark and MenuTSRs can',13,10,9
DB 9,'be used in sequence to replace TSRs.  Note:',13,10,9
DB 9,'MenuTSRs is called by TSRmenu.BAT because a',13,10,9
DB 9,'Load2TSR.BAT file is created to LOAD TSR(s)',13,10,9
DB 9,'by chaining when MenuTSRs returns.',13,10,10,9,'Command Syntax:'
TSRmenu DB 13,10,10,9,9,9,'prompt >TSRmenu',13,10,"$",8,32,26
Display DB 13,10,10			; You can >TYPE MenuTSRs.EXE
EVTSR	DB  'TSRdir=',25 DUP(0),13,10
EVMrk	DB  'MrkDir=',25 DUP(0),13,10
WaTSR	DB  'Watch PSP    NONE',13,10,10
	DB  'TSR FileName Status  MENU  '
	DB  'TSR FileName Status',13,10
TSR01	DB  '             NONE		'
TSR13	DB  '             NONE  ',13,10
TSR02	DB  '             NONE		'
TSR14	DB  '             NONE  ',13,10
TSR03	DB  '             NONE		'
TSR15	DB  '             NONE  ',13,10
TSR04	DB  '             NONE		'
TSR16	DB  '             NONE  ',13,10
TSR05	DB  '             NONE		'
TSR17	DB  '             NONE  ',13,10
TSR06	DB  '             NONE		'
TSR18	DB  '             NONE  ',13,10
TSR07	DB  '             NONE		'
TSR19	DB  '             NONE  ',13,10
TSR08	DB  '             NONE		'
TSR20	DB  '             NONE  ',13,10
TSR09	DB  '             NONE		'
TSR21	DB  '             NONE  ',13,10
TSR10	DB  '             NONE		'
TSR22	DB  '             NONE  ',13,10
TSR11	DB  '             NONE		'
TSR23	DB  '             NONE  ',13,10
TSR12	DB  '             NONE		'
TSR24	DB  '             NONE  ',13,10,10
Prompt  DB  'Enter TSRfile name [parameter(s)] <END>:',13,10,10,255
MarkID  DB  'FM3.2 TSR WATCHER'		; IDs of FMark and Watch
ReqVar  DB  'Enter Drive:[\Path] for $' ; Request for directories
BatDat  DB  'Echo.',13,10,'Echo Off',13,10,'KillLOAD',13,10,13,10
FMark	DB  'FMark \Load2TSR.BAT',0	; Three Lines of Multi-Data Items
Disk	DB  'DISKLOAD',80h DUP(?)
DTA	DB  43 DUP(0)			; Storage for File Control Block
align	16
MenuPSP DW  ?				; Storage for PSP of MenuTSRs
MenuENV DW  ?				; and SEG of its Environment
EnvSEG  DW  ?				; Storage for SEGment and
EnvLen  DW  ?				; Length of DOS Environment
WatchF  DW  0				; PSP of Watch 3.1 Resident
ResidF  DW  0				; PSP of MenuTSRs Resident
CurPos  DW  ?				; Stored Row and Column
ErrLvl  DW  4C00h			; Error Level Exit Word
MCBbuf  DW	100h	DUP(0)		; MCB Table start OFFset
_DATA	EndS
_STACK  Segment Para	Stack   'STACK'
	DB	100h	DUP(0)
_STACK  EndS
_TEXT	Segment Para	Public  'CODE'
	Assume	CS:_TEXT,DS:_DATA,ES:Nothing,SS:_STACK

Main	Proc	Far
	mov	ax,_DATA		; Make DATA
	mov	DS,ax			; Addressable
	mov	MenuPSP,ES		; Store PSP
	mov	ax,ES:[2Ch]		; and SEG of
	mov	MenuENV,ax		; Environment
	mov	ah,52h			; Undocumented
	int	21h			; Function
	mov	di,ES:[bx-2]		; to obtain
	mov	ES,di			; MCB of DOS
	inc	di			; Config.Sys
	add	di,ES:[3]		; Advance to
	mov	ES,di			; MCB of DOS
	inc	di			; Command.Com
GetEnv: add	di,ES:[3]		; Advance to
	mov	ES,di			; MCB of DOS
	inc	di			; Environment
	cmp	word ptr ES:[1],0	; If Trapped
	jz	GetEnv			; Then NOT ENV

	mov	EnvSEG,di		; Else Store Segment
	mov	ax,ES:[3]		; Convert from
	mov	cx,4			; Paragraphs to
	shl	ax,cl			; Bytes and Store
	mov	cx,ax			; Length in Bytes of
	mov	EnvLen,cx		; Master Environment
	call	GetDirs			; Get TSRdir & MrkDir
	mov	si,offset MCBbuf	; Set MCB
	xor	bx,bx			; Indices
MCBlp:  add	di,ES:[3]		; Advance so as to
	mov	ES,di			; Point to MCB and
	inc	di			; Next Paragraph
	mov	[si+bx+0],ES		; Store MCB
	mov	dx,ES:[1]		; Get and Store
	mov	[si+bx+2],dx		; Block Address
	mov	ax,ES:[3]		; and Block
	mov	[si+bx+4],ax		; Length
	call	DoFlags			; Set Appropriate Flags
	add	bx,8			; Advance to Next and
	cmp	byte ptr ES:[0],"Z"	; Loop Until Last MCB
	jne	MCBlp			; Table Entry Complete
	mov	ax,_DATA		; Restore Extra
	mov	ES,ax			; Segment to DATA
	mov	di,si			; Scan the Blocks for
	mov	ax,-1			; First File-Mark Block
	mov	bp,WatchF		; Looking for Watch Mark
	mov	cx,bx			; Convert Bytes to
	shr	cx,1			; Words in MCB to Scan
	repne	scasw			; If a File-Mark
	je	Watch?			; Then See If Watch

	mov	byte ptr ErrLvl,1	; Else NO File-Mark
Usage:  mov	ah,9			; Error Exit
	mov	dx,offset UsageMsg	; With Help
	int	21h			; Message
	jmp	Exit

Watch?: cmp	ES:[di+2],bp		; If 1st TSR IS Watch
	je	Ck4TSR			; Then Check for MenuTSRs
	 mov	byte ptr ErrLvl,2	; Else NO Watch Error
	 jmp	Short Usage		; Exit With Help Message

Ck4TSR: push	di			; Preserve Pointer
	mov	di,offset WaTSR+13	; Store Watch
	call	BP2PSPA			; PSP Address
	pop	di			; Restore Pointer
	mov	ax,ResidF		; If MenuTSRs
	or	ax,ax			; IS Resident
	jne	DoDisp			; Or If NO Other
	repne	scasw			; TSR Follows
	repne	scasw			; After Watch TSR
	jne	DoDisp			; Then Fill-Out Display
NoTSRs: mov	byte ptr ErrLvl,3	; Else Error Exit With Help
	jmp	Short Usage

DoDisp: mov	ah,1Ah			; Set Data
	mov	dx,offset DTA		; Transfer
	int	21h			; Area
	mov	si,offset EVTSR+7	; Copy TSRdir
	mov	di,offset DTA		; path to DTA
	mov	ax,"*\"			; up to Null
EndChk: cmp	byte ptr [si],0		; If Null
	jz	EndDir			; Then Path Done
	 movsb				; Else Copy More
	 jmp	short EndChk

EndDir: stosw				; Add "\*"
	mov	ax,"C."			; and ".COM"
	stosw				; filespec
	mov	ax,"MO"			; ASCIIZ
	stosw				; string
	movsb
	mov	ah,4Eh			; If Find
	mov	dx,offset DTA		; First of
	mov	cx,7			; ANY .COM
	int	21h			; File Fails
	jc	FilEnd			; Then Display NONE

	mov	di,offset TSR01-44	; Else Initialize Pointer
CpyNxt: add	di,48			; Copy File
	mov	si,offset DTA+30	; Name
	mov	cx,9			; Bytes
MovNxt: movsb				; up to
	cmp	byte ptr [si],"."	; period
	loopne  MovNxt
	add	di,cx			; If Installed
	call	IfPSPA			; Then "PSPA"
	jnc	NxtFil			; Status
	mov	si,offset Disk		; Else "DISK"
;v1.1	mov	cx,4			; Status
;v1.1	rep	movsb
	movsw				;v1.1
	movsw				;v1.1
NxtFil: mov	ah,4Fh			; If Find
	int	21h			; Next Fails
	jc	FilEnd			; Then Done
	sub	di,13			; Else If More
	cmp	di,offset TSR12+4	; Lines to go
	jc	CpyNxt			; Then Copy Next
	cmp	di,offset TSR24+4	; Else If Full Menu
	jnc	FilEnd			; Then End of Files
	 mov	di,offset TSR13-44	; Else Re-Initialize
	 jmp	short CpyNxt		; Pointer to 2nd Col

FilEnd: call	MakeBAT			; Create Load2TSR.BAT

	cmp	word ptr ResidF,0	; If Resident
	jnz	DisMsg			; Then Display Menu
	mov	ES,MenuENV		; Else
	mov	ah,49h			; Release
	int	21h			; Environment
	mov	ES,MenuPSP		; Copy DATA to Transient
	mov	di,60h			; MenuTSRs PSP Area to
	call	CpyData			; Initialize Resident DATA
	mov	ah,9			; Display
	mov	dx,offset TSRmenu	; Installed
	int	21h			; Message
	mov	dx,di			; Calculate
	mov	cl,4			; Paragraphs
	shr	dx,cl			; to Remain
	mov	ax,3100h		; Resident
	int	21h

DisMsg: mov	ah,0Eh			; Use ROM Teletype
	mov	si,offset Display	;  to Display Menu
DMloop: lodsb				; Get and Display
	int	10h			; Each Character
	inc	al			; Until Reaching
	jnz	DMloop			; 0FFh Byte
	mov	ah,3			; Get and
	xor	bx,bx			; Store
	int	10h			; Input
	sub	dx,0101h		; Row and
	mov	CurPos,dx		; Column
	call	GetLOAD			; Get Load2TSR Input
	jnc	DisMsg			; Until RETURN to END

	call	EndBAT			; End the Load2TSR.BAT
	mov	ES,ResidF		; Up-Date
	mov	di,60h			; Resident
	call	CpyData			; Data
Exit:	mov	ax,ErrLvl		; Exit to DOS
	int	21h
Main	EndP

IfPSPA  Proc
	push	di			; Preserve Display Index
	xor	bx,bx			; Zero TSR Counter
	mov	si,offset MCBbuf	; Search MCBs
IP1Lp:  add	si,8			; If Next MCB
	cmp	word ptr [si],0		; Is Past Last
	jz	NoMrk			; Then Exit w/CY
	cmp	word ptr [si+6],-1	; Else If NOT FMark
	jne	IP1Lp			; Then Check Next

	mov	bp,[si+2]		; Else Get Segment
	inc	bx			; Increment TSR #
	pop	di			; Keep Display
	push	di			; Index on Stack
	push	si			; Preserve MCB Index
	push	DS			; and Segment While
	mov	DS,bp			; Comparing FMark
	mov	si,82h			; Command TSRfilespec
	push	di			; Preserve Location
	mov	di,offset EVMrk+7	; While Including
DirLp:  cmpsb				; Directory Bytes
	je	DirLp			; Until Dir End
	cmp	byte ptr ES:[di-1],0	; If Wasn't End
	pop	di			; {Stack Evened}
	jne	Exit2			; Then NO Match
	cmp	byte ptr [si-1],"\"	; Else If "\"
	je	CmpFN			; Then Disregard
	dec	si			; Else Compare to
CmpFN:  sub	di,9			; Current FileName

IP2Lp:  lodsb				; If Match
	cmp	al,13			; to End
	je	Exit2			; Then PSPA to Status
	cmp	al,"a"			; Else If NOT Lower
	jc	IP2Cp			; Case Alphabetic
	cmp	al,"z"			; Character Byte
	ja	IP2Cp			; Then Compare AS IS
	and	al,5Fh			; Else If UpperCase
IP2Cp:  cmp	ES:[di],al		; Byte Fails Match
	jne	Exit2			; Then Check Next MCB
	inc	di			; Else Check Bytes
	jmp	short IP2Lp		; Until Exit Compare

Exit2:  pop	DS			; Restore DS:SI
	pop	si			; If NO Match
	jne	IP1Lp			; Then Check Next MCB
	pop	di			; Else Restore Status
	mov	bp,[si+10]		; Location for Next PSP
	call	BP2PSPA			; Address in Status
	push	di			; Preserve Position
	call	NBX2ASC			; While Add Counter
	pop	di			; Restore Display Index
	ret				; Return NoCarry Flag

NoMrk:  pop	di			; Restore Display Index
	stc				; Return Carry Flag SET
	ret
IfPSPA  EndP

DoFlags Proc
	push	si			; Preserve
	push	di			; Pointers and
	push	ES			; Segment Register
	mov	bp,di			; Copy for Comparisons
	sub	dx,di			; If Environment Block
	jnz	DFexit			; Then Flag Non-Zero

	mov	ES,di			; Else Examine
	mov	di,61h			; Identification for
	mov	si,offset UsageMsg+3	; MenuTSRs being in
	mov	cx,12			; Residence
	rep	cmpsb			; If NO ResID
	jne	Ck4Mrk			; Then Check for File-Mark
	 mov	ResidF,bp		; Else MenuTSRs IS Resident
Ck4Mrk: mov	di,60h			; Check Identification for
	mov	cx,9			; "FM3.1 TSR"
	mov	si,offset MarkID	; File-Mark ID
	rep	cmpsb			; If NOT File-Mark
	jne	ChkW30			; Then Check for Watch
	 mov	dx,-1			; Else Flag as File-Mark
	 jmp	short DFexit

ChkW30: mov	di,81h			; If Command Area
	mov	si,offset MarkID+6	; Does NOT Contain
	mov	cx,11			; "TSR WATCHER"
	rep	cmpsb			; for ANY Watch
	jne	ChkCVP			; Then Check CV MenuTSRs
	 mov	WatchF,bp		; Else Store Watch PSP
ChkCVP: mov	ax,ES:[86h]		; If the Command
	and	ax,5F5Fh		; Parameter does
	cmp	ax,"ST"			; NOT have "TSRs"
	jne	ChkPSP			; Then Check If Transient
	mov	ax,ES:[88h]		; Else If "TSRs"
	and	ax,5F5Fh		; regardless
	cmp	ax,"SR"			; of case
	je	StorBP			; Then IS CodeView
ChkPSP: cmp	MenuPSP,bp		; Else If NOT MenuTSRs
	jne	DFexit			; Then Leave Flag Zero
StorBP: mov	dx,bp			; Else Flag as NOT TSR

DFexit: pop	ES			; Restore Segment
	pop	di			; Destination and
	pop	si			; Source Pointers
	mov	[si+bx+6],dx		; Set MCB Flags
	ret
DoFlags EndP

GetDirs Proc
	push	ES			; Preserve MCB and
	mov	ES,di			; Scan Environment
	xor	di,di			; CX bytes for
TSR1st: mov	si,offset EVTSR		; TSRdir variable
	lodsb				; first character
	repne	scasb			; If NOT Found
	jne	InTSRv			; Then Input TSRdir
	call	GErest			; Else If NOT Rest
	jne	TSR1st			; Then Scan Until Done
	jmp	short EnvMrk		; Else Have TSRdir

InTSRv: mov	dx,offset EVTSR		; Input TSRdir
	call	InpVar			; Until Acceptable for
	jc	InTSRv			; DOS Master Environment

EnvMrk: xor	di,di			; Scan Environment
	mov	cx,EnvLen		; Length for
Mrk1st: mov	si,offset EVMrk		; MrkDir variable
	lodsb				; first character
	repne	scasb			; If NOT Found
	jne	InMrkV			; Then Input MrkDir
	call	GErest			; Else If NOT Rest
	jne	Mrk1st			; Then Scan Until Done
	jmp	short GDexit		; Else Have MrkDir

InMrkV: mov	dx,offset EVMrk		; Input MrkDir
	call	InpVar			; Until Acceptable for
	jc	InMrkV			; Master DOS Environment

GDexit: pop	ES			; Restore MCB
	mov	di,EnvSEG		; and Segment
	ret
GetDirs EndP

GErest  Proc
	push	cx			; Preserve Counter
	mov	cx,5			; Set Counter
ERlp:	mov	bx,5			; Set Byte
	sub	bx,cx			; Offset
	lodsb				; Convert Byte to
	and	al,5Fh			; UPPER Case and
	cmp	ES:[di+bx],al		; If Bytes Match
	loope	ERlp			; Then Check 5
	jne	ERdone			; Else Exit NE
	lodsb				; Match Found
	cmp	ES:[di+5],al		; If "=" Sign
ERdone: pop	cx			; If Match Found
	je	Ok2Cpy			; Then Copy Content
	 pushf				; Else Preserve NE
	 xor	al,al			; Find End of
	 repne	scasb			; Variable and
	 popf				; Return NE Flag
	 ret

Ok2Cpy: add	di,6			; Advance Past "="
	mov	cx,24			; Limit Length
	xor	ah,ah			; Zero Upper AX
CpyVar: mov	al,ES:[di]		; Copy
	mov	[si],al			; Bytes
	inc	si			; Advancing
	inc	di			; Pointers
	or	ax,ax			; Until Ending
	loopnz  CpyVar			; Null or Limit
	cmp	byte ptr DS:[si-2],"\"  ; If NOT "\" at End
	jne	GEexit			; Then Environment Ok
	mov	[si-2],al		; Else Null it Out
;v1.1	sub	di,2			; Back-Up in ENV and
	dec	di			;back up in ENV			v1.1
	dec	di			; and..				v1.1
	stosb				; Null-Out its "\"
	mov	ah,0FFh			; Insure AX NOT 0
AdjENV: mov	al,ES:[di+1]		; Move Environment
	stosb				; Bytes Back one Byte
GEexit: or	ax,ax			; Until Second of
	mov	ah,al			; Double Null Bytes
	jnz	AdjENV			; has been moved
	ret
GErest  EndP

InpVar  Proc
	push	dx			; Preserve Name and
	mov	ah,9			; Request to Enter
	mov	dx,offset ReqVar	; Drive:[\Path]
	int	21h			; for the
	pop	dx			; Directory
	mov	cx,7			; "???dir="
	mov	bx,1			; via Standard
	mov	ah,40h			; Output Device
	int	21h
	add	dx,7			; Position to Input
	mov	cx,25			; Up to 25 bytes
	xor	bx,bx			; from Console
	mov	ah,3Fh			; Keyboard Device
	int	21h			; If Input Less
	cmp	ax,4			; Than "d:"
	jc	IVexit			; Then Error Exit

	mov	bx,ax			; Else Locate
	add	bx,dx			; CR and LF to
	xor	ax,ax			; Null Out
	mov	DS:[bx-2],ax
	cmp	byte ptr DS:[bx-3],"\"  ; If NOT "\" Ending
	jne	IV2env			; Then Input is Ok
	 mov	DS:[bx-3],al		; Else Null it Out
IV2env: xor	di,di			; Scan for Ending
	mov	cx,EnvLen		; Environment Nulls
IVlp1:  repne	scasb			; If First Null is NOT
	cmp	ES:[di],al		; followed by Second
	jne	IVlp1			; Then Loop Until

	mov	si,dx			; Double Null
	mov	cx,6			; Replace Second
	sub	si,7			; Null and Next
IVlp2:  lodsb				; Five Charcters
	and	al,5Fh			; with UPPER Case
	stosb				; Variable Name
	loop	IVlp2			; and then add

	mov	cx,bx			; Variable with
	sub	cx,si			; at least two
	rep	movsb			; Null Bytes
IVexit: ret
InpVar  EndP

BP2PSPA Proc
	push	ax			; Preserve
	push	bx			; General
	push	cx			; Working
	push	dx			; Registers
	mov	bx,4096			; Set Divide and
	mov	cx,4			; Shift Registers

B2Plp:  xor	dx,dx			; Zero Extension
	mov	ax,bp			; Get PSP Value
	div	bx			; Calculate Digit
	mov	bp,dx			; Store Remainder
	or	al,30h			; If ASCII Digit
	cmp	al,3Ah			; Is Decimal
	jc	B2Padj			; Then ASCII is Ok
	 add	al,7			; Else HEX Convert
B2Padj: push	cx			; Reset Shift
	mov	cx,4			; Register and
	shr	bx,cl			; Adjust Divisor
	stosb				; Store PSP Digit
	pop	cx			; Restore Counter
	loop	B2Plp			; Loop for 4 Digits

	pop	dx			; Restore
	pop	cx			; General
	pop	bx			; Working
	pop	ax			; Registers
	ret
BP2PSPA EndP

NBX2ASC Proc
	sub	di,17			; Position Pointer
	push	ax			; Preserve
	push	bx			; TSR # &
	push	cx			; Working
	push	dx			; Registers
	mov	ax,bx			; Divide TSR # by
	mov	bx,10			; Decimal Base
	mov	cx,3			; Three Times
NBXlp1: xor	dx,dx			; Clear Top
	div	bx			; Store
	push	dx			; Remainder
	loop	NBXlp1			; Three

	mov	cx,3			; Times
NBXlp2: pop	ax			; If Result
	or	ax,ax			; Is NOT 0
	jnz	NBXdig			; Or If
	cmp	cx,1			; Last Place
	je	NBXdig			; Then Digit
	 sub	ax,10h			; Else Space
NBXdig: add	ax,30h			; Store ASCII
	stosb				; Byte in AL
	loop	NBXlp2			; Until Three

	pop	dx			; Restore
	pop	cx			; General
	pop	bx			; Working
	pop	ax			; Registers
	ret
NBX2ASC EndP

MakeBAT Proc
	mov	si,offset EVMrk+7	; Initialize
	mov	di,offset DTA		; Filespec
MBnext: lodsb				; with Mark
	or	al,al			; Directory
	stosb				; Until
	jnz	MBnext			; Null
	dec	di			; Add at Null
	mov	si,offset FMark +6	; File to Create
	mov	cx,14			; "\Load2TSR.BAT"
	rep	movsb			; ASCIIZ String
	mov	ah,3Ch			; Create
	mov	dx,offset DTA		; BAT file
	int	21h
	mov	bp,ax			; Store Handle
	mov	ah,40h			; Write to
	mov	bx,bp			; Handle
	mov	cx,10			; "Echo Off"
	mov	dx,offset BatDat+7	; plus CRLF
	int	21h
	ret
MakeBAT EndP

GetLOAD Proc
	mov	ah,2			; Restore
	mov	dx,CurPos		; Cursor
	int	10h			; Position
	mov	ax,0E20h		; Space-Out
	mov	cx,80h			; Input Area
Spaces: int	10h
	loop	Spaces
	mov	ah,2			; Restore Cursor
	int	10h			; Position for
	mov	dx,offset Disk+8	; User Input of
	mov	cx,80h			; Up to 128 byte
	mov	ah,3Fh
	int	21h			; If NOT
	mov	si,dx			; RETURN
	cmp	word ptr DS:[si],0A0Dh  ; to END
	jne	GLinit			; Then Check Input
	 stc				; Else Exit
	 jmp	GLexit			; With CY Flag

GLinit: mov	di,offset TSR01-44	; Initialize and
	push	si			; Preserve Input Pointer
GLcknx: add	di,48			; Check TSRfile Name
	mov	cx,9			; Through Ending Space
	pop	si			; Keep Input Index On
	push	si			; Stack and Preserve
	push	di			; Display Pointer
GLcpnx: cmp	byte ptr DS:[si],"a"	; If Input Byte
	jc	GLCNOk			; Is NOT Lower
	cmp	byte ptr DS:[si],"z"	; Case Alpha
	ja	GLCNOk			; Then is Ok
	 and	byte ptr DS:[si],5Fh	; Else UPcase
GLCNOk: cmpsb				; If Bytes Match
	loope	GLcpnx			; Through Space
	jcxz	GLCPOk			; Then TSR Matches
	cmp	cx,8			; Else If 1st Fails
	je	GLnone			; Then Match Fails
	cmp	byte ptr ES:[di-1]," "  ; Else If TSRfile
	je	GLCPOk			; Name + Space
	cmp	byte ptr ES:[di-1],13	; Or End of Input
	je	GLCPOk			; Then TSR Matches

GLnone: pop	di			; Else If NOT Last
	cmp	di,offset TSR12+4	; Line of 1st Col
	jc	GLcknx			; Then Next Line
	cmp	di,offset TSR24+4	; Else If at END
	jnc	GLendC			; Then End Checks
	 mov	di,offset TSR13-44	; Else Loop to 1st
	 jmp	short GLcknx		; Line and 2nd Col

GLendC: pop	si			; At End Even Stack
	mov	ax,0E07h		; Beep for NO Match
	int	10h			; Loop Until Input
	jmp	short GetLOAD		; RETURN to END

GLCPOk: pop	di			; Insure Index at
	add	di,9			; Status Location
	push	bx			; Preserve BX=0 and
	push	bp			; Load2TSR Handle
	call	IfPSPA			; If TSRfile
	pop	bp			; Is Already
	pop	bx			; Installed
	pop	si			; {Stack Evened}
	jnc	PastMk			; Then UpDate

	mov	si,offset Disk		; Else Insure
	mov	cx,4			; That Status
	push	di			; IS "DISK"
	rep	cmpsb			; If "DISK"
	pop	di			; Is NOT
	push	si			; Matched
	jne	GLendC			; Then Beep

	pop	si			; Else Copy
;v1.1	mov	cx,4			; "LOAD" over
;v1.1	rep	movsb			; "DISK"
	movsw				;'LOAD' over 'DISK'		v1.1
	movsw				;v1.1
	mov	ah,40h			; Write
	mov	dx,offset FMark		; "FMark " to
	mov	cx,6			; Load2TSR.BAT
	mov	bx,bp			; File Handle
	int	21h
	mov	dx,offset EVMrk+7	; Add FMark
	mov	di,dx			; Directory
	mov	cx,25			; Path
	xor	al,al			; Up to
	repne	scasb			; Null
	dec	di
	mov	cx,di
	mov	ah,40h			; Write
	sub	cx,dx			; Path
	int	21h
	mov	dx,offset FMark+6
	mov	ah,40h			; Write
	mov	cx,1			; "\"
	int	21h
	mov	dx,offset Disk+8	; Scan
	mov	si,dx			; Input

GLmore: lodsb				;  for
	cmp	al," "			; Space
	jnc	GLmore			; or Less

	mov	ah,40h			; Write
	mov	cx,si			; TSRfile
	sub	cx,dx			; Name
	int	21h
	mov	dx,offset Display	; Use CRLF to
	mov	cx,2			; End BAT line
	mov	ah,40h
	int	21h
PastMk: mov	dx,offset EVTSR+7	; Scan
	mov	di,dx			; TSRdir
	mov	cx,25			; for
	xor	al,al			; Null
	repne	scasb			; Use
	dec	di			; Null
	mov	cx,di			; for
	sub	cx,dx			; Length
	mov	ah,40h			; Write to
	mov	bx,bp			; Load2TSR.BAT
	int	21h			; TSRdir Path
	mov	dx,offset FMark+6	; and Ending
	mov	cx,1			; "\"
	mov	ah,40h
	int	21h
	mov	dx,offset Disk+8	; Add
	mov	cx,80h			; Input
	mov	di,dx			; Up to
	mov	al,10			; End
	repne	scasb
	mov	cx,di			; Calculate
	sub	cx,dx			; Length
	mov	ah,40h
	int	21h
	mov	dx,offset BatDat	; Add "Echo."
	mov	cx,7			; plus CRLF
	mov	ah,40h
	int	21h
	clc				; Clear Carry to Continue
GLexit: ret
GetLOAD EndP

EndBAT  Proc
	mov	ah,40h			; Write to
	mov	bx,bp			; Load2TSR.BAT
	mov	cx,12			; "KillLOAD"
	mov	dx,offset BatDat+17	; + 2 CRLFs
	int	21h
	mov	ah,3Eh			; Close File
	int	21h			; Load2TSR.BAT
	ret
EndBAT  EndP

CpyData Proc
	mov	si,offset UsageMsg+3	; Point to and
	mov	cx,12			; Copy ID after
	mov	ax,cx			; Storing
	stosb				; Length of
	rep	movsb			; "MenuTSRs 3.1"

	mov	si,offset Display	; Add CR,LF & LF
;v1.1	mov	cx,3
;v1.1	rep	movsb
	movsw				;v1.1
	movsb				;v1.1
	mov	si,offset MenuPSP	; Add Data
	mov	cx,8			; Words to
	rep	movsw			; End @ 7Fh
	ret				; DI=80h
CpyData EndP

_TEXT	EndS
	End	Main
