# include <dos.h>
# include <string.h>
# include <stdio.h>
# include <bios.h>
# include <stdlib.h>
# include <conio.h>
# include <mem.h>
# include <dir.h>

# include "simpwin.h"
# include "swskdef.h"
# include "mouse23.h"
# include "fontedit.h"
# include "egacolor.h"

# define MAIN_WIN 1
# define MAIN_MENU 0
# define QUIT_WIN 4
# define TUT_WIN 2
# define TUT_MENU 1
# define FUNC_WIN 3
# define FUNC_MENU 2
# define TXT_WIN 5


int mou_switch;
int display_switch = 1;
int buttons;

int main_menu(void);
int quit(void);
int tutor_menu(void);
int function_menu(void);
int demo_menu(void);
int file_screen(char *file_name);
int text_screen(int file_num);
int mouse_demo(void);

void main(void)
{
	int i,j,k;

	if(init_window(5,3,4,"",1) != 0)
	{
		cprintf("Can't init simple windows!");
		exit(1);
	}
	system("cls");

	if((mouinit() == 0) | ((buttons = mouinstalled()) != 0))
	{
		simp_window(30,10,50,12,1,0,14,4,0,0,0,0,0);
		if(loadcurs("moucurs.fnt") == 0)
		{
			mouhide();
			mousetposition(1,1);
			mou_switch = 1;
			write_window(3,2,"Mouse Installed !");
		}
		else
		{
			mou_switch = 0;
			write_window(3,2,"No cursor file !");
			delay(1000);
			uninit_window();
			system("CLS");
			exit(1);
		}
		delay(1000);
	}
	else
	{
		simp_window(23,10,57,12,1,0,14,4,0,0,0,0,0);
		write_window(3,2,"NO mouse driver installed");
		mou_switch = 0;
		delay(1000);
		uninit_window();
		system("CLS");
		exit(1);
	}
	if(load_menu_text("moutut.men") != 0)
	{
		system("cls");
		cprintf("Can't find file MOUTUT.MEN !");
		uninit_window();
		exit(1);
	}
	if(load_win_data("moutut.win") != 0)
	{
		system("cls");
		cprintf("Can't find file MOUTUT.WIN !");
		uninit_window();
		exit(1);
	}
	hide_cursor();
	k= 3;
	for(i = 0;i < 13;i++)
	{
		for(j = k - 3;j < k;j++)
		{
			simp_window(40 - j,13 - i,40 + j,13 + i,1,0,15,1,0,0,0,0,0);
		}
		k = k + 3;
	}
	simp_window(1,1,80,25,1,0,15,1,0,0,0,0,0);
	k = 3;
	for(i = 0;i < 13;i++)
	{
		for(j = k - 3;j < k;j++)
		{
			window(40 - j,13 - i,40 + j,13 + i);
			load_screen_form(0,"moutut.scr");
		}
		k = k + 3;
	}
	window(1,1,80,25);
	load_screen_form(0,"moutut.scr");
	write_window(35,25," HIT ANY KEY ");
	bioskey(0);
	draw_horizontal_line(196,196,196,2,79,25);
	save_screen(1);
	moucursortype(0x01);
	moushow();
	while(main_menu())
	{
	}
	uninit_window();
	mouuninit();
	show_cursor();
	system("cls");
}

int main_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[3][13] = {"Demo","Tutor","eXit"};


	if(display_switch)
	{
		load_screen(1);
		call_window(MAIN_WIN);
		call_menu(MAIN_MENU,3,2);
		save_screen(2);
	}
	else
	{
		load_screen(2);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"D");
	write_window(22,2,"T");
	write_window(41,2,"X");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if(mousey == 4)
			{
				if((mousex > 5) & (mousex < 12))
				{
					i = 0;
				}
				else if((mousex > 24) & (mousex < 31))
				{
					i = 1;
				}
				else if((mousex > 42) & (mousex < 49))
				{
					i = 2;
				}
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 4; break;
				case CURSOR_RIGHT : i = i + 1; break;
				case CURSOR_LEFT : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_D : choice = 2; break;
				case ALT_T : choice = 3; break;
				case ALT_X : choice = 4; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 2)
		{
			i = 2;
		}
		if(old_i != i)
		{
			mouhide();
			old_i = i;
			load_screen_buff();
			switch(i)
			{
				case 0 : simp_window(6,4,11,4,0,2,0,4,1,8,0,0,0); break;
				case 1 : simp_window(25,4,31,4,0,2,0,4,1,8,0,0,0); break;
				case 2 : simp_window(43,4,48,4,0,2,0,4,1,8,0,0,0); break;
			}
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if(mousey == 4)
			{
				if(((mousex > 5) & (mousex < 12)) |
					((mousex > 24) & (mousex < 31)) |
					((mousex > 42) & (mousex < 49)))
				{
					choice = 1;
				}
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	if(choice == 1)
	{
		choice = i + 2;
	}
	pick = 1;
	switch(choice)
	{
		case 2 : mouse_demo(); break;
		case 3 : while(tutor_menu()){} break;
		case 4 : pick = quit(); break;
	}
	return(pick);
}

int quit(void)
{

	call_window(QUIT_WIN);
	write_window(3,2,"Quit Y/N ?");
	show_cursor();
	if(get_choice(14,2,"N") == 1)
	{
		uncall_window(QUIT_WIN);
		hide_cursor();
		return(0);
	}
	uncall_window(QUIT_WIN);
	hide_cursor();
	return(1);
}

int tutor_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[4][19] = {"General","Support","Functions","A word"};

	if(display_switch)
	{
		if(display_switch == 1)
		{
			load_screen(2);
		}
		call_window(TUT_WIN);
		call_menu(TUT_MENU,3,2);
		save_screen(3);
	}
	else
	{
		load_screen(3);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"G");
	write_window(3,3,"S");
	write_window(3,4,"F");
	write_window(3,5,"A");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 20) & (mousex < 30))
			{
				i = mousey - 5;
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 7; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_G : choice = 2; break;
				case ALT_S : choice = 3; break;
				case ALT_F : choice = 4; break;
				case ALT_A : choice = 5; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 3)
		{
			i = 3;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(21,5 + i,31,5 + i,0,2,0,4,1,8,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 20) & (mousex < 30) & (mousey > 4) & (mousey < 9))
			{
				choice = 1;
			}
			else
			{
				choice = 7;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : file_screen("mougenrl.txt"); break;
		case 3 : text_screen(3); break;
		case 4 : while(function_menu()){} break;
		case 5 : text_screen(4);
		case 7 : pick = 0; break;
	}
	display_switch = pick;
	return(pick);
}

int function_menu(void)
{
	int pick,choice,i = 0,old_i = 12,mousex = 0,mousey = 0;
	char lable[15][29] = {"mouinstall\(\)","moureset\(\)","moubuttonpressed\(\)",
				"moubuttonrelease\(\)","mouposition\(\)","moupositionpix\(\)",
				"mousetposition\(\)","mousetmaxposition\(\)","mouhide\(\)",
				"moushow\(\)","loadcurs\(\)","mou_get_adapter\(\)",
				"mouinit\(\)","mouuninit\(\)","moucursortype\(\)"};

	if(display_switch)
	{
		load_screen(3);
		call_window(FUNC_WIN);
		call_menu(FUNC_MENU,3,2);
		save_screen(4);
	}
	else
	{
		load_screen(4);
	}
	display_switch = 1;
	save_screen_buff();
	moushow();
	i = 0;
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 22) & (mousex < 46))
			{
				i = mousey - 6;
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 12; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER: choice = 1; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 14)
		{
			i = 14;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(23,6 + i,47,6 + i,0,2,0,4,1,8,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 22) & (mousex < 46) & (mousey > 5) & (mousey < 21))
			{
				choice = 1;
			}
			else
			{
				choice = 12;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		text_screen(i + 5);
	}
	else
	{
		if(choice == 12)
		{
			pick = 0;
		}
	}
	display_switch = 0;
	return(pick);
}


int text_screen(int file_num)
{
	call_window(TXT_WIN);
	load_text(file_num,"moutut.men");
	write_window((80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	uncall_window(TXT_WIN);
	return(0);
}

int file_screen(char *file_name)
{
	call_window(TXT_WIN);
	write_window((80 - strlen(" PgUp/PgDn ESC ")) / 2,25," PgUp/PgDn ESC ");
	read_text(file_name,1);
	uncall_window(TXT_WIN);
	return(0);
}

int mouse_demo(void)
{
	int type = 1,done = 0;
	int moux,mouy,pix_x,pix_y;

	text_screen(20);
	set_palette(8,0);
	set_palette(15,7);
	enable_double_font(1);
	load_font("script.fnt",1);
	load_emulate(1);
	call_window(TXT_WIN);
	write_window((80 - strlen(" Hit Any Key to exit ")) / 2,25," HIT ANY KEY TO EXIT ");
	write_win_large(0,5,3,"Mouse v 2.3");
	write_win_large(1,5,11,"Mouse v 2.3");
	write_win_bank(0,55,9,"Mouse v 2.3");
	write_win_bank(1,55,16,"Mouse v 2.3");
	write_window(5,23,"Use LEFT and RIGHT button press to change cursor.");
	moureset();
	moushow();
	while(done == 0)
	{
		mouposition(&moux,&mouy);
		moupositionpix(&pix_x,&pix_y);
		if(buttons == 2)
		{
			if(moubuttonpressed(LEFTBUTTON))
			{
				write_window(40,20,"Left button pressed  ");
				type++;
				if(type > 8)
				{
					type = 8;
				}
				moucursortype(type);
				mouposition(&moux,&mouy);
			}
			if(moubuttonpressed(RIGHTBUTTON))
			{
				write_window(40,20,"Right button pressed ");
				type--;
				if(type < 1)
				{
					type = 1;
				}
				moucursortype(type);
				mouposition(&moux,&mouy);
			}
			if(moubuttonrelease(LEFTBUTTON))
			{
				write_window(40,20,"Left button released ");
			}
			if(moubuttonrelease(RIGHTBUTTON))
			{
				write_window(40,20,"Rigth button released");
			}
		}
		else
		{
			if(moubuttonpressed(LEFTBUTTON))
			{
				write_window(40,20,"Left button pressed   ");
				type++;
				if(type > 32)
				{
					type = 32;
				}
				moucursortype(type);
				mouposition(&moux,&mouy);
			}
			if(moubuttonpressed(RIGHTBUTTON))
			{
				write_window(40,20,"Right button pressed  ");
				type--;
				if(type < 1)
				{
					type = 1;
				}
				moucursortype(type);
				mouposition(&moux,&mouy);
			}
			if(moubuttonrelease(LEFTBUTTON))
			{
				write_window(40,20,"Left button released  ");
			}
			if(moubuttonrelease(RIGHTBUTTON))
			{
				write_window(40,20,"Rigth button released ");
			}
			if(moubuttonpressed(MIDBUTTON))
			{
				write_window(40,20,"Middle button pressed ");
			}
			if(moubuttonrelease(MIDBUTTON))
			{
				write_window(40,20,"Middle button released");
			}
		}
		write_window(5,19,"Number of buttons = %1d",buttons);
		write_window(5,21,"Pix X = %3d Pix Y = %3d",pix_x,pix_y);
		write_window(5,22,"    X = %2d     Y = %2d",moux,mouy);
		if(bioskey(1))
		{
		    done = 1;
		}
		write_window(5,20,"Cursor type number %2d",type);
	}
	enable_double_font(0);
	set_palette(8,56);
	set_palette(15,63);
	moucursortype(1);
	mouhide();
	uncall_window(TXT_WIN);
	return(0);
}

