/* simpwin9 copyright 1995 - 1997 by bruce r. o'banion */

# include <dos.h>
# include <string.h>
# include <stdio.h>
# include <bios.h>
# include <stdlib.h>
# include <conio.h>
# include <mem.h>
# include <dir.h>


# include "simpwn92.h"
# include "skdef92.h"
# include "mouse92.h"


# define MAIN_WIN 1
# define DIREC_WIN 2
# define ENTER_WIN 3
# define DESK_WIN 4
# define QUIT_WIN 5

int mou_switch;
char file_name[256];
int display_switch = 1;
int file_loaded = 0;
int dev_error;
unsigned char *read_buff;

int main_menu(void);
int readocs(void);
int printdocs(void);
int get_file(void);
int quit(void);
int help_screen(char *file_name);
int print_char(unsigned char prn_char);
int read_directory(char *buff,int num_file,char *directory);
int print_string_func(unsigned char *print_string);

void main(void)
{
	int i,j,k;

	system("cls");
	hide_cursor();
	if((read_buff = (char*)malloc(256)) == NULL)
	{
		cprintf("Not enough memory!");
		exit(1);
	}
	if(init_window(7,4,"") == 1)
	{
		cprintf("Unable to install simple windows");
		free(read_buff);
		exit(1);
	}
	if(mouinstalled() != 0)
	{
		moureset();
		mouhide();
		mousetposition(1,1);
		mou_switch = 1;
		simp_window(30,10,50,12,1,0,14,4,0,0,0,0,0);
		write_window(3,2,"Mouse Installed !");
		delay(1000);
	}
	else
	{
		simp_window(23,10,57,12,1,0,14,4,0,0,0,0,0);
		write_window(3,2,"NO mouse driver installed");
		delay(1000);
	}
	k= 3;
	for(i = 0;i < 13;i++)
	{
		for(j = k - 3;j < k;j++)
		{
			simp_window(40 - j,13 - i,40 + j,13 + i,1,0,14,4,1,0,0,0,0);
		}
		k = k + 3;
	}
	simp_window(1,1,80,25,1,0,14,4,1,0,0,0,0);
	write_window(35,25," HIT ANY KEY ");
	read_text("readoc92.scr",2);
	save_screen(1);
	moucursortype(0x01);
	moushow();
	while(main_menu())
	{
	}
	uninit_window();
	show_cursor();
	free(read_buff);
	system("cls");
}

int main_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[4][13] = {"File","Read","Print","eXit"};

	if(display_switch)
	{
		load_screen(1);
		popup_window(MAIN_WIN,5,3,51,5,2,2,14,6,1,8,0,0,0);
		write_window(3,2,"File        Read         Print         eXit");
		save_screen(2);
	}
	else
	{
		load_screen(2);
	}

	display_switch = 0;
	textcolor(0);
	write_window(3,2,"F");
	write_window(15,2,"R");
	write_window(28,2,"P");
	write_window(43,2,"X");
	save_screen(0);
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if(mousey == 4)
			{
				if((mousex > 5) & (mousex < 11))
				{
					i = 0;
				}
				else if((mousex > 17) & (mousex < 24))
				{
					i = 1;
				}
				else if((mousex > 30) & (mousex < 39))
				{
					i = 2;
				}
				else if((mousex > 44) & (mousex < 50))
				{
					i = 3;
				}
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 6; break;
				case CURSOR_RIGHT : i = i + 1; break;
				case CURSOR_LEFT : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_F : choice = 2; break;
				case ALT_R : choice = 3; break;
				case ALT_X : choice = 5; break;
				case ALT_P : choice = 4; break;
				case F1 : switch(i)
							{
						case 0 : help_screen("help0.txt"); break;
						case 1 : help_screen("help1.txt"); break;
						case 2 : help_screen("help2.txt"); break;
						case 3 : help_screen("help3.txt"); break;
							}
							break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 3)
		{
			i = 3;
		}
		if(old_i != i)
		{
			mouhide();
			old_i = i;
			load_screen(0);
			switch(i)
			{
				case 0 : simp_window(6,4,11,4,0,2,0,4,1,8,0,0,0); break;
				case 1 : simp_window(18,4,24,4,0,2,0,4,1,8,0,0,0); break;
				case 2 : simp_window(31,4,39,4,0,2,0,4,1,8,0,0,0); break;
				case 3 : simp_window(45,4,50,4,0,2,0,4,1,8,0,0,0); break;
			}
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if(mousey == 4)
			{
				if(((mousex > 5) & (mousex < 11)) |
					((mousex > 17) & (mousex < 24)) |
					((mousex > 30) & (mousex < 39)) |
					((mousex > 44) & (mousex < 50)))
				{
					choice = 1;
				}
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen(0);
	if(choice == 1)
	{
		choice = i + 2;
	}
	pick = 1;
	switch(choice)
	{
		case 2 : get_file(); break;
		case 3 : readocs(); break;
		case 4 : printdocs(); break;
		case 6 :
		case 5 : pick = quit(); break;
	}
	return(pick);
}

int get_file(void)
{
	char *directory;
	int i,j,num_files2 = 0;
	int mousex = 0,mousey = 0,oldi = 80,oldj = 80,choice,pick;
	int max_x,max_y,file_num = 0;
	char *file_pt;
	char temp_name[256];

	strcpy(temp_name,file_name);
	if((directory = (char*)malloc(13 * 70)) == NULL)
	{
		popup_window(ENTER_WIN,5,10,75,12,1,2,14,4,1,8,0,0,0);
		write_window(3,2,"NOT enough memory!");
		bioskey(0);
		unpopup_window(ENTER_WIN);
		return(1);
	}
	memset(directory,0,13 * 70);
	strcpy(file_name,"*.doc");
	popup_window(ENTER_WIN,5,10,75,12,1,2,0,7,1,8,0,0,0);
	write_window(3,2,"Enter file name: ");
	show_cursor();
	if(get_string(file_name,"                                                           ",
					"***********************************************************",
								20,2,1,1) != 0)
	{
		hide_cursor();
		unpopup_window(ENTER_WIN);
		strcpy(file_name,temp_name);
		return(1);;
	}
	hide_cursor();
	if((strstr(file_name,"*") != NULL) | (strstr(file_name,"?") != NULL))
	{
		if(read_directory(directory,70,file_name) == 1)
		{
			clear_window(0);
			write_window(3,2,"NO FILE FOUND");
			bioskey(0);
			unpopup_window(ENTER_WIN);
			return(1);
		}
		unpopup_window(ENTER_WIN);
		popup_window(DIREC_WIN,4,5,76,20,1,2,0,7,1,8,0,0,0);
		for(i = 0;i < 5;i++)
		{
			for(j = 0;j < 14;j++)
			{
				if(strcmp(&directory[(j * 13) + (i * 182)],"") != 0)
				{
					file_num++;
				}
				else
				{
					i = 5;
					break;
				}
				write_window((i * 14) + 3,j + 2,"%s ",&directory[(j * 13) + (i * 182)]);
			}
		}
		max_x = ((file_num / 14) * 14) + 19;
		max_y = (file_num - ((file_num / 14) * 14) + 6);
		save_screen(0);
		i = 0;
		j = 0;
		moushow();
		for(;;)
		{
			choice = 0;
			if(mouposition(&mousex,&mousey))
			{
				if((mousex > 5) & (mousex < 18))
				{
					j = 0;
				}
				if((mousex > 19) & (mousex < 32))
				{
					j = 1;
				}
				if((mousex > 33) & (mousex < 46))
				{
					j = 2;
				}
				if((mousex > 47) & (mousex < 60))
				{
					j = 3;
				}
				if((mousex > 61) & (mousex < 74))
				{
					j = 4;
				}
				i = mousey - 6;
			}
			if(bioskey(1) | (mou_switch == 0))
			{
				switch(bioskey(0))
				{
					case ESC : choice = 2; break;
					case CURSOR_UP : i = i - 1; break;
					case CURSOR_DN : i = i + 1; break;
					case CURSOR_RIGHT : j = j + 1; break;
					case CURSOR_LEFT : j = j - 1; break;
					case ENTER : choice = 1; break;
					case F1 : help_screen("help4.txt"); break;
				}
			}
			if(i < 0)
			{
				i = 0;
			}
			else if(i > 13)
			{
				i = 13;
			}
			else if(j < 0)
			{
				j = 0;
			}
			else if(j > 4)
			{
				j = 4;
			}
			if(((j * 14) + i) > file_num - 1)
			{
				if((file_num - 57) >= 0)
				{
					j = 4;
					i = file_num - 57;
				}
				else
				{
					if((file_num - 43) >= 0)
					{
						j = 3;
						i = file_num - 43;
					}
					else
					{
						if((file_num - 29) >= 0)
						{
							j = 2;
							i = file_num - 29;
						}
						else
						{
							if((file_num - 15) >= 0)
							{
								j = 1;
								i = file_num - 15;
							}
							else
							{
								j = 0;
								i = file_num - 1;
							}
						}
					}
				}
			}
			if((oldi != i) | (oldj != j))
			{
				mouhide();
				load_screen(0);
				oldi = i;
				oldj = j;
				simp_window(5 + (j * 14),i + 6,18 + (j * 14),i + 6,0,2,0,4,1,8,0,0,0);
				write_window(2,1,"%s",&directory[(j * 182) + (i * 13)]);
				moushow();
			}
			if(moubuttonpressed(LEFTBUTTON))
			{
				if((mousex < (max_x - 14)) & (mousey > 5) & (mousey < 20))
				{
					choice = 1;
				}
				else
				{
					if((mousex < max_x) & (mousey > 5) & (mousey < max_y))
					{
						choice = 1;
					}
					else
					{
						choice = 2;
					}
				}
			}
			if(choice != 0)
			{
				break;
			}
		}
		if(choice == 1)
		{
			num_files2 = (j * 14) + i;
			if((file_pt = strrchr(file_name,'\\')) != NULL)
			{
				file_pt[1] = '';
				strcat(file_name,&directory[num_files2 * 13]);
			}
			else
			{
				if((file_pt = strrchr(file_name,':')) != NULL)
				{
					file_pt[1] = '';
					strcat(file_name,&directory[num_files2 * 13]);
				}
				else
				{
					strcpy(file_name,&directory[num_files2 * 13]);
				}
			}
			file_loaded = 1;
		}
		if(choice == 80)
		{
			strcpy(file_name,temp_name);
			pick = 1;
		}
	}
	unpopup_window(DIREC_WIN);
	free(directory);
	return(pick);
}

int help_screen(char *file_name)
{
	popup_window(DESK_WIN,1,1,80,25,1,0,14,1,0,0,0,0,0);
	write_window(35,25," HIT ANY KEY ");
	read_text(file_name,2);
	unpopup_window(DESK_WIN);
	return(0);

}

int readocs(void)
{
	if(file_loaded == 0)
	{
		get_file();
	}
	popup_window(DESK_WIN,1,1,80,25,1,0,14,1,0,0,0,0,0);
	write_window(33,25," PgUp/PgDn ESC ");
	write_window((80 - strlen(file_name)) / 2,1," %s ",file_name);
	read_text(file_name,1);
	unpopup_window(DESK_WIN);
	return(0);
}

int printdocs(void)
{
	unsigned long int start_byte = 0L;
	int y,page_num = 1,i;
	unsigned char page_string[80];
	unsigned char page_number[10];
	unsigned char page_num_string[30];
	unsigned char print_page_string[80];
	unsigned char print_line[5];
	unsigned char print_string[90];
	unsigned char *temp_point;
	int error;

	if(file_loaded == 0)
	{
		get_file();
	}
	popup_window(6,20,10,52,12,2,2,14,4,1,8,0,0,0);
	if(print_char(0x0c) != 0)
	{
		write_window(3,2,"Printer error hit a key!");
		bioskey(0);
		unpopup_window(6);
	}
	write_window(3,2,"Align paper and hit any key.");
	bioskey(0);
	clear_window(0);
	write_window(3,2,"  Printing!  Hit ESC to quit");
	y = 1;
	for(i = 0;i < (((71 - strlen(file_name)) / 2) + 9);i++)
	{
		page_string[i] = 0x20;
	}
	page_string[i] = 0x00;
	strcat(page_string,file_name);
	strcat(page_string," \r\n");
	print_line[0] = '\r';
	print_line[1] = '\n';
	print_line[2] = 0x00;
	while((error = read_file(read_buff,file_name,256,start_byte)) < 1)
	{
		if(read_buff[0] == 0x00)
		{
			break;
		}
		if(error > 0)
		{
			break;
		}
		else
		{
			error = 0;
		}
		temp_point = strchr(read_buff,'\n');
		temp_point[1] = 0x00;
		start_byte = start_byte + strlen(read_buff);
		if(strlen(read_buff) > 70)
		{
			read_buff[70] = '\r';
			read_buff[71] = '\n';
			read_buff[72] = 0x00;
		}
		memset(print_string,0x20,20);
		print_string[8] = 0x00;
		strcat(print_string,read_buff);
		if(y == 1)
		{
			if((error = print_string_func(page_string)) != 0)
			{
				break;
			}
			else
			{
				y++;
				if((error = print_string_func(print_line)) != 0)
				{
					break;
				}
				y++;
			}
		}
		if(y < 59)
		{
			if((error =print_string_func(print_string)) != 0)
			{
				break;
			}
			y++;
		}
		if(y == 59)
		{
			strcpy(page_num_string,"Page: ");
			itoa(page_num,page_number,10);
			strcat(page_num_string,page_number);
			memset(print_page_string,0x20,80);
			print_page_string[(71 - strlen(page_num_string)) / 2] = 0x00;
			strcat(print_page_string,page_num_string);
			strcat(print_page_string," \r\n");
			if((error = print_string_func(print_line)) != 0)
			{
				break;
			}
			if((error = print_string_func(print_page_string)) != 0)
			{
				break;
			}
			if((error = print_char(0x0c)) != 0)
			{
				break;
			}
			y = 1;
			page_num++;
		}
		memset(read_buff,0,256);
	}
	if(error < 1)
	{
		if(y < 59)
		{
			memset(print_page_string,0x20,80);
			strcpy(page_num_string,"Page: ");
			itoa(page_num,page_number,10);
			strcat(page_num_string,page_number);
			print_page_string[(71 - strlen(page_num_string)) / 2] = 0x00;
			strcat(print_page_string,page_num_string);
			strcat(print_page_string," \r\n");
			while(y < 60)
			{
				if((error = print_string_func(print_line)) != 0)
				{
					break;
				}
				y++;
			}
			if(error == 0)
			{
				error = print_string_func(print_page_string);
			}
		}
	}
	if(error > 0)
	{
		clear_window(0);
		write_window(3,2,"Printer Error !");
		bioskey(0);
	}
	unpopup_window(6);
	return(0);

}

int quit(void)
{
	char choice[2];

	popup_window(QUIT_WIN,32,10,47,12,2,2,15,4,1,8,0,0,0);
	write_window(3,2,"Quit Y/N ?");
	strcpy(choice,"Y");
	show_cursor();
	if(get_string(choice," ","Y",14,2,1,1) == 0)
	{
		strupr(choice);
		if(strcmp(choice,"Y") == 0)
		{
			unpopup_window(QUIT_WIN);
			hide_cursor();
			return(0);
		}
	}
	unpopup_window(QUIT_WIN);
	hide_cursor();
	return(1);
}

int print_char(unsigned char prn_char)
{
	int prn_stat;
	unsigned long int i;

	dev_error = 0;
	i = 0;
	while(((prn_stat = biosprint(2,0,0)) &0x80) != 0x80)
	{
		if(i == 10000000L)
		{
			dev_error = 3;
		}
		if(((prn_stat & 0x01) == 0x01) | ((prn_stat & 0x08) == 0x08) |
			((prn_stat & 0x20) == 0x20))
		{
			return(prn_stat);
		}
		if(dev_error != 0)
		{
			return(dev_error);
		}
		i = i + 1;
	}
	i = 0;
	while(((prn_stat = biosprint(0,prn_char,0)) & 0x10) != 0x10)
	{
		if(i == 10000000L)
		{
			dev_error = 3;
		}
		if(((prn_stat & 0x01) == 0x01) | ((prn_stat & 0x08) == 0x08) |
			((prn_stat & 0x20) == 0x20))
		{
			return(prn_stat);
		}
		if(dev_error != 0)
		{
			return(dev_error);
		}
		i = i + 1;
	}
	return(0);
}

int read_directory(char *buff,int num_file,char *directory)
{
	int i;
	char far *data;
	struct ffblk dir_data;


	data = getdta();
	dev_error = 0;
	if(findfirst(directory,&dir_data,FA_RDONLY) != 0)
	{
		return(1);
	}
	strcpy(buff,dir_data.ff_name);
	buff = buff + 13;
	for(i = 1;i < num_file;i++)
	{
		if(findnext(&dir_data) != 0)
		{
			break;
		}
		strcpy(buff,dir_data.ff_name);
		buff = buff + 13;
	}
	setdta(data);
	return(0);
}

int print_string_func(unsigned char *print_string)
{
	int i;
	int error;

	for(i = 0;i < strlen(print_string);i++)
	{
		if((error = print_char(print_string[i])) != 0)
		{
			break;
		}
	}
	return(error);
}