/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* filehk.h  -  header file for file routines */

#ifndef FILEHK_HEADER
#define FILEHK_HEADER   1

#include <howard.h>

typedef struct filespec {
            char drive;
            char path[81];             /* all strings     */
            char filename[13];         /* are ASCIIZ      */
        };

typedef struct fnameext {
            char filename[9];
            char ext[4];
        };

#define FNAMESIZE       96      /* [d:][80 char path][filename].[ext] */
#define PATHSIZE        100     /* used for making variables to manipulate path stuff */
#define MAXFNAME        13      /* filename.ext w/null terminator */

/* function prototypes */
int getfname(byte row, byte col, char *returnstr, char *pattern,
             int argn, int argk[],char flags);  /* get a filename.ext */
int set_handles(int handles);               /* set handle count (DOS 3.3) */
int fname_match(char *fname1, char *fname2);/* compare filename with wildcards *,? */
boolean isdir(char *fspec);                 /* is fspec a subdirectory */
struct filespec *parsefilename(char *fspec);/* break fspec into d: path filename ext */
int fncmp(char *fname1, char *fname2);      /* compare filename 1 w/filename 2 */
struct fnameext *parsefnameext(char *filename); /* break filename.ext into filename & ext */
char *expandfilespec(char *filespec, char *dest);   /* expand filespec into full d:\path\filename.ext w/wildcards */
char *getfilespec(char *s);                 /* fix file specs for proper dir searching */
boolean fileexist(char *filename);          /* does filename exist */

#endif              /* FILEHK_HEADER */
