/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* ibm.h  -  header file for IBM.C - IBM specific functions */

#ifndef IBM_HEADER
#define IBM_HEADER  1

#include <howard.h>

/* ROM id */
#define PC              0xFF
#define XT              0xFE
#define Portable_PC     0xFE
#define PCjr            0xFD
#define AT              0xFC
#define AT3x9           0xFC
#define XT286           0xFC
#define PS2_Model_50    0xFC
#define PS2_Model_60    0xFC
#define XT2             0xFB
#define PS2_Model_25    0xFA
#define PS2_Model_30    0xFA
#define PC_Convertible  0xF9
#define PS2_Model_80    0xF8
#define Compaq          0x2D
#define Compaq_Plus     0x9A

/* machine_id codes */
#define PC_id               1
#define XT_id               2
#define Portable_PC_id      3          /* can't currently be identified */
#define PCjr_id             4
#define AT_id               5
#define AT3x9_id            6
#define XT2_id              7
#define XT286_id            8
#define PC_Convertible_id   9
#define PS2_Model_25_id     10         /* ?, see docs */
#define PS2_Model_30_id     11
#define PS2_Model_50_id     12
#define PS2_Model_60_id     13
#define PS2_Model_80_id     14
#define Unknown_id          99

/* Memory allocation strategies */
#define MEM_STRAT_FIRST 0         /* use first mem block large enough */
#define MEM_STRAT_BEST  1         /* use smallest mem block large enough */
#define MEM_STRAT_LAST  2         /* use high part of last usable mem block */
#define MEM_STRAT_BADDOS -1       /* using DOS earlier than 3.xx */

/* Disk id */
#define DISK_DSDD_8     0xFF      /* Double-sided, 5 1/4" floppy, 8 sectors */
#define DISK_SSDD_8     0xFE      /* Single-sided, 5 1/4" floppy, 8 sectors */
#define DISK_SS8_8      0xFE      /* Single-sided, 8" floppy, 8 sectors */
#define DISK_DSDD_9     0xFD      /* Double-sided, 5 1/4" floppy, 9 sectors */
#define DISK_SSDD_9     0xFC      /* Single-sided floppy, 9 sectors */
#define DISK_DSQD_15    0xF9      /* Double-sided, 5 1/4" floppy, 15 sectors */
#define DISK_DS3_15     0xF9      /* Double-sided, 3 1/2" floppy, 9 sectors */
#define DISK_HARD       0xF8      /* Hard disk */
#define DISK_DS3_18     0xF0      /* Double-sided, 3 1/2" floppy, 18 sectors */
#define DISK_UNDEFINED  0xF0      /* undefined media type */
/* Note: if the disk is Single-sided, 8" 26 sectors,
         it could have the id FE or FD                  */
#define DISK_INVALID    0x1       /* invalid disk specified */

/* EMS return (error?) codes */
#define EMS_SUCCESS         0x00        /* success */
#define EMS_ERROR_SOFTWARE  0x80        /* error in EMM software */
#define EMS_ERROR_HARDWARE  0x81        /* malfunction in EM hardware */
#define EMS_ERROR_UNDEFINED 0x84        /* function requested not defined */

typedef struct EMSrecord {
            unsigned int handle;
            unsigned int totalpages;
            unsigned int availpages;
            byte version;
            byte emserror;
        };

#define TIMER_TICKS *((long far *) 0x46Clu)  /* Timer tick count */
#define isBREAKon()     (getcbrk()==1?TRUE:FALSE)
#define setBREAK(b)     setcbrk(b)
#define isVERIFYon()    (getverify()==1?TRUE:FALSE)
#define setVERIFY(v)    setverify(b)

/* Identification prototypes */
int is2nd8259(void);                    /* is second 8259 chip installed */
boolean isBlogical(void);               /* is B: physical or logical */
boolean isExtended(void);               /* is Extended memory available */
boolean iskey102(void);                 /* is keyboard 101/102 keys */
int isMCA(void);                        /* is bus Micro Channel Architecture */
int isrealtimeclock(void);              /* is real-time clock installed */
int machine_id(void);                   /* determine machine id */
byte ROM_id(void);                      /* get ROM id */
char *ROM_date(void);                   /* get ROM date */

/* Compaq 386 prototypes */
unsigned char Compaq386GetCpuSpeed(unsigned int *speedvalue);               /* Compaq 386: Get cpu speed */
void Compaq386SetCpuSpeed(unsigned char speed, unsigned int speedvalue);    /* Compaq 386: Set cpu speed */
unsigned char Compaq386KbdType(void);                                       /* Compaq 386: Determine attached keyboard type */

/* Pointing Device BIOS Interface prototypes */
int SetPointDevice(boolean enable);     /* Pointing Device BIOS Interface: Enable/Disable (DV 2.x, PS/2) */
int ResetPointDevice(void);             /* Pointing Device BIOS Interface: Reset (DV 2.x, PS/2) */
int SetRatePointDevice(unsigned char samplerate);   /* Pointing Device BIOS Interface: Set Sampling Rate (DV 2.x, PS/2) */
int SetResPointDevice(unsigned char countpermm);    /* Pointing Device BIOS Interface: Set Resolution (DV 2.x, PS/2) */
int GetTypePointDevice(void);           /* Pointing Device BIOS Interface: Get Type (DV 2.x, PS/2) */

/* Disk prototypes */
boolean diskchanged(int drive);         /* disk change detected: AT, XT2, XT286, Convertible and PS/2 only */
byte disktype(byte drive);              /* type of disk (0=default, A=1, etc.) */

/* Joystick prototypes */
boolean isgameport(void);               /* is game port available */
char joysticksettings(void);            /* get joystick switch settings */
unsigned joystickAx(void);              /* read joystick input Ax */
unsigned joystickAy(void);              /* read joystick input Ay */
unsigned joystickBx(void);              /* read joystick input Bx */
unsigned joystickBy(void);              /* read joystick input By */

/* EMS prototypes */
boolean isEMSavail(void);               /* is EMS available */
unsigned char EMSGetStatus(void);       /* get EMS status */
boolean EMMversion(byte *version);      /* version or (on failure) error code */
boolean EMSpages(struct EMSrecord *ems);    /* total/available amount of EMS */
boolean EMSinfo(struct EMSrecord *ems);     /* EMS version and total/available pages */
int EMSwarmbootprep(void);                  /* Prep EMS hardware for warm boot: LIM EMS 4.0 */

/* Miscellaneous prototypes */
int Extendedtotal(void);                /* total amount of Extended memory (in K) */
void reboot(boolean warmboot);          /* reboot, warmboot vs. coldboot */

#endif              /* IBM_HEADER */
